#ifndef __COL_TAB_DOC__      
#define __COL_TAB_DOC__
// ColTbDoc.h : interface of the CColorTableDoc class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

typedef struct
{
	short		nIndex;
	RGBQUAD	rgbQuad;
} INDEXCOLOR;

class CColorTableDoc : public CDocument
{         
private:
	short		m_nFinalCnt;		// final number of color table entries
									// number of manually defined colors = m_Colors.Size()

	CPtrArray	m_IndexColors;		// array of INDEXCOLOR
		    
protected: // create from serialization only
	DECLARE_DYNCREATE(CColorTableDoc)

// Attributes
public:
// Operations
public:           
	void InitTable(int nCnt);
 	void DeleteArrayOf (CPtrArray* ptArray);
	void CopyColors (CPtrArray* ptDest, CPtrArray* ptSource);
	void CalcRgbQuads (RGBQUAD* ptQuads, INDEXCOLOR* ptIndCol_1, INDEXCOLOR* ptIndCol_2);
	RGBQUAD* CreateRGBQuads(short* ptCnt);
	void GetDataBase (CPtrArray* ptColorList);
	void SetDataBase (CPtrArray* ptColorList);
	void SetFinalCnt (short nCnt) { m_nFinalCnt = nCnt; }
	short GetFinalCnt () { return m_nFinalCnt; }

	RGBQUAD ColorRefToRGBQuad(COLORREF Color);
	COLORREF RGBQuadToColorRef (RGBQUAD quad);

	BOOL AppendColor (short nTableIndex, COLORREF Color);
	BOOL InsertColor (short nIndex, short nTableIndex, COLORREF Color);
	BOOL GetIndexColor (short nIndex, short* ptTableIndex, COLORREF* ptColor);
	COLORREF GetIndexColor (short nIndex, short* ptTableIndex);
	BOOL ChangeColor (short nIndex, INDEXCOLOR IndexColor);
	BOOL DeleteColor (short nIndex);
	short GetCnt();
  						  
// Implementation
public:
	CColorTableDoc(short nCnt = 16);
	virtual ~CColorTableDoc();  
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = FALSE);
    
	CString GetActualPath();
	BOOL Open(CWnd* ptWnd); 
	BOOL Save();
	BOOL SaveAs(CWnd* ptWnd, BOOL bConfirm = FALSE);
	
	virtual void DeleteContents();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	
// Generated message map functions
protected:
	//{{AFX_MSG(CColorTableDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif