/************************************************************************
 *  						C o l o r D o c . c p p  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "DimDoc.h"

#include "ColorDoc.h"  
#include "ColPrDlg.h"		// dialog to set color pref parameters

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL bMMText;

/////////////////////////////////////////////////////////////////////////////
// CColorDoc
IMPLEMENT_DYNCREATE(CColorDoc, CDocument)

BEGIN_MESSAGE_MAP(CColorDoc, CDocument)
	//{{AFX_MSG_MAP(CColorDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/****************************************************************************
 *  ColorDoc.cpp	  		 	 C C o l o r D o c 				Constructor	*
 ****************************************************************************/
CColorDoc::CColorDoc()
{                                      

m_bColorScreen = TRUE;
m_bColorPrinter = FALSE;

m_ptRtePen		= NULL; 
m_ptRtePenOld	= NULL; 

m_ptBearPen		= NULL;
m_ptBearPenOld  = NULL;

m_ptElevArrayPen	= NULL;
m_ptElevArrayPenOld = NULL;

m_ptElevPen		= NULL;
m_ptElevPenOld  = NULL;

m_ColMapLine = RGB (255, 0, 255);
m_ColMapBear = RGB (255, 0, 0);
m_ColMapLabel = RGB (255, 255,0);
m_ColMapSel = RGB (0, 255, 0);
m_ColMapFrame = RGB (128, 128, 0);
m_ColMapPos = RGB (255, 0, 0);
m_ColMapLineDisabled = RGB (128,128,128);
m_ColElevArray = RGB (111, 79, 41);		// dark earth - brown
m_ColElev = RGB (141, 99, 56);			// earth - brown
m_ColElevValue = RGB (147, 0, 0);		// elev number on map
m_ColCriticalLine = RGB (255,0,0);
m_ColSky = RGB (185,218,255);			// sky - blue

						// for MM_LOMETRIC: Line strength= 1,0 mm
m_nSizeLineMap = 10;
m_nSizeBearMap = 5;
m_nSizeLineScMap = 10;
m_nSizeBearScMap = 5;

m_nSizeLineMvMap = 5;
m_ColMvMapLine = RGB (0,0,0);

m_ColScMapLine= RGB (255, 255,0);
m_ColScMapBear = RGB (255, 0, 0); 
m_ColScMapLabel = RGB (255, 255,0);
m_ColScMapSel = RGB (0, 255, 0);
m_ColScMapText = RGB (0,0,0);
m_ColScMapPos = RGB (0,255,255);

m_bActivateSeaCT	= TRUE;
m_bActivateFlightCT	= TRUE;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	~ C C o l o r D o c 						*
 ****************************************************************************/
CColorDoc::~CColorDoc()
{
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 S e t M a p L i n e 						*
 ****************************************************************************/
void CColorDoc::SetMapLine (COLORREF Col, short nSize)				 
{
m_ColMapLine = Col;
m_nSizeLineMap = (int)nSize;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 G e t M a p L i n e 						*
 ****************************************************************************/
void CColorDoc::GetMapLine (COLORREF* ptCol, short* ptSize)				 
{
*ptCol = m_ColMapLine;
*ptSize = (short)m_nSizeLineMap;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 S e t S c M a p L i n e					*
 ****************************************************************************/
void CColorDoc::SetScMapLine (COLORREF Col, short nSize)				 
{
m_ColScMapLine = Col;
m_nSizeLineScMap = (int)nSize;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 G e t S c M a p L i n e					*
 ****************************************************************************/
void CColorDoc::GetScMapLine (COLORREF* ptCol, short* ptSize)				 
{
*ptCol = m_ColScMapLine;
*ptSize = (short)m_nSizeLineScMap;
}


/****************************************************************************
 *  ColorDoc.cpp	  		 	 S e t M a p B e a r						*
 ****************************************************************************/
void CColorDoc::SetMapBear (COLORREF Col, short nSize)				 
{
m_ColMapBear = Col;
m_nSizeBearMap = (int)nSize;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 G e t M a p B e a r 						*
 ****************************************************************************/
void CColorDoc::GetMapBear (COLORREF* ptCol, short* ptSize)				 
{
*ptCol = m_ColMapBear;
*ptSize = (short)m_nSizeBearMap;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 S e t S c M a p B e a r					*
 ****************************************************************************/
void CColorDoc::SetScMapBear (COLORREF Col, short nSize)				 
{
m_ColScMapBear = Col;
m_nSizeBearScMap = (int)nSize;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 G e t S c M a p B e a r					*
 ****************************************************************************/
void CColorDoc::GetScMapBear (COLORREF* ptCol, short* ptSize)				 
{
*ptCol = m_ColScMapBear;
*ptSize = (short)m_nSizeBearScMap;
}

/************************************************************************
 *  ColorDoc.cpp			G e t K m l L i n e C o l o r				*
 *  converts the color used to draw a route or track on scanned maps	*
 *  into a CString to be used as LineStyle-color in kml-files			*
 *  kml:Color = "OOBBGGRR", where OO = opaque							*
 *  E. g.: 7f0000ff = 50% opaque red line								*
 ************************************************************************/
CString CColorDoc::GetKmlLineColor()
{
	CString kmlColor = "ffffffff";		// 100 percent opaque white line 

	BYTE	 kmlOpaque = 0xFF;		// 100 percent opaque

//#define GetRValue(rgb)      ((BYTE)(rgb))
//#define GetGValue(rgb)      ((BYTE)(((WORD)(rgb)) >> 8))
//#define GetBValue(rgb)      ((BYTE)((rgb)>>16))

	kmlColor.Format((LPCTSTR)"%02hx%02hx%02hx%02hx",
		kmlOpaque,
		GetBValue(m_ColScMapLine), 
		GetGValue(m_ColScMapLine),
		GetRValue(m_ColScMapLine));

	return kmlColor;
}


/************************************************************************
 *  ColorDoc.cpp			G e t K m l L i n e W i d t h				*
 *  converts the line size used to draw a route or track on scanned maps*
 *  into a CString to be used as LineStyle-width in kml-files			*
 *  E. g. kml:Width = "5"												*
 ************************************************************************/
CString CColorDoc::GetKmlLineWidth()
{
	CString kmlLineWidth = "1";		// thin line 

					// get line size from Color Pref Dialog
	if(m_nSizeLineScMap > 2)
	{
		kmlLineWidth.Format((LPCTSTR)"%.2f", (double)m_nSizeLineScMap/2);
	}

	return kmlLineWidth;
}


/****************************************************************************
 *  ColorDoc.cpp	  		 	 S e l e c t R t P e n						*
 ****************************************************************************/
void CColorDoc::SelectRtPen (CDC* pDC, BOOL bScMap, BOOL bOn)
{
if (bOn)
	{
	if (m_ptRtePen == NULL)
		{
		COLORREF colLeg    = (bScMap)? m_ColScMapLine : m_ColMapLine;
		int	nSize = (bScMap)? m_nSizeLineScMap : m_nSizeLineMap;
		m_ptRtePen = new CPen (PS_SOLID, nSize, colLeg);
		m_ptRtePenOld = (CPen*)pDC->SelectObject (m_ptRtePen);
		}
	}
else{
	pDC->SelectObject (m_ptRtePenOld);
	delete m_ptRtePen;
	m_ptRtePen = NULL;
	}
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 S e l e c t R o u t e P e n				*
 ****************************************************************************/
void CColorDoc::SelectRoutePen (CDC* pDC, BOOL bOn)
{
BOOL bScMap = FALSE;
this->SelectRtPen (pDC, bScMap, bOn);
}


/****************************************************************************
 *  ColorDoc.cpp	  			SelectDisabledRoutePen						*
 *  Purpose: used in d r a w n map only while selecting scanned maps		*
 ****************************************************************************/
void CColorDoc::SelectDisabledRoutePen (CDC* pDC, BOOL bOn)
{									   // bScMap = FALSE // always!!
if (bOn)
	{
	if (m_ptRtePen == NULL)
		{
		COLORREF colLeg    = m_ColMapLineDisabled;
		m_ptRtePen = new CPen (PS_SOLID, m_nSizeLineMap, colLeg);
		m_ptRtePenOld = (CPen*)pDC->SelectObject (m_ptRtePen);
		}
	}
else{
	pDC->SelectObject (m_ptRtePenOld);
	delete m_ptRtePen;
	m_ptRtePen = NULL;
	}
}

/****************************************************************************
 *  ColorDoc.cpp	  		S e l e c t S c a n R o u t e P e n				*
 ****************************************************************************/
void CColorDoc::SelectScanRoutePen (CDC* pDC, BOOL bOn)
{
BOOL bScMap = TRUE;
this->SelectRtPen (pDC, bScMap, bOn);
}

/****************************************************************************
 *  ColorDoc.cpp	  	S e l e c t E l e v A r r a y P e n					*
 ****************************************************************************/
void CColorDoc::SelectElevArrayPen (CDC* pDC, BOOL bOn)
{
if (bOn)
	{
	if (m_ptElevArrayPen == NULL)
		{
		COLORREF colLeg  = m_ColElevArray;
		int	nSize = 5;
		m_ptElevArrayPen = new CPen (PS_SOLID, nSize, colLeg);
		m_ptElevArrayPenOld = (CPen*)pDC->SelectObject (m_ptElevArrayPen);
		}
	}
else{
	pDC->SelectObject (m_ptElevArrayPenOld);
	delete m_ptElevArrayPen;
	m_ptElevArrayPen = NULL;
	}
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 S e l e c t E l e v P e n					*
 ****************************************************************************/
void CColorDoc::SelectElevPen (CDC* pDC, BOOL bOn)
{
if (bOn)
	{
	if (m_ptElevPen == NULL)
		{
		COLORREF colLeg  = RGB(0,0,0);
		int	nSize = 1;
		m_ptElevPen = new CPen (PS_SOLID, nSize, colLeg);
		m_ptElevPenOld = (CPen*)pDC->SelectObject (m_ptElevPen);
		}
	}
else{
	pDC->SelectObject (m_ptElevPenOld);
	delete m_ptElevPen;
	m_ptElevPen = NULL;
	}
}


/****************************************************************************
 *  ColorDoc.cpp	  		 	 G e t L e g C o l o r						*
 ****************************************************************************/
COLORREF CColorDoc::GetLegColor (BOOL bScMap, BOOL bActivate)
{
COLORREF Col, colLeg, colSelLeg;

colLeg    = (bScMap)? m_ColScMapLine : m_ColMapLine;
colSelLeg = (bScMap)? m_ColScMapSel  : m_ColMapSel;

Col = bActivate? colSelLeg : colLeg;
return Col;
}


/************************************************************************
 *  ColorDoc.cpp	  			I n v e r t C o l o r					*
 ************************************************************************/
COLORREF CColorDoc::InvertColor (COLORREF Col)
{
COLORREF InvertCol = RGB(255,255,255) - Col;
return InvertCol;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 D r a w L e g 								*
 ****************************************************************************/
void CColorDoc::DrawLeg (CDC* pDC, long x0, long y0, long x1, long y1, BOOL bScMap, COLORREF Col)
{
short nPenSizeLP = (bScMap)? m_nSizeLineScMap : m_nSizeLineMap;
short	nShadowOffsetLP;
						   // use device resolution to get same size on notebook
double dDevPixLogInch = pDC->GetDeviceCaps (LOGPIXELSY);
int nPenSizeDP = (int)(dDevPixLogInch * nPenSizeLP / 254 + 0.5);
CSize sPen(nPenSizeDP, nPenSizeDP );

pDC->DPtoLP (&sPen);
nPenSizeLP = (short)sPen.cx;
nShadowOffsetLP = (short)(0.4*nPenSizeLP);

//CPen* ptShadowPen = new CPen (PS_SOLID, nPenSizeLP, this->InvertColor(Col));
CPen* ptShadowPen = new CPen (PS_SOLID, nPenSizeLP, RGB(0,0,0));
CPen* ptRtePen = new CPen (PS_SOLID, nPenSizeLP, Col);


CPen* ptOldPen = (CPen*)pDC->SelectObject (ptShadowPen);
pDC->MoveTo (x0+nShadowOffsetLP, y0-nShadowOffsetLP);
pDC->LineTo (x1+nShadowOffsetLP, y1-nShadowOffsetLP);

pDC->SelectObject (ptRtePen);
pDC->MoveTo (x0, y0);
pDC->LineTo (x1, y1);


pDC->SelectObject (ptOldPen);

delete ptRtePen;
delete ptShadowPen;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 D r a w M v M p L e g 						*
 ****************************************************************************/
void CColorDoc::DrawMvMpLeg (CDC* pDC, long x0, long y0, long x1, long y1)
{
short nPenSizeLP = m_nSizeLineMvMap;
						   // use device resolution to get same size on notebook
double dDevPixLogInch = pDC->GetDeviceCaps (LOGPIXELSY);
int nPenSizeDP = (int)(dDevPixLogInch * nPenSizeLP / 254 + 0.5);
CSize sPen(nPenSizeDP, nPenSizeDP );

pDC->DPtoLP (&sPen);
nPenSizeLP = (short)sPen.cx;

//CPen* ptRtePen = new CPen (PS_SOLID, nPenSizeLP, this->InvertColor(Col));
CPen* ptRtePen = new CPen (PS_SOLID, nPenSizeLP, m_ColMvMapLine);


CPen* ptOldPen = (CPen*)pDC->SelectObject (ptRtePen);

pDC->MoveTo (x0, y0);
pDC->LineTo (x1, y1);

pDC->SelectObject (ptOldPen);

delete ptRtePen;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 D r a w C h e c k P o i n t					*
 ****************************************************************************/
void CColorDoc::DrawCheckPoint (CDC* pDC, long LPx1, long LPy1, BOOL bScMap, BOOL bUpDown)
{										  /* Kartenpunkt			*/
CRect rEllipse;
short nRadius = ((bScMap)? m_nSizeLineScMap : m_nSizeLineMap);
rEllipse.SetRect (	LPx1-nRadius, LPy1- (bMMText? nRadius : -nRadius), 
					LPx1+nRadius, LPy1+ (bMMText? nRadius : -nRadius));


if (bUpDown)			/* draw white inserted way point		*/
	{
	CBrush* ptOldBrush = (CBrush*)pDC->SelectStockObject (WHITE_BRUSH);
	pDC->Ellipse(rEllipse);
	pDC->SelectObject (ptOldBrush);
	}
else{	 				/* use black color for regular way point	*/
//	CBrush* ptOldBrush = (CBrush*)pDC->SelectStockObject (BLACK_BRUSH);
//	CBrush brChkPt (RGB (255,0,0));
	CBrush brChkPt (bScMap? m_ColScMapLine : m_ColMapLine);
	CBrush* ptOldBrush = (CBrush*)pDC->SelectObject (&brChkPt);
	pDC->Ellipse(rEllipse);
	pDC->SelectObject (ptOldBrush);
	}
}


/****************************************************************************
 *  ColorDoc.cpp	  		 	 D r a w B e a r 							*
 ****************************************************************************/
void CColorDoc::DrawBear (CDC* pDC, long x0, long y0, long x1, long y1, 
						BOOL bScMap)
{
COLORREF Col = (bScMap)? m_ColScMapBear : m_ColMapBear;
short nPenSizeLP = (bScMap)? m_nSizeBearScMap : m_nSizeBearMap;
short	nShadowOffsetLP;
						   // use device resolution to get same size on notebook
double dDevPixLogInch = pDC->GetDeviceCaps (LOGPIXELSY);
int nPenSizeDP = (int)(dDevPixLogInch * nPenSizeLP / 254 + 0.5);
CSize sPen(nPenSizeDP, nPenSizeDP );

pDC->DPtoLP (&sPen);
nPenSizeLP = (short)sPen.cx;
nShadowOffsetLP = (short)(0.4*nPenSizeLP);

//CPen* ptShadowPen = new CPen (PS_SOLID, nPenSizeLP, this->InvertColor(Col));
CPen* ptShadowPen = new CPen (PS_SOLID, nPenSizeLP, RGB(0,0,0));
CPen* ptRtePen = new CPen (PS_SOLID, nPenSizeLP, Col);

CPen* ptOldPen = (CPen*)pDC->SelectObject (ptShadowPen);
//pDC->MoveTo (x0+nShadowOffsetLP, y0-nShadowOffsetLP);
//pDC->LineTo (x1+nShadowOffsetLP, y1-nShadowOffsetLP);

pDC->SelectObject (ptRtePen);

pDC->MoveTo (x0, y0);
pDC->LineTo (x1, y1);

pDC->SelectObject (ptOldPen);

delete ptRtePen;
delete ptShadowPen;
}

/****************************************************************************
 *  ColorDoc.cpp	  		 	 C h a n g e 								*
 ****************************************************************************/
BOOL CColorDoc::Change(CWnd* ptWnd, BOOL bMapSelected)
{
BOOL bChanged=FALSE;
CColorPrefDlg ColorDlg(ptWnd, this, bMapSelected);

int RetVal = ColorDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
 		ptWnd->InvalidateRect(NULL);
		bChanged = TRUE;
		break;
	case IDCANCEL:
		break;
	}	

return bChanged;
} 

/****************************************************************************
 *  ColorDoc.cpp	  				S e r i a l i z e 						*
 ****************************************************************************/
void CColorDoc::Serialize(CArchive& ar)
{    
if (ar.IsStoring())
	{
		// TODO: add storing code here   
	ar << m_ColMapLine;
	ar << m_ColMapBear;
	ar << m_ColMapLabel;
	ar << m_ColMapSel;
	ar << m_ColMapFrame;
	ar << m_ColMapPos;

	ar << m_nSizeLineMap;
	ar << m_nSizeLineScMap;
	ar << m_nSizeBearMap;
	ar << m_nSizeBearScMap;

	ar << m_ColScMapLine;
	ar << m_ColScMapBear; 
	ar << m_ColScMapLabel;
	ar << m_ColScMapSel;
	ar << m_ColScMapPos;

	ar << m_bActivateFlightCT;
	ar << m_bActivateSeaCT;
	}
else{
		// TODO: add loading code here  
	ar >> m_ColMapLine;
	ar >> m_ColMapBear;
	ar >> m_ColMapLabel;
	ar >> m_ColMapSel;
	ar >> m_ColMapFrame;
	ar >> m_ColMapPos;

	ar >> m_nSizeLineMap;
	ar >> m_nSizeLineScMap;
	ar >> m_nSizeBearMap;
	ar >> m_nSizeBearScMap;

	ar >> m_ColScMapLine;
	ar >> m_ColScMapBear; 
	ar >> m_ColScMapLabel;
	ar >> m_ColScMapSel;
	ar >> m_ColScMapPos;

	ar >> m_bActivateFlightCT;
	ar >> m_bActivateSeaCT;
	}
}
