#ifndef __COLORDOC__
#define __COLORDOC__

/************************************************************************
 *  						C o l o r D o c . h 	 					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de


class CColorDoc : public CDocument
{ 
protected: // create from serialization only
	DECLARE_DYNCREATE(CColorDoc)

protected:   

// Attributes
public:                      
	BOOL m_bColorScreen;
	BOOL m_bColorPrinter;

	CPen* m_ptRtePen;
	CPen* m_ptRtePenOld;

	CPen* m_ptBearPen;
	CPen* m_ptBearPenOld;

	CPen* m_ptElevArrayPen;
	CPen* m_ptElevArrayPenOld;

	CPen* m_ptElevPen;
	CPen* m_ptElevPenOld;

private:					// vector map parameters
	COLORREF m_ColMapLine;
	COLORREF m_ColMapBear;
 	COLORREF m_ColMapLabel;
	COLORREF m_ColMapSel;
	COLORREF m_ColMapFrame;
	COLORREF m_ColMapPos;
	COLORREF m_ColMapLineDisabled;
	COLORREF m_ColElevArray;
	COLORREF m_ColElev;
	COLORREF m_ColElevValue;
	COLORREF m_ColCriticalLine;
	COLORREF m_ColSky;

	int	 m_nSizeLineMap;
	int	 m_nSizeLineScMap;
	int	 m_nSizeBearMap;
	int	 m_nSizeBearScMap;
	int	 m_nSizeLineMvMap;

							 // scanned map parameters
	COLORREF m_ColMvMapLine;
	COLORREF m_ColScMapLine;
	COLORREF m_ColScMapBear;
	COLORREF m_ColScMapLabel;  
	COLORREF m_ColScMapSel;
	COLORREF m_ColScMapText;	// not serialized here, instead see CScannedMap
	COLORREF m_ColScMapPos;

	BOOL m_bActivateSeaCT;
	BOOL m_bActivateFlightCT;

// Operations
public:
	CColorDoc();	
	~CColorDoc();   
	BOOL Change (CWnd* ptWnd, BOOL bMapSelected);
	void Serialize(CArchive& ar);

	CString GetKmlLineColor();
	CString GetKmlLineWidth();

	void SelectRtPen (CDC* pDC, BOOL bScMap, BOOL bOn);
	void SelectRoutePen (CDC* pDC, BOOL bOn);
	void SelectDisabledRoutePen (CDC* pDC, BOOL bOn);
	void SelectScanRoutePen (CDC* pDC, BOOL bOn);
	void SelectElevArrayPen (CDC* pDC, BOOL bOn);
	void SelectElevPen (CDC* pDC, BOOL bOn);

	void SetMapLine (COLORREF Col, short nSize);				 
	void SetMapBear (COLORREF Col, short nSize);				 
	void SetColMapLabel (COLORREF Col) { m_ColMapLabel = Col; }
	void SetColMapSel (COLORREF Col) { m_ColMapSel = Col; }
	void SetColMapFrame (COLORREF Col) { m_ColMapFrame = Col; }
	void SetColMapPos (COLORREF Col) { m_ColMapPos = Col; }

	void SetScMapLine (COLORREF Col, short nSize);				 
	void SetScMapBear (COLORREF Col, short nSize);
	void SetColScMapLabel (COLORREF Col) { m_ColScMapLabel = Col; }
	void SetColScMapSel (COLORREF Col) { m_ColScMapSel = Col; }
	void SetColScMapText (COLORREF Col) { m_ColScMapText = Col; }
	void SetColScMapPos (COLORREF Col) { m_ColScMapPos = Col; }					 

	void SetActivateSeaCT(BOOL bSet) { m_bActivateSeaCT = bSet; }
	void SetActivateFlightCT(BOOL bSet) { m_bActivateFlightCT = bSet; }

	void GetMapLine (COLORREF* ptCol, short* ptSize);				 
	void GetMapBear (COLORREF* ptCol, short* ptSize);
	short GetMapLineSize () { return m_nSizeLineMap; }

	COLORREF GetColMapLabel () { return m_ColMapLabel; }
	COLORREF GetColMapSel () { return m_ColMapSel; }
	COLORREF GetColMapFrame () { return m_ColMapFrame; }
	COLORREF GetColMapPos () { return m_ColMapPos; }
	COLORREF GetColMapLineDisabled () { return m_ColMapLineDisabled; }
	COLORREF GetColElevArray () { return m_ColElevArray; }
	COLORREF GetColElevArea () { return m_ColElev; }
	COLORREF GetColElevValue () { return m_ColElevValue; }
	COLORREF GetColCriticalLine () { return m_ColCriticalLine; }
	COLORREF GetColSkyArea () { return m_ColSky; }

	void GetScMapLine (COLORREF* ptCol, short* ptSize);				 
	void GetScMapBear (COLORREF* ptCol, short* ptSize);				 
	short GetScMapLineSize () { return m_nSizeLineScMap; }

	COLORREF GetColScMapLabel () { return m_ColScMapLabel; }
	COLORREF GetColScMapSel () { return m_ColScMapSel; }
	COLORREF GetColScMapText () { return m_ColScMapText; }
	COLORREF GetColScMapPos () { return m_ColScMapPos; }

	BOOL IsActivateSeaCT() { return m_bActivateSeaCT; }
	BOOL IsActivateFlightCT() { return m_bActivateFlightCT; }


	COLORREF GetLegColor (BOOL bScMap, BOOL bActivate);
	COLORREF InvertColor (COLORREF Col);
	void DrawLeg (CDC* pDC, long x0, long y0, long x1, long y1, BOOL bScMap, COLORREF Col);
	void DrawMvMpLeg (CDC* pDC, long x0, long y0, long x1, long y1);
	void DrawCheckPoint (CDC* pDC, long LPx1, long LPy1, BOOL bScMap, BOOL bUpDown);
	void DrawBear (CDC* pDC, long x0, long y0, long x1, long y1, BOOL bScMap);

   
// Implementation
protected:          

	// Generated message map functions
protected:
	//{{AFX_MSG(CColorDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
