// CourseVw.cpp : implementation of the CCourseView class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"  
#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"
#include "Calc.h"			// this statement must be after PlaneDoc.h
#include "Sun.h"


#include "WayDoc.h"
#include "CourseVw.h"                                           

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;
extern CDimDoc* 		ptDim;      

extern CMetDoc*			ptMet; 
extern CLoadDoc*		ptLoad; 
extern CCalcDoc*		ptCalc;
extern CAppendixDoc*	ptAppend;  
extern CPlaneDoc*		ptPlaneDoc;
extern BOOL bMMText;

/////////////////////////////////////////////////////////////////////////////
// CCourseView

IMPLEMENT_DYNCREATE(CCourseView, CTextViewTool)

BEGIN_MESSAGE_MAP(CCourseView, CTextViewTool)
	//{{AFX_MSG_MAP(CCourseView)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTextViewTool::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTextViewTool::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCourseView construction/destruction

CCourseView::CCourseView()
{
	// TODO: add construction code here
ptFontTool->GetParams (m_FontName, &m_wPointSize);

m_CharX = m_LineY = 0;
m_BCharX = m_BLineY = 0;

CreateBoldFont(&m_BoldFont);
CreateNewFont(&m_PlainFont);
}

CCourseView::~CCourseView()
{
m_PlainFont.DeleteObject ();
m_BoldFont.DeleteObject ();
}

/************************************************************************
 *  CourseVw.cpp				U p d a t e F o n t s 					*
 ************************************************************************/
void CCourseView::UpdateFonts (CDC* pDC)
{
ptFontTool->GetParams (m_FontName, &m_wPointSize);
m_lfHeight = this->Y_PointToLP (pDC, m_wPointSize);  

m_PlainFont.DeleteObject ();
CreateNewFont(&m_PlainFont);
this->GetCharSize (pDC, &m_PlainFont, &m_CharX, &m_LineY); 

m_BoldFont.DeleteObject ();
CreateBoldFont(&m_BoldFont);
this->GetCharSize (pDC, &m_BoldFont, &m_BCharX, &m_BLineY); 

		//	used to get fixed left margin and defined "max" char width
GetLeftMarginAndCharX_LP (m_wPointSize, &m_CharX);	// defines m_LeftMargin, m_CharX
}

/************************************************************************
 *  CourseVw.cpp			O n I n i t i a l U p d a t e				*
 *  Calls OnUpdate														*
 ************************************************************************/
void CCourseView::OnInitialUpdate()
{
	CTextViewTool::OnInitialUpdate();
	// TODO: calculate the total size of this view

CDC* pDC = GetDC();    
//pDC->SetMapMode(MM_LOMETRIC);

//this->UpdateFonts (pDC);

ReleaseDC(pDC);     
}


/////////////////////////////////////////////////////////////////////////////
// CCourseView drawing
/************************************************************************
 *  CourseVw.cpp   				  S e t X T a b s 						*
 ************************************************************************/
void CCourseView::SetXTabs (CDC* pDC, CWayDoc* ptWayDoc, int CharX, BOOL bPrinter)
{
int X_TAB, LogPixXToUse, LogPixYToUse;
GetLogPixToUse(pDC, (int*)&LogPixXToUse, (int*)&LogPixYToUse);   


//X_TAB = (m_bForPrinter? 4 : 2)*CharX;
X_TAB = m_LeftMargin;

m_dY = LogPixYToUse;
m_Xleft  = X_TAB;

short nMaxNameLen;
nMaxNameLen = ptWayDoc->GetMaxLocNameLen (pDC, TRUE);	// bPair = TRUE: "Egelsbach (EDFE)" 
														// First and last Wpt with name AND indic
if (nMaxNameLen == 0)                        
	nMaxNameLen = GetRightPos (pDC, 0, IDS_PLACE);
if (nMaxNameLen < 4*CharX)
	nMaxNameLen = 4*CharX;

m_Xloc = m_Xleft + CharX;


							/* length of line: File, Plane, Date		*/ 
CString szFilePlane = Format(IDF_FILE_PLANE,
					(LPCTSTR)ptWayDoc->GetTitle(),
					(LPCTSTR)ptPlaneDoc->GetActPlaneName ());
m_Xdate  = m_Xleft + GetRightPos(pDC, 0, szFilePlane) + CharX;

UINT uDay, uMonth, uYear;
ptCalc->GetTime (&uDay, &uMonth, &uYear);
CString szDate = Format (IDF_DATE, uDay, uMonth, uYear);
m_Xdate  += GetRightPos(pDC, 0, szDate);

if (bPrinter)
	{
	m_Xfreq = GetRightPos (pDC, m_Xloc+nMaxNameLen+CharX, IDS_FREQ); 
	m_Xsavealt = GetRightPos (pDC, m_Xfreq+CharX, IDS_SAVEALT);
	m_Xgs	= GetRightPos (pDC, m_Xsavealt+CharX, IDS_GNDSPD);
	}
else{
	m_Xwind = GetRightPos (pDC, m_Xloc+nMaxNameLen+CharX, IDS_WIND);
	m_Xwca	= GetRightPos (pDC, m_Xwind+CharX, IDS_WCA);
	m_Xvar	= GetRightPos (pDC, m_Xwca+2*CharX, IDS_VAR);
	m_Xgs	= GetRightPos (pDC, m_Xvar+CharX, IDS_GNDSPD);
	}

	short nDistCharFakt = 1;
	short nTimeCharFakt = 1;
	if (ptDim->Distance() == DIM_METER)
	{		// need more space for dist and time
		nDistCharFakt = 3;
		nTimeCharFakt = 2;
	}

	m_Xtt = GetRightPos (pDC, m_Xgs+CharX, IDS_TRUETRACK);
	m_Xdist = GetRightPos (pDC, m_Xtt + nDistCharFakt*CharX, IDS_DIST);
	m_Xalt = GetRightPos (pDC, m_Xdist+CharX,IDS_ALT);
	m_Xmh = GetRightPos (pDC, m_Xalt+CharX, IDS_MAGHDG);
	m_Xtime = GetRightPos (pDC, m_Xmh + nTimeCharFakt*CharX, IDS_TIME);


	if (bPrinter)
	{
		m_Xeto = GetRightPos (pDC, m_Xtime+CharX, IDS_ETO); 
		m_Xato = GetRightPos (pDC, m_Xeto+CharX, IDS_ATO);
		m_Xright = m_Xato + CharX;
	}
	else
	{
		m_Xright = m_Xtime + CharX;
	}

if (m_Xdate > m_Xright)
	{         // put space between name and rest of columns
	short nDiff = m_Xdate - m_Xright;

	m_Xfreq   += nDiff; 
	m_Xsavealt+= nDiff; 

	m_Xwind	+= nDiff;
	m_Xwca	+= nDiff;
	m_Xvar	+= nDiff;

	m_Xgs	+= nDiff;
	m_Xtt	+= nDiff;
	m_Xdist	+= nDiff;
	m_Xalt	+= nDiff;
	m_Xmh	+= nDiff;
	m_Xtime	+= nDiff;

	m_Xeto	+= nDiff;
	m_Xato	+= nDiff;
	m_Xright+= nDiff;
	}

m_dX = m_Xright - m_Xleft;


									// for appendix:
int X = GetRightPos (pDC, m_Xloc, IDS_UPPERWIND);
m_X1500 = GetRightPos (pDC, X+CharX, IDS_1500FT);
m_X3000 = GetRightPos (pDC, m_X1500+2*CharX, IDS_3000FT);
m_X5000 = GetRightPos (pDC, m_X3000+2*CharX, IDS_5000FT);
m_X10000 = GetRightPos (pDC, m_X5000+2*CharX, IDS_10000FT);
m_XwindDim = m_X10000 + CharX;

CString szText, szDim;
ptDim->GetDimCstring (&szDim, ptDim->Wind());
szText = this->Format (IDF_WINDDIM, (LPCTSTR)szDim);
short nXappendix = GetRightPos (pDC, m_XwindDim + CharX, szText);

if (nXappendix > m_Xright)
	{				// increase width of table to fit to appendix
	short i=1;
	double dDiff = nXappendix - m_Xright + CharX;
	short nDiff = (short)(dDiff/8);

	if (bPrinter)
		{
		m_Xfreq		+= i++ *nDiff;	
		m_Xsavealt	+= i++ *nDiff;	
		m_Xgs		+= i++ *nDiff;
		}
	else{
		m_Xwind += i++ *nDiff;
		m_Xwca	+= i++ *nDiff;
		m_Xvar	+= i++ *nDiff; 
		m_Xgs	+= i*nDiff;			// don't increase i here! 
		}

	m_Xtt		+= i++ *nDiff; 
	m_Xdist		+= i++ *nDiff; 
	m_Xalt 		+= i++ *nDiff; 
	m_Xmh 		+= i++ *nDiff; 
	m_Xtime		+= i++ *nDiff; 
			
	if (bPrinter)
		{
		m_Xeto += i*nDiff;		  // don't increase i here!
		m_Xato += i*nDiff;		  // don't increase i here!
		m_Xright = m_Xato + CharX;
		}
	else{
		m_Xright = m_Xtime + CharX;
		}

	m_dX = m_Xright - m_Xleft;
	} 
}

/************************************************************************
 *  CourseVw.cpp		P r i n t G r a y C r o s s						*
 ************************************************************************/
void CCourseView::PrintGrayCross (CDC* pDC, int X0, int Y0, int X1, int Y1)
{
if (m_bDraw)
	{
	CPen BlackDotPen (PS_DOT, 1, RGB (0, 0, 0));
	CPen* ptOldPen = (CPen*)pDC->SelectObject (&BlackDotPen);
	pDC->MoveTo (X0, Y0);	 pDC->LineTo (X1, Y1);
	pDC->MoveTo (X0, Y1);	 pDC->LineTo (X1, Y0);
	pDC->SelectObject (ptOldPen);
	}
}

/************************************************************************
 *  CourseView.cpp		 P r i n t C o l u m n s V g _ T i m e			*
 ************************************************************************/
void CCourseView::PrintColumnsVg_Time (CDC* pDC, int Y, CFont* ptBoldFont, 
										LEGTYPE Leg, CWayPoint Wpt)
{
	double	fConvert;

	fConvert = ptDim->ConvertSpeed (Leg.dVgr, DIM_KT, ptDim->DistDimToSpeedDim (ptDim->Distance()));
	RsrcAlignRightEx (pDC, m_Xgs, Y, IDS_F_GS, (int)(fConvert + 0.5));

	RsrcAlignRightEx (pDC, m_Xtt, Y, IDS_F_TT, (int)Leg.dRWK);

	fConvert = ptDim->ConvertDist (Leg.dDistLeg_NM, DIM_NM, ptDim->Distance());		// exact value
	int nDist = (int)(fConvert + 0.5);
	RsrcAlignRightEx (pDC, m_Xdist, Y, IDS_F_DIST, nDist);
	m_ulTotalDist += nDist;

	long lAlt_ft = Wpt.GetActAlt_ft();
	if (lAlt_ft != NO_ALT)
		{
		fConvert = ptDim->ConvertDist (Wpt.GetActAlt_ft(), DIM_FEET, ptDim->Altitude());
		RsrcAlignRightEx (pDC, m_Xalt, Y, IDS_F_ALT, (int)(fConvert + 0.5));
		}

	CFont* ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);			// BOLD
	RsrcAlignRightEx (pDC, m_Xmh, Y, IDS_F_MH, (int)Leg.dMH);
	pDC->SelectObject (ptOldFont);

	if (ptDim->Distance() == DIM_METER)
	{
		short hour = 0;
		short min=0;
		short sec = 0;
		CDimDoc::MinutesToHMS(Leg.dTimeLeg_min, &hour, &min, &sec);		// exact value
		int nMinutes = (int)(60*hour + min);
		RsrcAlignRightEx (pDC, m_Xtime, Y, IDF_TIME_MS, nMinutes, sec);

		m_ulTotalMin += nMinutes;
		m_ulTotalSec += sec;				
	}
	else
	{
		int nMinutes = (int)(Leg.dTimeLeg);
		RsrcAlignRightEx (pDC, m_Xtime, Y, IDF_TIME, nMinutes);
		m_ulTotalMin += nMinutes;
	}
}

/************************************************************************
 *  CourseVw.cpp    		 G e t E x t r a I n f o L i n e s			*
 ************************************************************************/
short CCourseView::GetExtraInfoLines (CAppendixDoc* ptApp)
{
    short nLines = 0;
     
    nLines++;
    
    if (ptApp->IsWindInfo())			// W i n d i n f o
    {			
        nLines +=2;    
    }

    if (ptApp->IsFuelInfo())			// F u e l i n f o
    {
        nLines +=2;    
    }

    if (ptApp->IsSunInfo())				// S u n i n f o
    {
         nLines +=2;    
    }

                                                // u s e r s   t e x t
    if (ptApp->IsTextActiv(0) || ptApp->IsTextActiv(1) || ptApp->IsTextActiv(2))
    {
        nLines++;    
        for (short i=0; i<3; i++)
        {
            if (ptApp->IsTextActiv(i))
                nLines++;    
        }
    }

    nLines+=2;    
    return nLines;
}


/************************************************************************
 *  CourseVw.cpp    		 P r i n t E x t r a I n f o 				*
 ************************************************************************/
BOOL CCourseView::PrintExtraInfo (CDC* pDC, int* ptY, int dY, 
									CAppendixDoc* ptApp, CONSUMTYPE* ptC)
{
	BOOL bEndOfPage = FALSE;		// return TRUE  => more data for next pg.
									// return FALSE => no more data for next pg.
	short nNextLines = GetExtraInfoLines(ptApp);
	bEndOfPage = ((DWORD)(*ptY + nNextLines*dY) < (m_dwLinesPerPage * m_LineY));

	if (!bEndOfPage)
	{
		short Y_SEP;
		CString szDim, szText;
		BOOL	bPrintSeparator=FALSE;

		(*ptY) += m_LineY;
		Y_SEP = DrawHorzLine (pDC, *ptY+dY/2);

		if (ptApp->IsWindInfo())				// W i n d i n f o
			{							
			double	fConvert;
			short nDir, nSpd;

			(*ptY) += dY;						// title line
			RsrcAlignLeft (pDC, m_Xloc, *ptY, IDS_UPPERWIND);

			RsrcAlignRight (pDC, m_X1500, *ptY, IDS_1500FT);
			RsrcAlignRight (pDC, m_X3000, *ptY, IDS_3000FT);
			RsrcAlignRight (pDC, m_X5000, *ptY, IDS_5000FT);
			RsrcAlignRight (pDC, m_X10000, *ptY, IDS_10000FT);


			(*ptY) += dY;				/* printing wind table data	*/

			ptMet->GetWind (CMetDoc::ALT01, &nDir, &nSpd); 
			fConvert = ptDim->ConvertSpeed (nSpd, ptMet->GetWindDim(), ptDim->Wind());
			RsrcAlignRightEx (pDC, m_X1500, *ptY, IDS_F_WIND, nDir, (short)(fConvert+0.5));

			ptMet->GetWind (CMetDoc::ALT03, &nDir, &nSpd); 
			fConvert = ptDim->ConvertSpeed (nSpd, ptMet->GetWindDim(), ptDim->Wind());
			RsrcAlignRightEx (pDC, m_X3000, *ptY, IDS_F_WIND, nDir, (short)(fConvert+0.5));

			ptMet->GetWind (CMetDoc::ALT05, &nDir, &nSpd); 
			fConvert = ptDim->ConvertSpeed (nSpd, ptMet->GetWindDim(), ptDim->Wind());
			RsrcAlignRightEx (pDC, m_X5000, *ptY, IDS_F_WIND, nDir, (short)(fConvert+0.5));

			ptMet->GetWind (CMetDoc::ALT10, &nDir, &nSpd); 
			fConvert = ptDim->ConvertSpeed (nSpd, ptMet->GetWindDim(), ptDim->Wind());
			RsrcAlignRightEx (pDC, m_X10000, *ptY, IDS_F_WIND, nDir, (short)(fConvert+0.5));

			ptDim->GetDimCstring (&szDim, ptDim->Wind());
			RsrcAlignLeftEx (pDC, m_XwindDim, *ptY, IDF_WINDDIM, (LPCTSTR)szDim);

			bPrintSeparator = TRUE;
			}

		if (ptApp->IsFuelInfo())				   // F u e l i n f o
			{
			double  fFlight, fSafe;

			if (bPrintSeparator)
			{
				(*ptY) += dY;
				DrawGrayHorzLine (pDC, *ptY+dY/2);
			}

			(*ptY) += dY;
			ptDim->GetDimCstring (&szDim, ptDim->Volume());
			fFlight = ptDim->ConvertVolume (ptC->fEnRoute_l, DIM_LITER, ptDim->Volume())
					+ ptDim->ConvertVolume (ptC->fTaxiDepArv_l, DIM_LITER, ptDim->Volume());
			fSafe   = ptDim->ConvertVolume (ptC->fSafeRes_l, DIM_LITER, ptDim->Volume())
					+ ptDim->ConvertVolume (ptC->fAlternateRoute_l, DIM_LITER, ptDim->Volume());

			float fFlight_l = (float)floor(fFlight * 10 + .5)/10;
			float fSave_l = (float)floor(fSafe * 10 + .5)/10;

		//  "Treibstoffverbrauch [Liter]  Flug: 39.7  Reserve: 13.5  Gesamt: 53.2"
			RsrcAlignLeftEx (pDC, m_Xloc, *ptY, IDF_FUELINFO, (LPCTSTR)szDim,
					 fFlight_l, fSave_l, fFlight_l+fSave_l);

			bPrintSeparator = TRUE;
			}

		if (ptApp->IsSunInfo())					// S u n i n f o
			{
			SUNSHINETYPE SunShine;
			CSun Sun(ptCalc->GetTime());
			Sun.GetSunShine (ptC->LandLoc.GetLat(), ptC->LandLoc.GetLon(), &SunShine);

			if (bPrintSeparator)
			{
				(*ptY) += dY;
				DrawGrayHorzLine (pDC, *ptY+dY/2);
			}

			(*ptY) += dY;
			switch (SunShine.nMode)
				{
				case SUN_UPDOWN:				 
					RsrcAlignLeftEx (pDC, m_Xloc, *ptY, IDF_SUNINFO1, ptC->LandLoc.GetName(),
								SunShine.Hss, SunShine.Mss, SunShine.Sss);
					break;
				case SUN_INVISIBLE:			// "Polarnacht"
					RsrcAlignLeftEx (pDC, m_Xloc, *ptY, IDF_SUNINFO2, ptC->LandLoc.GetName());
					break;
				case SUN_CIRCUMPOLAR:		 // "Polartag"
					RsrcAlignLeftEx (pDC, m_Xloc, *ptY, IDF_SUNINFO3, ptC->LandLoc.GetName());
				break;
				}

			bPrintSeparator = TRUE;
			}


												// u s e r s   t e x t

		if (ptApp->IsTextActiv(0) || ptApp->IsTextActiv(1) || ptApp->IsTextActiv(2))
			{
			if (bPrintSeparator)
				{
					(*ptY) += dY;
					DrawGrayHorzLine (pDC, *ptY+dY/2);
				}
			}

		short i;
		for (i=0; i<3; i++)
			{
			if (ptApp->IsTextActiv(i))
				{
				(*ptY) += dY;
				ptApp->GetUserText(i, &szText);
				TextAlignLeft (pDC, m_Xloc, *ptY, szText);
				}
			}

		(*ptY) += dY;

		DrawHorzLine (pDC, *ptY+dY/2);
		DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+dY/2); 
		(*ptY) += dY;
	} // !bEndOfPage

	return bEndOfPage;
}

/************************************************************************
 *  CourseVw.cpp    		 P r i n t L o a d W a r n	 				*
 ************************************************************************/
void CCourseView::PrintLoadWarn (CDC* pDC, int* ptY, int dY, CONSUMTYPE* ptCons)
{
short Y_SEP;

(*ptY) += m_LineY;
Y_SEP = DrawHorzLine (pDC, *ptY+dY/2);

if (ptCons->nBadRowLoad > 0)			
    {							
	(*ptY) += m_LineY;
	RsrcAlignLeftEx (pDC, m_Xloc, *ptY, IDF_BAD_ROW_LOAD, ptCons->nBadRowLoad);
	}

if (ptCons->nBadLugLoad > 0)			
	{
	(*ptY) += m_LineY;
	RsrcAlignLeftEx (pDC, m_Xloc, *ptY, IDF_BAD_LUG_LOAD, ptCons->nBadLugLoad);
	}

if (ptCons->nBadFuelLoad > 0)			
	{
	(*ptY) += m_LineY;
	RsrcAlignLeftEx (pDC, m_Xloc, *ptY, IDF_BAD_FUEL_LOAD, ptCons->nBadFuelLoad);
	}

(*ptY) += dY;
DrawHorzLine (pDC, *ptY+dY/2);
DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+dY/2); 
(*ptY) += dY;
}

/************************************************************************
 *  CourseVw.cpp    		 	 D r a w W a y							*
 ************************************************************************/
BOOL CCourseView::DrawWay (CDC* pDC, CWayDoc* ptWayDoc, 
						DWORD* ptIndex, int* ptY, BOOL bPrinter, BOOL bDraw)
{
	BOOL	bEndOfPage = FALSE;
	short	Y_SEP, X_SEP1, X_SEP2;
	CString szText;

	ActivateDrawing (bDraw);

	CFont* ptOldFont;
	ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);
	pDC->SetBkMode(TRANSPARENT);

									// "Datei: %s  Flugzeug:%s       Datum:..."
	RsrcAlignLeftEx (pDC, m_Xleft, *ptY, IDF_FILE_PLANE, 
						(LPCTSTR)ptWayDoc->GetTitle(),
						(LPCTSTR)ptPlaneDoc->GetActPlaneName ());

	UINT uDay, uMonth, uYear;
	ptCalc->GetTime (&uDay, &uMonth, &uYear);
	RsrcAlignRightEx (pDC, m_Xright, *ptY, IDF_DATE, uDay, uMonth, uYear);
	(*ptY) += m_LineY;  

	short nCnt= ptWayDoc->GetWayPointCnt ();
	short nAlternateCnt = ptWayDoc->GetAlternateCnt();

	if ((short)*ptIndex < nCnt + nAlternateCnt)
	{			// print header of table
		(*ptY) += m_LineY;  
		Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);
		(*ptY) += m_LineY;  

		pDC->SelectObject (ptOldFont);
		ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);

		if (bPrinter)
		{
			X_SEP1 = m_Xtime+m_CharX;
			X_SEP2 = m_Xeto+m_CharX;
		}

		RsrcAlignLeft	(pDC, m_Xloc, *ptY, IDS_PLACE);
		if (bPrinter)
		{										  
			RsrcAlignRight (pDC, m_Xfreq, *ptY, IDS_FREQ);
			RsrcAlignRight (pDC, m_Xsavealt,*ptY, IDS_SAVEALT);
		}
		else
		{
 			RsrcAlignRight (pDC, m_Xwind,*ptY, IDS_WIND);
			RsrcAlignRight (pDC, m_Xwca,	*ptY, IDS_WCA);
			RsrcAlignRight (pDC, m_Xvar,	*ptY, IDS_VAR);
		}

		RsrcAlignRight (pDC, m_Xgs,	*ptY, IDS_GNDSPD);
		RsrcAlignRight (pDC, m_Xtt,	*ptY, IDS_TRUETRACK);
		RsrcAlignRight (pDC, m_Xdist,*ptY, IDS_DIST);
		RsrcAlignRight (pDC, m_Xalt,	*ptY, IDS_ALT);
		RsrcAlignRight (pDC, m_Xmh,	*ptY, IDS_MAGHDG);
		RsrcAlignRight (pDC, m_Xtime,*ptY, IDS_TIME);

		if (bPrinter)
		{										  
			RsrcAlignRight (pDC, m_Xeto, *ptY, IDS_ETO);
			RsrcAlignRight (pDC, m_Xato, *ptY, IDS_ATO);
		}
		(*ptY) += m_LineY;  
		pDC->SelectObject (ptOldFont);

		ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);
												// dimensions
		CString szDim;

		if (bPrinter)
		{
			ptDim->GetDimCstring (&szDim, ptDim->Altitude());
			TextAlignRight (pDC, m_Xsavealt, *ptY, szDim);
		}
		else
		{
			ptDim->GetDimCstring (&szDim, ptDim->Wind());
			TextAlignRight (pDC, m_Xwind, *ptY, szDim);
		}

		ptDim->GetDimCstring (&szDim, ptDim->DistDimToSpeedDim (ptDim->Distance()));
		TextAlignRight (pDC, m_Xgs, *ptY, szDim);

		ptDim->GetDimCstring (&szDim, ptDim->Distance());
		TextAlignRight (pDC, m_Xdist, *ptY, szDim);

		ptDim->GetDimCstring (&szDim, ptDim->Altitude());
		TextAlignRight (pDC, m_Xalt, *ptY, szDim);
		(*ptY) += m_LineY;  

		DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
		Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);
		(*ptY) += m_LineY;  
	} // header of table


	BOOL	bOK=FALSE;
	CPlane	ActPlane;
	CCalculate* ptLegs = NULL;
	if (ptPlaneDoc != NULL)
	{
		short nIndex = ptPlaneDoc->GetActIndex();
		bOK = ptPlaneDoc->GetPlanePtr(nIndex, &ActPlane);
	}

	if (bOK)					/* do prepare calculations		*/
	{
		ptLegs = ptWayDoc->GetCalculationPtr();
		ptLegs->Activate(&ActPlane);
		ptLegs->CourseTime ();

		ptLegs->AlternateCourseTime();		// increases m_dTotalDist, m_dTotalTime for alternates

		if (*ptIndex == (DWORD)0)
		{			// first page
			m_ulTotalDist = 0;
			m_ulTotalMin = 0;
			m_ulTotalSec = 0;
		}
	}


	short i;
	double	fConvert;

	BOOL bGroundWpt = TRUE;
	BOOL bRouteWpt = FALSE;
	BOOL bAlternateWpt = FALSE;

	for (i=(short)*ptIndex; i<(nCnt + nAlternateCnt) && bOK && !bEndOfPage; i++)
    {
		bAlternateWpt = (nCnt <= i && i < nCnt + nAlternateCnt);
		bGroundWpt = (i==0 || i==nCnt-1) || bAlternateWpt;
		bRouteWpt = (i > 0 && i < nCnt-1);		// route wpt, except start, dest, alternates

		CWayPoint Wpt;
		BOOL bWptOK = FALSE;				// alternate waypoint array starts with 1
		if (bAlternateWpt)	bWptOK = ptWayDoc->GetAlternateWayPointPtr(i-nCnt+1, &Wpt);
				else		bWptOK = ptWayDoc->GetWayPointPtr (i, &Wpt);
		if (bWptOK)
		{
			CString	szNameForRte;     
			if (bGroundWpt)			// Start, Dest, Alternate1, Alternate2
				 szNameForRte = Wpt.GetLocNamePair ();
			else szNameForRte = Wpt.GetNameForRte ();
			TextAlignLeft(pDC, m_Xloc, *ptY, szNameForRte);


			if (bPrinter)			// while printing
			{					// for every wpt: show Freq and H-Min.
				float fFreq;
				if (Wpt.GetFrequency(&fFreq))
				{
					RsrcAlignRightEx (pDC, m_Xfreq, *ptY, IDF_7K3F, fFreq);
				}

				if (Wpt.GetAltitude() != NO_ALT)
				{				/* set minimum altitude 	*/
					if (bRouteWpt)
					{			// route wpt, except start, dest, alternates
						fConvert = Wpt.GetSafeAlt_MSL (ptDim->Altitude());
					}
					else
					{
						fConvert = ptDim->ConvertDist (Wpt.GetAltitude(),
								  Wpt.GetElevDim(), ptDim->Altitude());
					}
					
					RsrcAlignRightEx (pDC, m_Xsavealt, *ptY, IDS_F_ALT, (long)(fConvert+0.5));
				}
				else
				{
					CString szBuffer("?");
					TextAlignRight (pDC, m_Xsavealt, *ptY, szBuffer);
				}
			}

			if (i==0)
			{
				short nAltDim = Wpt.GetAltDim ();

				long lAlt = Wpt.GetPlannedAlt ();
				if (lAlt != NO_ALT)
				{
					fConvert = ptDim->ConvertToPref (ALTITUDE, lAlt, nAltDim);
					RsrcAlignRightEx (pDC, m_Xalt, *ptY, IDS_F_ALT, (long)(fConvert + .5));
				}
			}
			else
			{			
				LEGTYPE Leg;						// alternate leg array starts with 0
				if (bAlternateWpt)	Leg = ptLegs->GetAlternateAt(i-nCnt);
					else			Leg = ptLegs->GetAt (i);	// get calculated leg

				if (!bPrinter)
				{				// for screen only: W/S, Luv, Var
					fConvert = ptDim->ConvertSpeed (Wpt.GetWindSpeed_kt(), DIM_KT, ptDim->Wind());
					RsrcAlignRightEx (pDC, m_Xwind, *ptY, IDS_F_WIND, 
											Wpt.GetWindDir(), (short)(fConvert+.5));

					short	nWCA = (WORD)(Leg.dWCA + 0.5);
					RsrcAlignRightEx (pDC, m_Xwca, *ptY, IDS_F_WCA, nWCA);

					if (m_bDraw)
						ptWayDoc->DrawVariation (pDC, m_Xvar, *ptY, m_CharX, Wpt.GetVariation());
				}

									// for printer and for screen:
				this->PrintColumnsVg_Time (pDC, *ptY, &m_BoldFont, Leg, Wpt);


				long lElev;				// check safe altitude
				if (Wpt.GetAltitude(&lElev) && bRouteWpt)
				{   
					long lMinSafeAlt_ft = Wpt.GetSafeAlt_MSL (DIM_FEET);
					
					if (Wpt.GetActAlt_ft() < lMinSafeAlt_ft)
					{
						CString szMsg;
						szMsg.Format (IDS_SAFEALTWARN, (LPCTSTR)Wpt.GetName());
						AfxMessageBox (szMsg);
					}
				}

			} // end of drawing calculated results for each leg
	
			(*ptY) += m_LineY;  

			CString szBearing;
			if (Wpt.HasBearing (0))				/* first bearing		*/
			{
				Wpt.GetBearString (0, &szBearing);
				TextAlignLeft (pDC, m_Xloc, *ptY, szBearing);
				(*ptY) += m_LineY;
			}
			if (Wpt.HasBearing (1))				/* second bearing		*/
			{
				Wpt.GetBearString (1, &szBearing);
				TextAlignLeft (pDC, m_Xloc, *ptY, szBearing);
				(*ptY) += m_LineY;
			}


											/* line feed and separator?	*/
			if (!Wpt.IsUpDown())
		    {
				DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 

				if (bPrinter)
				{
					DrawVertLines (pDC, X_SEP1, X_SEP2, Y_SEP, *ptY+m_LineY/2); 

					if (i == 0)					/* disable first ETO field	*/
						this->PrintGrayCross (pDC, X_SEP1, Y_SEP, X_SEP2, *ptY+m_LineY/2);
				}

				if (i==nCnt-1 || i == nCnt+nAlternateCnt-1)
					Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2); 
				else
					Y_SEP = DrawGrayHorzLine (pDC, *ptY+m_LineY/2);


				(*ptY) += m_LineY;				/* one additional line feed	*/
		    }


			if (i == nCnt - 1)
			{			// regular aerodrome of destination reached, show total dist and time
				RsrcAlignRightEx (pDC, m_Xdist, *ptY, IDS_F_DIST, (int)(m_ulTotalDist));

				short hour = 0;
				short min=0;
				short sec = 0;
				CDimDoc::MinutesToHMS(m_ulTotalMin, m_ulTotalSec, &hour, &min, &sec);
				RsrcAlignRightEx (pDC, m_Xtime, *ptY, IDF_TIME_HMS, hour, min, sec);

				(*ptY) += m_LineY; 

				DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
				Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);
				(*ptY) += m_LineY;
			}

		} // good GetWayPointPtr or GetAlternateWayPointPtr


 		if (bPrinter)
		{
			int NextY = m_LineY;
			bEndOfPage = (bMMText)? 
				((DWORD)(*ptY + 1*m_LineY + NextY) > (m_dwLinesPerPage * m_LineY)) :
				((DWORD)(*ptY + 1*m_LineY + NextY) < (m_dwLinesPerPage * m_LineY))	;

			if (bEndOfPage)
			{										// end of page, but not end of document!
				if (i<nCnt+nAlternateCnt-1)	*ptIndex = i+1;			// means: return TRUE  => more data for next pg.
					else		bEndOfPage = FALSE;		// means: return FALSE => no more data
			}
		}
	} // end for all legs

	if (i == nCnt + nAlternateCnt)
	{			// show total dist and time after last alternate:
		if(ptWayDoc->HasAlternates())
		{							// show course to alternates
			RsrcAlignRightEx (pDC, m_Xdist, *ptY, IDS_F_DIST, (int)(m_ulTotalDist));

			short hour = 0;
			short min=0;
			short sec = 0;
			CDimDoc::MinutesToHMS(m_ulTotalMin, m_ulTotalSec, &hour, &min, &sec);
			RsrcAlignRightEx (pDC, m_Xtime, *ptY, IDF_TIME_HMS, hour, min, sec);

			//RsrcAlignRightEx (pDC, m_Xtime, *ptY, IDF_TIME, (int)(ptLegs->TotalTime()));

			(*ptY) += m_LineY; 

			DrawHorzLine (pDC, *ptY+m_LineY/2);
			DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
			(*ptY) += m_LineY;
		} // end HasAlternates
	}


	if (ptLegs != NULL)
		ptLegs->DeActivate ();



	if (i == nCnt + nAlternateCnt)
	{
		if (ptAppend->IsAppendix())
		{
			CCalculate* ptLegs = ptWayDoc->GetCalculationPtr();
			ptLegs->Activate(&ActPlane);
			if (ptLegs->DoConsumCalc (&ActPlane, ptMet, ptLoad))
			{
				bEndOfPage = this->PrintExtraInfo (pDC, ptY, m_LineY, ptAppend, ptLegs->GetConsPtr());
				if (bEndOfPage)
				{
					*ptIndex = i;
				}
			}
			else
			{
				CONSUMTYPE* ptCons = ptLegs->GetConsPtr();
				this->PrintLoadWarn (pDC, ptY, m_LineY, ptCons);
			}
			ptLegs->DeActivate();
		}
	}

	if (!m_bDraw && !bPrinter)
	{
		this->SetTotalHeight (*ptY);
		this->SetTotalWidth (m_Xright + m_Xleft);
	}

	pDC->SelectObject (ptOldFont);


	return bEndOfPage;
}

/************************************************************************
 *  CourseVw.cpp			D r a w P a g e H e a d e r 				*
 ************************************************************************/
void CCourseView::DrawPageHeader (CDC* pDC, CWayDoc* ptWayDoc, int LineY, 
								int* ptY, int dX, BOOL bDraw)
{
int	Y1, Frame;
CWayPoint FirstWayPt, LastWayPt;
CFont* ptOldFont;


ActivateDrawing (bDraw);

Y1 = *ptY + 3*LineY;			/* Draw double line frame	*/ 
if (bDraw) Rectangle(pDC, m_Xleft, *ptY, m_Xleft + dX, Y1);

Frame = (LineY/4);
if (bDraw)
	{ 
	if (bMMText)Rectangle(pDC, m_Xleft+Frame, *ptY+Frame, m_Xleft + dX-Frame, Y1-Frame);
		else	Rectangle(pDC, m_Xleft-Frame, *ptY+Frame, m_Xleft + dX+Frame, Y1-Frame);
	}


ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);

Y1 = *ptY+LineY/2;
RsrcAlignCenter (pDC, (m_Xleft + dX + m_Xleft)/2, Y1, IDS_TITLE1);


Y1 += LineY;

short nCnt= ptWayDoc->GetWayPointCnt ();
if (ptWayDoc->GetWayPointPtr (0, &FirstWayPt) &&
	ptWayDoc->GetWayPointPtr(nCnt-1, &LastWayPt))
	{
	CString szName1, szName2;
	CLocation Loc;
	FirstWayPt.GetLoc (&Loc);
	szName1 = Loc.GetName();

	LastWayPt.GetLoc (&Loc);
	szName2 = Loc.GetName();

	CString szUserName = ptInit->GetCustName();

	RsrcAlignCenterEx (pDC, (m_Xleft + dX + m_Xleft)/2, Y1,	IDF_TITLE2,
		(LPCTSTR)szName1, (LPCTSTR)szName2, (LPCTSTR)szUserName);


	}

pDC->SelectObject (ptOldFont);

*ptY = Y1 + 3*LineY;
}


/************************************************************************
 *  CourseVw.cpp    	 	 D r a w P a g e F o o t e r 				*
 ************************************************************************/
void CCourseView::DrawPageFooter (CDC* pDC, int nPage, int LineY, 
								int* ptY, int dX, BOOL bDraw)
{
	CString szText;

	CFont* ptOldFont;
	ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);


	(*ptY) += LineY/2;
	szText = this->Format (IDF_PAGENUM, nPage);
	this->TextAlignCenter (pDC, dX/2, *ptY, szText);

	pDC->SelectObject (ptOldFont);
}       

/************************************************************************
 *  CourseVw.cpp   			  P r i n t P a g e							*
 ************************************************************************/
void CCourseView::PrintPage (CDC* pDC, int nPageToPrint)
{
CWayDoc* ptWayDoc = GetDocument();
ASSERT_VALID(ptWayDoc);

int	Y;
int	nPage = 1;


DWORD dwIndex = 0;

if (ptWayDoc != NULL)
	{
	BOOL bDraw;
	BOOL bPrinter = TRUE;
	
	do	{
		Y = 3*m_LineY;

		bDraw = (nPage == nPageToPrint);
		this->DrawPageHeader (pDC, ptWayDoc, m_LineY, &Y, m_dX, bDraw); 
		m_bMore = DrawWay (pDC, ptWayDoc, &dwIndex, &Y, bPrinter, bDraw);

		if (m_nPages > 1)
			{
			Y = (bMMText)? m_dY: -m_dY + m_LineY;
			this->DrawPageFooter (pDC, nPage, m_LineY, &Y, m_dX, bDraw); 
			}
		nPage++;
		} while (!bDraw);
	}    							
}                                  

	
/************************************************************************
 *  CourseVw.cpp     			 O n D r a w							*
 ************************************************************************/
void CCourseView::OnDraw(CDC* pDC)
{
	CWayDoc* ptWayDoc = GetDocument();
	ASSERT_VALID(ptWayDoc);
	// TODO: add draw code for native data here            

int	Y = m_LineY;
if (ptWayDoc != NULL)
	{
	BOOL	bMore = FALSE;
	DWORD 	dwIndex = 0;
	
 	bMore = DrawWay (pDC, ptWayDoc, &dwIndex, &Y, m_bForPrinter, m_bDraw);
	}	
}

/************************************************************************
 *  CourseVw.cpp			P r e p a r e X T a b s						* 
 ************************************************************************/
void CCourseView::PrepareXTabs (CDC* pDC)
{
CWayDoc* ptWayDoc = GetDocument();
ASSERT_VALID(ptWayDoc);  

if (ptWayDoc != NULL)
	{	
	pDC->SetMapMode(MM_LOMETRIC);
	this->UpdateFonts (pDC);					// defines m_CharX
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);		
	this->SetXTabs (pDC, ptWayDoc, m_CharX, m_bForPrinter);
	pDC->SelectObject (ptOldFont);
	}
}

/************************************************************************
 *  CourseVw.cpp				O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews 					*
 ************************************************************************/
void CCourseView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CWayDoc* ptWayDoc = GetDocument();

if (ptWayDoc != NULL)
	{	        
	CDC* pDC = GetDC();    

	this->PrepareXTabs(pDC);
	m_bDraw = FALSE;
	this->OnDraw(pDC);					// sets m_sizeTotal
	m_bDraw = TRUE;
	this->SetScrollSize (m_sizeTotal);

	ReleaseDC(pDC);     
	
	CTextViewTool::OnUpdate (pSender, lHint, pHint);
	}
}

/************************************************************************
 *  CourseVw.cpp   			 O n P r e p a r e D C						*
 ************************************************************************/
void CCourseView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class

CWayDoc* ptWayDoc = GetDocument();
ASSERT_VALID(ptWayDoc);  

if (ptWayDoc != NULL)
	{	 
	m_bForPrinter = pDC->IsPrinting();	  // important to get correct update after 
	if (m_bForPrinter)					  // printing dlg disappears!!
		{
		int	X, Y;
		DWORD	dwIndex = 0; 
		BOOL bMore = TRUE;

		m_nPages = 0;
		this->PrepareXTabs (pDC);
   						
		m_dwLinesPerPage = this->GetMaxLines (pDC, m_LineY);   // used in DrawKoord	while m_bForPrinter
			
		m_bDraw = FALSE;
		do	{    
			X = m_Xleft;
			Y = 3*m_LineY;

 			this->DrawPageHeader (pDC, ptWayDoc, m_LineY, &Y, m_dX, FALSE); 
			bMore = DrawWay (pDC, ptWayDoc, &dwIndex, &Y, m_bForPrinter, FALSE); // sets m_sizeTotal

 		//	this->DrawPageFooter (pDC, 0, m_LineY, &X, &Y, m_dX, FALSE); 
		//  there is place for footer after last line !! see GetLogPixToUse
 			m_nPages++;
			} while (bMore);
		m_bDraw = TRUE;

		if (pInfo != NULL)
			{
			pInfo->SetMaxPage (m_nPages);			// required for Preview
			pInfo->m_nNumPreviewPages = m_nPages;
			pInfo->m_bContinuePrinting = (m_bMore || pInfo->m_bPreview);
			}    
		}  // if m_bForPrinter
	else{
		this->PrepareXTabs (pDC);
		}
	}

if (!m_bForPrinter)
	CTextViewTool::OnPrepareDC(pDC, pInfo);	 // sets bContinuePrinting = TRUE if SetMaxPage is set
}



/////////////////////////////////////////////////////////////////////////////
// CCourseView printing

/************************************************************************
 *  CourseVw.cpp   		  O n P r e p a r e P r i n t i n g				*
 ************************************************************************/
BOOL CCourseView::OnPreparePrinting(CPrintInfo* pInfo)
{			 // called before the display of the print dialog
	// default preparation
m_bMore = TRUE;	               

return DoPreparePrinting(pInfo);
}

/************************************************************************
 *  CourseView.cpp  	 	O n B e g i n P r i n t i n g				*
 ************************************************************************/
void CCourseView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{			   // called after the print dialog exists
	// TODO: add extra initialization before printing
CWayDoc* ptWayDoc = GetDocument();
ASSERT_VALID(ptWayDoc);  

if (ptWayDoc != NULL)
	{	        
//	pDC->SetMapMode(MM_LOMETRIC);

//	this->UpdateFonts (pDC);					// defines m_CharX

//  this->SetXTabs (pDC, ptWayDoc, m_CharX, TRUE);
	}
							// 2. possibility to set the document length 
}

/************************************************************************
 *  CourseVw.cpp   		 		 O n P r i n t							*
 ************************************************************************/
void CCourseView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
this->PrintPage (pDC, pInfo->m_nCurPage);
}

/************************************************************************
 *  CourseVw.cpp   		 		 O n E n d P r i n t i n g				*
 ************************************************************************/
void CCourseView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
}

/////////////////////////////////////////////////////////////////////////////
// CCourseView diagnostics

#ifdef _DEBUG
void CCourseView::AssertValid() const
{
	CTextViewTool::AssertValid();
}

void CCourseView::Dump(CDumpContext& dc) const
{
	CTextViewTool::Dump(dc);
}

CWayDoc* CCourseView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWayDoc)));
	return (CWayDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCourseView message handlers




void CCourseView::OnEditCopy() 
{
	// TODO: Add your command handler code here
this->CopyToClipboard();	
}
