// CourseVw.h : interface of the CCourseView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "..\CPPTOOLS\TxVwTool.h"

//class CFont;
//class CWayPoint;

class CCourseView : public CTextViewTool
{
public:
	CFont	m_PlainFont; 
	CFont	m_BoldFont; 
	int		m_CharX, m_LineY;
	int		m_BCharX, m_BLineY;

	int m_Xloc, m_Xdate; 
	int m_Xwind, m_Xwca, m_Xvar; 
	int	m_Xfreq, m_Xsavealt;
	int m_Xgs, m_Xtt, m_Xdist, m_Xalt, m_Xmh, m_Xtime;
	int	m_Xeto, m_Xato;

	int m_X1500, m_X3000, m_X5000, m_X10000, m_XwindDim;   // for appendix
 
private:
	unsigned long	m_ulTotalDist;
	unsigned long	m_ulTotalMin;
	unsigned long	m_ulTotalSec;

public: // create from serialization only
	CCourseView();
	DECLARE_DYNCREATE(CCourseView)

// Attributes
public:
	CWayDoc* GetDocument();

// Operations
public:

// Implementation
public:
	virtual ~CCourseView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void UpdateFonts (CDC* pDC);
	void SetXTabs (CDC* pDC, CWayDoc* ptWayDoc, int CharX, BOOL bPrinter);
	void PrepareXTabs (CDC* pDC);

	void PrintGrayCross (CDC* pDC, int X0, int Y0, int X1, int Y1);

	void PrintColumnsVg_Time (CDC* pDC, int Y, CFont* ptBoldFont, 
								LEGTYPE Leg, CWayPoint Way);

	short GetExtraInfoLines (CAppendixDoc* ptApp);
	BOOL PrintExtraInfo (CDC* pDC, int* ptY, int dY, 
								CAppendixDoc* ptApp, CONSUMTYPE* ptC);
	void PrintLoadWarn (CDC* pDC, int* ptY, int dY, CONSUMTYPE* ptCons);

	BOOL DrawWay (CDC* pDC, CWayDoc* ptWayDoc, DWORD* ptIndex,
							int* ptY, BOOL bPrinter, BOOL bDraw = TRUE);
	void DrawPageHeader (CDC* pDC, CWayDoc* ptWayDoc, int LineY, 
							int* ptY, int dX, BOOL bDraw);
	void DrawPageFooter (CDC* pDC, int nPage, int LineY, 
								int* ptY, int dX, BOOL bDraw);
	void PrintPage (CDC* pDC, int nPageToPrint);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
protected:
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo); 
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL



// Generated message map functions
protected:
	//{{AFX_MSG(CCourseView)
	afx_msg void OnEditCopy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in wayview.cpp
inline CWayDoc* CCourseView::GetDocument()
   { return (CWayDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
