// DCalcDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "DimDoc.h"         
#include "DCalcDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc* ptDim;

/////////////////////////////////////////////////////////////////////////////
// CDimCalcDlg dialog


/************************************************************************
 *  DCalcDlg.cpp	  		 	C D i m C a l c D l g    constructor	*
 ************************************************************************/
CDimCalcDlg::CDimCalcDlg(CWnd* pParent)
	: CDlgTool(CDimCalcDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDimCalcDlg)
	m_fInput = 0.0;
	m_szOutput = _T("");
	m_nSetDim = -1;
	m_nLastDens = -1;
	m_fDensity = 0.0f;
	//}}AFX_DATA_INIT


m_nSetDim = INPUT;
m_nLastDens = FUEL;

m_fDensity = this->GetDensity ((DENSITY)m_nLastDens);

m_bCalculate = FALSE;
m_bOtherDens = FALSE;
m_bNeedDens = FALSE;

}


void CDimCalcDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDimCalcDlg)
	DDX_Text(pDX, ID_DCVAL1, m_fInput);
	DDX_Text(pDX, ID_DCVAL2, m_szOutput);
	DDX_Radio(pDX, ID_DCSETDIM1, m_nSetDim);
	DDX_Radio(pDX, ID_DCOIL, m_nLastDens);
	DDX_Text(pDX, ID_DCDENSITY, m_fDensity);
	DDV_MinMaxFloat(pDX, m_fDensity, 0.f, 20.f);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDimCalcDlg, CDlgTool)
	//{{AFX_MSG_MAP(CDimCalcDlg)
	ON_BN_CLICKED(ID_DCFUEL, OnFuelDens)
	ON_BN_CLICKED(ID_DCOTHER, OnOtherDens)
	ON_BN_CLICKED(ID_DCOIL, OnOilDens)
	ON_EN_CHANGE(ID_DCDENSITY, OnChangeOtherDens)
	ON_BN_CLICKED(ID_DCSETDIM1, OnSetInputDim)
	ON_BN_CLICKED(ID_DCSETDIM2, OnSetOutputDim)
	ON_EN_CHANGE(ID_DCVAL1, OnChangeInput)
	ON_BN_CLICKED(ID_DCFEET, OnFeet)
	ON_BN_CLICKED(ID_DCYARD, OnYards)
	ON_BN_CLICKED(ID_DCMTR, OnMeter)
	ON_BN_CLICKED(ID_DCKM, OnKiloMeter)
	ON_BN_CLICKED(ID_DCSM, OnStatuteMiles)
	ON_BN_CLICKED(ID_DCNM, OnNauticalMiles)
	ON_BN_CLICKED(ID_DCFTPM, OnFeetPerMinute)
	ON_BN_CLICKED(ID_DCKMPH, OnKmPerHour)
	ON_BN_CLICKED(ID_DCMPH, OnMilesPerHour)
	ON_BN_CLICKED(ID_DCNMPH, OnKnots)
	ON_BN_CLICKED(ID_DCMPS, OnMeterPerSecond)
	ON_BN_CLICKED(ID_DCUSQRT, OnUSQuarts)
	ON_BN_CLICKED(ID_DCLTR, OnLiter)
	ON_BN_CLICKED(ID_DCBRQRT, OnBritishQuarts)
	ON_BN_CLICKED(ID_DCUSGAL, OnUSGallons)
	ON_BN_CLICKED(ID_DCBRGAL, OnBritishGallons)
	ON_BN_CLICKED(ID_DCPOUND, OnPounds)
	ON_BN_CLICKED(ID_DCKG, OnKg)
	ON_BN_CLICKED(ID_DCHPA, OnHektoPascal)
	ON_BN_CLICKED(ID_DCMMHG, OnMillimeterHg)
	ON_BN_CLICKED(ID_DCINHG, OnInchHg)
	ON_BN_CLICKED(ID_DCGRADF, OnGradFahrenheit)
	ON_BN_CLICKED(ID_DCGRADC, OnGradCelsius)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/************************************************************************
 *  DCalcDlg.cpp	  			 	G e t D e n s i t y					*
 ************************************************************************/
float CDimCalcDlg::GetDensity (DENSITY Dens)
{
float fDensity;

switch (Dens)
	{
	case OIL:  fDensity = (float)0.90;	break;
	case FUEL: fDensity = (float)0.72;	break;
	case OTHER:
		UpdateData (TRUE);
		break;
	}

return fDensity;
}

/////////////////////////////////////////////////////////////////////////////
// CDimCalcDlg message handlers

/************************************************************************
 *  DCalcDlg.cpp	  		 	O n I n i t D i a l o g					*
 ************************************************************************/
BOOL CDimCalcDlg::OnInitDialog() 
{
CDlgTool::OnInitDialog();
	
	// TODO: Add extra initialization here
this->SelectItem (ID_DCVAL1);
	
return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  DCalcDlg.cpp	  		 	O n C h a n g e I n p u t				*
 ************************************************************************/
void CDimCalcDlg::OnChangeInput() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDlgTool::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	// TODO: Add your control notification handler code here
this->EraseText (ID_DCVAL2);
}

/************************************************************************
 *  DCalcDlg.cpp	  		 	O n O i l D e n s						*
 ************************************************************************/
void CDimCalcDlg::OnOilDens() 
{
	// TODO: Add your control notification handler code here
m_nLastDens = (int)OIL;
m_bOtherDens = FALSE;
m_fDensity = (float)0.90;	
UpdateData (FALSE);
if (m_bNeedDens)
	this->EraseText (ID_DCVAL2);
}

/************************************************************************
 *  DCalcDlg.cpp	  		 	O n F u e l D e n s						*
 ************************************************************************/
void CDimCalcDlg::OnFuelDens() 
{
	// TODO: Add your control notification handler code here
m_nLastDens = (int)FUEL;
m_bOtherDens = FALSE;
m_fDensity = (float)0.72;	
UpdateData (FALSE);
if (m_bNeedDens)
	this->EraseText (ID_DCVAL2);
}

/************************************************************************
 *  DCalcDlg.cpp	 		 	O n O t h e r D e n s					*
 ************************************************************************/
void CDimCalcDlg::OnOtherDens() 
{
	// TODO: Add your control notification handler code here
m_nLastDens = (int)OTHER;
m_bOtherDens = TRUE;
SelectItem (ID_DCDENSITY);	

if (m_bNeedDens)
	this->EraseText (ID_DCVAL2);
}


/************************************************************************
 *  DCalcDlg.cpp	 	O n C h a n g e O t h e r D e n s				*
 ************************************************************************/
void CDimCalcDlg::OnChangeOtherDens() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDlgTool::OnInitDialog()
	// function to send the EM_SETEVENTMASK message to the control
	// with the ENM_CHANGE flag ORed into the lParam mask.
	
	// TODO: Add your control notification handler code here
m_nLastDens = (int)OTHER;
						// first, last, actual
this->CheckRadioButton(ID_DCOIL, ID_DCOTHER, ID_DCOTHER);

if (m_bNeedDens && m_bOtherDens)
	this->EraseText (ID_DCVAL2);

}

/************************************************************************
 *  DCalcDlg.cpp	  		O n S e t I n p u t D i m					*
 ************************************************************************/
void CDimCalcDlg::OnSetInputDim() 
{
	// TODO: Add your control notification handler code here
m_bCalculate = FALSE;
m_bNeedDens = FALSE;

this->EraseText (ID_DCDIM1);
this->EraseText (ID_DCVAL2);
this->EraseText (ID_DCDIM2);
this->DisableControl (ID_DCSETDIM2, TRUE);
this->DisableIntervallControl (ID_DCFEET, ID_DCBRGAL, FALSE);
this->DisableIntervallControl (ID_DCPOUND, ID_DCGRADC, FALSE);
}

/************************************************************************
 *  DCalcDlg.cpp			S e t D i m D a t a							*
 ************************************************************************/
void CDimCalcDlg::SetDimData(double dResult, short nActSel)
{
char	szBuffer[32];   
CString szText;

sprintf(szBuffer, "%f", dResult);
this->SetText(ID_DCVAL2, (CString)szBuffer);

this->GetButtonText (nActSel, &szText);
this->SetText (ID_DCDIM2, szText);
}

/************************************************************************
 *  DCalcDlg.cpp	  		O n O u t p u t D i m						*
 ************************************************************************/
void CDimCalcDlg::OnSetOutputDim() 
{
	// TODO: Add your control notification handler code here
m_bCalculate = TRUE;
this->EraseText (ID_DCVAL2);
this->EraseText (ID_DCDIM2);
}


/************************************************************************
 *  DCalcDlg.cpp			C a l c u l a t e D i s t a n c e			*
 ************************************************************************/
void CDimCalcDlg::CalculateDistance(short nActSel)
{
short nDim;

if (nActSel == ID_DCFEET)	nDim = DIM_FEET;
if (nActSel == ID_DCYARD)	nDim = DIM_YARD;
if (nActSel == ID_DCMTR)	nDim = DIM_METER;
if (nActSel == ID_DCKM) 	nDim = DIM_KM;
if (nActSel == ID_DCSM) 	nDim = DIM_STM;
if (nActSel == ID_DCNM) 	nDim = DIM_NM;

if (m_bCalculate)
	{
	if (UpdateData (TRUE))
		{
		m_fFakt2 = CDimDoc::GetDistFakt (nDim);
		double fOutput = m_fInput * m_fFakt1 / m_fFakt2;
		this->SetDimData (fOutput, nActSel);
		}
	}
else{
	CString szButton;

	m_fFakt1 = CDimDoc::GetDistFakt (nDim);
	this->GetButtonText (nActSel, &szButton);
	this->SetText (ID_DCDIM1, szButton);
	this->SelectItem (ID_DCVAL1);
	m_nLastDim1 = nActSel;
	this->DisableControl (ID_DCSETDIM2, FALSE);
	this->DisableIntervallControl (ID_DCFTPM, ID_DCBRGAL, TRUE);
	this->DisableIntervallControl (ID_DCPOUND, ID_DCGRADC, TRUE);
	}
}

/************************************************************************
 *  DCalcDlg.cpp			Distance calculations...					*
 ************************************************************************/

void CDimCalcDlg::OnFeet() 
{
	// TODO: Add your control notification handler code here
this->CalculateDistance(ID_DCFEET);
}

void CDimCalcDlg::OnYards() 
{
	// TODO: Add your control notification handler code here
this->CalculateDistance(ID_DCYARD);
}

void CDimCalcDlg::OnMeter() 
{
	// TODO: Add your control notification handler code here
this->CalculateDistance(ID_DCMTR);
}

void CDimCalcDlg::OnKiloMeter() 
{
	// TODO: Add your control notification handler code here
this->CalculateDistance(ID_DCKM);
}

void CDimCalcDlg::OnStatuteMiles() 
{
	// TODO: Add your control notification handler code here
this->CalculateDistance(ID_DCSM);
}

void CDimCalcDlg::OnNauticalMiles() 
{
	// TODO: Add your control notification handler code here
this->CalculateDistance(ID_DCNM);
}

/************************************************************************
 *  DCalcDlg.cpp			C a l c u l a t e S p e e d					*
 ************************************************************************/
void CDimCalcDlg::CalculateSpeed(short nActSel)
{
short nDim;

if (nActSel == ID_DCFTPM) nDim = DIM_FTPM;
if (nActSel == ID_DCKMPH) nDim = DIM_KMH;
if (nActSel == ID_DCMPH)  nDim = DIM_MPH;
if (nActSel == ID_DCNMPH) nDim = DIM_KT;
if (nActSel == ID_DCMPS)  nDim = DIM_MPS;

if (m_bCalculate)
	{
	if (UpdateData (TRUE))
		{
		m_fFakt2 = CDimDoc::GetSpeedFakt (nDim);
		double fOutput = m_fInput * m_fFakt1 / m_fFakt2;
		this->SetDimData (fOutput, nActSel);
		}
	}
else{
	CString szButton;

	m_fFakt1 = CDimDoc::GetSpeedFakt (nDim);
	this->GetButtonText (nActSel, &szButton);
	this->SetText (ID_DCDIM1, szButton);
	this->SelectItem (ID_DCVAL1);
	m_nLastDim1 = nActSel;
	this->DisableControl (ID_DCSETDIM2, FALSE);
	this->DisableIntervallControl (ID_DCFEET, ID_DCNM, TRUE);
	this->DisableIntervallControl (ID_DCUSQRT, ID_DCBRGAL, TRUE);
	this->DisableIntervallControl (ID_DCPOUND, ID_DCGRADC, TRUE);
	}

}

/************************************************************************
 *  DCalcDlg.cpp			Speed calculations...						*
 ************************************************************************/

void CDimCalcDlg::OnFeetPerMinute() 
{
	// TODO: Add your control notification handler code here
this->CalculateSpeed(ID_DCFTPM);
}

void CDimCalcDlg::OnKmPerHour() 
{
	// TODO: Add your control notification handler code here
this->CalculateSpeed(ID_DCKMPH);
}

void CDimCalcDlg::OnMilesPerHour() 
{
	// TODO: Add your control notification handler code here
this->CalculateSpeed(ID_DCMPH);
}

void CDimCalcDlg::OnKnots() 
{
	// TODO: Add your control notification handler code here
this->CalculateSpeed(ID_DCNMPH);
}

void CDimCalcDlg::OnMeterPerSecond() 
{
	// TODO: Add your control notification handler code here
this->CalculateSpeed(ID_DCMPS);
}


/************************************************************************
 *  DCalcDlg.cpp			C a l c u l a t e V o l u m e				*
 ************************************************************************/
void CDimCalcDlg::CalculateVolume(short nActSel)
{
short nDim;

if (nActSel == ID_DCUSQRT)  nDim = DIM_USQRT;
if (nActSel == ID_DCLTR)    nDim = DIM_LITER;
if (nActSel == ID_DCBRQRT)  nDim = DIM_BRQRT;
if (nActSel == ID_DCUSGAL)  nDim = DIM_USGAL;
if (nActSel == ID_DCBRGAL)  nDim = DIM_BRGAL;

if (m_bCalculate)
	{
	if (UpdateData (TRUE))
		{
		m_fFakt2 = CDimDoc::GetVolumeFakt (nDim);
		m_bNeedDens = ( m_nLastDim1 >= ID_DCPOUND &&
						m_nLastDim1 <= ID_DCKG);

		double fOutput = m_fInput;
		if (m_bNeedDens)
			{				// convert mass to volume
			fOutput = m_fInput / m_fDensity;
			}

		fOutput = fOutput * m_fFakt1 / m_fFakt2;
		this->SetDimData (fOutput, nActSel);
		}
	}
else{
	CString szButton;

	m_fFakt1 = CDimDoc::GetVolumeFakt (nDim);
	this->GetButtonText (nActSel, &szButton);
	this->SetText (ID_DCDIM1, szButton);
	this->SelectItem (ID_DCVAL1);
	m_nLastDim1 = nActSel;
	this->DisableControl (ID_DCSETDIM2, FALSE);
	this->DisableIntervallControl (ID_DCFEET, ID_DCMPS, TRUE);
	this->DisableIntervallControl (ID_DCHPA, ID_DCGRADC, TRUE);
	}
}


/************************************************************************
 *  DCalcDlg.cpp			Volume calculations...						*
 ************************************************************************/

void CDimCalcDlg::OnUSQuarts() 
{
	// TODO: Add your control notification handler code here
this->CalculateVolume(ID_DCUSQRT);
}

void CDimCalcDlg::OnLiter() 
{
	// TODO: Add your control notification handler code here
this->CalculateVolume(ID_DCLTR);
}

void CDimCalcDlg::OnBritishQuarts() 
{
	// TODO: Add your control notification handler code here
this->CalculateVolume(ID_DCBRQRT);
}

void CDimCalcDlg::OnUSGallons() 
{
	// TODO: Add your control notification handler code here
this->CalculateVolume(ID_DCUSGAL);
}

void CDimCalcDlg::OnBritishGallons() 
{
	// TODO: Add your control notification handler code here
this->CalculateVolume(ID_DCBRGAL);
}


/************************************************************************
 *  DCalcDlg.cpp			C a l c u l a t e M a s s					*
 ************************************************************************/
void CDimCalcDlg::CalculateMass(short nActSel)
{
short nDim;

if (nActSel == ID_DCKG)		nDim = DIM_KG;
if (nActSel == ID_DCPOUND)	nDim = DIM_POUNDS;

if (m_bCalculate)
	{
  	if (UpdateData (TRUE))
		{
		m_fFakt2 = CDimDoc::GetMassFakt (nDim);

		m_bNeedDens = (	m_nLastDim1 >= ID_DCUSQRT &&
						m_nLastDim1 <= ID_DCBRGAL);

		double fOutput = m_fInput;
		if (m_bNeedDens)
			{	    // convert volume to mass
			fOutput = m_fInput * m_fDensity;
			}

		fOutput = fOutput * m_fFakt1 / m_fFakt2;
		this->SetDimData (fOutput, nActSel);
		}
	}
else{
	CString szButton;

	m_fFakt1 = CDimDoc::GetMassFakt (nDim);
	this->GetButtonText (nActSel, &szButton);
	this->SetText (ID_DCDIM1, szButton);
	this->SelectItem (ID_DCVAL1);
	m_nLastDim1 = nActSel;
	this->DisableControl (ID_DCSETDIM2, FALSE);
	this->DisableIntervallControl (ID_DCFEET, ID_DCMPS, TRUE);
	this->DisableIntervallControl (ID_DCHPA, ID_DCGRADC, TRUE);
	}
}

/************************************************************************
 *  DCalcDlg.cpp			Mass calculations...						*
 ************************************************************************/

void CDimCalcDlg::OnPounds() 
{
	// TODO: Add your control notification handler code here
this->CalculateMass(ID_DCPOUND);
}

void CDimCalcDlg::OnKg() 
{
	// TODO: Add your control notification handler code here
this->CalculateMass(ID_DCKG);
}


/************************************************************************
 *  DCalcDlg.cpp			C a l c u l a t e P r e s s					*
 ************************************************************************/
void CDimCalcDlg::CalculatePress(short nActSel)
{
short nDim;
	 		
if (nActSel == ID_DCHPA)  nDim = DIM_HPA;
if (nActSel == ID_DCMMHG) nDim = DIM_MMHG;
if (nActSel == ID_DCINHG) nDim = DIM_INCHHG;

if (m_bCalculate)
	{
   	if (UpdateData (TRUE))
		{
		m_fFakt2 = CDimDoc::GetPressFakt (nDim);
		double fOutput = m_fInput * m_fFakt1 / m_fFakt2;
		this->SetDimData (fOutput, nActSel);
		}
	}
else{
	CString szButton;

	m_fFakt1 = CDimDoc::GetPressFakt (nDim);
	this->GetButtonText (nActSel, &szButton);
	this->SetText (ID_DCDIM1, szButton);
	this->SelectItem (ID_DCVAL1);
	m_nLastDim1 = nActSel;
	this->DisableControl (ID_DCSETDIM2, FALSE);
	this->DisableIntervallControl (ID_DCFEET, ID_DCBRGAL, TRUE);
	this->DisableIntervallControl (ID_DCPOUND, ID_DCKG, TRUE);
	this->DisableIntervallControl (ID_DCGRADF, ID_DCGRADC, TRUE);
	}
}

/************************************************************************
 *  DCalcDlg.cpp			Press calculations...						*
 ************************************************************************/

void CDimCalcDlg::OnHektoPascal() 
{
	// TODO: Add your control notification handler code here
this->CalculatePress(ID_DCHPA);
}

void CDimCalcDlg::OnMillimeterHg() 
{
	// TODO: Add your control notification handler code here
this->CalculatePress(ID_DCMMHG);
}

void CDimCalcDlg::OnInchHg() 
{
	// TODO: Add your control notification handler code here
this->CalculatePress(ID_DCINHG);
}


/************************************************************************
 *  DCalcDlg.cpp			C a l c u l a t e T e m p					*
 ************************************************************************/
void CDimCalcDlg::CalculateTemp(short nActSel)
{
if (m_bCalculate)
	{
	if (UpdateData (TRUE))
		{
		BOOL bCtoF = (nActSel == ID_DCGRADF);
		
		double fOutput;		
		if (nActSel != m_nLastDim1)
			 fOutput = CDimDoc::CelsToFahr (m_fInput, bCtoF);
		else fOutput = m_fInput;
		this->SetDimData (fOutput, nActSel);
		}
	}
else{
	CString szButton;

	this->GetButtonText (nActSel, &szButton);
	this->SetText (ID_DCDIM1, szButton);
	this->SelectItem (ID_DCVAL1);
	m_nLastDim1 = nActSel;
	this->DisableControl (ID_DCSETDIM2, FALSE);
	this->DisableIntervallControl (ID_DCFEET, ID_DCBRGAL, TRUE);
	this->DisableIntervallControl (ID_DCPOUND, ID_DCINHG, TRUE);
	}
}


/************************************************************************
 *  DCalcDlg.cpp			Temperatur calculations...					*
 ************************************************************************/	 

void CDimCalcDlg::OnGradFahrenheit() 
{
	// TODO: Add your control notification handler code here
this->CalculateTemp(ID_DCGRADF);
}

void CDimCalcDlg::OnGradCelsius() 
{
	// TODO: Add your control notification handler code here
this->CalculateTemp(ID_DCGRADC);
}


/************************************************************************
 *  DCalcDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CDimCalcDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
