#if !defined(AFX_DCALCDLG_H__60E8D261_1CF2_11D2_BFB4_DD57A104A07C__INCLUDED_)
#define AFX_DCALCDLG_H__60E8D261_1CF2_11D2_BFB4_DD57A104A07C__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// DCalcDlg.h : header file
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// CDimCalcDlg dialog

class CDimCalcDlg : public CDlgTool
{
typedef enum
	{
	INPUT,
	OUTPUT
	} SETDIM;
	
typedef enum
	{
	OIL,
	FUEL,
	OTHER
	} DENSITY;
// Construction
public:
	CDimCalcDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CDimCalcDlg)
	enum { IDD = IDD_DIMCALCBOX };
	double	m_fInput;
	CString	m_szOutput;
	int		m_nSetDim;
	int		m_nLastDens;
	float	m_fDensity;
	//}}AFX_DATA

BOOL m_bCalculate;
BOOL m_bNeedDens;
BOOL m_bOtherDens;

short	m_nLastDim1;
double	m_fFakt1;
double	m_fFakt2;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDimCalcDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	float GetDensity (DENSITY Dens);
	void SetDimData(double dResult, short nActSel);
	void CalculateDistance(short nActSel);
	void CalculateSpeed(short nActSel);
	void CalculateVolume(short nActSel);
	void CalculateMass(short nActSel);
	void CalculatePress(short nActSel);
	void CalculateTemp(short nActSel);

	// Generated message map functions
	//{{AFX_MSG(CDimCalcDlg)
	afx_msg void OnFuelDens();
	afx_msg void OnOtherDens();
	afx_msg void OnOilDens();
	afx_msg void OnChangeOtherDens();
	afx_msg void OnSetInputDim();
	afx_msg void OnSetOutputDim();
	virtual BOOL OnInitDialog();
	afx_msg void OnChangeInput();
	afx_msg void OnFeet();
	afx_msg void OnYards();
	afx_msg void OnMeter();
	afx_msg void OnKiloMeter();
	afx_msg void OnStatuteMiles();
	afx_msg void OnNauticalMiles();
	afx_msg void OnFeetPerMinute();
	afx_msg void OnKmPerHour();
	afx_msg void OnMilesPerHour();
	afx_msg void OnKnots();
	afx_msg void OnMeterPerSecond();
	afx_msg void OnUSQuarts();
	afx_msg void OnLiter();
	afx_msg void OnBritishQuarts();
	afx_msg void OnUSGallons();
	afx_msg void OnBritishGallons();
	afx_msg void OnPounds();
	afx_msg void OnKg();
	afx_msg void OnHektoPascal();
	afx_msg void OnMillimeterHg();
	afx_msg void OnInchHg();
	afx_msg void OnGradFahrenheit();
	afx_msg void OnGradCelsius();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DCALCDLG_H__60E8D261_1CF2_11D2_BFB4_DD57A104A07C__INCLUDED_)
