// DimDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"
 
#include "DimDoc.h"
#include "DimDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDimDlg dialog


/************************************************************************
 *  DimDlg.cpp   			C D i m D l g	 		Constructor			*
 ************************************************************************/
CDimDlg::CDimDlg(CWnd* pParent, CDimDoc* ptDoc)
	: CDialog(CDimDlg::IDD, pParent)
{
m_ptDoc = ptDoc;

this->SetDimensions(m_ptDoc->Arm(),  m_ptDoc->Altitude(),  
					m_ptDoc->Distance(), m_ptDoc->RwyLength(),  
					m_ptDoc->Mass(), m_ptDoc->Press(),
					m_ptDoc->Temp(), m_ptDoc->Volume(),  
					m_ptDoc->Wind());

m_nFormLatLon = (short)m_ptDoc->GetLatLonFormat ();
}

void CDimDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDimDlg)
	DDX_Radio(pDX, ID_PRARM_M, m_nArm);
	DDX_Radio(pDX, ID_PRALT_FT, m_nAlt);
	DDX_Radio(pDX, ID_PRDIST_NM, m_nDist);
	DDX_Radio(pDX, ID_PRLEN_MTR, m_nLen);
	DDX_Radio(pDX, ID_PRMASS_KG, m_nMass);
	DDX_Radio(pDX, ID_PRPRESS_HPA, m_nPress);
	DDX_Radio(pDX, ID_PRTEMP_C, m_nTemp);
	DDX_Radio(pDX, ID_PRVOL_LTR, m_nVol);
	DDX_Radio(pDX, ID_PRWIND_KT, m_nWind);
	DDX_CBIndex(pDX, ID_PRFORMLL, m_nFormLatLon);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDimDlg, CDialog)
	//{{AFX_MSG_MAP(CDimDlg)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/************************************************************************
 *  DimDlg.cpp   			   O n I n i t D i a l o g 	 	 	 	 	*
 ************************************************************************/
BOOL CDimDlg::OnInitDialog()       
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/************************************************************************
 *  DimDlg.cpp   			S e t D i m e n s i o n s					*
 ************************************************************************/
void CDimDlg::SetDimensions(short nArm,  short nAlt,  short nDist,
							short nLen,  short nMass, short nPress,
							short nTemp, short nVol,  short nWind)
{
m_nArm = (nArm==DIM_METER)*0 + (nArm==DIM_CM)*1 + (nArm==DIM_INCH)*2;
m_nAlt = (nAlt==DIM_FEET)*0 + (nAlt==DIM_METER)*1;
m_nDist = (nDist==DIM_NM)*0 + (nDist==DIM_STM)*1 + (nDist==DIM_KM)*2 + (nDist==DIM_METER)*3;
m_nLen = (nLen==DIM_METER)*0 + (nLen==DIM_FEET)*1;
m_nMass = (nMass==DIM_KG)*0 + (nMass==DIM_POUNDS)*1;
m_nPress = (nPress==DIM_HPA)*0 + (nPress==DIM_INCHHG)*1 + (nPress==DIM_MMHG)*2;
m_nTemp = (nTemp==DIM_C)*0 + (nTemp==DIM_F)*1;
m_nVol = (nVol==DIM_LITER)*0 + (nVol==DIM_USGAL)*1 + (nVol==DIM_BRGAL)*2;
m_nWind = (nWind==DIM_KT)*0 + (nWind==DIM_MPS)*1 + (nWind==DIM_KMH)*2; 
}

/************************************************************************
 *  DimDlg.cpp   			   G e t D i m e n s i o n s				*
 ************************************************************************/
void CDimDlg::GetDimensions (short* ptArm,  short* ptAlt,  short* ptDist,
							short* ptLen,  short* ptMass, short* ptPress,
							short* ptTemp, short* ptVol,  short* ptWind)
{
*ptArm = (m_nArm==0)*DIM_METER + (m_nArm==1)*DIM_CM + (m_nArm==2)*DIM_INCH;
*ptAlt = (m_nAlt==0)*DIM_FEET + (m_nAlt==1)*DIM_METER;
*ptDist = (m_nDist==0)*DIM_NM + (m_nDist==1)*DIM_STM + (m_nDist==2)*DIM_KM + (m_nDist==3)*DIM_METER;
*ptLen = (m_nLen==0)*DIM_METER + (m_nLen==1)*DIM_FEET;
*ptMass = (m_nMass==0)*DIM_KG + (m_nMass==1)*DIM_POUNDS;
*ptPress = (m_nPress==0)*DIM_HPA + (m_nPress==1)*DIM_INCHHG + (m_nPress==2)*DIM_MMHG;
*ptTemp = (m_nTemp==0)*DIM_C + (m_nTemp==1)*DIM_F;
*ptVol = (m_nVol==0)*DIM_LITER + (m_nVol==1)*DIM_USGAL + (m_nVol==2)*DIM_BRGAL;
*ptWind = (m_nWind==0)*DIM_KT + (m_nWind==1)*DIM_MPS + (m_nWind==2)*DIM_KMH;
}   


/************************************************************************
 *  DimDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CDimDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}

