/************************************************************************
 *  						D i m D o c . c p p  						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "math.h"							// for: floor
#include "pf.h"

#include "DimDlg.h"				// dialog to set dimensions
#include "DimDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDimDoc    

IMPLEMENT_DYNCREATE(CDimDoc, CDocument)

BEGIN_MESSAGE_MAP(CDimDoc, CDocument)
	//{{AFX_MSG_MAP(CDimDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDimDoc construction/destruction


CDimDoc::CDimDoc()
{           
m_nAltDim = DIM_FEET;		    /* prefered dimensions	   */
m_nDistDim = DIM_NM;
m_nLenDim = DIM_METER;
m_nMassDim = DIM_KG;
m_nWindDim = DIM_KT;
m_nTempDim = DIM_C;
m_nPressDim = DIM_HPA;
m_nVolDim = DIM_LITER;
m_nArmDim = DIM_METER;
m_nFreqDim = DIM_MHZ;

m_nFormLatLon = LLF_GGGMMSS;
}

CDimDoc::~CDimDoc()
{
}
     

/************************************************************************
 *  DimDoc.cpp    			S t r i n g T o D i m						*
 ************************************************************************/
BOOL CDimDoc::StringToDim (CString szDim, short* ptDim)
{
	*ptDim = 0;

	if (szDim.Compare("DIM_FEET") == 0) 	*ptDim = DIM_FEET;
	if (szDim.Compare("DIM_YARD") == 0) 	*ptDim = DIM_YARD;
	if (szDim.Compare("DIM_METER") == 0) 	*ptDim = DIM_METER;
	if (szDim.Compare("DIM_KM") == 0) 		*ptDim = DIM_KM;
	if (szDim.Compare("DIM_STM") == 0) 		*ptDim = DIM_STM;
	if (szDim.Compare("DIM_NM") == 0)		*ptDim = DIM_NM;
	if (szDim.Compare("DIM_FL") == 0)		*ptDim = DIM_FL;
	if (szDim.Compare("DIM_FTPM") == 0) 	*ptDim = DIM_FTPM;
	if (szDim.Compare("DIM_KMH") == 0)		*ptDim = DIM_KMH;
	if (szDim.Compare("DIM_MPH") == 0)		*ptDim = DIM_MPH;
	if (szDim.Compare("DIM_KT") == 0)		*ptDim = DIM_KT;
	if (szDim.Compare("DIM_MPS") == 0)		*ptDim = DIM_MPS;
	if (szDim.Compare("DIM_USQRT") == 0)	*ptDim = DIM_USQRT;
	if (szDim.Compare("DIM_LITER") == 0)	*ptDim = DIM_LITER;
	if (szDim.Compare("DIM_BRQRT") == 0)	*ptDim = DIM_BRQRT;
	if (szDim.Compare("DIM_USGAL") == 0)	*ptDim = DIM_USGAL;
	if (szDim.Compare("DIM_BRGAL") == 0)	*ptDim = DIM_BRGAL;
	if (szDim.Compare("DIM_POUNDS") == 0)	*ptDim = DIM_POUNDS;
	if (szDim.Compare("DIM_KG") == 0)		*ptDim = DIM_KG;
	if (szDim.Compare("DIM_HPA") == 0)		*ptDim = DIM_HPA;
	if (szDim.Compare("DIM_MMHG") == 0)		*ptDim = DIM_MMHG;
	if (szDim.Compare("DIM_INCHHG") == 0)	*ptDim = DIM_INCHHG;
	if (szDim.Compare("DIM_F") == 0)		*ptDim = DIM_F;
	if (szDim.Compare("DIM_C") == 0)		*ptDim = DIM_C;
	if (szDim.Compare("DIM_CM") == 0)		*ptDim = DIM_CM;
	if (szDim.Compare("DIM_INCH") == 0)		*ptDim = DIM_INCH;
	if (szDim.Compare("DIM_KHZ") == 0)		*ptDim = DIM_KHZ;
	if (szDim.Compare("DIM_MHZ") == 0)		*ptDim = DIM_MHZ;

	return (*ptDim > 0);
}

/************************************************************************
 *  DimDoc.cpp	  		  G e t D i m C s t r i n g 					*
 ************************************************************************/
void CDimDoc::GetDimCstring (CString* ptDim, short nDim)
{
short nID = -1;

switch (nDim)
	{
	case DIM_CM:	nID = IDS_CM_ABR;	break;
	case DIM_INCH:	nID = IDS_INCH;		break;
	case DIM_FEET:	nID = IDS_FEET_ABR;	break;
	case DIM_METER:	nID = IDS_METER_ABR;	break;
	case DIM_KM:	nID = IDS_KM;		break;
	case DIM_STM:	nID = IDS_STM;		break;
	case DIM_NM:	nID = IDS_NM;		break;
	case DIM_FL:	nID = IDS_FL;		break;

	case DIM_FTPM:	nID = IDS_FPM_ABR;	break;
	case DIM_KMH:	nID = IDS_KMPH; 	break;
	case DIM_MPH:	nID = IDS_MPH;		break;
	case DIM_KT:	nID = IDS_KNOTS_ABR;	break;
	case DIM_MPS:	nID = IDS_MPS;		break;
	
	case DIM_POUNDS:nID = IDS_POUNDS_ABR;	break;
	case DIM_KG:	nID = IDS_KG;		break;

	case DIM_HPA:	nID = IDS_HPA;		break;
	case DIM_MMHG:	nID = IDS_MMHG; 	break;
	case DIM_INCHHG:nID = IDS_INCHHG;	break;
	
	case DIM_F:	nID = IDS_FAHRENH_ABR;	break;
	case DIM_C:	nID = IDS_CELSIUS_ABR;	break;

	case DIM_USQRT:	nID = IDS_USQRT;	break;
	case DIM_LITER:	nID = IDS_LITER;	break;
	case DIM_BRQRT:	nID = IDS_BRQRT;	break;
	case DIM_USGAL:	nID = IDS_USGAL;	break;
	case DIM_BRGAL:	nID = IDS_BRGAL;	break;

	case DIM_KHZ:	nID = IDS_KHZ;		break;
	case DIM_MHZ:	nID = IDS_MHZ;		break;
	}     
	
	if (nID >= 0)	ptDim->LoadString (nID);
		else		ptDim->Empty();
}  
         
/************************************************************************
 *  DimDoc.cpp			D i s t D i m T o S p e e d D i m				*
 ************************************************************************/
short CDimDoc::DistDimToSpeedDim (short nDistDim)
{
short	nSpeedDim;

nSpeedDim = DIM_KT;
switch (nDistDim)
    {
    case DIM_NM:    nSpeedDim = DIM_KT;  break;
    case DIM_KM:    nSpeedDim = DIM_KMH; break;
    case DIM_STM:   nSpeedDim = DIM_MPH; break;
    }

return nSpeedDim;
}          

/************************************************************************
 *  DimDoc.cpp			S p e e d D i m T o D i s t D i m				*
 ************************************************************************/
short CDimDoc::SpeedDimToDistDim (short nSpeedDim)
{
short	nDistDim;

nDistDim = DIM_NM;
switch (nSpeedDim)
    {
    case DIM_KT:    nDistDim = DIM_NM;  break;
    case DIM_KMH:   nDistDim = DIM_KM;  break;
    case DIM_MPH:   nDistDim = DIM_STM; break;
    }

return nDistDim;
}   
       
/************************************************************************
 *  DimDoc.cpp			A l t D i m T o C l i m b D i m					*
 ************************************************************************/
short CDimDoc::AltDimToClimbDim (short nAltDim)
{
short	nSpeedDim;

switch (nAltDim)
    {
    case DIM_METER:	nSpeedDim = DIM_MPS;  break;
    default:		nSpeedDim = DIM_FTPM; break;
    }

return nSpeedDim;
}

/************************************************************************
 *  DimDoc.cpp			C l i m b D i m T o A l t D i m					*
 ************************************************************************/
short CDimDoc::ClimbDimToAltDim (short nClimbDim)
{
short	nAltDim;

switch (nClimbDim)
    {
	case DIM_MPS:	nAltDim = DIM_METER;	break;
    default:		nAltDim = DIM_FEET;		break;
    }

return nAltDim;
}                                                              

/************************************************************************
 *  DimDoc.cpp					M i n u t e s T o H M S					*
 ************************************************************************/
void CDimDoc::MinutesToHMS(unsigned long ulMinutes, unsigned long ulSeconds, 
						   short* ptHours, short* ptMinutes, short* ptSeconds)
{
	*ptHours = 0;
	*ptMinutes = 0;
	*ptSeconds = 0;

	
	unsigned long ulMinutesOfSec = 0;

	if (ulSeconds > 60)
		ulMinutesOfSec = (int)(ulSeconds / 60);
	unsigned long ulTotalMin = ulMinutes + ulMinutesOfSec;


	if (ulTotalMin > 60)
	{
		*ptHours = (short)(ulTotalMin / 60);
	}

	*ptMinutes = (short)(ulTotalMin - (60 * *ptHours));
	*ptSeconds = (short)(ulSeconds  - (60 * ulMinutesOfSec));
}

/************************************************************************
 *  DimDoc.cpp					M i n u t e s T o H M S					*
 ************************************************************************/
void CDimDoc::MinutesToHMS(double dMin, short* ptHours, short* ptMinutes, short* ptSeconds)
{
	*ptHours = 0;
	*ptMinutes = 0;
	*ptSeconds = 0;

	if (dMin > 60)
	{
		*ptHours = (short)floor(dMin/60);
	}

	double dRestMinutes = dMin - (60 * *ptHours);

	if (dRestMinutes > 1)
	{
		*ptMinutes = (short)floor(dRestMinutes);
	}

	double dRestSeconds = dRestMinutes - (*ptMinutes);

	*ptSeconds = (short)(dRestSeconds * 60 + .5);
}

/************************************************************************
 *  DimDoc.cpp	  		 		 C h a n g e 							*
 ************************************************************************/
void CDimDoc::Change(CWnd* ptWnd)
{
CDimDlg DimPrefDlg(ptWnd, this);

int RetVal = DimPrefDlg.DoModal();
switch (RetVal)
	{
	case IDOK:        
		DimPrefDlg.GetDimensions (&m_nArmDim,  &m_nAltDim, &m_nDistDim,
						  &m_nLenDim, &m_nMassDim, &m_nPressDim,
						  &m_nTempDim, &m_nVolDim,  &m_nWindDim);
		m_nFormLatLon = (LATLONFORM)DimPrefDlg.GetLatLonFormat ();	
 		ptWnd->InvalidateRect(NULL);
		break;
	case IDCANCEL:
		break;
	}	
} 


/************************************************************************
 *  DimDoc.cpp	  		 		 S e r i a l i z e 						*
 ************************************************************************/
void CDimDoc::Serialize(CArchive& ar)
{    
WORD	Word;

if (ar.IsStoring())
	{
		// TODO: add storing code here  
	ar << (WORD)m_nAltDim;		 
	ar << (WORD)m_nDistDim;
	ar << (WORD)m_nLenDim;
	ar << (WORD)m_nMassDim;
	ar << (WORD)m_nWindDim;
	ar << (WORD)m_nTempDim;
	ar << (WORD)m_nPressDim;
	ar << (WORD)m_nVolDim;
	ar << (WORD)m_nArmDim;
	ar << (WORD)m_nFormLatLon;
	}
else{
		// TODO: add loading code here  
	ar >> Word;		m_nAltDim  = (short)Word;
	ar >> Word;		m_nDistDim = (short)Word;
	ar >> Word;		m_nLenDim  = (short)Word;
	ar >> Word;		m_nMassDim = (short)Word;
	ar >> Word;		m_nWindDim = (short)Word;
	ar >> Word;		m_nTempDim = (short)Word;
	ar >> Word;		m_nPressDim= (short)Word;
	ar >> Word;		m_nVolDim  = (short)Word;
	ar >> Word;		m_nArmDim  = (short)Word;
	ar >> Word;		m_nFormLatLon = (LATLONFORM)Word;
	}
}


            
/************************************************************************
 *  DimDoc.cpp				F i l l P U 							*
 ************************************************************************/
void CDimDoc::FillPU (CComboBox* ptPopUp, PARAMETER Param)    
{
CString szDim;
switch (Param)
	{                    
	case ALTITUDE:  
		szDim.LoadString (IDS_FEET_ABR);   			// DIM_FEET
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_METER_ABR);   		// 	DIM_METER
        ptPopUp->AddString ((LPCTSTR)szDim);
		break;
	case DISTANCE: 
		szDim.LoadString (IDS_NM);   			// DIM_NM
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_KM);   			// DIM_KM
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_STM);   			// DIM_STM
        ptPopUp->AddString ((LPCTSTR)szDim);
 		break;       

 	case CRUISESPEED:
		szDim.LoadString (IDS_KNOTS_ABR);   	// DIM_KT
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_KMPH);   			// DIM_KMH
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_MPH);   			// DIM_MPH
        ptPopUp->AddString ((LPCTSTR)szDim);
 		break;       

	case CLIMBRATE:
		szDim.LoadString (IDS_FPM_ABR);   		// DIM_FTPM
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_MPS);   			// DIM_MPS
        ptPopUp->AddString ((LPCTSTR)szDim);
 		break;       

	case RWYLENGTH: 
		szDim.LoadString (IDS_METER_ABR);   	// 	DIM_METER
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_FEET_ABR);   		// DIM_FEET
        ptPopUp->AddString ((LPCTSTR)szDim);
		break;
	case MASS:
		szDim.LoadString (IDS_KG);   			// 	DIM_KG
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_POUNDS_ABR);   	// 	DIM_POUNDS
        ptPopUp->AddString ((LPCTSTR)szDim);
     	break;
	case WIND:	
		szDim.LoadString (IDS_KNOTS_ABR);   	// 	DIM_KT
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_MPS);   			// 	DIM_MPS
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_KMPH);   			// 	DIM_KMH
        ptPopUp->AddString ((LPCTSTR)szDim);
		break;
	case TEMP:   
		szDim.LoadString (IDS_CELSIUS_ABR);   	// 	DIM_C
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_FAHRENH_ABR);   	// 	DIM_F
        ptPopUp->AddString ((LPCTSTR)szDim);
	  	break;
	case PRESS:	
		szDim.LoadString (IDS_HPA);   			// 	DIM_HPA
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_MMHG);  		 	// 	DIM_MMHG
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_INCHHG);   		// 	DIM_INCHHG
        ptPopUp->AddString ((LPCTSTR)szDim);
		break;
	case VOLUME:	
		szDim.LoadString (IDS_LITER);   		// 	DIM_LITER
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_USGAL);   		// 	DIM_USGAL
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_BRGAL);   		// 	DIM_BRGAL
        ptPopUp->AddString ((LPCTSTR)szDim);
		break;
	case ARM:
		szDim.LoadString (IDS_METER_ABR);   	// 	DIM_METER
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_CM_ABR);   		// 	DIM_CM
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_INCH);   			// 	DIM_INCH
        ptPopUp->AddString ((LPCTSTR)szDim);
		break;           
	case FREQ:
		szDim.LoadString (IDS_KHZ);   			// 	DIM_KHZ
        ptPopUp->AddString ((LPCTSTR)szDim);
		szDim.LoadString (IDS_MHZ);   			// 	DIM_MHZ
        ptPopUp->AddString ((LPCTSTR)szDim);
		break;
	}
}                 
   
/************************************************************************
 *  DimDoc.cpp					G e t P U I n d e x						*
 ************************************************************************/
short CDimDoc::GetPUIndex (PARAMETER Param, short nDim)    
{
short nPopUpIndex = -1;

switch (Param)
	{                    
	case ALTITUDE:  
		switch (nDim)
			{
			case DIM_FEET:	nPopUpIndex = 0;	break;	
			case DIM_METER:	nPopUpIndex = 1;	break;	 
			}
 		break;
	case DISTANCE:      
		switch (nDim)
			{
			case DIM_NM:	nPopUpIndex = 0;	break;	
			case DIM_KM:	nPopUpIndex = 1;	break;	 
			case DIM_STM:	nPopUpIndex = 2;	break;	 
			}
 		break; 
		
	case CRUISESPEED:      
		switch (nDim)
			{
			case DIM_KT:	nPopUpIndex = 0;	break;	
			case DIM_KMH:	nPopUpIndex = 1;	break;	 
			case DIM_MPH:	nPopUpIndex = 2;	break;	 
			}
 		break; 
 
	case CLIMBRATE:    
		switch (nDim)
			{
			case DIM_FTPM:	nPopUpIndex = 0;	break;	
			case DIM_MPS:	nPopUpIndex = 1;	break;	 
			}
		break;
 		
	case RWYLENGTH:    
		switch (nDim)
			{
			case DIM_METER:	nPopUpIndex = 0;	break;	
			case DIM_FEET:	nPopUpIndex = 1;	break;	 
			}
		break;
	case MASS:
		switch (nDim)
			{
			case DIM_KG:		nPopUpIndex = 0;	break;	
			case DIM_POUNDS:	nPopUpIndex = 1;	break;	 
			}
     	break;
	case WIND:	
		switch (nDim)
			{
			case DIM_KT:	nPopUpIndex = 0;	break;	
			case DIM_MPS:	nPopUpIndex = 1;	break;	 
			case DIM_KMH:	nPopUpIndex = 2;	break;	 
			}
		break;
	case TEMP:   
		switch (nDim)
			{
			case DIM_C:	nPopUpIndex = 0;	break;	
			case DIM_F:	nPopUpIndex = 1;	break;	 
			}
	  	break;
	case PRESS:	
		switch (nDim)
			{
			case DIM_HPA:		nPopUpIndex = 0;	break;	
			case DIM_MMHG:		nPopUpIndex = 1;	break;	 
			case DIM_INCHHG:	nPopUpIndex = 2;	break;	 
			}
		break;
	case VOLUME:	
		switch (nDim)
			{
			case DIM_LITER:		nPopUpIndex = 0;	break;	
			case DIM_USGAL:		nPopUpIndex = 1;	break;	 
			case DIM_BRGAL:		nPopUpIndex = 2;	break;	 
			}
		break;
	case ARM:
		switch (nDim)
			{
			case DIM_METER:		nPopUpIndex = 0;	break;	
			case DIM_CM:		nPopUpIndex = 1;	break;	 
			case DIM_INCH:		nPopUpIndex = 2;	break;	 
			}
		break;           
	case FREQ:
		switch (nDim)
			{
			case DIM_KHZ:		nPopUpIndex = 0;	break;	
			case DIM_MHZ:		nPopUpIndex = 1;	break;	 
			}
		break;           
	}   
return nPopUpIndex;
}        

/************************************************************************
 *  DimDoc.cpp				G e t P U D i m								*
 ************************************************************************/
short CDimDoc::GetPUDim (PARAMETER Param, short nPopUpIndex)    
{     
short nDim = NO_DIM;
switch (Param)
	{                    
	case ALTITUDE:  
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_FEET;	break;	
			case 1: nDim = DIM_METER;	break;	 
			}
 		break;
	case DISTANCE:      
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_NM;	break;	
			case 1: nDim = DIM_KM;	break;	 
			case 2: nDim = DIM_STM;	break;	 
			}
 		break;

	case CRUISESPEED:      
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_KT;	break;	
			case 1: nDim = DIM_KMH;	break;	 
			case 2: nDim = DIM_MPH;	break;	 
			}
 		break; 
 
	case CLIMBRATE:    
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_FTPM;	break;	
			case 1: nDim = DIM_MPS;		break;	 
			}
		break;
 		

	case RWYLENGTH:    
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_METER;	break;	
			case 1: nDim = DIM_FEET;	break;	 
			}
		break;
	case MASS:
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_KG;	break;	
			case 1: nDim = DIM_POUNDS;	break;	 
			}
     	break;
	case WIND:	
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_KT;	break;	
			case 1: nDim = DIM_MPS;	break;	 
			case 2: nDim = DIM_KMH;	break;	 
			}
		break;
	case TEMP:   
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_C;	break;	
			case 1: nDim = DIM_F;	break;	 
			}
	  	break;
	case PRESS:	
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_HPA;	break;	
			case 1: nDim = DIM_MMHG;	break;	 
			case 2: nDim = DIM_INCHHG;	break;	 
			}
		break;
	case VOLUME:	
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_LITER;	break;	
			case 1: nDim = DIM_USGAL;	break;	 
			case 2: nDim = DIM_BRGAL;	break;	 
			}
		break;
	case ARM:
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_METER;	break;	
			case 1: nDim = DIM_CM;		break;	 
			case 2: nDim = DIM_INCH;	break;	 
			}
		break;           
	case FREQ:
		switch (nPopUpIndex)
			{
			case 0: nDim = DIM_KHZ;		break;	
			case 1: nDim = DIM_MHZ;		break;	 
			}
		break;           
	}      
return nDim;
}  
            
/************************************************************************
 *  DimDoc.cpp	  		 		 C e l s T o F a h r					*
 ************************************************************************/
double CDimDoc::CelsToFahr (double fTemp1, BOOL bCelsiusToFahrenheit)
{
double fTemp2;

if (bCelsiusToFahrenheit)
    {				    /* fTemp1 in Grad Celsius	    */
    fTemp2 = 32 + 9*fTemp1/5;
    }
else{					/* fTemp1 in Grad Fahrenheit	*/
    fTemp2 = (fTemp1 - 32) * 5/9;
    }
return fTemp2;
}

/************************************************************************
 *  DimDoc.cpp				G e t D i s t F a k t						*
 ************************************************************************/
double CDimDoc::GetDistFakt (short nDim)
{
double fFakt = 1;

switch (nDim)
	{
	case DIM_CM:	fFakt = METER_PER_CM;	break;
	case DIM_INCH:	fFakt = METER_PER_INCH;	break;
	case DIM_FEET:	fFakt = METER_PER_FOOT;	break;
	case DIM_YARD:	fFakt = METER_PER_YARD;	break;
	case DIM_METER:	fFakt = 1.0;		break;
	case DIM_KM:	fFakt = METER_PER_KM;	break;
	case DIM_STM:	fFakt = METER_PER_SM;	break;
	case DIM_NM:	fFakt = METER_PER_NM;	break;
	}
	
return fFakt;
}

/************************************************************************
 *  DimDoc.cpp				G e t S p e e d F a k t						*
 ************************************************************************/
double CDimDoc::GetSpeedFakt (short nDim)
{
double fFakt;

switch (nDim)
	{
	case DIM_FTPM:	fFakt = KMPH_PER_FTPM;	break;
	case DIM_KMH:	fFakt = 1.0;		break;
	case DIM_MPH:	fFakt = KMPH_PER_MPH;	break;
	case DIM_KT:	fFakt = KMPH_PER_NMPH;	break;
	case DIM_MPS:	fFakt = KMPH_PER_MPS;	break;
	}
	
return fFakt;
}

/************************************************************************
 *  DimDoc.cpp				G e t V o l u m e F a k t					*
 ************************************************************************/
double CDimDoc::GetVolumeFakt (short nDim)
{
double fFakt;

switch (nDim)
	{
	case DIM_USQRT:	fFakt = L_PER_USQRT;	break;
	case DIM_LITER:	fFakt = 1.0;		break;
	case DIM_BRQRT:	fFakt = L_PER_BRQRT;	break;
	case DIM_USGAL:	fFakt = L_PER_USGAL;	break;
	case DIM_BRGAL:	fFakt = L_PER_BRGAL;	break;
	}
	
return fFakt;
}

/************************************************************************
 *  DimDoc.cpp				G e t M a s s F a k t						*
 ************************************************************************/
double CDimDoc::GetMassFakt (short nDim)
{
double fFakt;

switch (nDim)
	{
	case DIM_POUNDS:	fFakt = KG_PER_POUND;	break;
	case DIM_KG:		fFakt = 1.0;		break;
	}
	
return fFakt;
}

/************************************************************************
 *  DimDoc.cpp				G e t P r e s s F a k t						*
 ************************************************************************/
double CDimDoc::GetPressFakt (short nDim)
{
double fFakt;

switch (nDim)
	{
	case DIM_HPA:	fFakt = 1.0;		break;
	case DIM_MMHG:	fFakt = HPA_PER_MMHG;	break;
	case DIM_INCHHG:fFakt = HPA_PER_INHG;	break;
	}
	
return fFakt;
}

/************************************************************************
 *  DimDoc.cpp				G e t F r e q F a k t						*
 ************************************************************************/
double CDimDoc::GetFreqFakt (short nDim)
{
double fFakt;
switch (nDim)
	{
	case DIM_KHZ:	fFakt = 1.0;			break;
	case DIM_MHZ:	fFakt = KHZ_PER_MHZ;	break;
	}
	
return fFakt;
}

/************************************************************************
 *  DimDoc.cpp				C o n v e r t D i s t						*
 ************************************************************************/
double CDimDoc::ConvertDist (double fOldValue, short nOldDim, short nNewDim)
{
double fNewValue;

if (nNewDim == nOldDim)
    {
    fNewValue = fOldValue;
    }
else{
    double fFakt1, fFakt2;

    fFakt1 = GetDistFakt (nOldDim);
    fFakt2 = GetDistFakt (nNewDim);
    fNewValue = fOldValue * fFakt1 / fFakt2;
    }
return fNewValue;
}


/************************************************************************
 *  DimDoc.cpp				   C o n v e r t S p e e d					*
 ************************************************************************/
double CDimDoc::ConvertSpeed (double fOldValue, short nOldDim, short nNewDim)
{
double fNewValue;

if (nNewDim == nOldDim)
    {
    fNewValue = fOldValue;
    }
else{
    double fFakt1, fFakt2;

    fFakt1 = GetSpeedFakt (nOldDim);
    fFakt2 = GetSpeedFakt (nNewDim);
    fNewValue = fOldValue * fFakt1 / fFakt2;
    }
return fNewValue;
}

/************************************************************************
 *  DimDoc.cpp					C o n v e r t M a s s					*
 ************************************************************************/
double CDimDoc::ConvertMass (double fOldValue, short nOldDim, short nNewDim)
{
double fNewValue;

if (nNewDim == nOldDim)
    {
    fNewValue = fOldValue;
    }
else{
    double fFakt1, fFakt2;

    fFakt1 = GetMassFakt (nOldDim);
    fFakt2 = GetMassFakt (nNewDim);
    fNewValue = fOldValue * fFakt1 / fFakt2;
    }
return fNewValue;
}


/************************************************************************
 *  DimDoc.cpp					C o n v e r t P r e s s					*
 ************************************************************************/
double CDimDoc::ConvertPress (double fOldValue, short nOldDim, short nNewDim)
{
double fNewValue;

if (nNewDim == nOldDim)
    {
    fNewValue = fOldValue;
    }
else{
    double fFakt1, fFakt2;

    fFakt1 = GetPressFakt (nOldDim);
    fFakt2 = GetPressFakt (nNewDim);
    fNewValue = fOldValue * fFakt1 / fFakt2;
    }
return fNewValue;
}

/************************************************************************
 *  DimDoc.cpp					C o n v e r t T e m p					*
 ************************************************************************/
double CDimDoc::ConvertTemp (double fOldValue, short nOldDim, short nNewDim)
{
double fNewValue;

if (nNewDim == nOldDim)
    {
    fNewValue = fOldValue;
    }
else{
    BOOL bCelsiusToFahrenheit;

    bCelsiusToFahrenheit = (nOldDim == DIM_C);
    fNewValue = CelsToFahr (fOldValue, bCelsiusToFahrenheit);
    }
return fNewValue;
}

/************************************************************************
 *  DimDoc.cpp				C o n v e r t V o l u m e					*
 ************************************************************************/
double CDimDoc::ConvertVolume (double fOldValue, short nOldDim, short nNewDim)
{
double fNewValue;

if (nNewDim == nOldDim)
    {
    fNewValue = fOldValue;
    }
else{
    double fFakt1, fFakt2;

    fFakt1 = GetVolumeFakt (nOldDim);
    fFakt2 = GetVolumeFakt (nNewDim);
    fNewValue = fOldValue * fFakt1 / fFakt2;
    }
return fNewValue;
}   
 

/************************************************************************
 *  DimDoc.cpp				C o m p a r e D i s t						*
 ************************************************************************/
short CDimDoc::CompareDist (double fValue1, short nDim1, double fValue2, short nDim2, double fDflt)
{     
short nRetVal = 0;

if ((fValue1 != fDflt) && (fValue2 != fDflt))
	{	
	double fConvert1 = this->ConvertDist (fValue1, nDim1, nDim2);
	if ((fConvert1 - fValue2) > CMP_LIMIT) nRetVal = 1;         
	if ((fValue2 - fConvert1) > CMP_LIMIT) nRetVal = -1;
	}                 
	
if ((fValue1 != fDflt) && (fValue2 == fDflt))
	nRetVal = 1;	
if ((fValue1 == fDflt) && (fValue2 != fDflt))
	nRetVal = -1;	

return nRetVal;	
}         

/************************************************************************
 *  DimDoc.cpp				C o m p a r e S p e e d						*
 ************************************************************************/
short CDimDoc::CompareSpeed (double fValue1, short nDim1, double fValue2, short nDim2, double fDflt)
{     
short nRetVal = 0;

if ((fValue1 != fDflt) && (fValue2 != fDflt))
	{	
	double fConvert1 = this->ConvertSpeed (fValue1, nDim1, nDim2);
	if ((fConvert1 - fValue2) > CMP_LIMIT) nRetVal = 1;         
	if ((fValue2 - fConvert1) > CMP_LIMIT) nRetVal = -1;
	}                 
	
if ((fValue1 != fDflt) && (fValue2 == fDflt))
	nRetVal = 1;	
if ((fValue1 == fDflt) && (fValue2 != fDflt))
	nRetVal = -1;	

return nRetVal;	
}                      

/************************************************************************
 *  DimDoc.cpp				C o m p a r e V o l u m e					*
 ************************************************************************/
short CDimDoc::CompareVolume (double fValue1, short nDim1, double fValue2, short nDim2, double fDflt)
{     
short nRetVal = 0;

if ((fValue1 != fDflt) && (fValue2 != fDflt))
	{	
	double fConvert1 = this->ConvertVolume (fValue1, nDim1, nDim2);
	if ((fConvert1 - fValue2) > CMP_LIMIT) nRetVal = 1;         
	if ((fValue2 - fConvert1) > CMP_LIMIT) nRetVal = -1;
	}                 
	
if ((fValue1 != fDflt) && (fValue2 == fDflt))
	nRetVal = 1;	
if ((fValue1 == fDflt) && (fValue2 != fDflt))
	nRetVal = -1;	

return nRetVal;	
}    


/************************************************************************
 *  DimDoc.cpp				C o m p a r e M a s s						*
 ************************************************************************/
short CDimDoc::CompareMass (double fValue1, short nDim1, double fValue2, short nDim2, double fDflt)
{     
short nRetVal = 0;

if ((fValue1 != fDflt) && (fValue2 != fDflt))
	{	
	double fConvert1 = this->ConvertMass (fValue1, nDim1, nDim2);
	if ((fConvert1 - fValue2) > CMP_LIMIT) nRetVal = 1;         
	if ((fValue2 - fConvert1) > CMP_LIMIT) nRetVal = -1;
	}                 
	
if ((fValue1 != fDflt) && (fValue2 == fDflt))
	nRetVal = 1;	
if ((fValue1 == fDflt) && (fValue2 != fDflt))
	nRetVal = -1;	

return nRetVal;	
}    

/************************************************************************
 *  DimDoc.cpp				C o m p a r e T o r q						*
 ************************************************************************/
short CDimDoc::CompareTorq (double fValue1, short nArmDim1, short nMassDim1,
							double fValue2, short nArmDim2, short nMassDim2, double fDflt)
{     
short nRetVal = 0;

if ((fValue1 != fDflt) && (fValue2 != fDflt))
	{	
	double fConvert1 = this->ConvertDist (fValue1, nArmDim1, nArmDim2);
	fConvert1 = this->ConvertMass (fConvert1, nMassDim1, nMassDim2);
	if ((fConvert1 - fValue2) > CMP_LIMIT) nRetVal = 1;         
	if ((fValue2 - fConvert1) > CMP_LIMIT) nRetVal = -1;
	}                 
	
if ((fValue1 != fDflt) && (fValue2 == fDflt))
	nRetVal = 1;	
if ((fValue1 == fDflt) && (fValue2 != fDflt))
	nRetVal = -1;	

return nRetVal;	
}    



/************************************************************************
 *  DimDoc.cpp				C o n v e r t T o P r e f 					*
 ************************************************************************/
double CDimDoc::ConvertToPref (PARAMETER Param, double fOldValue, short nOldDim)
{
double fNewValue;
short	nNewDim;

switch (Param)
	{            
	case ALTITUDE:  nNewDim = m_nAltDim; 	break;
	case DISTANCE:  nNewDim = m_nDistDim;	break;
	case RWYLENGTH: nNewDim = m_nLenDim;	break;
	case MASS:      nNewDim = m_nMassDim;	break;
	case WIND:		nNewDim = m_nWindDim;	break;
	case TEMP:      nNewDim = m_nTempDim;	break;
	case PRESS:		nNewDim = m_nPressDim;	break;
	case VOLUME:	nNewDim = m_nVolDim;	break;
	case ARM:		nNewDim = m_nArmDim;	break;           
	case FREQ:		nNewDim = m_nFreqDim;	break;           
	default:  
		AfxMessageBox ("ConvertToPref: Unknown Paramtype"); 
		nNewDim = nOldDim;
		break; 	
	}


if (nNewDim == nOldDim)
    {
    fNewValue = fOldValue;
    }
else{        
    BOOL bCelsiusToFahrenheit;
	double fFakt1, fFakt2;

	switch (Param)
		{                    
		case ALTITUDE:
		    fFakt1 = GetDistFakt (nOldDim);
		    fFakt2 = GetDistFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;
		case DISTANCE:
		    fFakt1 = GetDistFakt (nOldDim);
		    fFakt2 = GetDistFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;
/*		case CLIMBRATE:
		case CRUISESPEED:
		    fFakt1 = GetSpeedFakt (nOldDim);
		    fFakt2 = GetSpeedFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;    */
		case RWYLENGTH:
		    fFakt1 = GetDistFakt (nOldDim);
		    fFakt2 = GetDistFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;
		case MASS:
		    fFakt1 = GetMassFakt (nOldDim);
		    fFakt2 = GetMassFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;
		case WIND: 
		    fFakt1 = GetSpeedFakt (nOldDim);
		    fFakt2 = GetSpeedFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;
		case TEMP:          	// m_nTempDim
		    bCelsiusToFahrenheit = (nOldDim == DIM_C);
    		fNewValue = CelsToFahr (fOldValue, bCelsiusToFahrenheit);
 			break;
		case PRESS:
		    fFakt1 = GetPressFakt (nOldDim);
		    fFakt2 = GetPressFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;
		case VOLUME:
 		    fFakt1 = GetVolumeFakt (nOldDim);
		    fFakt2 = GetVolumeFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;
		case ARM:           
		    fFakt1 = GetDistFakt (nOldDim);
		    fFakt2 = GetDistFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;
		case FREQ:           
		    fFakt1 = GetFreqFakt (nOldDim);
		    fFakt2 = GetFreqFakt (nNewDim);
		    fNewValue = fOldValue * fFakt1 / fFakt2;
			break;
		}
     }
return fNewValue;
}           

 