#ifndef __DIMDOC__
#define __DIMDOC__

/************************************************************************
 *  							D i m D o c . h	  						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

/////////////////////////////////////////////////////////////////////////////
// CDimDoc view      
#define NO_SHORT ((short)(32767))
#define NO_LONG	 (0xFFFFFFFF)
#define NO_DWORD ((DWORD)(-1))

#define NO_KOORD	1000.		/* undefined val of Lat or Lon		*/
#define NO_ALT		6250335		/* undefined elevation ("___")		*/
#define NO_RWY		1			/* 1 m runway length: undefined 	*/
#define NO_RWYDIR	18			/* runway direction: undefined		*/
#define NO_ARM		((float)99)	/* 99 m lever arm: undefined		*/  
#define NO_FREQ		((float)0)
#define NO_PRESS	((float)0)
#define NO_MASS 	(-1)
#define NO_FUEL 	((float)-1)
#define NO_PCENT	((float)-1)
#define NO_DIM 		(-1)
#define NO_DIST		(-1)
#define NO_RATE		0			/* climb or descend rate of plane	*/

#define DIM_FEET    1
#define DIM_YARD    2
#define DIM_METER   3
#define DIM_KM	    4
#define DIM_STM     5
#define DIM_NM	    6
#define DIM_FL	    7
#define DIM_FTPM    8
#define DIM_KMH     9
#define DIM_MPH     10
#define DIM_KT	    11
#define DIM_MPS     12
#define DIM_USQRT   13
#define DIM_LITER   14
#define DIM_BRQRT   15
#define DIM_USGAL   16
#define DIM_BRGAL   17
#define DIM_POUNDS  18
#define DIM_KG	    19
#define DIM_HPA     20
#define DIM_MMHG    21
#define DIM_INCHHG  22
#define DIM_F	    23
#define DIM_C	    24
#define DIM_CM	    25
#define DIM_INCH    26
#define DIM_KHZ		27
#define DIM_MHZ		28


#define METER_PER_CM	0.01
#define METER_PER_INCH	0.0254
#define METER_PER_FOOT	0.3048
#define METER_PER_YARD	0.9144
#define METER_PER_KM	1000.0
#define METER_PER_SM	1609.0
#define METER_PER_NM	1852.0

#define KMPH_PER_FTPM	0.018288
#define KMPH_PER_MPH	1.609
#define KMPH_PER_NMPH	1.852
#define KMPH_PER_MPS	3.6

#define L_PER_USQRT  0.95
#define L_PER_BRQRT  1.14
#define L_PER_USGAL  3.7853
#define L_PER_BRGAL  4.5459

#define KG_PER_POUND	0.45359

#define HPA_PER_MMHG  1.3331579
#define HPA_PER_INHG  33.862211

#define KHZ_PER_MHZ		1000.0;

#define CMP_LIMIT 0.00001

enum PARAMETER {ALTITUDE,
				DISTANCE, 
				CRUISESPEED,
				CLIMBRATE,
				RWYLENGTH,
				MASS,
				WIND,
				TEMP,
				PRESS,
				VOLUME,
				ARM,
				FREQ
				};

typedef struct
	{      
	int	nValueID;
	CComboBox* ptPopUp;
	}DIMGROUP; 

typedef enum
	{
	LLF_GGGMMSS,
	LLF_GGGMMm
	} LATLONFORM; 

class CDimDoc : public CDocument
{ 
protected: // create from serialization only
	DECLARE_DYNCREATE(CDimDoc)

protected:

// Attributes
public:  
	short m_nAltDim;		    /* for dimensions	   */
	short m_nDistDim;
	short m_nLenDim;
	short m_nMassDim;
	short m_nWindDim;
	short m_nTempDim;
	short m_nPressDim;
	short m_nVolDim;
	short m_nArmDim;
	short m_nFreqDim;
    
	LATLONFORM m_nFormLatLon;
// Operations
public:
	CDimDoc();	
	void SetDocDim (short nDocDim);
	short GetDocDim();
	static BOOL StringToDim (CString szDim, short* ptDim);
	void GetDimCstring (CString* ptDim, short nDim);
	~CDimDoc();
	short DistDimToSpeedDim (short nDistDim);   
	short SpeedDimToDistDim (short nSpeedDim);
	short AltDimToClimbDim (short nAltDim);
	short ClimbDimToAltDim (short nClimbDim);
	static void MinutesToHMS(unsigned long ulMinutes, unsigned long ulSeconds, 
						   short* ptHours, short* ptMinutes, short* ptSeconds);

	static void MinutesToHMS(double dMin, short* ptHours, short* ptMinutes, short* ptSeconds);

    void Change (CWnd* ptWnd);
	void Serialize(CArchive& ar);
     
    void FillPU (CComboBox* ptPopUp, PARAMETER Param);    
    short GetPUIndex (PARAMETER Param, short nDim);    
	short GetPUDim (PARAMETER Param, short nPopUpIndex);    

    
	static double CelsToFahr (double fTemp1, BOOL bCelsiusToFahrenheit);
	static double GetDistFakt (short nDim);
	static double GetSpeedFakt (short nDim);
	static double GetVolumeFakt (short nDim);
	static double GetMassFakt (short nDim);
	static double GetPressFakt (short nDim);
	static double GetFreqFakt (short nDim);
	double ConvertDist (double fOldValue, short nOldDim, short nNewDim);
	double ConvertSpeed (double fOldValue, short nOldDim, short nNewDim);
	double ConvertMass (double fOldValue, short nOldDim, short nNewDim);
	double ConvertPress (double fOldValue, short nOldDim, short nNewDim);
	double ConvertTemp (double fOldValue, short nOldDim, short nNewDim);
	double ConvertVolume (double fOldValue, short nOldDim, short nNewDim);
	double ConvertToPref (PARAMETER Param, double fOldValue, short nOldDim);
    
	short CompareDist (double fValue1, short nDim1, double fValue2, short nDim2, double fDflt);
 	short CompareSpeed (double fValue1, short nDim1, double fValue2, short nDim2, double fDflt);
	short CompareVolume (double fValue1, short nDim1, double fValue2, short nDim2, double fDflt);
	short CompareMass (double fValue1, short nDim1, double fValue2, short nDim2, double fDflt);
    short CompareTorq (double fValue1, short nArmDim1, short nMassDim1,
					double fValue2, short nArmDim2, short nMassDim2, double fDflt);
                                                                
	short Altitude(){ return m_nAltDim; }
	short Distance(){ return m_nDistDim; }
	short RwyLength(){ return m_nLenDim; }
 	short Mass(){ return m_nMassDim; }
	short Wind(){ return m_nWindDim; }
	short Temp(){ return m_nTempDim; }
	short Press(){ return m_nPressDim; }
	short Volume(){ return m_nVolDim; }
	short Arm(){ return m_nArmDim; }
	short Freq(){ return m_nFreqDim; }

    void SetLatLonFormat(short nFormat) { m_nFormLatLon=(LATLONFORM)nFormat; }   
	LATLONFORM GetLatLonFormat() { return m_nFormLatLon; }   
// Implementation
protected:

	// Generated message map functions
protected:
	//{{AFX_MSG(CDimDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
