// DlgTools.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "DimDoc.h"  
#include "Location.h"
#include "DlgTool.h"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc* ptDim;

short		nActID;
CPtrArray*  ptActDimGroups;		// pointer to array of DIMGROUP

float	g_fNoArm;				// undefined value (99m) indicator in actual dimension 

/************************************************************************
 *  DlgTool.cpp    	 	 		G e t S h o r t							*
 ************************************************************************/
void GetShort(HWND hWnd, short& nValue, short nDflt)
{ 
char szWindowText[20];
::GetWindowText(hWnd, szWindowText, 19);

if (strlen (szWindowText) > 0)
	 nValue  = _ttoi(szWindowText);
else nValue = nDflt;
}

/************************************************************************
 *  DlgTool.cpp    	 	 		S e t S h o r t							*
 ************************************************************************/
void SetShort(HWND hWnd, short nValue, short nDflt)
{
char szText[20];
if (nValue == nDflt)	*szText = 0;
			else		sprintf (szText, "%d", nValue);
::SetWindowText(hWnd, (LPCSTR)szText);
}

/************************************************************************
 *  DlgTool.cpp    	 	 		G e t L o n g							*
 ************************************************************************/
void GetLong(HWND hWnd, long& lValue, long lDflt)
{ 
char szWindowText[20];
::GetWindowText(hWnd, szWindowText, 19);

if (strlen (szWindowText) > 0)
	 lValue  = _ttol(szWindowText);
else lValue = lDflt;
}

/************************************************************************
 *  DlgTool.cpp    	 	 		S e t L o n g							*
 ************************************************************************/
void SetLong(HWND hWnd, long lValue, long lDflt)
{
char szText[20];
if (lValue == lDflt)	*szText = 0;
			else		sprintf (szText, "%d", lValue);
::SetWindowText(hWnd, (LPCSTR)szText);
}

/************************************************************************
 *  DlgTool.cpp    	 	 		G e t D W O R D							*
 ************************************************************************/
void GetDWORD(HWND hWnd, DWORD& dwValue, DWORD dwDflt)
{
TCHAR szWindowText[20];
::GetWindowText(hWnd, szWindowText, 19);

if (strlen (szWindowText) > 0)
	 dwValue  = _ttol(szWindowText);
else dwValue = dwDflt;
}

/************************************************************************
 *  DlgTool.cpp    	 	 		S e t D W O R D							*
 ************************************************************************/
void SetDWORD(HWND hWnd, DWORD dwValue, DWORD dwDflt)
{
char szText[20];
if (dwValue == dwDflt)	*szText = 0;
				else	sprintf (szText, "%d", dwValue);
							//sprintf (szText, _T("%d"), dwValue);  
::SetWindowText(hWnd, (LPCSTR)szText);
}

/************************************************************************
 *  DlgTool.cpp    	 	 		G e t F l o a t							*
 ************************************************************************/
void GetFloat(HWND hWnd, float& fValue, float fDflt)
{
TCHAR	szWindowText[20];  
short	i;
short	nCharCnt = ::GetWindowText(hWnd, szWindowText, 19);

for (i=0; i<nCharCnt; i++)
	if (*(szWindowText+i) == ',') *(szWindowText+i) = '.';             
 
if (nCharCnt > 0)
	 fValue  = (float)atof(szWindowText);
else fValue = fDflt;
}

/************************************************************************
 *  DlgTool.cpp    	 	 		S e t F l o a t							*
 ************************************************************************/
void SetFloat(HWND hWnd, float fValue, float fDflt, short nNumPrec)
{
char szText[20];  
char szFormat[10];
sprintf (szFormat, "%%.%df", nNumPrec);
    
if (fValue == fDflt)	*szText = 0;
				else	sprintf (szText, szFormat, fValue);
::SetWindowText(hWnd, (LPCSTR)szText);
}


/************************************************************************
 *  DlgTool.c					G e t L a t L o n						*
 ************************************************************************/
void GetLatLon (HWND hWnd, double& dAngle, double dDflt)
{
TCHAR szWindowText[20];
::GetWindowText(hWnd, szWindowText, 19);

if (!CLocation::StringToLatLon((LPCTSTR)szWindowText, &dAngle)) 
	{       		// charcount == 0
	dAngle = dDflt;
    }
}


/************************************************************************
 *  DlgTool.cpp    	 	 		S e t L a t L o n						*
 ************************************************************************/
void SetLatLon(HWND hWnd, double dAngle, BOOL bLat, double dDflt)
{
char szText[20];
if (dAngle == dDflt)
	{
	*szText = 0;
	}
else{
	LATLONFORM LatLonForm;
	short	Grad, Dir;
	
	if (dAngle < 0.)	Dir = (bLat)? 'S': 'W';
				else	Dir = (bLat)? 'N': 'E';
	
	if (dAngle < 0.) dAngle *=-1;
	Grad	= (short)dAngle;

	LatLonForm = ptDim->GetLatLonFormat();
	if (LatLonForm == LLF_GGGMMSS)
		{
		short Min, Sec;
		Min	= (short)( (dAngle - Grad)*60 );
		
		Sec = (short)( ((dAngle - Grad)*60 - Min)*60 + 0.5 );
		if (Sec == 60) { Min++; Sec=0;}
		if (Min == 60) {Grad++; Min=0;}
		
		sprintf (szText, "%3d %2d %2d %c", Grad, Min, Sec, Dir);
		}
	else{		// if (LatLonForm == LLF_GGGMMm)
		double dMin = (dAngle - Grad)*60;
		sprintf (szText, "%3d %.2f %c", Grad, dMin, Dir);
		}	
	}
::SetWindowText(hWnd, (LPCSTR)szText);
}


/************************************************************************
 *  DlgTool.cpp    	 	 		S e t V a r								*
 ************************************************************************/
void SetVar(HWND hWnd, double dAngle, double dDflt)
{
char szText[20];
if (dAngle == dDflt)
	{
	*szText = 0;
	}
else{
	short	Dir;
		
	Dir = (dAngle < 0.)? 'W' : 'E';
	if (dAngle < 0.) dAngle *=-1;
		
	sprintf (szText, "%3d %c", (short)dAngle, Dir);	  
    }
::SetWindowText(hWnd, (LPCSTR)szText);
}


/************************************************************************
 *  DlgTool.cpp	  		 		 G e t D i m P o p U p					*
 ************************************************************************/
CComboBox* GetDimPopUp (CPtrArray* ptDimGroups, int nValueID, short* ptNextIndex)
{    
CComboBox* ptPopUp = NULL;    
BOOL	bFound = FALSE;
short i, nStartInd;

nStartInd = (ptNextIndex == NULL)? 0 : *ptNextIndex;
     
for (i=nStartInd; i<ptDimGroups->GetSize() && !bFound; i++)
	{ 
	DIMGROUP* ptEntry;
	if ((ptEntry = (DIMGROUP*)ptDimGroups->GetAt(i)) != NULL)
		{
		if (ptEntry->nValueID == nValueID)
			{
			bFound = TRUE;
			ptPopUp = ptEntry->ptPopUp;
			if (ptNextIndex!= NULL)
				*ptNextIndex = i+1;
			}
		}
	}
return ptPopUp;		
}

/************************************************************************
 *  DlgTool.cpp	  		 		 G e t D i m							*
 ************************************************************************/
short GetDim (CDataExchange* pDX, PARAMETER Param, CPtrArray* ptDimGroups, short nValueID)
{
short nDim = NO_DIM; 
CComboBox* ptPopUp; 

ptPopUp = GetDimPopUp (ptDimGroups, nValueID);
if (ptPopUp != NULL)
	{   
	int nPopUpIndex = 0;
	nPopUpIndex = ptPopUp->GetCurSel();
	if (nPopUpIndex >= 0)
		nDim = ptDim->GetPUDim (Param, nPopUpIndex);    
    }
return nDim;
}

/************************************************************************
 *  DlgTool.cpp	  		 		G e t S e c o n d D i m					*
 ************************************************************************/
short GetSecondDim (CDataExchange* pDX, PARAMETER Param, CPtrArray* ptDimGroups, short nValueID)
{
short nDim = NO_DIM; 
CComboBox* ptPopUp; 

short	nStart = 0;
ptPopUp = GetDimPopUp (ptDimGroups, nValueID, &nStart);
ptPopUp = GetDimPopUp (ptDimGroups, nValueID, &nStart);
if (ptPopUp != NULL)
	{   
	int nPopUpIndex = 0;
	nPopUpIndex = ptPopUp->GetCurSel();
	if (nPopUpIndex >= 0)
		nDim = ptDim->GetPUDim (Param, nPopUpIndex);    
    }
return nDim;
}            

/************************************************************************
 *  DlgTool.cpp    	 		C h e c k R w y								*
 ************************************************************************/
void CheckRwy (CDataExchange* pDX, short nValue, short nMin, short nMax, BOOL bNeedValue)
{
BOOL 	bOK = TRUE;    
BOOL	bTest = TRUE;
char szText[128]; 
                
if (pDX->m_bSaveAndValidate)
	{          
	CString szDim;
	short nDim = GetDim (pDX, RWYLENGTH, ptActDimGroups, nActID); 	
	ptDim->GetDimCstring (&szDim, nDim);
	     
	if (bNeedValue)
		{  				// we need a value
		if (nValue == NO_RWY)
			{           	// but there is no input!
			bOK 	= FALSE;  
			bTest	= FALSE;
			CString szFormat;
			szFormat.LoadString (IDF_ENTER_RWY);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
			}
		else{ 				// and there is our input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
 		}
	else{				// we dont need a value
		if (nValue == NO_RWY)
			{           	// and there is no input!
			bOK 	= TRUE;  
			bTest	= FALSE;
			}
		else{ 				// but there is an input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
		} 
		
	if (bTest)
		{
		double fConvert;
		fConvert = ptDim->ConvertDist (nMin, DIM_METER, nDim);
	    nMin = (short)fConvert;
		fConvert = ptDim->ConvertDist (nMax, DIM_METER, nDim);
	    nMax = (short)fConvert;
		if (nValue < nMin || nValue > nMax)
			{
			bOK = FALSE;
			CString szFormat;
			szFormat.LoadString (IDF_LIM_RWY);
			sprintf (szText, szFormat, nValue, nMin, nMax, (LPCTSTR)szDim);
	        } 
		}
    }    
                
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}




/************************************************************************
 *  DlgTool.cpp    	 		C h e c k D i s t a n c e					*
 ************************************************************************/
void CheckDistance (CDataExchange* pDX, long lValue, long lMin, long lMax, BOOL bNeedValue)
{
BOOL	bOK = TRUE;        
BOOL	bTest = TRUE;
char szText[128]; 
                
if (pDX->m_bSaveAndValidate)
	{   
	CString szDim;
	short nDim = GetDim (pDX, DISTANCE, ptActDimGroups, nActID); 	
	ptDim->GetDimCstring (&szDim, nDim);
            
	if (bNeedValue)
		{  				// we need a value
		if (lValue == NO_LONG)
			{           	// but there is no input!
			bOK 	= FALSE;  
			bTest	= FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_DIST);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
			}
		else{ 				// and there is our input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
 		}
	else{				// we dont need a value
		if (lValue == NO_LONG)
			{           	// and there is no input!
			bOK 	= TRUE;  
			bTest	= FALSE;
			}
		else{ 				// but there is an input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
		} 

	
	if (bTest)
		{
		double fConvert;
		fConvert = ptDim->ConvertDist (lMin, DIM_NM, nDim);
	    lMin = (long)fConvert;
		fConvert = ptDim->ConvertDist (lMax, DIM_NM, nDim);
	    lMax = (long)fConvert;
		if (lValue < lMin || lValue > lMax)
			{
			bOK = FALSE;
			CString szFormat;
			szFormat.LoadString (IDF_LIM_DIST);
			sprintf (szText, szFormat, lValue, lMin, lMax, (LPCTSTR)szDim);
	        } 
		}
    }    
                
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}


/************************************************************************
 *  DlgTool.cpp    	 		C h e c k D i s t a n c e					*
 ************************************************************************/
void CheckDistance (CDataExchange* pDX, float fValue, float fMin, float fMax, BOOL bNeedValue)
{
	BOOL	bOK = TRUE;        
	BOOL	bTest = TRUE;
	char szText[128]; 
                
	if (pDX->m_bSaveAndValidate)
	{   
		CString szDim;
		short nDim = GetDim (pDX, DISTANCE, ptActDimGroups, nActID); 	
		ptDim->GetDimCstring (&szDim, nDim);
            
		if (bNeedValue)
		{  				// we need a value
			if (fValue == NO_DIST)
			{           	// but there is no input!
				bOK 	= FALSE;  
				bTest	= FALSE;
				sprintf (szText, "Bitte geben Sie eine Entfernung (in %s) ein!", 
								(LPCTSTR)szDim);
			}
			else
			{ 				// and there is our input
				bOK		= TRUE;
				bTest 	= TRUE;
			}
 		}
		else
		{				// we dont need a value
			if (fValue == NO_DIST)
			{           	// and there is no input!
				bOK 	= TRUE;  
				bTest	= FALSE;
			}
			else
			{	// but there is an input
				bOK		= TRUE;
				bTest 	= TRUE;
			}
		} 

	
		if (bTest)
		{
			double fConvert;
			fConvert = ptDim->ConvertDist (fMin, DIM_NM, nDim);
			fMin = (float)fConvert;
			fConvert = ptDim->ConvertDist (fMax, DIM_NM, nDim);
			fMax = (float)fConvert;
			if (fValue < fMin || fValue > fMax)
			{
				bOK = FALSE;
				sprintf (szText, "Die Entfernung %.2f sollte zwischen %.2f und %.2f %s liegen!", 
								fValue, fMin, fMax, (LPCTSTR)szDim);
	        } 
		}
    }    
                
	if (!bOK)
	{
		AfxMessageBox(szText);
		pDX->Fail();
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		C h e c k A l t i t u d e					*
 ************************************************************************/
void CheckAltitude (CDataExchange* pDX, long lValue, long lMin, long lMax, BOOL bNeedValue)
{
BOOL 	bOK = TRUE;    
BOOL	bTest = TRUE;
char szText[128]; 
                
if (pDX->m_bSaveAndValidate)
	{          
	CString szDim;
	short nDim = GetDim (pDX, ALTITUDE, ptActDimGroups, nActID); 	
	ptDim->GetDimCstring (&szDim, nDim);
	     
	if (bNeedValue)
		{  				// we need a value
		if (lValue == NO_ALT)
			{           	// but there is no input!
			bOK 	= FALSE;  
			bTest	= FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_ALT);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
			}
		else{ 				// and there is our input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
 		}
	else{				// we dont need a value
		if (lValue == NO_ALT)
			{           	// and there is no input!
			bOK 	= TRUE;  
			bTest	= FALSE;
			}
		else{ 				// but there is an input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
		} 
		
	if (bTest)
		{
		double fConvert;
		fConvert = ptDim->ConvertDist (lMin, DIM_FEET, nDim);
	    lMin = (long)fConvert;
		fConvert = ptDim->ConvertDist (lMax, DIM_FEET, nDim);
	    lMax = (long)fConvert;
		if (lValue < lMin || lValue > lMax)
			{
			bOK = FALSE;
			CString szFormat;
			szFormat.LoadString (IDF_LIM_ALT);
			sprintf (szText, szFormat, lValue, lMin, lMax, (LPCTSTR)szDim);
	        } 
		}
    }    
                
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		C h e c k V o l u m e					*
 ************************************************************************/
void CheckVolume (CDataExchange* pDX, long lValue, long lMin, long lMax, BOOL bNeedValue)
{
BOOL 	bOK = TRUE;    
BOOL	bTest = TRUE;
char szText[128]; 
                
if (pDX->m_bSaveAndValidate)
	{          
	CString szDim;
	short nDim = GetDim (pDX, VOLUME, ptActDimGroups, nActID); 	
	ptDim->GetDimCstring (&szDim, nDim);
	     
	if (bNeedValue)
		{  				// we need a value
		if (lValue == NO_LONG)
			{           	// but there is no input!
			bOK 	= FALSE;  
			bTest	= FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_VOL);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
			}
		else{ 				// and there is our input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
 		}
	else{				// we dont need a value
		if (lValue == NO_LONG)
			{           	// and there is no input!
			bOK 	= TRUE;  
			bTest	= FALSE;
			}
		else{ 				// but there is an input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
		} 
		
	if (bTest)
		{
		double fConvert;
		fConvert = ptDim->ConvertVolume (lMin, DIM_LITER, nDim);
	    lMin = (long)fConvert;
		fConvert = ptDim->ConvertVolume (lMax, DIM_LITER, nDim);
	    lMax = (long)fConvert;
		if (lValue < lMin || lValue > lMax)
			{
			bOK = FALSE;
			CString szFormat;
			szFormat.LoadString (IDF_LIM_VOL);
			sprintf (szText, szFormat, lValue, lMin, lMax, (LPCTSTR)szDim);
	        } 
		}
    }    
                
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		C h e c k F r e q u e n c y					*
 ************************************************************************/
void CheckFrequency (CDataExchange* pDX, float fValue, float fMin, float fMax, BOOL bNeedValue)
{
BOOL 	bOK = TRUE; 
BOOL	bTest = TRUE;
CString	szText; 
                
if (pDX->m_bSaveAndValidate)
	{               
	if (bNeedValue)
		{  				// we need a value
		if (fValue == NO_FREQ)
			{           	// but there is no input!
			bOK 	= FALSE;  
			bTest	= FALSE;
			szText.LoadString(IDS_ENTER_FREQ);
			}
		else{ 				// and there is our input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
 		}
	else{				// we dont need a value
		if (fValue == NO_FREQ)
			{           	// and there is no input!
			bOK 	= TRUE;  
			bTest	= FALSE;
			}
		else{ 				// but there is an input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
		}
 		
	if (bTest)
		{
		if (fValue < fMin || fValue > fMax)
			{
			bOK = FALSE;
			szText.Format(IDF_LIM_FREQ, fValue, fMin, fMax);
	        } 
		}
    }    
                
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		C h e c k M a s s							*
 ************************************************************************/
void CheckMass (CDataExchange* pDX, long lValue, long lMin, long lMax, BOOL bNeedValue)
{
BOOL	bOK = TRUE;        
BOOL	bTest = TRUE;
char szText[128]; 
                
if (pDX->m_bSaveAndValidate)
	{   
	CString szDim;
	short nDim = GetDim (pDX, MASS, ptActDimGroups, nActID); 	
	ptDim->GetDimCstring (&szDim, nDim);
            
	if (bNeedValue)
		{  				// we need a value
		if (lValue == NO_MASS)
			{           	// but there is no input!
			bOK 	= FALSE;  
			bTest	= FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_MASS);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
			}
		else{ 				// and there is our input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
 		}
	else{				// we dont need a value
		if (lValue == NO_MASS)
			{           	// and there is no input!
			bOK 	= TRUE;  
			bTest	= FALSE;
			}
		else{ 				// but there is an input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
		} 

	
	if (bTest)
		{
		double fConvert;
		fConvert = ptDim->ConvertMass (lMin, DIM_KG, nDim);
	    lMin = (long)fConvert;
		fConvert = ptDim->ConvertMass (lMax, DIM_KG, nDim);
	    lMax = (long)fConvert;
		if (lValue < lMin || lValue > lMax)
			{
			bOK = FALSE;
			CString szFormat;
			szFormat.LoadString (IDF_LIM_MASS);
			sprintf (szText, szFormat, lValue, lMin, lMax, (LPCTSTR)szDim);
	        } 
		}
    }    
                
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		C h e c k A r m								*
 ************************************************************************/
void CheckArm (CDataExchange* pDX, float fValue, float fMin, float fMax, BOOL bNeedValue)
{
BOOL 	bOK = TRUE; 
BOOL	bTest = TRUE;
CString szText;
                
if (pDX->m_bSaveAndValidate)
	{               
	CString szDim;
	short nDim = GetDim (pDX, ARM, ptActDimGroups, nActID); 	
	ptDim->GetDimCstring (&szDim, nDim);

	if (bNeedValue)
		{  				// we need a value
		if (fValue == g_fNoArm)
			{           	// but there is no input!
			bOK 	= FALSE;  
			bTest	= FALSE;
			szText.LoadString(IDS_ENTER_ARM);
			}
		else{ 				// and there is our input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
 		}
	else{				// we dont need a value
		if (fValue == g_fNoArm)
			{           	// and there is no input!
			bOK 	= TRUE;  
			bTest	= FALSE;
			}
		else{ 				// but there is an input
		    bOK		= TRUE;
		    bTest 	= TRUE;
			}
		}
 		
	if (bTest)
		{
		double fConvert;
		fConvert = ptDim->ConvertDist (fMin, DIM_METER, nDim);
	    fMin = (float)fConvert;
		fConvert = ptDim->ConvertDist (fMax, DIM_METER, nDim);
	    fMax = (float)fConvert;
		if (fValue < fMin || fValue > fMax)
			{
			bOK = FALSE;
			szText.Format (IDF_LIM_ARM, fValue, fMin, fMax, (LPCTSTR)szDim);
	        } 
		}
    }    
                
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		D D X _ C B I n d e x A r m D i m  			*
 *  Purpose: Do usual DDX_CBIndex and use actual nArmDim to				*
 *			 calculate new UNDEFINED ARM indicator (99m)				*
 ************************************************************************/
void AFXAPI DDX_CBIndexArmDim(CDataExchange* pDX, int nIDC, int& nValue)
{
	DDX_CBIndex(pDX, nIDC, nValue);		// get new ArmDim PU index here
							
	short nArmDim	= ptDim->GetPUDim (ARM, nValue);// PUIndex to ArmDim

	double fConvert;					// convert UNDEFINED value (99m)
	fConvert = ptDim->ConvertDist (NO_ARM, DIM_METER, nArmDim);
	g_fNoArm = (float)((short)fConvert);	// for Dim=cm: fNoArm = 9900
}

/************************************************************************
 *  DlgTool.cpp    	 	 D D X _ S h o r t O p t i o n a l  			*
 ************************************************************************/
void AFXAPI DDX_ShortOptional(CDataExchange* pDX, int nIDC, short& nValue)
{
	HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
	if (pDX->m_bSaveAndValidate)
			GetShort(hWndCtrl, nValue, NO_SHORT);
	else	SetShort(hWndCtrl, nValue, NO_SHORT);

}

/************************************************************************
 *  DlgTool.cpp    	 	 D D V _ S h o r t O p t i o n a l 				*
 ************************************************************************/
void AFXAPI DDV_ShortOptional(CDataExchange* pDX, short nValue, short nMin, short nMax)
{
	BOOL bOK = TRUE;

	if (pDX->m_bSaveAndValidate && (nValue != NO_SHORT))
		bOK = (nValue >= nMin && nValue <= nMax);
    
	if (!bOK)
	{
		char szText[128];
		CString szFormat;
		szFormat.LoadString (IDF_LIM_SHORT);
		sprintf (szText, szFormat, nValue, nMin, nMax);
		AfxMessageBox(szText);
		pDX->Fail();
	}
}                      

/************************************************************************
 *  DlgTool.cpp    	 	 D D X _ D W O R D O p t i o n a l 				*
 ************************************************************************/
void AFXAPI DDX_DWORDOptional(CDataExchange* pDX, int nIDC, DWORD& dwValue)
{
	HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
	if (pDX->m_bSaveAndValidate)
			GetDWORD(hWndCtrl, dwValue, NO_DWORD);
	else	SetDWORD(hWndCtrl, dwValue, NO_DWORD);
}

/************************************************************************
 *  DlgTool.cpp    	 	 D D V _ D W O R D O p t i o n a l 				*
 ************************************************************************/
void AFXAPI DDV_DWORDOptional(CDataExchange* pDX, DWORD dwValue, DWORD dwMin, DWORD dwMax)
{
BOOL bOK = TRUE;

if (pDX->m_bSaveAndValidate && (dwValue != NO_DWORD))
	bOK = (dwValue >= dwMin && dwValue <= dwMax);

if (!bOK)
	{
	char szText[128];
	CString szFormat;
	szFormat.LoadString (IDF_LIM_SHORT);
	sprintf (szText, szFormat, dwValue, dwMin, dwMax);
	AfxMessageBox(szText);
	pDX->Fail();
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ D i s t 						*
 ************************************************************************/
void AFXAPI DDX_Dist(CDataExchange* pDX, int nIDC, long& lValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetLong(hWndCtrl, lValue, NO_LONG);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetLong(hWndCtrl, lValue, NO_LONG);
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ D i s t 						*
 ************************************************************************/
void AFXAPI DDX_Dist(CDataExchange* pDX, int nIDC, float& fValue)
{
	HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
	if (pDX->m_bSaveAndValidate)
	{
		nActID = nIDC;
		GetFloat(hWndCtrl, fValue, NO_DIST);  
	}
	else
	{         // converts from dimension of document to dimension of preference 
	   	SetFloat(hWndCtrl, fValue, NO_DIST, 2); 
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ D i s t 						*
 ************************************************************************/
void AFXAPI DDV_Dist(CDataExchange* pDX, long lValue, long lMin, long lMax)
{  
BOOL	bNeedValue = TRUE;     
CheckDistance (pDX, lValue, lMin, lMax, bNeedValue);
}            


/************************************************************************
 *  DlgTool.cpp    	 		D D V _ D i s t O p t i o n a l 			*
 ************************************************************************/
void AFXAPI DDV_DistOptional(CDataExchange* pDX, long lValue, long lMin, long lMax)
{
BOOL	bNeedValue = FALSE;     
CheckDistance (pDX, lValue, lMin, lMax, bNeedValue);
} 

/************************************************************************
 *  DlgTool.cpp    	 		D D V _ D i s t O p t i o n a l 			*
 ************************************************************************/
void AFXAPI DDV_DistOptional(CDataExchange* pDX, float fValue, float fMin, float fMax)
{
BOOL	bNeedValue = FALSE;     
CheckDistance (pDX, fValue, fMin, fMax, bNeedValue);
} 

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ A l t 							*
 ************************************************************************/
void AFXAPI DDX_Alt(CDataExchange* pDX, int nIDC, long& lValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetLong(hWndCtrl, lValue, NO_ALT);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetLong(hWndCtrl, lValue, NO_ALT);
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ A l t	 						*
 ************************************************************************/
void AFXAPI DDV_Alt(CDataExchange* pDX, long lValue, long lMin, long lMax)
{  
BOOL	bNeedValue = TRUE;     
CheckAltitude (pDX, lValue, lMin, lMax, bNeedValue);
}            

/************************************************************************
 *  DlgTool.cpp    	 		D D V _ A l t O p t i o n a l 				*
 ************************************************************************/
void AFXAPI DDV_AltOptional(CDataExchange* pDX, long lValue, long lMin, long lMax)
{
BOOL	bNeedValue = FALSE;     
CheckAltitude (pDX, lValue, lMin, lMax, bNeedValue);
}            

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ F r e q						*
 ************************************************************************/
void AFXAPI DDX_Freq(CDataExchange* pDX, int nIDC, float& fValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{   
	GetFloat (hWndCtrl, fValue, NO_FREQ); 
	}
else{         
   	SetFloat(hWndCtrl, fValue, NO_FREQ, 3); 
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		D D V _ F r e q O p t i o n a l 			*
 ************************************************************************/
void AFXAPI DDV_FreqOptional(CDataExchange* pDX, float fValue, float fMin, float fMax)
{
BOOL	bNeedValue = FALSE;     
CheckFrequency (pDX, fValue, fMin, fMax, bNeedValue);
}    

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ R w y							*
 ************************************************************************/
void AFXAPI DDX_Rwy(CDataExchange* pDX, int nIDC, short& nValue)
{
	HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
	if (pDX->m_bSaveAndValidate)
		{
	    nActID = nIDC;
		GetShort(hWndCtrl, nValue, NO_RWY);  
		}
	else{         // converts from dimension of document to dimension of preference 
		SetShort(hWndCtrl, nValue, NO_RWY);
		}
}


/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ R w y							*
 ************************************************************************/
void AFXAPI DDV_Rwy(CDataExchange* pDX, short nValue, short nMin, short nMax)
{
BOOL	bNeedValue = TRUE;     
CheckRwy (pDX, nValue, nMin, nMax, bNeedValue);
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ R w y O p t					*
 ************************************************************************/
void AFXAPI DDX_RwyOpt(CDataExchange* pDX, int nIDC, short& nValue)
{
DDX_Rwy(pDX, nIDC, nValue);
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ R w y O p t					*
 ************************************************************************/
void AFXAPI DDV_RwyOpt(CDataExchange* pDX, short nValue, short nMin, short nMax)
{
BOOL	bNeedValue = FALSE;     
CheckRwy (pDX, nValue, nMin, nMax, bNeedValue);
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ R w y L e n g t h	(long)		*
 ************************************************************************/
void AFXAPI DDX_RwyLength(CDataExchange* pDX, int nIDC, long& lValue)
{
	HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
	if (pDX->m_bSaveAndValidate)
		{
	    nActID = nIDC;
		GetLong(hWndCtrl, lValue, NO_RWY);  
		}
	else{         // converts from dimension of document to dimension of preference 
		SetLong(hWndCtrl, lValue, NO_RWY);
		}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ R w y L e n g t h O p t		*
 ************************************************************************/
void AFXAPI DDV_RwyLengthOpt(CDataExchange* pDX, long lValue, long lMin, long lMax)
{
BOOL bOK = TRUE;
char szText[128]; 

if (pDX->m_bSaveAndValidate && (lValue != NO_RWY))
	{            
	CString szDim;
	short nDim = GetDim (pDX, RWYLENGTH, ptActDimGroups, nActID); 	
	ptDim->GetDimCstring (&szDim, nDim);
	
	double fConvert;
	fConvert = ptDim->ConvertDist (lMin, DIM_METER, nDim);
    lMin = (long)(fConvert+0.5);
	fConvert = ptDim->ConvertDist (lMax, DIM_METER, nDim);
    lMax = (long)(fConvert+0.5);
	bOK = (lValue >= lMin && lValue <= lMax); 
	if (!bOK)
		sprintf (szText, "Die Bahnlnge %d sollte zwischen %ld und %ld %s liegen!", 
							lValue, lMin, lMax, (LPCTSTR)szDim);
    }    
    
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}                 

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ T e m p 						*
 ************************************************************************/
void AFXAPI DDX_Temp(CDataExchange* pDX, int nIDC, short& nValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetShort(hWndCtrl, nValue, NO_SHORT);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetShort(hWndCtrl, nValue, NO_SHORT);
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ T e m p 						*
 ************************************************************************/
void AFXAPI DDV_Temp(CDataExchange* pDX, short nValue, short nMin, short nMax)
{
	BOOL bOK = TRUE;
	char szText[128]; 

	if (pDX->m_bSaveAndValidate)
	{            
		CString szDim;
		short nDim = GetDim (pDX, TEMP, ptActDimGroups, nActID); 	
		ptDim->GetDimCstring (&szDim, nDim);
		
		if (nValue == NO_SHORT)
		{
			bOK = FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_TEMP);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
 		}
		else
		{
			double fConvert;
			fConvert = ptDim->ConvertTemp (nMin, DIM_C, nDim);
			nMin = (short)fConvert;			// negativ value! => dont add 0.5
			fConvert = ptDim->ConvertTemp (nMax, DIM_C, nDim);
			nMax = (short)fConvert;
			bOK = (nValue >= nMin && nValue <= nMax); 
			if (!bOK)
			{
				CString szFormat;
				szFormat.LoadString (IDF_LIM_TEMP);
				sprintf (szText, szFormat, nValue, nMin, nMax, (LPCTSTR)szDim);
			}
		}
    }    
    
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}                

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ P r e s s 						*
 ************************************************************************/
void AFXAPI DDX_Press(CDataExchange* pDX, int nIDC, float& fValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetFloat(hWndCtrl, fValue, NO_PRESS);  
	}
else{         // converts from dimension of document to dimension of preference 
	short nDim = GetDim (pDX, PRESS, ptActDimGroups, nIDC); 	
	if (nDim == DIM_INCHHG)
		{
		SetFloat(hWndCtrl, fValue, NO_PRESS, 2);
		}
	else{
		SetFloat(hWndCtrl, fValue, NO_PRESS, 0);
		}
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ P r e s s 						*
 ************************************************************************/
void AFXAPI DDV_Press(CDataExchange* pDX, float fValue, float fMin, float fMax)
{
	BOOL bOK = TRUE;
	char szText[128]; 

	if (pDX->m_bSaveAndValidate)
	{          
		CString szDim;
		short nDim = GetDim (pDX, PRESS, ptActDimGroups, nActID); 	
		ptDim->GetDimCstring (&szDim, nDim); 
		
		if (fValue == NO_PRESS)
		{
			bOK = FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_PRESS);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
 		}
		else
		{
			double fConvert;
			fConvert = ptDim->ConvertPress (fMin, DIM_HPA, nDim);
			fMin = (float)fConvert;
			fConvert = ptDim->ConvertPress (fMax, DIM_HPA, nDim);
			fMax = (float)fConvert;
			bOK = (fValue >= fMin && fValue <= fMax); 
			if (!bOK)
			{
				CString szFormat;
				szFormat.LoadString (IDF_LIM_PRESS);
				sprintf (szText, szFormat, fValue, fMin, fMax, (LPCTSTR)szDim);
			}
		}
    }    
    
	if (!bOK)
	{
		AfxMessageBox(szText);
		pDX->Fail();
	}
}              

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ W i n d S p e e d				*
 ************************************************************************/
void AFXAPI DDX_WindSpeed(CDataExchange* pDX, int nIDC, short& nValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetShort(hWndCtrl, nValue, NO_SHORT);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetShort(hWndCtrl, nValue, NO_SHORT);
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ W i n d S p e e d				*
 ************************************************************************/
void AFXAPI DDV_WindSpeed(CDataExchange* pDX, short nValue, short nMin, short nMax)
{
	BOOL bOK = TRUE;
	char szText[128]; 

	if (pDX->m_bSaveAndValidate)
	{          
		CString szDim;
		short nDim = GetDim (pDX, WIND, ptActDimGroups, nActID); 	
		ptDim->GetDimCstring (&szDim, nDim);

		if (nValue == NO_SHORT)
		{
			bOK = FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_SPEED_WIND);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
 		}
		else
		{
			double fConvert;
			fConvert = ptDim->ConvertSpeed (nMin, DIM_KT, nDim);
			nMin = (short)(fConvert+0.5);
			fConvert = ptDim->ConvertSpeed (nMax, DIM_KT, nDim);
			nMax = (short)(fConvert+0.5);
			bOK = (nValue >= nMin && nValue <= nMax); 
			if (!bOK)
			{
				CString szFormat;
				szFormat.LoadString (IDF_LIM_SPEED_WIND);
				sprintf (szText, szFormat, nValue, nMin, nMax, (LPCTSTR)szDim);
			}
		}    
    }

	if (!bOK)
	{
		AfxMessageBox(szText);
		pDX->Fail();
	}
}                  
 
/************************************************************************
 *  DlgTool.cpp    	 		D D X _ C r u i s e S p e e d				*
 ************************************************************************/
void AFXAPI DDX_CruiseSpeed(CDataExchange* pDX, int nIDC, short& nValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetShort(hWndCtrl, nValue, NO_SHORT);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetShort(hWndCtrl, nValue, NO_SHORT);
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		D D V _ C r u i s e S p e e d				*
 ************************************************************************/
void AFXAPI DDV_CruiseSpeed(CDataExchange* pDX, short nValue, short nMin, short nMax)
{
	BOOL bOK = TRUE;
	char szText[128]; 

	if (pDX->m_bSaveAndValidate)
	{          
		CString szDim;
		short nDim = GetDim (pDX, CRUISESPEED, ptActDimGroups, nActID); 	
		ptDim->GetDimCstring (&szDim, nDim);

		if (nValue == NO_SHORT)
		{
			bOK = FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_SPEED_FLIGHT);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
 		}
		else
		{
			double fConvert;
			fConvert = ptDim->ConvertSpeed (nMin, DIM_KT, nDim);
			nMin = (short)(fConvert+0.5);
			fConvert = ptDim->ConvertSpeed (nMax, DIM_KT, nDim);
			nMax = (short)(fConvert+0.5);
			bOK = (nValue >= nMin && nValue <= nMax); 
			if (!bOK)
			{
				CString szFormat;
				szFormat.LoadString (IDF_LIM_SPEED_FLIGHT);
				sprintf (szText, szFormat, nValue, nMin, nMax, (LPCTSTR)szDim);
			}
		}
    }    
    
	if (!bOK)
	{
		AfxMessageBox(szText);
		pDX->Fail();
	}
}   

/************************************************************************
 *  DlgTool.cpp    	 		D D X _ C l i m b S p e e d					*
 ************************************************************************/
void AFXAPI DDX_ClimbSpeed(CDataExchange* pDX, int nIDC, short& nValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetShort(hWndCtrl, nValue, NO_SHORT);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetShort(hWndCtrl, nValue, NO_SHORT);
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		D D V _ C l i m b S p e e d					*
 ************************************************************************/
void AFXAPI DDV_ClimbSpeed(CDataExchange* pDX, short nValue, short nMin, short nMax)
{
	BOOL bOK = TRUE;
	char szText[128]; 

	if (pDX->m_bSaveAndValidate)
	{          
		CString szDim;
		short nDim = GetDim (pDX, CLIMBRATE, ptActDimGroups, nActID); 	
		ptDim->GetDimCstring (&szDim, nDim);

		if (nValue == NO_SHORT)
		{
			bOK = FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_SPEED_CLIMB);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
 		}
		else
		{
			double fConvert;
			fConvert = ptDim->ConvertSpeed (nMin, DIM_FTPM, nDim);
			nMin = (short)(fConvert+0.5);
			fConvert = ptDim->ConvertSpeed (nMax, DIM_FTPM, nDim);
			nMax = (short)(fConvert+0.5);
			bOK = (nValue >= nMin && nValue <= nMax); 
			if (!bOK)
			{
				CString szFormat;
				szFormat.LoadString (IDF_LIM_SPEED_CLIMB);
				sprintf (szText, szFormat, nValue, nMin, nMax, (LPCTSTR)szDim);
			}
		}
    }    
    
	if (!bOK)
	{
		AfxMessageBox(szText);
		pDX->Fail();
	}
}   
 

/************************************************************************
 *  DlgTool.cpp    	 		D D X _ C l i m b R a t e					*
 ************************************************************************/
void AFXAPI DDX_ClimbRate(CDataExchange* pDX, int nIDC, float& fValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetFloat(hWndCtrl, fValue, NO_RATE);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetFloat(hWndCtrl, fValue, NO_RATE, 1);
	}
}

/************************************************************************
 *  DlgTool.cpp    	 		D D V _ C l i m b R a t e					*
 ************************************************************************/
void AFXAPI DDV_ClimbRate(CDataExchange* pDX, float fValue, float fMin, float fMax)
{
	BOOL bOK = TRUE;
	char szText[128]; 

	if (pDX->m_bSaveAndValidate)
	{          
		CString szDim;
		short nDim = GetDim (pDX, CLIMBRATE, ptActDimGroups, nActID); 	
		ptDim->GetDimCstring (&szDim, nDim);

		if (fValue == NO_RATE)
		{
			bOK = FALSE;
			CString	szFormat;
			szFormat.LoadString(IDF_ENTER_RATE_CLIMB);
			sprintf (szText, szFormat, (LPCTSTR)szDim);
 		}
		else
		{
			double fConvert;
			fConvert = ptDim->ConvertSpeed (fMin, DIM_FTPM, nDim);
			fMin = (float)(fConvert+0.5);
			fConvert = ptDim->ConvertSpeed (fMax, DIM_FTPM, nDim);
			fMax = (float)(fConvert+0.5);
			bOK = (fValue >= fMin && fValue <= fMax); 
			if (!bOK)
			{
				CString szFormat;
				szFormat.LoadString (IDF_LIM_RATE_CLIMB);
				sprintf (szText, szFormat, fValue, fMin, fMax, (LPCTSTR)szDim);
			}
		}
    }    
    
	if (!bOK)
	{
		AfxMessageBox(szText);
		pDX->Fail();
	}
}   
 

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ V o l u m e					*
 ************************************************************************/
void AFXAPI DDX_Volume(CDataExchange* pDX, int nIDC, long& lValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetLong(hWndCtrl, lValue, NO_LONG);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetLong(hWndCtrl, lValue, NO_LONG);
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ V o l u m e					*
 ************************************************************************/
void AFXAPI DDV_Volume(CDataExchange* pDX, long lValue, long lMin, long lMax)
{  
BOOL	bNeedValue = TRUE;   
CheckVolume (pDX, lValue, lMin, lMax, bNeedValue);
}            

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ V o l u m e O p t					*
 ************************************************************************/
void AFXAPI DDX_VolumeOpt(CDataExchange* pDX, int nIDC, long& lValue)
{
DDX_Volume (pDX, nIDC, lValue);
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ V o l u m e O p t					*
 ************************************************************************/
void AFXAPI DDV_VolumeOpt(CDataExchange* pDX, long lValue, long lMin, long lMax)
{  
BOOL	bNeedValue = FALSE;   
CheckVolume (pDX, lValue, lMin, lMax, bNeedValue);
}            


/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ A r m 							*
 ************************************************************************/
void AFXAPI DDX_Arm(CDataExchange* pDX, int nIDC, float& fValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{   
    nActID = nIDC;
	GetFloat (hWndCtrl, fValue, g_fNoArm); 
	}
else{         
   	SetFloat(hWndCtrl, fValue, g_fNoArm, 2); 
	}
}


/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ A r m 						*
 ************************************************************************/
void AFXAPI DDV_Arm(CDataExchange* pDX, float fValue, float fMin, float fMax)
{
BOOL	bNeedValue = TRUE;     
CheckArm (pDX, fValue, fMin, fMax, bNeedValue);
}    

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ A r m O p t					*
 ************************************************************************/
void AFXAPI DDX_ArmOpt(CDataExchange* pDX, int nIDC, float& fValue)
{
DDX_Arm (pDX, nIDC, fValue);
}

/************************************************************************
 *  DlgTool.cpp    	 			D D V _ A r m O p t						*
 ************************************************************************/
void AFXAPI DDV_ArmOpt(CDataExchange* pDX, float fValue, float fMin, float fMax)
{
BOOL	bNeedValue = FALSE;     
CheckArm (pDX, fValue, fMin, fMax, bNeedValue);
}    

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ M a s s 						*
 ************************************************************************/
void AFXAPI DDX_Mass(CDataExchange* pDX, int nIDC, long& lValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
    nActID = nIDC;
	GetLong(hWndCtrl, lValue, NO_MASS);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetLong(hWndCtrl, lValue, NO_MASS);
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ M a s s 						*
 ************************************************************************/
void AFXAPI DDV_Mass(CDataExchange* pDX, long lValue, long lMin, long lMax)
{
BOOL	bNeedValue = TRUE;     
CheckMass (pDX, lValue, lMin, lMax, bNeedValue);
}                
  
/************************************************************************
 *  DlgTool.cpp    	 		 D D X _ M a s s O p t			 			*
 ************************************************************************/
void AFXAPI DDX_MassOpt(CDataExchange* pDX, int nIDC, long& lValue)
{    
DDX_Mass (pDX, nIDC, lValue);
}

/************************************************************************
 *  DlgTool.cpp    	 		D D V _ M a s s	O p t						*
 ************************************************************************/
void AFXAPI DDV_MassOpt(CDataExchange* pDX, long lValue, long lMin, long lMax)
{
BOOL	bNeedValue = FALSE;     
CheckMass (pDX, lValue, lMin, lMax, bNeedValue);
}                

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ T o r q 						*
 ************************************************************************/
void AFXAPI DDX_Torq(CDataExchange* pDX, int nIDC, float& fValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{   
    nActID = nIDC;
	GetFloat (hWndCtrl, fValue, (float)NO_MASS); 
	}
else{         
   	SetFloat(hWndCtrl, fValue, (float)NO_MASS, 2); 
	}
}


/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ T o r q 						*
 ************************************************************************/
void AFXAPI DDV_Torq(CDataExchange* pDX, float fValue, float fMin, float fMax)
{
	BOOL 	bOK = TRUE; 
	BOOL	bTest = TRUE;
	CString szText;
	
	if (pDX->m_bSaveAndValidate)
	{               
		CString szArmDim, szMassDim;
		short nArmDim, nMassDim;
		
		nArmDim = GetDim (pDX, ARM, ptActDimGroups, nActID); 	
		ptDim->GetDimCstring (&szArmDim, nArmDim);

		nMassDim = GetSecondDim (pDX, MASS, ptActDimGroups, nActID); 	
		ptDim->GetDimCstring (&szMassDim, nMassDim);

		if (fValue == NO_MASS)
		{           	// but there is no input!
			bOK 	= FALSE;  
			bTest	= FALSE;
			szText.LoadString(IDS_ENTER_TORQUE);
		}
		else
		{ 				// and there is our input
			bOK		= TRUE;
			bTest 	= TRUE;
		}
 		
		if (bTest)
		{
			double fConvert;
			fConvert = ptDim->ConvertDist (fMin, DIM_METER, nArmDim);
			fConvert = ptDim->ConvertMass (fConvert, DIM_KG, nMassDim);
			fMin = (float)fConvert;
			fConvert = ptDim->ConvertDist (fMax, DIM_METER, nArmDim);
			fConvert = ptDim->ConvertMass (fConvert, DIM_KG, nMassDim);
			fMax = (float)fConvert;
			if (fValue < fMin || fValue > fMax)
			{
				bOK = FALSE;
				szText.Format (IDF_LIM_TORQUE, fValue, fMin, fMax, (LPCTSTR)szArmDim, (LPCTSTR)szMassDim);
	        } 
		}
    }    
                
if (!bOK)
	{
	AfxMessageBox(szText);
	pDX->Fail();
	}
}    



/************************************************************************
 *  DlgTool.cpp    	 		D D X _ T a n k D e g r e e O p t			*
 ************************************************************************/
void AFXAPI DDX_TankDegreeOpt(CDataExchange* pDX, int nIDC, float& fValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
	GetFloat(hWndCtrl, fValue, NO_PCENT*100);
	fValue /= 100;
	}
else{
	fValue *= 100;
	SetFloat(hWndCtrl, fValue, NO_PCENT*100, 0); 
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ T a n k D e g r e e			*
 ************************************************************************/
void AFXAPI DDV_TankDegreeOpt(CDataExchange* pDX, float fValue, float fMin, float fMax)
{
BOOL bOK = TRUE;
float EPS=(float)0.0001;

fMin /= 100;
fMax /= 100;


if (pDX->m_bSaveAndValidate && (fValue != NO_PCENT))
	bOK = ( (fMin - fValue) < EPS &&
			(fValue - fMax) < EPS );
if (!bOK)
	{
	char szText[128];
	CString szFormat;
	szFormat.LoadString (IDF_LIM_TANK_PERCENT);
	sprintf (szText, szFormat, fValue*100, fMin*100, fMax*100);
	AfxMessageBox(szText);
	pDX->Fail();
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ L a t i t u d e				*
 ************************************************************************/
void AFXAPI DDX_Latitude(CDataExchange* pDX, int nIDC, double& dValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
	GetLatLon(hWndCtrl, dValue, NO_KOORD);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetLatLon(hWndCtrl, dValue, TRUE, NO_KOORD); 	// bLat = TRUE
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ L o n g i t u d e				*
 ************************************************************************/
void AFXAPI DDX_Longitude(CDataExchange* pDX, int nIDC, double& dValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
	GetLatLon(hWndCtrl, dValue, NO_KOORD);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetLatLon(hWndCtrl, dValue, FALSE, NO_KOORD); 	// bLat = FALSE
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D X _ V a r i a t i o n				*
 ************************************************************************/
void AFXAPI DDX_Variation(CDataExchange* pDX, int nIDC, double& dValue)
{
HWND hWndCtrl = pDX->PrepareEditCtrl(nIDC);
if (pDX->m_bSaveAndValidate)
	{
	GetLatLon(hWndCtrl, dValue, NO_KOORD);  
	}
else{         // converts from dimension of document to dimension of preference 
	SetVar(hWndCtrl, dValue, NO_KOORD); 
	}
}

/************************************************************************
 *  DlgTool.cpp    	 			 D D V _ A n g l e 						*
 ************************************************************************/
void AFXAPI DDV_Angle(CDataExchange* pDX, double dValue, double dMin, double dMax)
{
	BOOL bOK = TRUE;
	CString szText; 

	if (pDX->m_bSaveAndValidate)
	{          
		if (dValue == NO_KOORD)
		{
			bOK = FALSE;
			szText.LoadString(IDS_ENTER_ANGLE);
 		}
		else
		{
			bOK = (dValue >= dMin && dValue <= dMax); 
			if (!bOK)
			{
				szText.Format(IDF_LIM_ANGLE, dValue, dMin, dMax);
			}
		}
    }    
    
	if (!bOK)
	{
		AfxMessageBox(szText);
		pDX->Fail();
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDlgTool dialog


CDlgTool::CDlgTool(UINT nIDTemplate, CWnd* pParent /*=NULL*/)
	: CDialog(nIDTemplate, pParent)
{
	//{{AFX_DATA_INIT(CDlgTool)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


/************************************************************************
 *  DlgTool.cpp    	 	 		~ C D l g T o o l						*
 ************************************************************************/
CDlgTool::~CDlgTool()
{
this->DeleteDimGroups ();
} 

/************************************************************************
 *  DlgTool.cpp			G e t B u t t o n T e x t						*
 ************************************************************************/
void CDlgTool::GetButtonText (int nID, CString* ptText)
{
CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->GetWindowText (*ptText);
}

/************************************************************************
 *  DlgTool.cpp    	 	 		S e t T e x t							*
 ************************************************************************/
void CDlgTool::SetText(short nID, CString szText)
{
CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->SetWindowText((LPCTSTR)szText);
}

/************************************************************************
 *  DlgTool.cpp    	 	 		G e t T e x t							*
 ************************************************************************/
void CDlgTool::GetText(short nID, CString& rText)
{                 
rText.Empty();
CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->GetWindowText(rText);
}

/************************************************************************
 *  DlgTool.cpp				E r a s e T e x t							*
 ************************************************************************/
void CDlgTool::EraseText (int nID)
{
char	szText = 0;
CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->SetWindowText((LPCSTR)&szText);
}  

/************************************************************************
 *  DlgTool.cpp    	 	 	I s T e x t A v a i l a b l e				*
 ************************************************************************/
BOOL CDlgTool::IsTextAvailable(short nID)
{                 
	CString rText;
	CWnd* ptWnd = this->GetDlgItem (nID);	
	ptWnd->GetWindowText(rText);
	return (rText.GetLength() > 0);
}

/************************************************************************
 *  DlgTool.cpp				S e l e c t I t e m 						*
 ************************************************************************/
void CDlgTool::SelectItem (int nID)
{
WPARAM wParam;
LPARAM lParam;

CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->SetFocus ();
 
#ifdef WIN_NT
	wParam = (WPARAM) (INT) 0;		
	lParam = (LPARAM) (INT) -1;     
#else
    wParam = (WPARAM)1;				
    lParam = MAKELPARAM (0, -1);	
#endif
	
ptWnd->SendMessage (EM_SETSEL, wParam, lParam); 

}


/************************************************************************
 *  DlgTool.cpp				S e t P U I n d e x							*
 ************************************************************************/
void CDlgTool::SetPUIndex (int nID, short nIndex)
{
CComboBox* ptPopUp = (CComboBox*)GetDlgItem (nID);	
ptPopUp->SetCurSel (nIndex);	
}
    
/************************************************************************
 *  DlgTool.cpp				G e t P U I n d e x 						*
 ************************************************************************/
short CDlgTool::GetPUIndex (int nID)
{  
short nIndex = -1;
CComboBox* ptPopUp = (CComboBox*)GetDlgItem (nID);	
nIndex = ptPopUp->GetCurSel();	
return nIndex;
}

/************************************************************************
 *  DlgTool.cpp				S e t C o n t r o l							*
 ************************************************************************/
void CDlgTool::SetControl (int nID, BOOL bSet)
{
CWnd* ptWnd = this->GetDlgItem (nID);	
LRESULT Result = ptWnd->SendMessage (BM_SETCHECK, (WPARAM)bSet, 0L);
}
    
/************************************************************************
 *  DlgTool.cpp				G e t C o n t r o l							*
 ************************************************************************/
BOOL CDlgTool::GetControl (int nID)
{  
BOOL	bChecked = FALSE;
CWnd* ptWnd = this->GetDlgItem (nID);	
LRESULT Result = ptWnd->SendMessage (BM_GETCHECK, (WPARAM)0, 0L);
	
bChecked = (Result==1);
return bChecked;
}

/************************************************************************
 *  DlgTool.cpp			D i s a b l e C o n t r o l						*
 ************************************************************************/
void CDlgTool::DisableControl (int nID, BOOL bDisable)
{ 
CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->EnableWindow (!bDisable);
}

/************************************************************************
 *  DlgTool.cpp		D i s a b l e I n t e r v a l l C o n t r o l		*
 ************************************************************************/
void CDlgTool::DisableIntervallControl (int nFirstID, int nLastID, BOOL bDisable)
{
int i;

for (i=nFirstID; i<=nLastID; i++)
	{
	CWnd* ptWnd = this->GetDlgItem (i);	
	ptWnd->EnableWindow (!bDisable);
	}
}

/************************************************************************
 *  DlgTool.cpp				H i d e C o n t r o l						*
 ************************************************************************/
void CDlgTool::HideControl (int nID, BOOL bHide)
{ 
CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->ShowWindow (bHide? SW_HIDE : SW_SHOW);
}

void CDlgTool::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgTool)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

/************************************************************************
 *  DlgTool.cpp	  		 		 A d d D i m G r o u p					*
 ************************************************************************/
void CDlgTool::AddDimGroup (int nValueID, int nPopUpID)
{ 
CComboBox* ptPopUp = (CComboBox*)GetDlgItem (nPopUpID);
	
DIMGROUP* ptDimGroup = new DIMGROUP;
ptDimGroup->nValueID = nValueID;
ptDimGroup->ptPopUp	 = ptPopUp;

m_DimGroups.Add (ptDimGroup);
}

/************************************************************************
 *  DlgTool.cpp	  		 		 ActivateDimGroups					*
 ************************************************************************/
void CDlgTool::ActivateDimGroups ()
{ 
ptActDimGroups = &m_DimGroups;
}

/************************************************************************
 *  DlgTool.cpp	  		 		 DeleteDimGroups					*
 ************************************************************************/
void CDlgTool::DeleteDimGroups ()
{                      
int i, nEntryCnt;	
											
nEntryCnt = m_DimGroups.GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	DIMGROUP* ptEntry;
	if ((ptEntry = (DIMGROUP*)m_DimGroups.GetAt(i)) != NULL)
		delete ptEntry;				// delete original element
	}
m_DimGroups.RemoveAll();
}

/************************************************************************
 *  DlgTool.cpp	  		 		 F i l l D i m P U						*
 ************************************************************************/
void CDlgTool::FillDimPU (short nPopUpID, PARAMETER Param)
{   
CComboBox* ptPopUp = (CComboBox*)GetDlgItem (nPopUpID);	
ptDim->FillPU (ptPopUp, Param);    
}


/************************************************************************
 *  DlgTool.cpp				F o r m a t									*
 ************************************************************************/
CString CDlgTool::Format (short nID, ...)
{
CString szFormat;
char	szBuffer[256];   

szFormat.LoadString (nID);
va_list ptArgs;
va_start(ptArgs, nID);
short nLen = vsprintf (szBuffer, (LPCTSTR)szFormat, ptArgs);
va_end( ptArgs );

return (CString)szBuffer;
}


              
BEGIN_MESSAGE_MAP(CDlgTool, CDialog)
	//{{AFX_MSG_MAP(CDlgTool)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgTool message handlers
