#ifndef __DLGTOOL__
#define __DLGTOOL__

#include "DimDoc.h"    

/************************************************************************
 *  						D l g T o o l . h	  						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

void GetShort(HWND hWnd, short& nValue, short nDflt);
void SetShort(HWND hWnd, short nValue, short nDflt);
void GetLong(HWND hWnd, long& lValue, long lDflt);
void SetLong(HWND hWnd, long lValue, long lDflt);
void GetDWORD(HWND hWnd, DWORD& dwValue, DWORD dwDflt);
void SetDWORD(HWND hWnd, DWORD dwValue, DWORD dwDflt);
void GetFloat(HWND hWnd, float& fValue, float fDflt); 
void SetFloat(HWND hWnd, float fValue, float fDflt, short nNumPrec);
void GetLatLon (HWND hWnd, double& dAngle, double dDflt);
void SetLatLon(HWND hWnd, double dAngle, BOOL bLat, double dDflt);
void SetVar(HWND hWnd, double dAngle, double dDflt);

CComboBox* GetDimPopUp (CPtrArray* ptDimGroups, int nValueID, short* ptNextIndex=NULL);

//CComboBox* GetDimPopUp (CPtrArray* ptDimGroups, int nValueID);
short GetDim (CDataExchange* pDX, PARAMETER Param, CPtrArray* ptDimGroups, short nValueID);

void CheckRwy (CDataExchange* pDX, short nValue, short nMin, short nMax, BOOL bNeedValue);
void CheckDistance (CDataExchange* pDX, long lValue, long lMin, long lMax, BOOL bNeedValue);
void CheckDistance (CDataExchange* pDX, float fValue, float fMin, float fMax, BOOL bNeedValue);
void CheckAltitude (CDataExchange* pDX, long lValue, long lMin, long lMax, BOOL bNeedValue);
void CheckVolume (CDataExchange* pDX, long lValue, long lMin, long lMax, BOOL bNeedValue);
void CheckFrequency (CDataExchange* pDX, float fValue, float fMin, float fMax, BOOL bNeedValue);
void CheckMass (CDataExchange* pDX, long lValue, long lMin, long lMax, BOOL bNeedValue);

void AFXAPI DDX_CBIndexArmDim(CDataExchange* pDX, int nIDC, int& nValue);
 
void AFXAPI DDX_ShortOptional(CDataExchange* pDX, int nIDC, short& nValue);
void AFXAPI DDV_ShortOptional(CDataExchange* pDX, short nValue, short nMin, short nMax);
void AFXAPI DDX_DWORDOptional(CDataExchange* pDX, int nIDC, DWORD& dwValue);
void AFXAPI DDV_DWORDOptional(CDataExchange* pDX, DWORD dwValue, DWORD dwMin, DWORD dwMax);
void AFXAPI DDX_Dist(CDataExchange* pDX, int nIDC, long& lValue);
void AFXAPI DDX_Dist(CDataExchange* pDX, int nIDC, float& fValue);
void AFXAPI DDV_Dist(CDataExchange* pDX, long lValue, long lMin, long lMax);
void AFXAPI DDV_DistOptional(CDataExchange* pDX, long lValue, long lMin, long lMax);
void AFXAPI DDV_DistOptional(CDataExchange* pDX, float fValue, float fMin, float fMax);
void AFXAPI DDX_Alt(CDataExchange* pDX, int nIDC, long& lValue);
void AFXAPI DDV_Alt(CDataExchange* pDX, long lValue, long lMin, long lMax);   
void AFXAPI DDV_AltOptional(CDataExchange* pDX, long lValue, long lMin, long lMax);
void AFXAPI DDX_Freq(CDataExchange* pDX, int nIDC, float& fValue);
void AFXAPI DDV_FreqOptional(CDataExchange* pDX, float fValue, float fMin, float fMax);
void AFXAPI DDX_Rwy(CDataExchange* pDX, int nIDC, short& nValue);
void AFXAPI DDV_Rwy(CDataExchange* pDX, short nValue, short nMin, short nMax);
void AFXAPI DDX_RwyOpt(CDataExchange* pDX, int nIDC, short& nValue);
void AFXAPI DDV_RwyOpt(CDataExchange* pDX, short nValue, short nMin, short nMax);
void AFXAPI DDX_RwyLength(CDataExchange* pDX, int nIDC, long& lValue);
void AFXAPI DDV_RwyLengthOpt(CDataExchange* pDX, long lValue, long lMin, long lMax);
void AFXAPI DDX_Temp(CDataExchange* pDX, int nIDC, short& nValue);
void AFXAPI DDV_Temp(CDataExchange* pDX, short nValue, short nMin, short nMax);
void AFXAPI DDX_Press(CDataExchange* pDX, int nIDC, float& fValue);
void AFXAPI DDV_Press(CDataExchange* pDX, float fValue, float fMin, float fMax);
void AFXAPI DDX_WindSpeed(CDataExchange* pDX, int nIDC, short& nValue);
void AFXAPI DDV_WindSpeed(CDataExchange* pDX, short nValue, short nMin, short nMax);
void AFXAPI DDX_CruiseSpeed(CDataExchange* pDX, int nIDC, short& nValue);
void AFXAPI DDV_CruiseSpeed(CDataExchange* pDX, short nValue, short nMin, short nMax);
void AFXAPI DDX_ClimbSpeed(CDataExchange* pDX, int nIDC, short& nValue);
void AFXAPI DDV_ClimbSpeed(CDataExchange* pDX, short nValue, short nMin, short nMax);
void AFXAPI DDX_ClimbRate(CDataExchange* pDX, int nIDC, float& fValue);
void AFXAPI DDV_ClimbRate(CDataExchange* pDX, float fValue, float fMin, float fMax);
void AFXAPI DDX_Volume(CDataExchange* pDX, int nIDC, long& lValue);
void AFXAPI DDV_Volume(CDataExchange* pDX, long lValue, long lMin, long lMax);
void AFXAPI DDX_VolumeOpt(CDataExchange* pDX, int nIDC, long& lValue);
void AFXAPI DDV_VolumeOpt(CDataExchange* pDX, long lValue, long lMin, long lMax);
void AFXAPI DDX_Arm(CDataExchange* pDX, int nIDC, float& fValue);
void AFXAPI DDV_Arm(CDataExchange* pDX, float fValue, float fMin, float fMax);
void AFXAPI DDX_ArmOpt(CDataExchange* pDX, int nIDC, float& fValue);
void AFXAPI DDV_ArmOpt(CDataExchange* pDX, float fValue, float fMin, float fMax);
void AFXAPI DDX_Mass(CDataExchange* pDX, int nIDC, long& lValue);
void AFXAPI DDV_Mass(CDataExchange* pDX, long lValue, long lMin, long lMax);
void AFXAPI DDX_MassOpt(CDataExchange* pDX, int nIDC, long& lValue);
void AFXAPI DDV_MassOpt(CDataExchange* pDX, long lValue, long lMin, long lMax);
void AFXAPI DDX_Torq(CDataExchange* pDX, int nIDC, float& fValue);
void AFXAPI DDV_Torq(CDataExchange* pDX, float fValue, float fMin, float fMax);
void AFXAPI DDX_TankDegreeOpt(CDataExchange* pDX, int nIDC, float& fValue);
void AFXAPI DDV_TankDegreeOpt(CDataExchange* pDX, float fValue, float fMin, float fMax);
void AFXAPI DDX_Latitude(CDataExchange* pDX, int nIDC, double& dValue);
void AFXAPI DDX_Longitude(CDataExchange* pDX, int nIDC, double& dValue);
void AFXAPI DDX_Variation(CDataExchange* pDX, int nIDC, double& dValue);
void AFXAPI DDV_Angle(CDataExchange* pDX, double dValue, double dMin, double dMax);


class CDlgTool : public CDialog
{
// Construction      
private:
	CPtrArray m_DimGroups;		// array of DIMGROUP, see DimDoc.h

public:
	CDlgTool(UINT nIDTemplate, CWnd* pParent = NULL);   // standard constructor  
	~CDlgTool();								// destructor

	void GetButtonText (int nID, CString* ptText);

	void SetText(short nID, CString szText);
	void GetText(short nID, CString& rText);
	void EraseText (int nID);
	BOOL IsTextAvailable(short nID);
	void SelectItem (int nID);      
	
	void SetPUIndex (int nID, short nIndex);
	short GetPUIndex (int nID);
	void SetControl (int nID, BOOL bSet);
	BOOL GetControl (int nID);
	void DisableControl (int nID, BOOL bDisable);  
	void DisableIntervallControl (int nFirstID, int nLastID, BOOL bDisable);
	void HideControl (int nID, BOOL bHide);
	
	void AddDimGroup (int nValueID, int nPopUpID); 
	void ActivateDimGroups ();
    void DeleteDimGroups ();
	void FillDimPU (short nPopUpID, PARAMETER Param);	

	static CString Format (short nID, ...);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgTool)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDlgTool)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 



/* in C:\WINDOWS\APSTUDIO.INI, oder C:\MSDEV\BIN\DDX.clw:     
// mfc 5.0: \Program Files\DevStudio\SharedIDE\bin 


[ExtraDDX]
ExtraDDXCount=25
ExtraDDX1=E;;Short Opt;short;0;ShortOptional;short with optional range validation;ShortOptional;Min;d;Max;d
ExtraDDX2=E;;DWORD Opt ;DWORD;0;DWORDOptional;DWORD with optional range validation;DWDORDOptional;Min;U;Max;U
ExtraDDX3=E;;Distance;long;0;Dist;Distance;Dist;Min[NM];D;Max[NM];D
ExtraDDX4=E;;Distance Opt;long;0;Dist;Distance with optional range validation;DistOptional;Min[NM];D;Max[NM];D
ExtraDDX5=E;;Altitude;long;0;Alt;Altitude;Alt;Min[ft];D;Max[ft];D
ExtraDDX6=E;;Altitude Opt;long;0;Alt;Altitude with optional range validation;AltOptional;Min[ft];D;Max[ft];D
ExtraDDX7=E;;Frequency Opt;float;0;Freq;Frequency with optional range validation;FreqOptional;Min;f;Max;f
ExtraDDX8=E;;Runway;short;0;Rwy;Length of runway;Rwy;Min[m];d;Max[m];d
ExtraDDX9=E;;Runway Opt;short;0;RwyOpt;Length of runway with optional range validation;RwyOpt;Min[m];d;Max[m];d
ExtraDDX10=E;;Temperature;short;0;Temp;Temperature;Temp;Min[Grad C];d;Max[Grad C];d
ExtraDDX11=E;;Luftdruck;float;0;Press;Luftdruck;Press;Min[hPa];f;Max[hPa];f
ExtraDDX12=E;;Windgeschw.;short;0;WindSpeed;Windgeschwindigkeit;WindSpeed;Min[kt];d;Max[kt];d
ExtraDDX13=E;;Fluggeschw.;short;0;CruiseSpeed;Fluggeschwindigkeit;CruiseSpeed;Min[kt];d;Max[kt];d
ExtraDDX14=E;;Steiggeschw.;short;0;ClimbSpeed;Steiggeschwindigkeit;ClimbSpeed;Min[ft/min];d;Max[ft/min];d
ExtraDDX15=E;;Volumen;long;0;Volume;Volumen;Volume;Min[l];D;Max[l];D
ExtraDDX16=E;;Volumen Opt;long;0;VolumeOpt;Optionales Volumen;VolumeOpt;Min[l];D;Max[l];D
ExtraDDX17=E;;Arm;float;0;Arm;Lever Arm;Arm;Min[m];f;Max[m];f
ExtraDDX18=E;;Arm Opt;float;0;ArmOpt;Lev with optional range validation;ArmOpt;Min[m];f;Max[m];f
ExtraDDX19=E;;Mass;long;0;Mass;Masse;Mass;Min[kg];D;Max[kg];D
ExtraDDX20=E;;Mass Opt;long;0;MassOpt;Mass with optional range validation;MassOpt;Min[kg];D;Max[kg];D
ExtraDDX21=E;;Drehmoment;float;0;Torq;Drehmoment;Torq;Min[mkp];f;Max[mkp];f
ExtraDDX22=E;;Tankfllgrad;float;0;TankDegreeOpt;Optionaler Fankfllgrad[%];TankDegreeOpt;Min[%];f;Max[%];f
ExtraDDX23=E;;Latitude;double;0;Latitude;Latitude;Angle;Min[Grad];F;Max[Grad];F
ExtraDDX24=E;;Longitude;double;0;Longitude;Longitude;Angle;Min[Grad];F;Max[Grad];F
ExtraDDX25=E;;Variation;double;0;Variation;Variation;Angle;Min[Grad];F;Max[Grad];F

*/