#ifndef __ELEV__      
#define __ELEV__

// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#define ACT_ELEV_VERS	1  

#pragma pack(2)

typedef struct
	{
	float	fLat_TL;		/* Latitude of top left point		*/
	float	fLon_TL;		/* Longitude of top left point		*/
	short	nSouth_min;		/* area height in minutes			*/
	short	nEast_min;		/* area width in minutes			*/
	long	lMaxElev;		/* max. elevation in this area		*/
	short	nElevDim;		/* dimension of elevation			*/
	} ELEVTYPE;

typedef ELEVTYPE FAR* LPELEV;
#pragma pack() 
	
class CLatLon;	
class CElev : public CObject
{
	DECLARE_SERIAL(CElev)

// Attributes
public:    
	CLatLon			m_PosTL;
	short			m_nSouth_min;
	short			m_nEast_min;
	long			m_lMaxElev;
	short			m_nElevDim;

// Operations
private:

protected:
	void ReadFromPtr(LPELEV lpElev);
	void WriteToPtr(LPELEV lpElev) const;

// Implementation
public:
	CElev(LPELEV lpElev = NULL);		
	CElev(CElev& SourceElev);
	~CElev();                                                

	void GetPtr(LPELEV lpElev);
	void SetPtr (LPELEV lpElev);
	const CElev& operator=(const CElev& Elev);
	void FirstInit();


 	void Serialize(CArchive& ar, short nVersion = ACT_ELEV_VERS);
	LPELEV CreatePtr ();
	BOOL IsEqual(const CElev& ptTestElev);
	BOOL IsEqual(LPELEV lpTestElev);
	CString GetListEntry();

	int Compare(const CLatLon& LL, BOOL bFrameIsInside);
	int Compare(const CElev& Elev);

	double LatToY (double dLat);
	double LonToX (double dLon);
	double YtoLat (double dY);
	double XtoLon (double dX);

	BOOL IsLonBtn (double dMinLon, double dTestLon, double dMaxLon);

	BOOL CrossEast(CLatLon& Wpt1, CLatLon& Wpt2, double* ptLatCross);
	BOOL CrossWest(CLatLon& Wpt1, CLatLon& Wpt2, double* ptLatCross);
	BOOL CrossNorth(CLatLon& Wpt1, CLatLon& Wpt2, double* ptLonCross);
	BOOL CrossSouth(CLatLon& Wpt1, CLatLon& Wpt2, double* ptLonCross);

	BOOL CreateFont (CFont* ptFont, char* szName, long lHeight, BOOL bBold);
	void DrawValue (CDC* pDC, long lTop, long lLeft, long lBottom, long lRight);

	void SetPosTL(CLatLon& LL) { m_PosTL = LL; }
	void SetSouthMinutes (short nMin) { m_nSouth_min = nMin; }
	void SetEastMinutes (short nMin) { m_nEast_min = nMin; }
	void SetMaxElev (long lElev) { m_lMaxElev = lElev; }
	void SetElevDim(short nDim){m_nElevDim = nDim;}

	CLatLon GetPosTL () { return m_PosTL; }

	static double AddSouth(double dLatTop, short nSouth_min);
	static double AddEast(double dLonLeft, short nEast_min);
	CLatLon GetPosBR ();

	short GetSouthMinutes() { return m_nSouth_min; }
	short GetEastMinutes() { return m_nEast_min; }
	long GetMaxElev () { return m_lMaxElev; }
	short GetElevDim(){return m_nElevDim;}
	
};
#endif 

