#ifndef __ELEV_ARRAY__      
#define __ELEV_ARRAY__

// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#define ACT_ELEV_ARRAY_VERS	1  

typedef enum
{
	LITTLE_ENDIAN,
	BIG_ENDIAN
} BYTEORDER;
	
class CLatLon;	
class CElevArray : public CObject
{
	DECLARE_SERIAL(CElevArray)

// Attributes
public:  
	CString		m_szName;			// "Europa"
	CString		m_szPath;			// D:\\ELEVATION60_0_20_40\\mydata.bin
	BOOL		m_bActivated;
	double		m_fLonMin;
	double		m_fLonMax;
	double		m_fLatMax;
	double		m_fLatMin;
	short		m_nRows;
	short		m_nColumns;
	double		m_fGridSize;
	short		m_nElevMin_m;
	short		m_nElevMax_m;
	short		m_nElevMissingFlag;
	BYTEORDER	m_ByteOrder;
	BOOL		m_bOpened;

	CFile*		m_ptFile;
	long		m_lLastOffset;
	short		m_nLastElev_m;
	short		m_nElevLineLen;
	short*		m_ptElevLine;

// Operations
private:

// Implementation
public:
	CElevArray();		
	CElevArray(CElevArray& SourceElev);
	~CElevArray();                                                

	const CElevArray& operator=(const CElevArray& Elev);
	void Reset();
	BOOL IsEqual(const CElevArray& Elev);
	BOOL IsAntipod(DRECT rMap);
	BOOL GetElev_m (double fLat, double fLon, short* ptElev);

	BOOL HasElevFor (double fLat, double fLon);
	BOOL Open ();
	BOOL ReadElev_m (double fLat, double fLon, short* ptElev);
	short GetRow (double fLat);
	short GetColumn (double fLon);
	BOOL ReadElevLine (double fLat, double fLon, short nElevCnt);

	double GetLonForElevArea (double dLon);
	void GenerateImageLine (LPSTR lpData, long lFileRowBytes,
							short nLine, short nImgageRowStart, short nImageRowEnd,
							double dActLat, double dStartLon, double dEndLon);

	void Close ();

 	void Serialize(CArchive& ar, short nVersion = ACT_ELEV_ARRAY_VERS);	

	CString GetName() { return m_szName; }
	CString GetPath() { return m_szPath; }
	BOOL IsActivated() { return m_bActivated; }

	double GetLonMin () { return m_fLonMin; }
	double GetLonMax () { return m_fLonMax; }
	double GetLatMin () { return m_fLatMin; }
	double GetLatMax () { return m_fLatMax; }

	short GetRowCnt () { return m_nRows; }
	short GetColumnCnt () { return m_nColumns; }

	double GetGridSize () { return m_fGridSize; }
	short GetElevMin_m () { return m_nElevMin_m; }
	short GetElevMax_m () { return m_nElevMax_m; }

	short GetElevMissingFlag () { return m_nElevMissingFlag; }
	BYTEORDER GetByteOrder () { return m_ByteOrder; }



	void SetName (CString szName) { m_szName = szName; }
	void SetPath (CString szPath) { m_szPath = szPath; }
	void SetActivated (BOOL bActiv) { m_bActivated = bActiv; }

	void SetLonMin (double fDegree) { m_fLonMin = fDegree; }
	void SetLonMax (double fDegree) { m_fLonMax = fDegree; }
	void SetLatMin (double fDegree) { m_fLatMin = fDegree; }
	void SetLatMax (double fDegree) { m_fLatMax = fDegree; }

	void SetRowCnt (short nCnt) { m_nRows = nCnt; }
	void SetColumnCnt (short nCnt) { m_nColumns = nCnt; }

	void SetGridSize (double fDegree) { m_fGridSize = fDegree; }

	void SetElevMin_m (short nElev) { m_nElevMin_m = nElev; }
	void SetElevMax_m (short nElev) { m_nElevMax_m = nElev; }

	void SetElevMissingFlag (short nElev)  { m_nElevMissingFlag = nElev; }
	void SetByteOrder (BYTEORDER ByteOrder) { m_ByteOrder = ByteOrder; }

private:
	BOOL RenameLybiaToLibya();
	short NewShortByteOrder (short nSource);

};
#endif 

