// ElevArrayDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"  

#include "InitDoc.h"
#include "DimDoc.h"   
 
#include "ElevArrayDlg.h"

#include "..\Cpptools\DirBrDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;              

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CElevArrayDlg 


CElevArrayDlg::CElevArrayDlg(CWnd* pParent, CElevArrayDoc* ptDoc)
	: CDlgTool(CElevArrayDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CElevArrayDlg)
	m_nListIndex = -1;
	m_szName = _T("");
	m_szPath = _T("");
	m_fLatMin = NO_KOORD;
	m_fLatMax = NO_KOORD;
	m_fLonMin = NO_KOORD;
	m_fLonMax = NO_KOORD;
	m_bActivate = FALSE;
	m_fGridSize = 0.0;
	m_nColumns = 0;
	m_nRows = 0;
	m_nElevMissingFlag = 0;
	m_nElevMax_m = 0;
	m_nElevMin_m = 0;
	m_bSRTM = FALSE;
	//}}AFX_DATA_INIT


m_ptDoc = ptDoc;
m_bInsert = FALSE;
m_nOldIndex = -1;
m_szInitialSelName.Empty();

this->ReadDataBaseFromDoc ();	// defines m_ActList[CElevArray]
}

CElevArrayDlg::~CElevArrayDlg()
{
this->DeleteDataBase();
}


/************************************************************************
 *  ElevArrayDlg.cpp	  		D e l e t e D a t a B a s e				*
 ************************************************************************/
void CElevArrayDlg::DeleteDataBase()
{  
m_ptDoc->DeleteArrayOf (&m_ActList);		// array of CElevArray
}


/************************************************************************
 *  ElevArrayDlg.cpp	  	R e a d D a t a B a s e	F r o m D o c		*
 ************************************************************************/
void CElevArrayDlg::ReadDataBaseFromDoc()
{                   					// copy database from Doc to Dlg
							
	m_ptDoc->GetDataBase (&m_ActList);	// array of CElevArray
	m_nListIndex = m_ptDoc->GetActIndex();

	if (m_nListIndex > -1 && m_ActList.GetSize() > 0)
	{
		CElevArray* ptEntry = (CElevArray*)m_ActList.GetAt (m_nListIndex); 
		if (ptEntry != NULL)
		{
			m_szInitialSelName = ptEntry->GetName();
		}
	}

	m_bChanged = FALSE;
	m_ptDoc->SetModifiedFlag(FALSE);
}


/************************************************************************
 *  ElevArrayDlg.cpp	  	W r i t e D a t a B a s e I n t o D o c 	*
 ************************************************************************/
BOOL CElevArrayDlg::WriteDataBaseIntoDoc()
{ 				
                                  // copy database from Dlg to Doc
	BOOL bWritten = FALSE;
	BOOL bSelectionChanged = FALSE;

	if (m_nListIndex > -1 && m_ActList.GetSize() > 0)
	{
		m_ptDoc->SetActIndex (m_nListIndex);

		CElevArray* ptEntry = (CElevArray*)m_ActList.GetAt (m_nListIndex); 
		if (ptEntry != NULL)
		{						// new ElevArray selected: set m_bChanged!
			CString szNewSelName = ptEntry->GetName();
			bSelectionChanged = (szNewSelName.Compare (m_szInitialSelName) != 0);
		}
	}	

	if (m_bChanged || m_ptDoc->WasConverted() || bSelectionChanged)
	{
		m_ptDoc->SetDataBase (&m_ActList);  
		m_ptDoc->SetModifiedFlag(TRUE);  
		bWritten = TRUE;
	}

	return bWritten;
}

/************************************************************************
 *  ElevArrayDlg.cpp	  				R e s e t						*
 ************************************************************************/
void CElevArrayDlg::Reset ()
{
	m_nListIndex = -1;
	m_szName.Empty();
	m_szPath.Empty();
	m_fLatMin = NO_KOORD;
	m_fLatMax = NO_KOORD;
	m_fLonMin = NO_KOORD;
	m_fLonMax = NO_KOORD;
	m_bActivate = FALSE;
	m_szInitialSelName.Empty();
}

/************************************************************************
 *  ElevArrayDlg.cpp	  			S e t D a t a						*
 ************************************************************************/
void CElevArrayDlg::SetData (CElevArray* ptElevArray)
{
	m_szName = ptElevArray->GetName ();
	m_szPath = ptElevArray->GetPath ();
	m_bActivate = ptElevArray->IsActivated ();

	m_fLatMin = ptElevArray->GetLatMin ();
	m_fLatMax = ptElevArray->GetLatMax ();
	m_fLonMin = ptElevArray->GetLonMin ();
	m_fLonMax = ptElevArray->GetLonMax ();

	m_nRows = ptElevArray->GetRowCnt ();
	m_nColumns = ptElevArray->GetColumnCnt ();

	m_fGridSize = ptElevArray->GetGridSize ();
	m_nElevMin_m = ptElevArray->GetElevMin_m ();
	m_nElevMax_m = ptElevArray->GetElevMax_m ();

	m_nElevMissingFlag = ptElevArray->GetElevMissingFlag ();

	BYTEORDER byteOrder = ptElevArray->GetByteOrder ();
	m_bSRTM = (byteOrder == BIG_ENDIAN);
}


/************************************************************************
 *  ElevArrayDlg.cpp	  			G e t D a t a						*
 ************************************************************************/
void CElevArrayDlg::GetData (CElevArray* ptElevArray)
{
	ptElevArray->SetName (m_szName);
	ptElevArray->SetPath (m_szPath);
	ptElevArray->SetActivated (m_bActivate);

	ptElevArray->SetLonMin (m_fLonMin);
	ptElevArray->SetLonMax (m_fLonMax);
	ptElevArray->SetLatMin (m_fLatMin);
	ptElevArray->SetLatMax (m_fLatMax);

	ptElevArray->SetRowCnt (m_nRows);
	ptElevArray->SetColumnCnt (m_nColumns);

	ptElevArray->SetGridSize (m_fGridSize);

	ptElevArray->SetElevMin_m (m_nElevMin_m);
	ptElevArray->SetElevMax_m (m_nElevMax_m);

	ptElevArray->SetElevMissingFlag (m_nElevMissingFlag);

	BYTEORDER byteOrder = (m_bSRTM? BIG_ENDIAN : LITTLE_ENDIAN);
	ptElevArray->SetByteOrder (byteOrder);
}

/************************************************************************
 *  ElevArrayDlg.cpp	   R e m o v e L i s t S e l e c t i o n		*
 ************************************************************************/
void CElevArrayDlg::RemoveListSelection()
{
m_nListIndex = -1;  			   // remove selection
CListBox* ptList = (CListBox*)GetDlgItem (IDC_EALIST); 
if (ptList != NULL)
	ptList->SetSel(m_nListIndex, FALSE);   
}

/************************************************************************
 *  ElevArrayDlg.cpp	  			F i l l L i s t 					*
 ************************************************************************/
void CElevArrayDlg::FillList ()
{
	CListBox* ptList = (CListBox*)GetDlgItem (IDC_EALIST);    
	if (ptList != NULL)
	{
		ptList->ResetContent();

		CString szText;
		short i;
		for (i=0; i<m_ActList.GetSize(); i++)
		{      
			CElevArray* ptTestEntry = (CElevArray*)m_ActList.GetAt (i);
			if (ptTestEntry != NULL)
			{
				szText = ptTestEntry->GetName();
				ptList->AddString((LPCTSTR)szText);  
			}
		}   
	}
}                             

/************************************************************************
 *  ElevArrayDlg.cpp	  		O n N e w L i s t 						*
 ************************************************************************/
short CElevArrayDlg::OnNewList ()
{
	this->FillList();

	BOOL bData = (m_ActList.GetSize() > 0);
	short nListIndex = bData? m_nListIndex : -1;    

	this->DisableControl (IDC_EACHANGE, !bData);	
	this->DisableControl (IDC_EADELETE, !bData); 
 
	return nListIndex;
}


/************************************************************************
 *  ElevArrayDlg.cpp	  	 D o D a t a E x c h a n g e				*
 ************************************************************************/
void CElevArrayDlg::DoDataExchange(CDataExchange* pDX)
{
if (pDX->m_bSaveAndValidate)
	{  
	m_nOldIndex 	= m_nListIndex;	  
	}
else{   
	CElevArray* ptNewElevArray = NULL;
							
	if (m_nListIndex >= 0 && m_nListIndex<m_ActList.GetSize())	
		ptNewElevArray = (CElevArray*)m_ActList.GetAt(m_nListIndex);

	if (ptNewElevArray != NULL)
		{
		m_ActElevArray.Reset();
		m_ActElevArray = *ptNewElevArray;
		this->SetData (ptNewElevArray);    
	    }
	else{
		CElevArray Dummy;
		this->SetData(&Dummy);
		}
    }

	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CElevArrayDlg)
	DDX_LBIndex(pDX, IDC_EALIST, m_nListIndex);
	DDX_Text(pDX, IDC_EANAME, m_szName);
	DDV_MaxChars(pDX, m_szName, 32);
	DDX_Text(pDX, IDC_EAPATH, m_szPath);
	DDV_MaxChars(pDX, m_szPath, 256);
	DDX_Latitude(pDX, IDC_EALATMIN, m_fLatMin);
	DDX_Latitude(pDX, IDC_EALATMAX, m_fLatMax);
	DDX_Longitude(pDX, IDC_EALONMIN, m_fLonMin);
	DDX_Longitude(pDX, IDC_EALONMAX, m_fLonMax);
	DDX_Check(pDX, IDC_EAACTIVATE, m_bActivate);
	DDX_Text(pDX, IDC_EAGRID, m_fGridSize);
	DDV_MinMaxDouble(pDX, m_fGridSize, 1.e-004, 0.5);
	DDX_Text(pDX, IDC_EACOLUMNS, m_nColumns);
	DDV_MinMaxInt(pDX, m_nColumns, 0, 20000);
	DDX_Text(pDX, IDC_EAROWS, m_nRows);
	DDV_MinMaxInt(pDX, m_nRows, 0, 20000);
	DDX_Text(pDX, IDC_EAELEVMISS, m_nElevMissingFlag);
	DDV_MinMaxInt(pDX, m_nElevMissingFlag, -5000, 0);
	DDX_Text(pDX, IDC_EAELEVMAX, m_nElevMax_m);
	DDV_MinMaxInt(pDX, m_nElevMax_m, -5000, 10000);
	DDX_Text(pDX, IDC_EAELEVMIN, m_nElevMin_m);
	DDV_MinMaxInt(pDX, m_nElevMin_m, -5000, 10000);
	DDX_Check(pDX, IDC_EASRTM, m_bSRTM);
	//}}AFX_DATA_MAP

if (pDX->m_bSaveAndValidate)
	{        
	if (m_bInsert)
		{
		this->GetData (&m_ActElevArray);  		   
		if (!this->InsertSorted (&m_ActElevArray))
			{				// checks for double names
			pDX->Fail();    // DDX_Text(pDX, IDC_EANAME, m_szName); must be last DDX_...
			}
		}
	else{				  // change-mode
		if (m_nOldIndex>=0 && m_nOldIndex<m_ActList.GetSize())
			{
			CElevArray* ptOldElevArray = (CElevArray*)m_ActList.GetAt(m_nOldIndex);

			this->GetData (&m_ActElevArray);  

			if (!m_ActElevArray.IsEqual(*ptOldElevArray))
				{  									// data has been changed !!
				this->InsertSorted (&m_ActElevArray);
				delete ptOldElevArray;
				}
			}
		}
    }
}


BEGIN_MESSAGE_MAP(CElevArrayDlg, CDlgTool)
	//{{AFX_MSG_MAP(CElevArrayDlg)
	ON_BN_CLICKED(IDC_EASEL, OnSelectFile)
	ON_BN_CLICKED(IDC_EADELETE, OnDelete)
	ON_BN_CLICKED(IDC_EAINSERT, OnInsert)
	ON_BN_CLICKED(IDC_EACHANGE, OnChange)
	ON_LBN_SELCHANGE(IDC_EALIST, OnSelchangeList)
	ON_LBN_DBLCLK(IDC_EALIST, OnDblclkList)
	ON_EN_CHANGE(IDC_EANAME, OnChangeName)
	ON_BN_CLICKED(IDC_EADONE, OnDone)
	ON_WM_HELPINFO()
	ON_BN_CLICKED(IDC_EAIMPORT, OnImport)
	ON_BN_CLICKED(IDC_EAEXPORT, OnExport)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CElevArrayDlg 


/************************************************************************
 *  ElevArrayDlg.cpp	 		O n I n i t D i a l o g 				*
 ************************************************************************/
BOOL CElevArrayDlg::OnInitDialog() 
{
	m_nListIndex = this->OnNewList ();

	if (m_nListIndex > -1)
	{
		CListBox* ptList = (CListBox*)GetDlgItem (IDC_EALIST);    
		if (ptList != NULL)
			ptList->SetSel(m_nListIndex);

		CElevArray* ptElevArray = (CElevArray*)m_ActList.GetAt (m_nListIndex);
		m_ActElevArray = *ptElevArray;
		this->DisableControl (IDC_EAINSERT, TRUE);
		this->DisableControl (IDC_EAEXPORT, FALSE);
	}
	else
	{
		this->DisableControl (IDC_EAEXPORT, TRUE);
	}

	CDlgTool::OnInitDialog();
	
	// TODO: Zustzliche Initialisierung hier einfgen
	SelectItem (IDC_EANAME);		// focus set to a control, return FALSE
	
	return FALSE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

/************************************************************************
 *  ElevArrayDlg.cpp	  		I n s e r t S o r t e d					*
 ************************************************************************/
BOOL CElevArrayDlg::InsertSorted (CElevArray* ptElevArray)
{
short nNewIndex;
					   // create new memory for actual ElevArray
if (m_bInsert)
	{
	BOOL bDifferentNamesReq = TRUE;
	nNewIndex = m_ptDoc->GetSortedIndex (m_ActList, ptElevArray);

	if (nNewIndex > 0 && bDifferentNamesReq)
		{
		CElevArray* ptPrevCust = (CElevArray*)m_ActList.GetAt(nNewIndex-1);
		CString szPrevName = ptPrevCust->GetName();
		CString	szNewName = ptElevArray->GetName();
		if (szNewName.Compare ((LPCTSTR)szPrevName) == 0)
			{
			AfxMessageBox (IDS_SAME_NAME);
			return FALSE;
			}
		}

	CElevArray* ptNewElevArray = new CElevArray (*ptElevArray);
	if (ptNewElevArray != NULL)
		{
		m_ActList.InsertAt (nNewIndex, ptNewElevArray);	// insert new  
		m_bChanged = TRUE;
		}

	RemoveListSelection();			// for multi selection list box

	m_nListIndex = nNewIndex;
	}
else{		  			 // m_nOldIndex defined in DoDataExchange  
	m_ActList.RemoveAt (m_nOldIndex); 	// delete old database entry 
	nNewIndex = m_ptDoc->GetSortedIndex (m_ActList, ptElevArray); 

	CElevArray* ptNewElevArray = new CElevArray (*ptElevArray);
	if (ptNewElevArray != NULL)
		{
		m_ActList.InsertAt (nNewIndex, ptNewElevArray);	// insert new
		m_bChanged = TRUE;

		if (nNewIndex > m_nOldIndex)
			if (m_nOldIndex < m_nListIndex && m_nListIndex <= nNewIndex) 
				m_nListIndex--;

		if (nNewIndex < m_nOldIndex)
			if (nNewIndex <= m_nListIndex && m_nListIndex < m_nOldIndex)
				m_nListIndex++;  
		}
	}
		
if (m_bChanged)
	{
	if (ptInit->IsSaveSignal())
		MessageBeep(MB_OK);	
	}

	              				// compare listbox entries         
CListBox* ptList = (CListBox*)GetDlgItem (IDC_EALIST);    
CString szNewName = ptElevArray->GetName();        

if (m_bInsert)
	{
	ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);   
	ptList->SetSel(nNewIndex, TRUE);		// for multi selection list box
	}
else{
	CString szOldName;
	ptList->GetText (m_nOldIndex, szOldName);
			
	if (szNewName.CompareNoCase((LPCTSTR)szOldName) != 0)
		{                		// change listbox entry	
		ptList->DeleteString(m_nOldIndex);
		ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);  
		ptList->SetSel(m_nListIndex, FALSE);
		ptList->SetSel(nNewIndex, TRUE);		// for multi selection list box
		m_nListIndex = nNewIndex;
		}   
	}

m_ptDoc->SetActIndex (nNewIndex);
return TRUE;
}


/************************************************************************
 *  ElevArrayDlg.cpp 			O n S e l C h a n g e L i s t			*
 ************************************************************************/
void CElevArrayDlg::OnSelchangeList() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CListBox* ptList = (CListBox*)GetDlgItem (IDC_EALIST);    
	short nNewIndex = ptList->GetCurSel ();

	if (m_nListIndex != nNewIndex)
	{	
		if (this->UpdateData(TRUE))
		{  
 			this->UpdateData(FALSE);
		}      
		else
		{				// bad input, reset selection to bad entry 
			m_nListIndex = m_nOldIndex;
			ptList->SetSel (m_nListIndex, TRUE);		  
		}

		CElevArray* ptEntry = (CElevArray*)m_ActList.GetAt (m_nListIndex);
		m_ActElevArray = *ptEntry;
	}
	else
	{	// check if new data different from old, then confirm dlg.
		this->UpdateData (FALSE);
	}	

	m_ptDoc->SetActIndex (m_nListIndex);

	BOOL bDisableExport = (GetSelCnt() == 0);
	this->DisableControl (IDC_EAEXPORT, bDisableExport);

	BOOL bMultSel = (GetSelCnt() > 1);
	this->DisableControl (IDC_EACHANGE, bMultSel);
	this->DisableControl (IDC_EADELETE, bMultSel);
}

/************************************************************************
 *  ElevArrayDlg.cpp	  		O n S e l e c t F i l e					*
 ************************************************************************/
void CElevArrayDlg::OnSelectFile() 
{
	// TODO: Add your control notification handler code here
static char szFilter[] = "Profil (*.bin)|*.bin||"; 

CFileDialog dlg(TRUE, 	  					// File Open dialog
				NULL,						// no default extension
				"*.bin",					// initial filename
				OFN_HIDEREADONLY |	  		// dwFlags
				OFN_OVERWRITEPROMPT,
				szFilter,
				this);						// parent window

//CString szPath = ptInit->GetActualPath() + "bin";	// without NameExt
//dlg.m_ofn.lpstrInitialDir = (LPCTSTR)szPath;

int ret = dlg.DoModal();
if (ret == IDOK)
	{
	m_szPath = dlg.GetPathName();
	this->SetText (IDC_EAPATH, m_szPath);

	if (m_szName.GetLength() == 0)
	{
		CString szFileExt = dlg.GetFileName();
		CString szFile = szFileExt;			   // remove ext from file.ext
		short nDot = szFileExt.Find('.');
		if (nDot > 0) szFile = szFileExt.Left(nDot);
		this->SetText (IDC_EANAME, szFile);

		if (szFile.GetLength() > 0)
			this->DisableControl (IDC_EAINSERT, FALSE);
	}

	this->SelectItem (IDC_EANAME);
	}
}


/************************************************************************
 *  ElevArrayDlg.cpp	  			O n I n s e r t		 				*
 ************************************************************************/
void CElevArrayDlg::OnInsert() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
m_bInsert = TRUE;
if (this->UpdateData(TRUE))
	{
	m_bChanged = TRUE;
	this->UpdateData (FALSE);

	if (m_ActList.GetSize() == 1)
		{
		this->DisableControl (IDC_EACHANGE, FALSE);  
		this->DisableControl (IDC_EADELETE, FALSE);  
		}
	SelectItem (IDC_EANAME);
	}


this->DisableControl (IDC_EAINSERT, TRUE);	// avoid to select Insert again

m_bInsert = FALSE;	
}


/************************************************************************
 *  ElevArrayDlg.cpp				O n C h a n g e		 				*
 ************************************************************************/
void CElevArrayDlg::OnChange() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
if (this->UpdateData(TRUE))
	{
	m_bChanged = TRUE;
	this->UpdateData (FALSE);
	this->SelectItem (IDC_EANAME);
	}
}


/************************************************************************
 *  ElevArrayDlg.cpp	  		O n D e l e t e 		 				*
 ************************************************************************/
void CElevArrayDlg::OnDelete() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
CListBox* ptList = (CListBox*)GetDlgItem (IDC_EALIST);    

short nDeleteIndex = ptList->GetCurSel (); 
if (nDeleteIndex > -1)
	{
	CElevArray* ptEntry = (CElevArray*)m_ActList.GetAt(nDeleteIndex); 
	if (ptEntry!=NULL)
		{
		delete ptEntry;
		m_ActList.RemoveAt (nDeleteIndex); 
		m_bChanged = TRUE;           
		}

	ptList->DeleteString (nDeleteIndex);

	if (m_ActList.GetSize() > 0)
		{ 
		m_nListIndex = (nDeleteIndex > 0)? nDeleteIndex - 1 : 0; 
		ptList->SetSel(m_nListIndex, TRUE);	// for multi selection list box
		this->UpdateData(FALSE);
		}
	else{
		this->DisableControl (IDC_EACHANGE, TRUE);  
		this->DisableControl (IDC_EADELETE, TRUE);  
		m_nListIndex = -1;  
		}
	}	 
}

/************************************************************************
 *  ElevArrayDlg.cpp	  		O n D b l c l k L i s t					*
 ************************************************************************/
void CElevArrayDlg::OnDblclkList() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->OnOK();
}

/************************************************************************
 *  ElevArrayDlg.cpp 					O n D o n e						*
 ************************************************************************/
void CElevArrayDlg::OnDone() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
this->OnOK();
}

/************************************************************************
 *  ElevArrayDlg.cpp	  			P a t h C o n t a i n s 			*
 *  Purpose: Checks if szPath contains files with szExt (= "bin")		*
 ************************************************************************/
BOOL CElevArrayDlg::PathContains (CStringArray* ptFiles, CString szPath, CString szExt)
{
BOOL bFound = FALSE;
CString szSearchPath (szPath + "\\*." + szExt);	  // G:\Elev\*.bin

short nCnt = CQuickFind::EnumFiles (ptFiles, szSearchPath);  
bFound = (nCnt > 0);

return bFound;
}

/************************************************************************
 *  ElevArrayDlg.cpp	  			C o p y F i l e s					*
 *  Purpose: Copies files from ONE source dir to ONE dest dir			*
 *  Files: Name.ext of all files to be copied							*
 *			from szSourcePath to szDestPath								*
 ************************************************************************/
BOOL CElevArrayDlg::CopyFiles (CStringArray& Files, CString szSourcePath, CString szDestPath)
{
	BOOL bCopied = FALSE;

	BeginWaitCursor();		// display the hourglass cursor

	short i;
	for (i=0; i<Files.GetSize(); i++)			 
	{
		CString szNameExt = Files.GetAt(i);				// N48E0061.bin
		CString szSource = szSourcePath + "\\" + szNameExt;	// "G:\Elev\N48E0061.bin"
		CString szDest	= szDestPath + "\\" + szNameExt;

 		if (CopyFile ((LPCTSTR)szSource,	// pointer to name of an existing file 
						(LPCTSTR)szDest,	// pointer to filename to copy to 
						FALSE))				//   BOOL bFailIfExists = FALSE
		{
			bCopied = TRUE;
											// reset write protection of files copied from CD
			CFileStatus status;
			CFile::GetStatus(szDest, status );
			status.m_attribute = CFile::normal | CFile::archive;
			CFile::SetStatus(szDest, status );
		}
	}

	EndWaitCursor();		// remove the hourglass cursor

	return bCopied;
}

/************************************************************************
 *  ElevArrayDlg.cpp	  			C o p y F i l e s					*
 *  Purpose: Copies files from different source dirs to ONE dest dir	*
 *  FilePaths: Path/Name.ext of all files to be copied to szDestPath	*
 *  szDestPath must end with a backslash!!								*
 ************************************************************************/
BOOL CElevArrayDlg::CopyFiles(CStringArray& FilePaths, CString szDestPath)
{
	BOOL bCopied = FALSE;

	BeginWaitCursor();		// display the hourglass cursor

	short i;
	for (i=0; i<FilePaths.GetSize(); i++)			 
	{
		CString szSource = FilePaths.GetAt(i);			// C:\PF\Elev\N48E0061.bin
		CString szNameExt = CInitDoc::GetFileFromPath(szSource);
		CString szDest	= szDestPath + szNameExt;

 		if (CopyFile ((LPCTSTR)szSource,	// pointer to name of an existing file 
					(LPCTSTR)szDest,	// pointer to filename to copy to 
						FALSE))				//   BOOL bFailIfExists = FALSE
		{
			bCopied = TRUE;
											// reset write protection of files copied from CD
			CFileStatus status;
			CFile::GetStatus(szDest, status );
			status.m_attribute = CFile::normal | CFile::archive;
			CFile::SetStatus(szDest, status );
		}
	}

	EndWaitCursor();		// remove the hourglass cursor

	return bCopied;
}

/************************************************************************
 *  ElevArrayDlg.cpp	  		O n I m p o r t							*
 ************************************************************************/
void CElevArrayDlg::OnImport() 
{
	CString szProfiles;	
	szProfiles.LoadString(IDS_PROFILES);

	char szFilterLine[256];
	char szFilter[16];
	wsprintf (szFilter, "*%s", (LPCTSTR)CElevArrayDoc::GetExt());
	wsprintf (szFilterLine, "%s (%s)|%s||", (LPCTSTR)szProfiles, szFilter, szFilter);
//	static char szFilterLine[] = "Profil (*.ela)|*.ela||"; 


	CFileDialog dlg(TRUE, 	  				// File Open dialog
				NULL,						// no default extension
				szFilter,					// initial filename (*.ela)
				OFN_HIDEREADONLY |	  		// dwFlags
				OFN_OVERWRITEPROMPT,
				szFilterLine,
				this);						// parent window

	BOOL bImport = FALSE;
	int ret; 
	do	
	{								// select dir with *.scm
		ret = dlg.DoModal();
		if (ret==IDOK)
		{
			CString szFile = dlg.GetFileName();
										// don't select name of own *.scm file
			CString szElaFile;
			szElaFile.LoadString(IDS_ELEV_ARRAY_FILE);	// "PFelev.ela"
			bImport = (szFile.CompareNoCase (szElaFile) != 0);
			if (!bImport)
				AfxMessageBox (IDS_SEL_NEW_ELA);
		}
	} while (ret==IDOK && !bImport);



	if (bImport)
	{
		CStringArray FilesToCopy;			// get CString array with name.ext
		CString szDestPath;
	
		CString szElaPath = ptInit->GetActualPath();	// "D:\Code\Cpp_Win\PF40\"
 		szDestPath = szElaPath  + "Elev";		// "D:\Code\Cpp_Win\PF40\Elev"

		szElaPath = dlg.GetPathName();			// source path on disk: "D:\Update\Elev\Africa\Calib.ela"
		short	nNameIndex = szElaPath.ReverseFind('\\');
		CString szSourcePath = szElaPath.Left (nNameIndex);			// "D:\Update\Elev\Africa"

		if (this->PathContains (&FilesToCopy, szSourcePath, "bin"))
		{
			CString szMsg;

			int iRet = AfxMessageBox (IDS_COPYPROFILESTOPC, MB_YESNO);
			if (iRet == IDYES)
			{									// copy *.bin to PC
				BOOL bCopyElevBinaries=FALSE;

				szMsg = this->Format (IDF_COPYPROFILESTOELEV, szDestPath);
 				int iRet = AfxMessageBox (szMsg, MB_YESNO);
				if (iRet == IDYES)
				{								// copy *.bin to C:\PF\Elev
					bCopyElevBinaries = TRUE;
				}
				else
				{			
					CDirSelectDlg dlg;

					szMsg.LoadString (IDS_SELPROFILESPATH);
					dlg.SetTitle(szMsg);
					if(dlg.DoModal())				// get destination on PC
					{
						dlg.GetDirectory(szDestPath);// C:\...
						bCopyElevBinaries = TRUE;			// or C:\dir1\dir2

						short nSlashIndex = szDestPath.GetLength()-1;
						char cSlash = szDestPath.GetAt(nSlashIndex);
						if (cSlash == '\\')			// remove "\" if available
							szDestPath = szDestPath.Left (nSlashIndex);	// C:
					}
					else
					{
						bImport = FALSE;
					}
				}

				if (bCopyElevBinaries)
					this->CopyFiles (FilesToCopy, szSourcePath, szDestPath);	// copy elev arrays
			}
			else
			{						// ela files stay on removable disk
				szDestPath = szSourcePath;
			}
		}

		if (!bImport)			// may be reset if GetDirectory-Dialog returned FALSE!
			return;


		// TODO import data here...
		if (this->UpdateData(TRUE))
		{		
			CString szActElevName;
			if (m_ActList.GetSize() > 0)
			{					// save actual elev name	
				CElevArray* ptActElevArray = (CElevArray*)m_ActList.GetAt(m_nListIndex);
				szActElevName = ptActElevArray->GetName();	// "Nord Europa"
			}
			else
			{
				m_nListIndex = -1;
			}
									// write actual array into doc
			m_ptDoc->SetDataBase (&m_ActList);  

									// add new elevs into doc
			m_ptDoc->ActivateImportMode (szDestPath);
			m_ptDoc->OnOpenDocument (szElaPath);  // read new elevArrays only!

									// read extended map array from doc into dlg
			m_ptDoc->GetDataBase (&m_ActList);

			m_bChanged = m_ptDoc->IsImported();
			if (m_bChanged)
			{
				this->FillList ();			// update dlg list
				if (szActElevName.GetLength() > 0)
					m_nListIndex = m_ptDoc->ElevNameToIndex (szActElevName);	// set previous selection

				if (m_nListIndex == -1)
				{								// there was nothing selected before
					if (m_ActList.GetSize() > 0)
						m_nListIndex = 0;			// select first entry
				}

				CListBox* ptList = (CListBox*)GetDlgItem (IDC_EALIST);    
				if (ptList != NULL)
					ptList->SetSel(m_nListIndex);

				this->UpdateData (FALSE);
				if (ptInit->IsSaveSignal())
					MessageBeep(MB_OK);	
			}
		}
	}
}

/************************************************************************
 *  ElevArrayDlg.cpp	  		G e t S e l C n t						*
 ************************************************************************/
short CElevArrayDlg::GetSelCnt()
{
	short nActSelCnt = 0;

	CListBox* ptList = (CListBox*)GetDlgItem (IDC_EALIST);    
	int nMaxSelCnt = ptList->GetCount();

	int* ptInt = new int[nMaxSelCnt];	// Allocate new memory
	nActSelCnt = (short)ptList->GetSelItems (nMaxSelCnt, (LPINT)ptInt);

	return nActSelCnt;
}

/************************************************************************
 *  ElevArrayDlg.cpp	  		O n E x p o r t							*
 ************************************************************************/
void CElevArrayDlg::OnExport() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	CDirSelectDlg dlg;

	CString szMsg;
	szMsg.LoadString (IDS_SELPROFILESPATH);
	dlg.SetTitle(szMsg);
	if(dlg.DoModal())				// get destination on PC
	{
		CString szDestPath;
		dlg.GetDirectory(szDestPath);	// "D:\Update\Elev\Afgh_Alaska"
										// ensure, path ends with backslash
		short nSlashIndex = szDestPath.GetLength()-1;
		char cSlash = szDestPath.GetAt(nSlashIndex);
		if (cSlash != '\\')			// add "\" if missing
			szDestPath += "\\";


	    CElevArrayDoc*	ptElevArrayDoc;
		ptElevArrayDoc	= new CElevArrayDoc;  

		if (ptElevArrayDoc != NULL)
		{
			BOOL bCopyElevBinaries = FALSE;

			CString szElaFile("Calib.ela");
			CString szElaFullPath (szDestPath);
			szElaFullPath += szElaFile;
			ptElevArrayDoc->SetTitle((LPCTSTR)szElaFile);
			ptElevArrayDoc->SetPathName ((LPCTSTR)szElaFullPath);	// "D:\Update\Elev\Afgh_Alaska\Calib.ela"


									
			CStringArray PathsToCopy;		// create CString array with long file names
												// for each selected list entry
			CListBox* ptList = (CListBox*)GetDlgItem (IDC_EALIST);    
			int nMaxSelCnt = ptList->GetCount();

			int* ptInt = new int[nMaxSelCnt];	// Allocate new memory
			int nActSelCnt = ptList->GetSelItems (nMaxSelCnt, (LPINT)ptInt);
			if (nActSelCnt > 0)
			{
				int i;
				for (i=0; i<nActSelCnt; i++)
				{
					int nIndex = ptInt[i];			// 0, ... N-1
					
					CElevArray* ptEntry = (CElevArray*)m_ActList.GetAt(nIndex); 
					if (ptEntry!=NULL)
					{
						CString szPath = ptEntry->GetPath();		// "D:\Orte\Elev\Afgh.bin"
						CString szFileExt = CInitDoc::GetFileFromPath(szPath);
						PathsToCopy.Add(szPath);

												// make copy from original entry
						CElevArray* ptNewEntry = new CElevArray(*ptEntry);	// get new memory
												// change path to new destination
						CString szFullDestPath(szDestPath);
						szFullDestPath += szFileExt;
						ptNewEntry->SetPath(szFullDestPath);// "D:\Update\Elev\Afgh_Alaska\Afgh.bin"

						if (ptElevArrayDoc->AddSortedElevArrayPtr(ptNewEntry))
							bCopyElevBinaries = TRUE;
					}
				} // for each selected item
			} // nActSelCnt > 0

			delete [] ptInt;

			if (bCopyElevBinaries)
			{
				this->CopyFiles (PathsToCopy, szDestPath);	// copy elev arrays

				BOOL bConfirmSave = FALSE;
				ptElevArrayDoc->OnSaveDocument(ptElevArrayDoc->GetPathName(), bConfirmSave);
			}

	        delete ptElevArrayDoc;
		} // ptElevArrayDoc != NULL
	} // DoModal
}

/************************************************************************
 *  ElevArrayDlg.cpp	  		O n C h a n g e N a m e					*
 ************************************************************************/
void CElevArrayDlg::OnChangeName() 
{
	// TODO: Wenn es sich hierbei um ein RICHEDIT-Steuerelement handelt, sendet es
	// sendet diese Benachrichtigung nur, wenn die Funktion CDlgTool::OnInitDialog()
	// berschrieben wird, um die EM_SETEVENTMASK-Nachricht an das Steuerelement
	// mit dem ENM_CHANGE-Attribut ORed in die Maske lParam zu senden.
	
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	BOOL bUsedName=FALSE;

	this->GetText (IDC_EANAME, m_szName);

	if (m_szName.GetLength())				// check if used name:
	{
		CString szUsedName;
		short i;
		for (i=0; i<m_ActList.GetSize() && !bUsedName; i++)
		{      
			CElevArray* ptEntry = (CElevArray*)m_ActList.GetAt (i);
			if (ptEntry != NULL)
			{
				szUsedName = ptEntry->GetName();
				bUsedName = (m_szName.Compare (szUsedName) == 0);
			}
		}    
	}

	BOOL bDisable = (bUsedName	|| (m_szName.GetLength() == 0));

	this->DisableControl (IDC_EAINSERT, bDisable);	
}

/************************************************************************
 *  ElevArrayDlg.cpp	  		O n H e l p I n f o						*
 ************************************************************************/
BOOL CElevArrayDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}


