#ifndef __ELEVARRAYDLG__
#define __ELEVARRAYDLG__

// ElevArrayDlg.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CElevArrayDlg 

class CElevArrayDlg : public CDlgTool
{
// Konstruktion
private:
	CElevArrayDoc*	m_ptDoc;
	CObArray		m_ActList;			// array of CElevArray 
	CElevArray		m_ActElevArray;
	BOOL			m_bInsert;        
	BOOL			m_bChanged;
 	int				m_nOldIndex;
	CString			m_szInitialSelName;		

public:
	CElevArrayDlg(CWnd* pParent = NULL, CElevArrayDoc* ptDoc=NULL);   // Standardkonstruktor
	~CElevArrayDlg();
	void ReadDataBaseFromDoc();
	BOOL WriteDataBaseIntoDoc();

// Dialogfelddaten
	//{{AFX_DATA(CElevArrayDlg)
	enum { IDD = IDD_ELEVARRAYBOX };
	int		m_nListIndex;
	CString	m_szName;
	CString	m_szPath;
	double	m_fLatMin;
	double	m_fLatMax;
	double	m_fLonMin;
	double	m_fLonMax;
	BOOL	m_bActivate;
	double	m_fGridSize;
	short	m_nColumns;
	short	m_nRows;
	short	m_nElevMissingFlag;
	short	m_nElevMax_m;
	short	m_nElevMin_m;
	BOOL	m_bSRTM;
	//}}AFX_DATA

// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CElevArrayDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

private:
	void DeleteDataBase();
	void FillList ();
	short OnNewList ();

	void Reset ();
	void SetData (CElevArray* ptElevArray);
	void GetData (CElevArray* ptElevArray);
	void RemoveListSelection();
	void PrepareButtons();
	BOOL InsertSorted (CElevArray* ptElevArray);
	BOOL PathContains (CStringArray* ptFiles, CString szPath, CString szExt);
	BOOL CopyFiles (CStringArray& Files, CString szSourcePath, CString szDestPath);
	BOOL CopyFiles(CStringArray& FilePaths, CString szDestPath);
	short GetSelCnt();


// Implementierung
protected:

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CElevArrayDlg)
	afx_msg void OnSelectFile();
	afx_msg void OnDelete();
	afx_msg void OnInsert();
	afx_msg void OnChange();
	afx_msg void OnSelchangeList();
	afx_msg void OnDblclkList();
	afx_msg void OnChangeName();
	virtual BOOL OnInitDialog();
	afx_msg void OnDone();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnImport();
	afx_msg void OnExport();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio fgt zustzliche Deklarationen unmittelbar vor der vorhergehenden Zeile ein.

#endif // __ELEVARRAYDLG__
