// ElevArrayDoc.cpp : implementation of the CElevArrayDoc class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de


#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"

#include "..\Cpptools\image.h"			// GetBmpBytesPerRow

#include "ElevArrayDoc.h"  
#include "ElevArrayDlg.h"				


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;              
extern CDimDoc* 	ptDim;      
extern BOOL			bDemo;

 
/////////////////////////////////////////////////////////////////////////////
// CElevArrayDoc

IMPLEMENT_DYNCREATE(CElevArrayDoc, CDocument)

BEGIN_MESSAGE_MAP(CElevArrayDoc, CDocument)
	//{{AFX_MSG_MAP(CElevArrayDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CElevArrayDoc construction/destruction

CElevArrayDoc::CElevArrayDoc()
{
	// TODO: add one-time construction code here  
	this->InitHeader();
	m_bConverted = FALSE;
	m_bReadOnly = FALSE;
	m_bImported = FALSE;
	m_bImport = FALSE;

	this->ResetStatusElev();

	m_ptOpenedArray = NULL;
}

CElevArrayDoc::~CElevArrayDoc()
{   
if (this->IsModified())  
	{
	CString szPath = this->GetPathName(); 
	this->OnSaveDocument (szPath);
	}

this->DeleteArrayOf (&m_Elevs);
}
   
/************************************************************************
 *  ElevArrayDoc.cpp			G e t E x t 							*
 ************************************************************************/
CString CElevArrayDoc::GetExt()
{
	CString szExt(".ela");
	return szExt;
}

/************************************************************************
 *  ElevArrayDoc.cpp		D e l e t e A r r a y O f 					*
 ************************************************************************/
void CElevArrayDoc::DeleteArrayOf (CObArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CElevArray* ptEntry;
	if ((ptEntry = (CElevArray*)ptArray->GetAt(i)) != NULL)
		{
		TRACE ("Deleting ElevArray %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}                
 
/************************************************************************
 *  ElevArrayDoc.cpp				C o p y E l e v s					*
 ************************************************************************/
void CElevArrayDoc::CopyElevs (CObArray* ptDest, CObArray* ptSource)
{
	short i;
	for (i=0; i<ptSource->GetSize(); i++) 
	{
		CElevArray*	lpDocElev = NULL;         

		lpDocElev = (CElevArray*)ptSource->GetAt (i);    
		if (lpDocElev != NULL)
		{
			CElevArray* lpCpyElev = new CElevArray;	 
			if (lpCpyElev != NULL)
			{
				TRACE ("CElevArrayDoc::CopyElevs Create %d\n", i);

				*lpCpyElev = *lpDocElev; 
				ptDest->Add (lpCpyElev);    
			}
		}
	}
}        

/************************************************************************
 *  ElevArrayDoc.cpp			R e s e t S t a t u s E l e v 			*
 ************************************************************************/
void CElevArrayDoc::ResetStatusElev ()
{
	m_bStatusElev = FALSE;
}



/************************************************************************
 *  ElevArrayDoc.cpp		A c t u a l i z e S t a t u s E l e v 		*
 ************************************************************************/
void CElevArrayDoc::ActualizeStatusElev (CLatLon& ActPos)
{
	short nElev_m;
	if (this->GetElev_m (ActPos.GetLat(), ActPos.GetLon(), &nElev_m))
	{
		short nElevDim = ptDim->Altitude();
		double fConvert = ptDim->ConvertDist (nElev_m, DIM_METER, nElevDim);
		m_nStatusElev = (short)(fConvert + 0.5);
		m_bStatusElev = TRUE;
	}
	else
	{
		this->ResetStatusElev();
	}
}

/************************************************************************
 *  ElevArrayDoc.cpp		G e t S t a t u s E l e v					*
 ************************************************************************/
BOOL CElevArrayDoc::GetStatusElev (short* ptElev)
{
	if (m_bStatusElev)
		*ptElev = m_nStatusElev;

	return m_bStatusElev;
}

/************************************************************************
 *  ElevArrayDoc.cpp		G e t D a t a B a s e 						*
 ************************************************************************/
void CElevArrayDoc::GetDataBase (CObArray* ptElevList)
{    
                              	// copy database from Doc to Dlg
this->DeleteArrayOf (ptElevList);
this->CopyElevs (ptElevList, &m_Elevs);   
}   

/************************************************************************
 *  ElevArrayDoc.cpp			S e t D a t a B a s e 					*
 ************************************************************************/
void CElevArrayDoc::SetDataBase (CObArray* ptElevList)
{     
                          		 // copy database from Dlg to Doc
this->DeleteArrayOf (&m_Elevs);
this->CopyElevs (&m_Elevs, ptElevList);   
this->SetElevCnt(m_Elevs.GetSize());
}

/************************************************************************
 *  ElevArrayDoc.cpp				G e t E l e v _ m					*
 ************************************************************************/
BOOL CElevArrayDoc::GetElev_m (double fLat, double fLon, short* ptElev)
{
	BOOL bFound = FALSE;
	for (int i=0; i<m_Elevs.GetSize() && !bFound; i++)
	{
		CElevArray* ptElevArray;
		ptElevArray = (CElevArray*)m_Elevs.GetAt(i);
		if (ptElevArray != NULL)
			bFound = ptElevArray->GetElev_m(fLat, fLon, ptElev);  
	}      

	return bFound;
}

/************************************************************************
 *  ElevArrayDoc.cpp				G e t E l e v _ m					*
 ************************************************************************/
BOOL CElevArrayDoc::GetElev_m (CLatLon& LatLon, short* ptElev)
{

	return this->GetElev_m (LatLon.GetLat(), LatLon.GetLon(), ptElev);
}



/************************************************************************
 *  ElevArrayDoc.cpp		A r r a y R e a d E l e v _ m				*
 ************************************************************************/
BOOL CElevArrayDoc::ArrayReadElev_m (double fLat, double fLon, short* ptElev)
{
	BOOL bRead = FALSE;


	for (int i=0; i<m_Elevs.GetSize() && !bRead; i++)
	{
		CElevArray* ptElevArray;
		ptElevArray = (CElevArray*)m_Elevs.GetAt(i);
		if (ptElevArray != NULL)
		{
			if (ptElevArray->HasElevFor(fLat, fLon))
			{
				if (ptElevArray != m_ptOpenedArray)
				{			// change open array
					this->ArrayClose();					
					if (ptElevArray->Open())
						m_ptOpenedArray = ptElevArray;
				}

				if (ptElevArray->ReadElev_m (fLat, fLon, ptElev))
					bRead = TRUE;
			}
		}
	}      

	return bRead;
}

/************************************************************************
 *  ElevArrayDoc.cpp		A c t i v a t e A l l						*
 *  Purpose: sets state of all ElevArrays to bActiv						*
 ************************************************************************/
void CElevArrayDoc::ActivateAll (BOOL bActiv)
{
	for (int i=0; i<m_Elevs.GetSize(); i++)
	{
		CElevArray* ptElevArray;
		ptElevArray = (CElevArray*)m_Elevs.GetAt(i);
		if (ptElevArray != NULL)
		{
			ptElevArray->SetActivated(bActiv);
		}
	}
}

/************************************************************************
 *  ScMpDoc.cpp				D e l e t e E l e v A r r a y				*
 ************************************************************************/
BOOL CElevArrayDoc::DeleteElevArray (short nIndex)
{
	BOOL bDeleted = FALSE;
	short nCnt = m_Elevs.GetSize();

	if (nIndex >= 0 && nIndex < m_Elevs.GetSize())
	{
		CElevArray* ptElevArray = (CElevArray*)m_Elevs.GetAt(nIndex);
		if (ptElevArray != NULL)
		{  
			m_Elevs.RemoveAt(nIndex);
			delete ptElevArray;
			bDeleted = (m_Elevs.GetSize() == nCnt-1);      
		}
	}
	else
	{
		AfxMessageBox ("CElevArrayDoc::DeleteElevArray Bad index!");
	}

return bDeleted;
}

/************************************************************************
 *  ElevArrayDoc.cpp		G e t E l e v A r r a y P t r				*
 *  Purpose: returns pointer to specified ElevArray						*
 ************************************************************************/
BOOL CElevArrayDoc::GetElevArrayPtr (short nIndex, CElevArray** ptptElevArray)
{
	BOOL bDone = FALSE;
	CElevArray* ptElevArray=NULL;
	ptElevArray = (CElevArray*)m_Elevs.GetAt(nIndex);
	if (ptElevArray != NULL)
	{
		*ptptElevArray = ptElevArray;
		bDone = TRUE;
	}

	return bDone;
}

/************************************************************************
 *  ElevArrayDoc.cpp	A d d S o r t e d E l e v A r r a y P t r		*
 ************************************************************************/
BOOL CElevArrayDoc::AddSortedElevArrayPtr (CElevArray* ptElevArray)
{
	BOOL bAdded = FALSE;
	int nOldCnt = m_Elevs.GetSize();
	
	short nIndex = this->GetSortedIndex (m_Elevs, ptElevArray);
	m_Elevs.InsertAt(nIndex, ptElevArray);	
	bAdded = (nOldCnt < m_Elevs.GetSize());
	this->SetElevCnt(m_Elevs.GetSize());

	return bAdded;
}

/************************************************************************
 *  ElevArrayDoc.cpp		A p p e n d E l e v A r r a y P t r			*
 ************************************************************************/
BOOL CElevArrayDoc::AppendElevArrayPtr (CElevArray* ptElevArray)
{
	BOOL bAdded = FALSE;
	int nOldCnt = m_Elevs.GetSize();

	m_Elevs.Add(ptElevArray);	
	bAdded = (nOldCnt < m_Elevs.GetSize());
	this->SetElevCnt(m_Elevs.GetSize());

	return bAdded;
}

/************************************************************************
 *  ElevArrayDoc.cpp		A r r a y O p e n							*
 *  Purpose: Opens ElevArray, specified by index						*
 ************************************************************************/
BOOL CElevArrayDoc::ArrayOpen (short nIndex)
{
	BOOL bOpened = FALSE;

	CElevArray* ptElevArray;
	ptElevArray = (CElevArray*)m_Elevs.GetAt(nIndex);
	if (ptElevArray != NULL)
	{
		if (ptElevArray->IsActivated())
		{
			if (ptElevArray != m_ptOpenedArray)
			{			// change open array
				this->ArrayClose();					
				if (ptElevArray->Open())
					m_ptOpenedArray = ptElevArray;
			}

			bOpened = TRUE;
		}
	}

	return bOpened;
}

/************************************************************************
 *  ElevArrayDoc.cpp		A r r a y O p e n							*
 *  Purpose: Opens ElevArray, containing elev for fLat/fLon and			*
 *		returns index of opened ElevArray								*
 ************************************************************************/
BOOL CElevArrayDoc::ArrayOpen (double fLat, double fLon, short* ptIndex)
{
	BOOL bFound = FALSE;

	for (int i=0; i<m_Elevs.GetSize() && !bFound; i++)
	{
		CElevArray* ptElevArray;
		ptElevArray = (CElevArray*)m_Elevs.GetAt(i);
		if (ptElevArray != NULL)
		{
			if (ptElevArray->HasElevFor(fLat, fLon))
			{
				if (ptElevArray != m_ptOpenedArray)
				{			// change open array
					this->ArrayClose();					
					if (ptElevArray->Open())
						m_ptOpenedArray = ptElevArray;
				}

				if (ptIndex != NULL)
					*ptIndex = i;
				bFound = TRUE;
			}
		}
	}      

	return bFound;
}


/************************************************************************
 *  ElevArrayDoc.cpp		A r r a y O p e n							*
 *  Purpose: Opens ElevArray, whoose vertical borders are on fLat and	* 
 *		between dLonMin and dLonMax.									*
 *		=>		dLonMin < left border of elev array < dLonMax			*
 *		or		dLonMin < right border of elev array < dLonMax			*
 *		returns index of opened ElevArray								*
 *		if there are more than on fitting ElevArrays, prefer min lat	*
 ************************************************************************/
BOOL CElevArrayDoc::ArrayOpen (double dLat, double dLonMin, double dLonMax, short* ptIndex)
{
	CElevArray* ptElevArray = NULL;
	double dMinLat = 180;
	short	nBestIndex = -1;

	for (int i=0; i<m_Elevs.GetSize(); i++)
	{
		BOOL bFound = FALSE;
		ptElevArray = (CElevArray*)m_Elevs.GetAt(i);
		if (ptElevArray != NULL)
		{
			double dLon;
			
			dLon = ptElevArray->GetLonMin();		// left border of elev array
			if (dLonMin < dLon && dLon < dLonMax)
			{											// left border is in limits
				if (ptElevArray->HasElevFor(dLat, dLon))
				{
					if (ptElevArray->GetLonMin() < dMinLat)
					{									// check right border
						dMinLat = ptElevArray->GetLonMin();
						nBestIndex = i;
						bFound = TRUE;
					}
				}
			}
			
			
			if (!bFound)
			{			// test right border:
				dLon = ptElevArray->GetLonMax();		// right border of elev array
				if (dLonMin < dLon && dLon < dLonMax)
				{										// right border is in limits
					if (ptElevArray->HasElevFor(dLat, dLon))
					{
						if (ptElevArray->GetLonMin() < dMinLat)
						{								// check right border
							dMinLat = ptElevArray->GetLonMin();
							nBestIndex = i;
						}
					}
				}
			}
		}
	}      


	if (nBestIndex > -1)
	{
		ptElevArray = (CElevArray*)m_Elevs.GetAt(nBestIndex);
		if (ptElevArray != NULL)
		{
			if (ptElevArray != m_ptOpenedArray)
			{			// change open array
				this->ArrayClose();					
				if (ptElevArray->Open())
					m_ptOpenedArray = ptElevArray;
			}

			if (ptIndex != NULL)
				*ptIndex = nBestIndex;
		}
	}

	return (m_ptOpenedArray != NULL);
}


/************************************************************************
 *  ElevArrayDoc.cpp				A r r a y C l o s e					*
 ************************************************************************/
void CElevArrayDoc::ArrayClose ()
{
	if (m_ptOpenedArray != NULL)
	{
		m_ptOpenedArray->Close();
		m_ptOpenedArray = NULL;
	}
}

/************************************************************************
 *  ElevArrayDoc.cpp		O n N e w D o c u m e n t					*
 ************************************************************************/
BOOL CElevArrayDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)     
	
   
return TRUE;
}   

/************************************************************************
 *  ElevArrayDoc.cpp		D e l e t e C o n t e n t s					*
 *  Called from: OnFileNew and OnFileOpen								*
 ************************************************************************/
void CElevArrayDoc::DeleteContents()
{		// this would avoid using m_bImport mode in Serialize!!!
	if (!m_bImport)	
	{
		this->InitHeader();
		this->DeleteArrayOf (&m_Elevs);
	}
}

/************************************************************************
 *  ElevArrayDoc.cpp		A c t i v a t e I m p o r t M o d e			*
 ************************************************************************/
void CElevArrayDoc::ActivateImportMode (CString szElevArrayPath)
{
m_szDestElevArrayPath = szElevArrayPath;
m_bImport = TRUE;
}


/************************************************************************
 *  ElevArrayDoc.cpp		O n O p e n D o c u m e n t					*
 ************************************************************************/
BOOL CElevArrayDoc::OnOpenDocument(LPCTSTR pszPathName)
{
BOOL bOpened = FALSE;

bOpened = CDocument::OnOpenDocument(pszPathName); 

if (bOpened)
	{
	if (m_bConverted)
		{
		if (this->OnSaveDocument (pszPathName, FALSE))		// don't confirm
			{
			m_bConverted = FALSE;
			if (ptInit->IsSaveSignal())
				MessageBeep(MB_OK);	
			}
		}
	}

return bOpened;
}


/************************************************************************
 *  ElevArrayDoc.cpp		O n S a v e D o c u m e n t					*
 ************************************************************************/
BOOL CElevArrayDoc::OnSaveDocument(const char* pszPathName, BOOL bConfirm)
{
BOOL bSaved = FALSE;
BOOL bDoSave;

if (bConfirm)
	{
	CString szText;
	CString szFileExt = this->GetTitle();
	szText.Format(IDF_SAVE_FILE, (LPCTSTR)szFileExt);
	bDoSave = (AfxMessageBox ((LPCSTR)szText, MB_YESNO) == IDYES);
	}
else{
	bDoSave = TRUE;
	}

if (bDoSave)
	{
	if (bDemo)
		{
		AfxMessageBox (IDS_SAVE_DISABLED);
		return bSaved;
		}
	else{
		bSaved = CDocument::OnSaveDocument(pszPathName); 
		}
	}        
else{   
    this->SetModifiedFlag (FALSE);
	}

return bSaved;
}

/************************************************************************
 *  ElevArrayDoc.cpp 		 G e t S o r t e d I n d e x 				*
 ************************************************************************/
short CElevArrayDoc::GetSortedIndex (CObArray& ElevArrays, CElevArray* ptElevArray)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;

        								// get new name to insert 
CString	szNewName = ptElevArray->GetName();

IndMin  = 0;
IndMax  = ElevArrays.GetSize();		/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

if (ElevArrays.GetSize() > 0)
   {
   do	{  
        CElevArray* lpTestMap = (CElevArray*)ElevArrays.GetAt((int)i);
        CString szTestName = lpTestMap->GetName();
        
        int iCmp = szNewName.CompareNoCase ((LPCTSTR)szTestName);

	    if (iCmp >=0)	bInsAfter = TRUE;
	    		else	bInsAfter = FALSE;

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
				
		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
   
return (short)i;
}
 


/************************************************************************
 *  ElevArrayDoc.cpp  		 		 C h a n g e 						*
 ************************************************************************/
BOOL CElevArrayDoc::Change(CWnd* ptWnd)
{  
	BOOL 	bChanged = FALSE;
	CElevArrayDlg ElevArrayDlg(ptWnd, this);

	int RetVal = ElevArrayDlg.DoModal();
	switch (RetVal)
	{
	case IDOK:
		{   
		CString szPath = this->GetPathName(); 
		if (ElevArrayDlg.WriteDataBaseIntoDoc()) 
			{             
			bChanged = this->OnSaveDocument (szPath);
 			}     
		}
 		break;
	case IDCANCEL: 
        this->SetModifiedFlag(FALSE);
		break;
	}
	return bChanged;	
} 




//     IDS_ELA_VERS            "PF ELA 1.00  "

/************************************************************************
 *  ElevArrayDoc.cpp  		 	 H e a d e r T o V e r s 				*
 ************************************************************************/
short CElevArrayDoc::HeaderToVers (char* ptHeader)
{  
short nVersion = 0;
CString szTestVers; 

szTestVers.LoadString (IDS_ELA_VERS);
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = ACT_ELEV_ARRAY_VERS;

return nVersion;
} 
     
/************************************************************************
 *  ElevArrayDoc.cpp  	 		V e r s T o H e a d e r 				*
 ************************************************************************/
void CElevArrayDoc::VersToHeader (LPSTR lpHeader, short nVersion)
{      
CString szVers;
switch (nVersion)
	{
	case ACT_ELEV_ARRAY_VERS:	
			 szVers.LoadString (IDS_ELA_VERS);	break; 
	default: szVers.Empty();	break;
    }

_fstrcpy (lpHeader, (LPCTSTR)szVers);
}      

/************************************************************************
 *  ElevArrayDoc.cpp			I n i t H e a d e r						*
 ************************************************************************/
void CElevArrayDoc::InitHeader ()
{  
CString		szVers;

szVers.LoadString (IDS_ELA_VERS);
_fstrcpy (m_Header.szVersion, (LPCTSTR)szVers);
m_Header.cFlags		= 0;
m_Header.cDummy		= 0;
m_Header.nActIndex	= -1;
m_Header.nElevCnt	= 0;  
}

/************************************************************************
 *  ElevArrayDoc.cpp		E l e v N a m e T o I n d e x				*
 ************************************************************************/
short CElevArrayDoc::ElevNameToIndex (CString szName)
{
	short nIndex = -1;
	short	i;

	BOOL bFound = FALSE;

	for (i=0; i<m_Elevs.GetSize() && !bFound; i++)
	{
		CElevArray* ptElev = (CElevArray*)m_Elevs.GetAt(i);
		if (ptElev != NULL)
		{	
			CString szTestName = ptElev->GetName();	
			bFound = (szTestName.Compare (szName) == 0);
			if (bFound)
				nIndex = i;
		}
	}
	return nIndex;
}

/************************************************************************
 *  ElevArrayDoc.cpp		E l e v P a t h T o I n d e x				*
 ************************************************************************/
short CElevArrayDoc::ElevPathToIndex (CString szPath)
{
	short nIndex = -1;
	short	i;

	BOOL bFound = FALSE;

	for (i=0; i<m_Elevs.GetSize() && !bFound; i++)
	{
		CElevArray* ptElev = (CElevArray*)m_Elevs.GetAt(i);
		if (ptElev != NULL)
		{	
			CString szTestPath = ptElev->GetPath();	
			bFound = (szTestPath.Compare (szPath) == 0);
			if (bFound)
				nIndex = i;
		}
	}
	return nIndex;
}

/************************************************************************
 *  ElevArrayDoc.cpp  		 	S e r i a l i z e 						*
 ************************************************************************/
void CElevArrayDoc::Serialize(CArchive& ar)
{    
	short i, nVersion;

	if (ar.IsStoring())
	{					// TODO: add storing code here     
		nVersion = ACT_ELEV_ARRAY_VERS;  
		VersToHeader ((LPSTR)&m_Header.szVersion, nVersion);	
		this->SetElevCnt (m_Elevs.GetSize());	// put elev cnt into header

		ar.Write (&m_Header, sizeof (ELEVARRAYHEADER));    
		
		for (i=0; i<m_Elevs.GetSize(); i++)
		{
			CElevArray* ptElev;
			ptElev = (CElevArray*)m_Elevs.GetAt(i);
			if (ptElev != NULL)
				ptElev->Serialize (ar);  
		}      
		m_bConverted = FALSE;		
	}
	else
	{				// TODO: add loading code here   
		m_bConverted = FALSE;

		ar.Read (&m_Header, sizeof (ELEVARRAYHEADER));
		nVersion = this->HeaderToVers (m_Header.szVersion);  
			
		if (nVersion < ACT_ELEV_ARRAY_VERS)
		{
			if (!m_bReadOnly)
			{
				char szText[256];
				CString szFormat;
				szFormat.LoadString (IDS_CONVERT_ELA);
				wsprintf ((LPSTR)szText, (LPCTSTR)szFormat, (LPCTSTR)this->GetTitle());
				if (AfxMessageBox ((LPCSTR)szText, MB_YESNO) == IDYES) 
				{ 
					m_bConverted = TRUE; 
				}
				else
				{ 
		    		AfxMessageBox (IDS_BAD_ELA_VERS);
		    		return;
				}
			}
		}


		short nCnt = this->GetElevCnt ();
	
		m_bImported = FALSE;
		for (i=0; i<nCnt; i++)
		{
			CElevArray* ptElev = new CElevArray; 
			if (ptElev != NULL)
			{
				ptElev->Serialize (ar, nVersion);

				if (m_bImport)	
				{
					short nIndex;

					CString szOldPath = ptElev->GetPath();	// "D:\Update\Elev\Africa\S00e007.bin"
					CString szTitle = CInitDoc::GetFileFromPath(szOldPath);
					ptElev->SetPath(m_szDestElevArrayPath + "\\" + szTitle);


					nIndex = ElevNameToIndex (ptElev->GetName());
					if (nIndex > -1)
					{			// Name of imported map already used
						DeleteElevArray (nIndex);	// delete old map entry from document list
					}

					nIndex = ElevPathToIndex (ptElev->GetPath());
					if (nIndex > -1)
					{			// full file name of imported map already used
						DeleteElevArray (nIndex);	// delete old map entry from document list
					}

					nIndex = this->GetSortedIndex (m_Elevs, ptElev);
					m_Elevs.InsertAt (nIndex, ptElev);
					m_bImported = TRUE;
				}
				else
				{
					m_Elevs.Add (ptElev);       	// add new Element     
				}
			} // ptElev != NULL
		} // for


		if (m_bImport)						// deactivate import mode
			m_bImport = FALSE;

		if (this->GetActIndex()==-1 && nCnt>0)
			this->SetActIndex(0);		// to select 1. entry in dialog list
 	}  
}



/////////////////////////////////////////////////////////////////////////////
// CElevArrayDoc diagnostics

#ifdef _DEBUG
void CElevArrayDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CElevArrayDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CElevArrayDoc commands
