#ifndef __ELEV_ARRAY_DOC__      
#define __ELEV_ARRAY_DOC__
// ElevArrayDoc.h : interface of the CElevArrayDoc class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "ElevArray.h"


typedef struct 
	{
	char szVersion[14];
	unsigned char cFlags;
	unsigned char cDummy;
	short	nActIndex;
	short	nElevCnt;
	} ELEVARRAYHEADER; 

class CLatLon;
class CElevArrayDoc : public CDocument
{         
private:
	#define MAX_HEADER_SIZE 20
    
    ELEVARRAYHEADER		m_Header;     
	CObArray		m_Elevs;             
 	BOOL			m_bConverted;
	BOOL			m_bReadOnly;
	BOOL			m_bStatusElev;
	BOOL			m_bImport;
	CString			m_szDestElevArrayPath;		// base path for imported elev arrays
	BOOL			m_bImported;
	short			m_nStatusElev;

	CElevArray*		m_ptOpenedArray;
	    
protected: // create from serialization only
	DECLARE_DYNCREATE(CElevArrayDoc)

// Attributes
public:
// Operations
public:           
	static CString GetExt();
 	void DeleteArrayOf (CObArray* ptArray);
	void CopyElevs (CObArray* ptDest, CObArray* ptSource);
	void GetDataBase (CObArray* ptElevList);
	void SetDataBase (CObArray* ptElevList);
	BOOL GetElev_m (CLatLon& LatLon, short* ptElev);
	BOOL GetElev_m (double fLat, double fLon, short* ptElev);

	BOOL DeleteElevArray (short nIndex);
	BOOL GetElevArrayPtr (short nIndex, CElevArray** ptptElevArray);
	BOOL AddSortedElevArrayPtr (CElevArray* ptElevArray);
	BOOL AppendElevArrayPtr (CElevArray* ptElevArray);
	CElevArray* GetOpenedElevArrayPtr () { return m_ptOpenedArray; }

	BOOL ArrayReadElev_m (double fLat, double fLon, short* ptElev);
	void ActivateAll (BOOL bActiv);
	BOOL ArrayOpen (short nIndex);
	BOOL ArrayOpen (double fLat, double fLon, short* ptIndex = NULL);
	BOOL ArrayOpen (double dLat, double dLonMin, double dLonMax, short* ptIndex=NULL);
	void ArrayClose ();

    BOOL WasConverted(){return m_bConverted;}     
	BOOL IsImported() { return m_bImported; }
	void ActivateImportMode (CString szElevArrayPath);

	short ElevNameToIndex (CString szName);
	short GetActIndex() { return m_Header.nActIndex; }
	short GetElevCnt () { return m_Header.nElevCnt; }

	void SetActIndex(short nIndex) { m_Header.nActIndex = nIndex; }
	void SetElevCnt (short nCnt) { m_Header.nElevCnt = nCnt; }
	void SetReadOnly (BOOL bSet) { m_bReadOnly = bSet; }
	BOOL IsReadOnly () { return m_bReadOnly; }

	void ResetStatusElev ();
	void ActualizeStatusElev (CLatLon& ActPos);
	BOOL GetStatusElev (short* ptElev);
  						  
// Implementation
public:
	CElevArrayDoc();
	virtual ~CElevArrayDoc();  
	virtual BOOL OnNewDocument();  
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = TRUE);
    
	short GetSortedIndex (CObArray& ElevArrays, CElevArray* ptElevArray);
	BOOL Change(CWnd* ptWnd);
	
	virtual void DeleteContents();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:    
	short HeaderToVers (char* ptHeader);
	void VersToHeader (LPSTR lpHeader, short nVersion);   
	void InitHeader ();
	short ElevPathToIndex (CString szPath);
	
// Generated message map functions
protected:
	//{{AFX_MSG(CElevArrayDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif