// ColTbDlg.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "resource.h"

#include "DimDoc.h"    
#include "ElevColDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CElevColorDlg 


CElevColorDlg::CElevColorDlg(CWnd* pParent, CElevColorDoc* ptDoc, int mode)
	: CDlgTool(CElevColorDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CElevColorDlg)
	m_nElevDimIndex = 0;
	m_nFinalCnt = 0;
	m_nIndex00 = 0;
	m_nIndex01 = 0;
	m_nIndex02 = 0;
	m_nIndex03 = 0;
	m_nIndex04 = 0;
	m_nIndex05 = 0;
	m_nIndex06 = 0;
	m_nIndex07 = 0;
	m_szElev00 = _T("");
	m_szElev01 = _T("");
	m_szElev02 = _T("");
	m_szElev03 = _T("");
	m_szElev04 = _T("");
	m_szElev05 = _T("");
	m_szElev06 = _T("");
	m_szElev07 = _T("");
	m_szTitle = _T("");
	//}}AFX_DATA_INIT


	m_ptDoc = ptDoc;					// get data from actual document
	m_Mode = (CElevColorDoc::Mode)mode;

	this->InitTable(COLTABLE_CNT);
}



/************************************************************************
 *  ColTbDlg.cpp	  		 I n i t T a b l e							*
 *  Purpose: Copies actual contents of document into dialog				*
 ************************************************************************/
void CElevColorDlg::InitTable(int nCnt)
{
	m_nFinalCnt = 256;

	short nElevDim = m_ptDoc->GetElevDim();
	m_nElevDimIndex = ptDim->GetPUIndex (ALTITUDE, nElevDim);

	for (int i=0; i<nCnt; i++)
	{
		short nTableIndex;
		COLORREF Color;

		Color = m_ptDoc->GetIndexColor(i, &nTableIndex);
		this->SetIndex(i, nTableIndex);
		this->SetColor(i, Color);

		CString szElev;		// set text with elev information
		if (i==0 && m_Mode == CElevColorDoc::SEA_BASED)
			szElev.LoadString(IDS_CT_SEA);
		else
			szElev = this->IndexToElevText(nTableIndex);	

		this->SetElevText(i, szElev);
	}
}


/************************************************************************
 *  ColTbDlg.cpp	  		 O n I n i t D i a l o g					*
 ************************************************************************/
BOOL CElevColorDlg::OnInitDialog() 
{                 
/*	
	// in this dlg, we use the dimension PU to define the dimension
	// for the elevations, calculated after changing the color table index
	// changing the dimension will change the VALUE of the displayed elevations!
				// value DlgID,	dim DlgID
	this->AddDimGroup (IDC_CT_ELEV_00, IDC_CT_ELEVDIM);
*/
	this->FillDimPU (IDC_CT_ELEVDIM, ALTITUDE);
	this->SetData();

	CDialog::OnInitDialog();
	
	// TODO: Zustzliche Initialisierung hier einfgen
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}


/************************************************************************
 *  ColTbDlg.cpp	  		 	S e t D a t a 							*
 ************************************************************************/
void CElevColorDlg::SetData()
{
	short nTitleID;						// get title of dialog contents	
	if (m_Mode == CElevColorDoc::SEA_BASED)
		 nTitleID = IDS_CT_TITLE_SEA;
	else nTitleID = IDS_CT_TITLE_FLIGHT;
	m_szTitle.LoadString(nTitleID);


	int nCnt = m_ptDoc->GetCnt();		// data available in document 
	if (nCnt > 0)
	{
		m_nFinalCnt = m_ptDoc->GetFinalCnt();

		for (int i=0; i<COLTABLE_CNT; i++)
		{
			short nTableIndex;
			COLORREF Color;

			Color = m_ptDoc->GetIndexColor(i, &nTableIndex);

			this->SetIndex(i, nTableIndex);

			CString szElev;		// set text with elev information
			if (i==0 && m_Mode == CElevColorDoc::SEA_BASED)
				szElev.LoadString (IDS_CT_SEA);
			else
				szElev = this->IndexToElevText(nTableIndex);	

			this->SetElevText(i, szElev);
			this->SetColor(i, Color);
		}
	}
}


/************************************************************************
 *  ColTbDlg.cpp	  		 D o D a t a E x c h a n g e				*
 ************************************************************************/
void CElevColorDlg::DoDataExchange(CDataExchange* pDX)
{
	this->ActivateDimGroups();

	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CElevColorDlg)
	DDX_CBIndex(pDX, IDC_CT_ELEVDIM, m_nElevDimIndex);
	DDX_Text(pDX, IDC_CT_IND_00, m_nIndex00);
	DDV_MinMaxInt(pDX, m_nIndex00, 0, 255);
	DDX_Text(pDX, IDC_CT_IND_01, m_nIndex01);
	DDV_MinMaxInt(pDX, m_nIndex01, 0, 255);
	DDX_Text(pDX, IDC_CT_IND_02, m_nIndex02);
	DDV_MinMaxInt(pDX, m_nIndex02, 0, 255);
	DDX_Text(pDX, IDC_CT_IND_03, m_nIndex03);
	DDV_MinMaxInt(pDX, m_nIndex03, 0, 255);
	DDX_Text(pDX, IDC_CT_IND_04, m_nIndex04);
	DDV_MinMaxInt(pDX, m_nIndex04, 0, 255);
	DDX_Text(pDX, IDC_CT_IND_05, m_nIndex05);
	DDV_MinMaxInt(pDX, m_nIndex05, 0, 255);
	DDX_Text(pDX, IDC_CT_IND_06, m_nIndex06);
	DDV_MinMaxInt(pDX, m_nIndex06, 0, 255);
	DDX_Text(pDX, IDC_CT_IND_07, m_nIndex07);
	DDV_MinMaxInt(pDX, m_nIndex07, 0, 255);
	DDX_Text(pDX, IDC_CT_ELEV_00, m_szElev00);
	DDX_Text(pDX, IDC_CT_ELEV_01, m_szElev01);
	DDX_Text(pDX, IDC_CT_ELEV_02, m_szElev02);
	DDX_Text(pDX, IDC_CT_ELEV_03, m_szElev03);
	DDX_Text(pDX, IDC_CT_ELEV_04, m_szElev04);
	DDX_Text(pDX, IDC_CT_ELEV_05, m_szElev05);
	DDX_Text(pDX, IDC_CT_ELEV_06, m_szElev06);
	DDX_Text(pDX, IDC_CT_ELEV_07, m_szElev07);
	DDX_Text(pDX, IDC_CT_TITLE, m_szTitle);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CElevColorDlg, CDialog)
	//{{AFX_MSG_MAP(CElevColorDlg)
	ON_BN_CLICKED(IDC_CT_CHANGE_00, OnChangeColor00)
	ON_BN_CLICKED(IDC_CT_CHANGE_01, OnChangeColor01)
	ON_BN_CLICKED(IDC_CT_CHANGE_02, OnChangeColor02)
	ON_BN_CLICKED(IDC_CT_CHANGE_03, OnChangeColor03)
	ON_BN_CLICKED(IDC_CT_CHANGE_04, OnChangeColor04)
	ON_BN_CLICKED(IDC_CT_CHANGE_05, OnChangeColor05)
	ON_BN_CLICKED(IDC_CT_CHANGE_06, OnChangeColor06)
	ON_BN_CLICKED(IDC_CT_CHANGE_07, OnChangeColor07)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_CT_RESET, OnColorsReset)
	ON_EN_CHANGE(IDC_CT_IND_00, OnChangeInd00)
	ON_EN_CHANGE(IDC_CT_IND_01, OnChangeInd01)
	ON_EN_CHANGE(IDC_CT_IND_02, OnChangeInd02)
	ON_EN_CHANGE(IDC_CT_IND_03, OnChangeInd03)
	ON_EN_CHANGE(IDC_CT_IND_04, OnChangeInd04)
	ON_EN_CHANGE(IDC_CT_IND_05, OnChangeInd05)
	ON_EN_CHANGE(IDC_CT_IND_06, OnChangeInd06)
	ON_EN_CHANGE(IDC_CT_IND_07, OnChangeInd07)
	ON_CBN_SELCHANGE(IDC_CT_ELEVDIM, OnSelchangeElevDim)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/************************************************************************
 *  ColTbDlg.cpp	  		 	D r a w R e c t							*
 ************************************************************************/
void CElevColorDlg::DrawRect (UINT uID, COLORREF Col)
{
	CBrush* ptBrush = new	CBrush (Col);

	CWnd* ptWnd = this->GetDlgItem (uID);
	CDC* pDC = ptWnd->GetDC();	
	CRect rClient;
	ptWnd->GetClientRect(&rClient);

	CBrush* ptOldBrush = (CBrush*)pDC->SelectObject (ptBrush);
	pDC->Rectangle (rClient);
	pDC->SelectObject (ptOldBrush);
	ptWnd->ReleaseDC(pDC);

	delete ptBrush;	 	
}



/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CElevColorDlg 

/************************************************************************
 *  ColTbDlg.cpp	  		I n d e x T o E l e v T e x t				*
 ************************************************************************/
CString CElevColorDlg::IndexToElevText (int nIndex)
{
	CString szElev;

	int nElev_m = m_ptDoc->IndexToMeterElev(nIndex);

	if (m_Mode == CElevColorDoc::FLIGHT_BASED)
		nElev_m -= m_ptDoc->GetBaseAlt_m();		// show table for flight alt 4000m

	short nElevDim = ptDim->GetPUDim (ALTITUDE, m_nElevDimIndex);    

	int nElev = (int)ptDim->ConvertDist(nElev_m, DIM_METER, nElevDim);

							// set text with elev information
	if (m_Mode == CElevColorDoc::SEA_BASED)
	{
		szElev.Format("%d", nElev);
	}
	else					
	{				// FLIGHT_BASED
		short nStringID = (nElev < 0)? IDF_CT_FLIGHTALT : IDF_CT_FLIGHTALT_PL;

		if (nElev < 0)
			szElev.Format(nStringID, nElev);
		else
			szElev.Format(nStringID, nElev);
	}

	return szElev;
}


/************************************************************************
 *  ColTbDlg.cpp	  		O n C h a n g e I n d e x					*
 ************************************************************************/
void CElevColorDlg::OnChangeIndex (UINT uIndexID, UINT uElevID)
{
	CWnd* ptWnd = this->GetDlgItem (uIndexID);	

	char szIndex[INDEX_LEN];
	if (ptWnd->GetWindowText(szIndex, INDEX_LEN) > 0)
    {							// get text with index
		short nIndex = atoi(szIndex);
		CString szElev = this->IndexToElevText(nIndex);
		ptWnd = this->GetDlgItem (uElevID);	
		ptWnd->SetWindowText((LPCTSTR)szElev);
	}
}


void CElevColorDlg::OnChangeInd00() 
{
	if (m_Mode == CElevColorDoc::SEA_BASED)
	{					// set text with elev information
		CString szElev;
		szElev.LoadString (IDS_CT_SEA);
		CWnd* ptWnd = this->GetDlgItem (IDC_CT_ELEV_00);	
		ptWnd->SetWindowText((LPCTSTR)szElev);
	}
	else
	{
		this->OnChangeIndex(IDC_CT_IND_00, IDC_CT_ELEV_00);	
	}
}

void CElevColorDlg::OnChangeInd01() 
{
	this->OnChangeIndex(IDC_CT_IND_01, IDC_CT_ELEV_01);		
}

void CElevColorDlg::OnChangeInd02() 
{
	this->OnChangeIndex(IDC_CT_IND_02, IDC_CT_ELEV_02);		
}

void CElevColorDlg::OnChangeInd03() 
{
	this->OnChangeIndex(IDC_CT_IND_03, IDC_CT_ELEV_03);	
}

void CElevColorDlg::OnChangeInd04() 
{
	this->OnChangeIndex(IDC_CT_IND_04, IDC_CT_ELEV_04);		
}

void CElevColorDlg::OnChangeInd05() 
{
	this->OnChangeIndex(IDC_CT_IND_05, IDC_CT_ELEV_05);		
}

void CElevColorDlg::OnChangeInd06() 
{
	this->OnChangeIndex(IDC_CT_IND_06, IDC_CT_ELEV_06);		
}

void CElevColorDlg::OnChangeInd07() 
{
	this->OnChangeIndex(IDC_CT_IND_07, IDC_CT_ELEV_07);	
}


/************************************************************************
 *  ColTbDlg.cpp	  		O n S e l c h a n g e E l e v D i m 		*
 ************************************************************************/
void CElevColorDlg::OnSelchangeElevDim() 
{
	if (this->UpdateData(TRUE))
	{
		this->SetData();	// use new dimension to show new elevations!
		this->UpdateData(FALSE);
	}
}

/************************************************************************
 *  ColTbDlg.cpp	  		C h a n g e C o l o r D l g					*
 ************************************************************************/
void CElevColorDlg::ChangeColorDlg (UINT uFrameID, COLORREF* ptCol)
{
DWORD dwFlags = 0;
CColorDialog ColDlg (*ptCol, dwFlags, this);

int ret = ColDlg.DoModal();
if (ret == IDOK)
	{
	*ptCol = ColDlg.GetColor(); 
		// to force color update after closing ColDlg
	this->DrawRect (uFrameID, *ptCol);	
	}
}

void CElevColorDlg::OnChangeColor00() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->ChangeColorDlg(IDC_CT_COL_00, &m_Color00);	
}

void CElevColorDlg::OnChangeColor01() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->ChangeColorDlg(IDC_CT_COL_01, &m_Color01);		
}

void CElevColorDlg::OnChangeColor02() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->ChangeColorDlg(IDC_CT_COL_02, &m_Color02);		
}

void CElevColorDlg::OnChangeColor03() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->ChangeColorDlg(IDC_CT_COL_03, &m_Color03);		
}

void CElevColorDlg::OnChangeColor04() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->ChangeColorDlg(IDC_CT_COL_04, &m_Color04);	
}

void CElevColorDlg::OnChangeColor05() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->ChangeColorDlg(IDC_CT_COL_05, &m_Color05);	
}

void CElevColorDlg::OnChangeColor06() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->ChangeColorDlg(IDC_CT_COL_06, &m_Color06);	
}

void CElevColorDlg::OnChangeColor07() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->ChangeColorDlg(IDC_CT_COL_07, &m_Color07);	
}


void CElevColorDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen
	this->DrawRect (IDC_CT_COL_00,	m_Color00);	
	this->DrawRect (IDC_CT_COL_01,	m_Color01);	
	this->DrawRect (IDC_CT_COL_02,	m_Color02);	
	this->DrawRect (IDC_CT_COL_03,	m_Color03);	
	this->DrawRect (IDC_CT_COL_04,	m_Color04);	
	this->DrawRect (IDC_CT_COL_05,	m_Color05);	
	this->DrawRect (IDC_CT_COL_06,	m_Color06);	
	this->DrawRect (IDC_CT_COL_07,	m_Color07);	

	// Kein Aufruf von CDialog::OnPaint() fr Zeichnungsnachrichten
}

void CElevColorDlg::SetIndex (int i, int nIndex)
{
	switch (i)
	{
		case 0:		m_nIndex00 = nIndex; break;
		case 1:		m_nIndex01 = nIndex; break;
		case 2:		m_nIndex02 = nIndex; break;
		case 3:		m_nIndex03 = nIndex; break;
		case 4:		m_nIndex04 = nIndex; break;
		case 5:		m_nIndex05 = nIndex; break;
		case 6:		m_nIndex06 = nIndex; break;
		case 7:		m_nIndex07 = nIndex; break;
	}
}

int CElevColorDlg::GetIndex (int i)
{
	int nIndex;

	switch (i)
	{
		case 0:		nIndex = m_nIndex00; break;
		case 1:		nIndex = m_nIndex01; break;
		case 2:		nIndex = m_nIndex02; break;
		case 3:		nIndex = m_nIndex03; break;
		case 4:		nIndex = m_nIndex04; break;
		case 5:		nIndex = m_nIndex05; break;
		case 6:		nIndex = m_nIndex06; break;
		case 7:		nIndex = m_nIndex07; break;
	}
	return nIndex;
}

void CElevColorDlg::SetColor (int i, COLORREF Color)
{
	switch (i)
	{
		case 0:		m_Color00 = Color; break;
		case 1:		m_Color01 = Color; break;
		case 2:		m_Color02 = Color; break;
		case 3:		m_Color03 = Color; break;
		case 4:		m_Color04 = Color; break;
		case 5:		m_Color05 = Color; break;
		case 6:		m_Color06 = Color; break;
		case 7:		m_Color07 = Color; break;
	}
}

COLORREF CElevColorDlg::GetColor (int i)
{
	COLORREF Color;

	switch (i)
	{
		case 0:		Color = m_Color00; break;
		case 1:		Color = m_Color01; break;
		case 2:		Color = m_Color02; break;
		case 3:		Color = m_Color03; break;
		case 4:		Color = m_Color04; break;
		case 5:		Color = m_Color05; break;
		case 6:		Color = m_Color06; break;
		case 7:		Color = m_Color07; break;
	}

	return Color;
}

void CElevColorDlg::SetElevText (int i, CString szElev)
{
	switch (i)
	{
		case 0:		m_szElev00 = szElev; break;
		case 1:		m_szElev01 = szElev; break;
		case 2:		m_szElev02 = szElev; break;
		case 3:		m_szElev03 = szElev; break;
		case 4:		m_szElev04 = szElev; break;
		case 5:		m_szElev05 = szElev; break;
		case 6:		m_szElev06 = szElev; break;
		case 7:		m_szElev07 = szElev; break;
	}
}

void CElevColorDlg::OnColorsReset() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen

	m_nElevDimIndex = ptDim->GetPUIndex (ALTITUDE, DIM_FEET);

	m_ptDoc->Reset();						// resets content of document
	this->InitTable(COLTABLE_CNT);			// copies content of document into members of dlg

	this->UpdateData(FALSE);				// updates members of dlg

	this->DrawRect (IDC_CT_COL_00,	m_Color00);	
	this->DrawRect (IDC_CT_COL_01,	m_Color01);	
	this->DrawRect (IDC_CT_COL_02,	m_Color02);	
	this->DrawRect (IDC_CT_COL_03,	m_Color03);	
	this->DrawRect (IDC_CT_COL_04,	m_Color04);	
	this->DrawRect (IDC_CT_COL_05,	m_Color05);	
	this->DrawRect (IDC_CT_COL_06,	m_Color06);	
	this->DrawRect (IDC_CT_COL_07,	m_Color07);	
}

void CElevColorDlg::OnOK() 
{
	// TODO: Zustzliche Prfung hier einfgen
	
	if (this->UpdateData (TRUE))
	{
		m_ptDoc->DeleteContents();

		m_ptDoc->SetFinalCnt(m_nFinalCnt);
		short nElevDim = ptDim->GetPUDim (ALTITUDE, m_nElevDimIndex);

		BOOL bIndexOK = TRUE;
		int nMinLegalIndex = 0;
		for (int i=0; i<COLTABLE_CNT && bIndexOK; i++)
		{
			int nTableIndex = this->GetIndex(i);
			if (nTableIndex >= nMinLegalIndex)
			{
				nMinLegalIndex = nTableIndex;
			}
			else
			{
				CString szMsg;
				szMsg.Format(IDF_CT_BAD_COLNUM, i+1, nTableIndex, GetIndex (i-1));
				AfxMessageBox (szMsg);
				bIndexOK = FALSE;
				short nCtrlIndex = IDC_CT_IND_00 + i * 4;
				this->SelectItem(nCtrlIndex);
			}
		}

		if (bIndexOK)
		{
			for (int i=0; i<COLTABLE_CNT; i++)
			{
				int nTableIndex = this->GetIndex(i);
				COLORREF Color  = this->GetColor(i);
				m_ptDoc->AppendColor(nTableIndex, Color);
			}

			m_ptDoc->SetElevDim(nElevDim);
			
			CDialog::OnOK();
		}
	}
	else
	{					
		CDialog::OnCancel();
	}
}

/************************************************************************
 *  ElevColDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CElevColorDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}




