// ElevColDoc.cpp : implementation of the CElevColorDoc class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "resource.h"

#include "DimDoc.h"    
#include "ElevColDlg.h"
#include "ElevColDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL bDemo;
extern CDimDoc*		ptDim;
 
/////////////////////////////////////////////////////////////////////////////
// CElevColorDoc

IMPLEMENT_DYNCREATE(CElevColorDoc, CDocument)

BEGIN_MESSAGE_MAP(CElevColorDoc, CDocument)
	//{{AFX_MSG_MAP(CElevColorDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CElevColorDoc construction/destruction

CElevColorDoc::CElevColorDoc(Mode mode)
	: CColorTableDoc(COLTABLE_CNT)
{
	// TODO: add one-time construction code here  
	m_nElevDim = DIM_FEET;
	m_Mode = mode;
	m_bContrast = TRUE;

	m_nBaseAlt_m = 4000;
	this->InitTable(COLTABLE_CNT);
}



CElevColorDoc::~CElevColorDoc()
{   
}


/************************************************************************
 *  ColTbDlg.cpp	  		 I n i t I n d e x							*
 ************************************************************************/
int CElevColorDoc::InitIndex(int i)
{
	int nIndex=0;

	if (m_Mode == CElevColorDoc::SEA_BASED)
	{
		if (m_bContrast)
		{
			switch (i)
			{
			case 0:		nIndex = 0;		break;
			case 1:		nIndex = 1;		break;
			case 2:		nIndex = 5;		break;
			case 3:		nIndex = 15;	break;
			case 4:		nIndex = 30;	break;
			case 5:		nIndex = 98;	break;
			case 6:		nIndex = 254;	break;
			case 7:		nIndex = 255;	break;
			}
		}
		else
		{
			switch (i)
			{
			case 0:		nIndex = 0;		break;
			case 1:		nIndex = 1;		break;
			case 2:		nIndex = 10;	break;
			case 3:		nIndex = 24;	break;
			case 4:		nIndex = 64;	break;
			case 5:		nIndex = 128;	break;
			case 6:		nIndex = 254;	break;
			case 7:		nIndex = 255;	break;
			}
		}
	}
	else
	{					// FLIGHT_BASED
		switch (i)
		{
		case 0:		nIndex = 0;		break;
		case 1:		nIndex = 121;	break;
		case 2:		nIndex = 124;	break;
		case 3:		nIndex = 126;	break;
		case 4:		nIndex = 128;	break;
		case 5:		nIndex = 160;	break;
		case 6:		nIndex = 192;	break;
		case 7:		nIndex = 224;	break;
		}		
	}

	return nIndex;
}

/************************************************************************
 *  ColTbDlg.cpp	  		 I n i t C o l o r							*
 ************************************************************************/
COLORREF CElevColorDoc::InitColor(int i)
{
	COLORREF color = RGB(255, 255, 255);

	if (m_Mode == CElevColorDoc::SEA_BASED)
	{
		if (m_bContrast)
		{
			switch (i)
			{
			case 0:		color = RGB(  0, 255, 255); break;
			case 1:		color = RGB(255, 255, 155); break;
			case 2:		color = RGB(210, 210,  40); break;
			case 3:		color = RGB(  0, 128,   0); break;
			case 4:		color = RGB(250, 140, 140); break;
			case 5:		color = RGB(170,  55,   0); break;
			case 6:		color = RGB( 94,  47,   0); break;
			case 7:		color = RGB(255, 255, 255); break;
			}
		}
		else
		{
			switch (i)
			{
			case 0:		color = RGB(  0, 255, 255); break;
			case 1:		color = RGB(255, 255, 155); break;
			case 2:		color = RGB(128, 255, 128); break;
			case 3:		color = RGB(  0, 206,   0); break;
			case 4:		color = RGB(255, 128,  64); break;
			case 5:		color = RGB(204,  66,   0); break;
			case 6:		color = RGB( 94,  47,   0); break;
			case 7:		color = RGB(255, 255, 255); break;
			}
		}
	}
	else
	{					// FLIGHT_BASED
		switch (i)
		{
		case 0:		color = RGB(  0, 255,  64); break;
		case 1:		color = RGB(204, 254, 129); break;
		case 2:		color = RGB(255, 255,   0); break;
		case 3:		color = RGB(254, 121,   1); break;
		case 4:		color = RGB(255,   0,   0); break;
		case 5:		color = RGB(255,   0, 128); break;
		case 6:		color = RGB(128,  64,   0); break;
		case 7:		color = RGB( 31,  31,  31); break;
		}		
	}

	return color;
}
   

/************************************************************************
 *  ColTbDlg.cpp	  		 I n i t T a b l e							*
 ************************************************************************/
void CElevColorDoc::InitTable(int nCnt)
{
	this->DeleteContents();
	for (int i=0; i<nCnt; i++)
	{
		short nIndex = this->InitIndex(i);
		COLORREF color = this->InitColor(i);
		this->AppendColor (nIndex, color);
	}
}

/************************************************************************
 *  ElevColDoc.cpp  		 		C h a n g e							*
 ************************************************************************/
void CElevColorDoc::Reset()
{
	this->InitTable(COLTABLE_CNT);
}

/************************************************************************
 *  ElevColDoc.cpp  		 		C h a n g e							*
 ************************************************************************/
BOOL CElevColorDoc::Change(CWnd* ptWnd)
{  
	BOOL 	bChanged = FALSE;
	CElevColorDlg CElevColorDlg(ptWnd, this, m_Mode);

	int RetVal = CElevColorDlg.DoModal();
	switch (RetVal)
	{
	case IDOK:
		{   
		CString szPath = this->GetPathName(); 
	//	if (CElevColorDlg.WriteDataBaseIntoDoc()) 
			{             
			this->OnSaveDocument (szPath);
			bChanged = TRUE;
 			}     
		}
 		break;
	case IDCANCEL: 
        this->SetModifiedFlag(FALSE);
		break;
	}
	return bChanged;	
} 


/************************************************************************
 *  ElevColDoc.cpp  		M e t e r E l e v T o I n d e x				*
 *  Purpose: converts elevation [meter] into color table index			*
 *	used in: CElevColorDoc::CreateRGBQuads								*
 ************************************************************************/
int CElevColorDoc::MeterElevToIndex (long nElev_m)
{
	int nIndex=0;
	
	if (m_Mode == SEA_BASED)
	{
		if (nElev_m < 0)
			nElev_m = 0;
		nIndex = 254 * nElev_m / 8000 + 1;
		if (nIndex > 255) nIndex = 255;
	}
	else
	{
		nIndex = 256 * nElev_m / 8000;
		if (nIndex < 0) nIndex = 0;
		if (nIndex > 255) nIndex = 255;	
	}

	return nIndex;
}

/************************************************************************
 *  ElevColDoc.cpp  		I n d e x T o M e t e r E l e v 			*
 *	Purpose: converts color table index into elevation in meter			*
 *	used in: CElevColorDlg::IndexToElevText								*
 ************************************************************************/
int CElevColorDoc::IndexToMeterElev (int nIndex)
{
	int nElev_m;
	
	if (m_Mode == SEA_BASED)
	{							// for nIndex from 1 ... 255
		nElev_m = 8000 * (nIndex - 1) / 254;
	}
	else
	{							// for nIndex from 0 ... 255
		nElev_m = 8000 * nIndex/256;
	}

	return nElev_m;
}

/************************************************************************
 *  ColTbDoc.cpp			C r e a t e R G B Q u a d s					*
 *  Purpose: creates memory for RGBQUAD array and returns pointer to it	*
 *			if lElev != m_nBaseAlt_m, color table will be shifted		*
 *			returns number of entries in ptCnt							*
 ************************************************************************/
RGBQUAD* CElevColorDoc::CreateRGBQuads(short* ptCnt, long lElev_m)
{
	RGBQUAD* ptQuads = NULL;

								// get standard colortable
	ptQuads = CColorTableDoc::CreateRGBQuads(ptCnt);// 0,1,2,3,..., 254,255

	if (m_Mode == FLIGHT_BASED)
	{
													// lElev_m		= 3000
		int nIndex = MeterElevToIndex (lElev_m);	// nIndex		= 96
		int nBaseIndex = MeterElevToIndex (m_nBaseAlt_m);	// 128
		int nIndexDiff = nBaseIndex - nIndex;				// nIndexDiff	= 32
		int i;
    
		if (nIndexDiff > 0)							// 32,33, ... 255,255,255
		{
			int j=0;
			for (i=nIndexDiff; i<256; i++)		// shift beginn of color table up
				*(ptQuads + j++) = *(ptQuads + i);	// 32,33,34,...,255,-,-,-
			for (i=j; i<256; i++)					// fill last entries with max value
				*(ptQuads + i) = *(ptQuads + 255);	// 32,33,34,...,255,255,255,255

		}
		else										// 0,0,0, ... 223,224
		{
			int j=255;
			for (i=255+nIndexDiff; i>=0; i--)	// shift end of color table down
				*(ptQuads + j--) = *(ptQuads + i);	// -,-,-,0,1,2,...,224
			for (i=j; i>=0; i--)
				*(ptQuads + i) = *(ptQuads + 0);	// 0,0,0,0,1,2,...,224

		}
	} // FLIGHT_BASED


	return ptQuads;
}

/************************************************************************
 *  ElevColDoc.cpp  			S e r i a l i z e 						*
 ************************************************************************/
void CElevColorDoc::Serialize(CArchive& ar)
{    
	if (ar.IsStoring())
	{					// TODO: add storing code here  
		ar << m_nElevDim;
		CColorTableDoc::Serialize(ar);
	}
	else
	{				// TODO: add loading code here   
		ar >> m_nElevDim;
		CColorTableDoc::Serialize(ar);
	}
}
