#ifndef __ELEV_COL_DOC__      
#define __ELEV_COL_DOC__

#include "ColTbDoc.h"

// ColTbDoc.h : interface of the CElevColorDoc class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

// Color Table storing elevaltion dimension

class CElevColorDoc : public CColorTableDoc
{         
		    
protected: // create from serialization only
	DECLARE_DYNCREATE(CElevColorDoc)

// Attributes
public:
	enum Mode { SEA_BASED = 1, 
				FLIGHT_BASED = 2
				};
	#define COLTABLE_CNT 8

private:
	short		m_nElevDim;			// dimension selected in dialog
	Mode		m_Mode;
	BOOL		m_bContrast;		// generate image with high or low contrast
	int			m_nBaseAlt_m;		// std. flight altitude in meter (4000)

// Operations
public:           
	void Reset();
	void SetElevDim (short nDim) { m_nElevDim = nDim; }
	short GetElevDim () { return m_nElevDim; }
	long GetBaseAlt_m() { return (long)m_nBaseAlt_m; }

	int MeterElevToIndex (long lElev_m);
	int IndexToMeterElev (int nIndex);

	RGBQUAD* CreateRGBQuads(short* ptCnt, long lElev_m);

	BOOL Change(CWnd* ptWnd);

private:
	int InitIndex(int i);
	COLORREF InitColor(int i);
	void InitTable(int nCnt);

  						  
// Implementation
public:
	CElevColorDoc(Mode mode=SEA_BASED);
	virtual ~CElevColorDoc();  
	
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
	
// Generated message map functions
protected:
	//{{AFX_MSG(CElevColorDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif