// ElevDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"  

#include "InitDoc.h"
#include "DimDoc.h"    
 
#include "ElevDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*		ptDim;
extern CInitDoc* 	ptInit;  

/////////////////////////////////////////////////////////////////////////////
// CElevDlg dialog


CElevDlg::CElevDlg(CWnd* pParent, CElevDoc* ptDoc)
	: CDlgTool(CElevDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CElevDlg)
	m_nListIndex = -1;
	m_dLatTL = 0;
	m_dLonTL = 0;
	m_nSouth_min = 30;
	m_nEast_min = 30;
	m_lElevation = 0;
	m_nElevDim = 0;
	//}}AFX_DATA_INIT
	
m_ptDoc = ptDoc;
m_bChanged = FALSE;           
m_bInsert = FALSE;

this->ReadDataBaseFromDoc ();
}

CElevDlg::~CElevDlg()
{
this->DeleteDataBase();
}

/************************************************************************
 *  ElevDlg.cpp	  			D e l e t e D a t a B a s e					*
 ************************************************************************/
void CElevDlg::DeleteDataBase()
{  
m_ptDoc->DeleteArrayOf (&m_ActList);
}

/************************************************************************
 *  ElevDlg.cpp	  		R e a d D a t a B a s e	F r o m D o c			*
 ************************************************************************/
void CElevDlg::ReadDataBaseFromDoc()
{                   					// copy database from Doc to Dlg
m_ptDoc->GetDataBase (&m_ActList);
m_bChanged = FALSE;
m_ptDoc->SetModifiedFlag(FALSE);
}

/************************************************************************
 *  ElevDlg.cpp	  	W r i t e D a t a B a s e I n t o D o c				*
 ************************************************************************/
BOOL CElevDlg::WriteDataBaseIntoDoc()
{ 				
BOOL	bWritten = FALSE;				  
if (m_bChanged || m_ptDoc->WasConverted())
	{                                   // copy database from Dlg to Doc
	m_ptDoc->SetDataBase (&m_ActList);  
	m_ptDoc->SetModifiedFlag(TRUE);  
	bWritten = TRUE;
	}               
return bWritten;
}



/************************************************************************
 *  ElevDlg.cpp	  		 		S e t D a t a  							*
 ************************************************************************/
void CElevDlg::SetData (CElev& Elev)
{  
m_nElevDim = ptDim->GetPUIndex (ALTITUDE, Elev.GetElevDim());

//ptDim->GetDimCstring (&m_szElevDim, ptDim->GetPUDim (ALTITUDE, m_nElevDim));

CLatLon PosTL = Elev.GetPosTL ();
m_dLatTL = PosTL.GetLat();
m_dLonTL = PosTL.GetLon();

m_nSouth_min = Elev.GetSouthMinutes();
m_nEast_min = Elev.GetEastMinutes();

m_lElevation = Elev.GetMaxElev();
}	

/************************************************************************
 *  ElevDlg.cpp	  		 		G e t D a t a  							*
 ************************************************************************/
BOOL CElevDlg::GetData (CElev* ptElev)
{ 
	BOOL bOK = TRUE;

	ptElev->SetElevDim(ptDim->GetPUDim (ALTITUDE, m_nElevDim));

	CLatLon PosTL (m_dLatTL, m_dLonTL);
	ptElev->SetPosTL (PosTL);

	ptElev->SetSouthMinutes(m_nSouth_min);
	ptElev->SetEastMinutes(m_nEast_min);

	ptElev->SetMaxElev (m_lElevation);

return bOK;
}	

/************************************************************************
 *  ElevDlg.cpp	  		 F i l l E l e v L i s t 						*
 ************************************************************************/
void CElevDlg::FillElevList (CPtrArray* ptElevs)
{
CListBox* ptList = (CListBox*)GetDlgItem (IDC_ELLIST);    
ptList->ResetContent();

CString szText;
short i;
for (i=0; i<ptElevs->GetSize(); i++)
	{      
	CElev Elev((LPELEV)ptElevs->GetAt(i));
	szText = Elev.GetListEntry();
	ptList->AddString((LPCTSTR)szText);  
	}              
}                             

/************************************************************************
 *  ElevDlg.cpp	  				O n N e w L i s t		 				*
 ************************************************************************/
short CElevDlg::OnNewList (CPtrArray* ptElevs)
{
this->FillElevList(ptElevs);   

BOOL bData = (ptElevs->GetSize() > 0);
short nListIndex = bData? m_ptDoc->GetActIndex () : -1;     

this->DisableControl (IDC_ELCHANGE, !bData);  
this->DisableControl (IDC_ELDEL, !bData);  
return nListIndex;
}

/************************************************************************
 *  ElevDlg.cpp	  			 D o D a t a E x c h a n g e 				*
 ************************************************************************/
void CElevDlg::DoDataExchange(CDataExchange* pDX)
{   
this->ActivateDimGroups();

if (pDX->m_bSaveAndValidate)
		{  
		m_nOldIndex 	= m_nListIndex;	  
		}
    else{   
	 	LPELEV lpLoadElev = NULL;
		if (m_nListIndex >= 0 && m_nListIndex<m_ActList.GetSize())	
			lpLoadElev = (LPELEV)m_ActList.GetAt(m_nListIndex);   
	
		if (lpLoadElev != NULL)
			{
			CElev Elev(lpLoadElev); 
			this->SetData (Elev);    
	        }
		else{
			CElev Dummy;
			this->SetData (Dummy);
			}
    	}
    	
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CElevDlg)
	DDX_LBIndex(pDX, IDC_ELLIST, m_nListIndex);
	DDX_Latitude(pDX, IDC_ELLATTL, m_dLatTL);
	DDV_Angle(pDX, m_dLatTL, -90., 90.);
	DDX_Longitude(pDX, IDC_ELLONTL, m_dLonTL);
	DDV_Angle(pDX, m_dLonTL, -180., 180.);
	DDX_Text(pDX, IDC_ELEAST, m_nEast_min);
	DDV_MinMaxInt(pDX, m_nEast_min, -240, 240);
	DDX_Text(pDX, IDC_ELSOUTH, m_nSouth_min);
	DDV_MinMaxInt(pDX, m_nSouth_min, -240, 240);
	DDX_Alt(pDX, IDC_ELELEV, m_lElevation);
	DDV_Alt(pDX, m_lElevation, -5000, 30000);
	DDX_CBIndex(pDX, IDC_ELELEVDIM, m_nElevDim);
	//}}AFX_DATA_MAP
	
if (pDX->m_bSaveAndValidate)
	{        
	if (m_bInsert)
		{  
		CElev NewElev;
		this->GetData (&NewElev);  
		if (!this->InsertSorted (&NewElev))
			pDX->Fail();		// DDV_MaxChars(pDX, m_szName, 12); must be last DDX_...
		}
	else{
		if (m_nOldIndex>=0 && m_nOldIndex<m_ActList.GetSize())
			{
			LPELEV lpOldElev = (LPELEV)m_ActList.GetAt(m_nOldIndex);   

			CElev NewElev;
			if (!this->GetData (&NewElev))
				pDX->Fail();

			short nCmp = NewElev.Compare(lpOldElev);
			if (nCmp == 0)
				nCmp = (NewElev.GetMaxElev() == lpOldElev->lMaxElev)? 0:1;

			if (nCmp != 0)
				{  									// data has been changed !!
						// check if new name already used at other position in this array
				short nTestIndex = this->ElevToIndex (NewElev);
				if ((nTestIndex > -1) && (nTestIndex != m_nOldIndex))
					{
					AfxMessageBox (IDS_SAME_ELEV);
					pDX->Fail();
					}
				else{
					this->InsertSorted (&NewElev);		// save new data     
					delete lpOldElev;                  // free old data
					}
				}
          	} 
     // else list was empty
		}
    }
}


BEGIN_MESSAGE_MAP(CElevDlg, CDlgTool)
	//{{AFX_MSG_MAP(CElevDlg)
	ON_LBN_SELCHANGE(IDC_ELLIST, OnSelchangeList)
	ON_BN_CLICKED(IDC_ELINS, OnInsert)
	ON_BN_CLICKED(IDC_ELDEL, OnDelete)
	ON_BN_CLICKED(IDC_ELCHANGE, OnChange)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CElevDlg message handlers

/************************************************************************
 *  ElevDlg.cpp	  			 O n I n i t D i a l o g	 				*
 ************************************************************************/
BOOL CElevDlg::OnInitDialog()
{                 // value DlgID,	dim DlgID
this->AddDimGroup (IDC_ELELEV, IDC_ELELEVDIM);

this->FillDimPU (IDC_ELELEVDIM, ALTITUDE);
							
m_nListIndex = this->OnNewList (&m_ActList);

// TODO: Add extra initialization here   
	CDlgTool::OnInitDialog();
	
SelectItem (IDC_ELELEV);		// focus set to a control, return FALSE

return FALSE;  // return TRUE  unless you set the focus to a control
}

/************************************************************************
 *  ElevDlg.cpp	  		 G e t S o r t e d I n d e x 					*
 ************************************************************************/
short CElevDlg::GetSortedIndex (CElev* ptElev)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;

IndMin  = 0;
IndMax  = m_ActList.GetSize();		/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

if (m_ActList.GetSize() > 0)
   {
   do	{  
        LPELEV lpTestElev = (LPELEV)m_ActList.GetAt((int)i);
        CElev	TestElev (lpTestElev);
        
        int iCmp = ptElev->Compare (TestElev);

	    if (iCmp >=0)	bInsAfter = TRUE;
	    		else	bInsAfter = FALSE;

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
				
		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
   
return (short)i;
}

/************************************************************************
 *  ElevDlg.cpp	  			E l e v T o I n d e x						*
 ************************************************************************/
short CElevDlg::ElevToIndex (CElev& NewElev)
{
short nIndex = -1;
short i;

for (i=0; i<m_ActList.GetSize() && (nIndex == -1); i++)
	{							// search used name...
    CElev	TestElev ((LPELEV)m_ActList.GetAt((int)i));
    
    if (NewElev.Compare (TestElev) == 0)
		nIndex = i;
	}

return nIndex;
}

/************************************************************************
 *  ElevDlg.cpp		 		 I n s e r t S o r t e d					*
 ************************************************************************/
BOOL CElevDlg::InsertSorted(CElev* ptElev)	
{	
short nNewIndex;

if (m_bInsert)
	{
	nNewIndex = this->GetSortedIndex (ptElev); 

	if (nNewIndex > 0)
		{
 		CElev PrevLoc((LPELEV)m_ActList.GetAt(nNewIndex-1));
		CString szPrevName = PrevLoc.GetListEntry();
		CString szNewName = ptElev->GetListEntry();

		if (szNewName.Compare (szPrevName) == 0)
			{
			AfxMessageBox (IDS_SAME_ELEV);
			return FALSE;
			}
		}

	m_ActList.InsertAt (nNewIndex, ptElev->CreatePtr());	// insert new
	m_nListIndex = nNewIndex;
	}
else{		  			 // m_nOldIndex defined in DoDataExchange  
	m_ActList.RemoveAt (m_nOldIndex); 	// delete old database entry 
	nNewIndex = this->GetSortedIndex (ptElev);  
	m_ActList.InsertAt (nNewIndex, ptElev->CreatePtr());	// insert new

	if (nNewIndex > m_nOldIndex)
		if (m_nListIndex > m_nOldIndex && m_nListIndex <= nNewIndex)
			m_nListIndex--;   

	if (nNewIndex < m_nOldIndex)
		if (m_nListIndex >=	nNewIndex  && m_nListIndex < m_nOldIndex)
			m_nListIndex++;
	}
		
if (ptInit->IsSaveSignal())
	MessageBeep(MB_OK);	
	              			// compare listbox entries         
CListBox* ptList = (CListBox*)GetDlgItem (IDC_ELLIST);    
CString szNewName = ptElev->GetListEntry();        

if (m_bInsert)
	{
	ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);    
	}
else{
	CString szOldName;
	ptList->GetText (m_nOldIndex, szOldName);
			
	if (szNewName.CompareNoCase((LPCTSTR)szOldName) != 0)
		{                		// change listbox entry	
		ptList->DeleteString(m_nOldIndex);
		ptList->InsertString(nNewIndex, (LPCTSTR)szNewName);  
		}   
	}

m_bChanged = TRUE;
m_ptDoc->SetActIndex (nNewIndex);
return TRUE;
}

/************************************************************************
 *  ElevDlg.cpp	  		 O n S e l c h a n g e L i s t					*
 ************************************************************************/
void CElevDlg::OnSelchangeList()
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (IDC_ELLIST);    
short nNewIndex = ptList->GetCurSel ();

if (m_nListIndex != nNewIndex)
	{	
	if (this->UpdateData(TRUE))
		{      
		this->UpdateData(FALSE);
		}      
	else{				// bad input, reset selection to bad entry 
	    m_nListIndex = m_nOldIndex;
		ptList->SetCurSel (m_nListIndex);		  
		}
	}
else{	// check if new data different from old, then confirm dlg.
	this->UpdateData (FALSE);
	}

m_ptDoc->SetActIndex (m_nListIndex);
}



/************************************************************************
 *  ElevDlg.cpp	  				 O n I n s e r t 						*
 ************************************************************************/
void CElevDlg::OnInsert()
{
	// TODO: Add your control notification handler code here  
m_bInsert = TRUE;
if (this->UpdateData(TRUE))
	{
	this->UpdateData (FALSE);
	if (m_ActList.GetSize() == 1)
		{
		this->DisableControl (IDC_ELCHANGE, FALSE);  
		this->DisableControl (IDC_ELDEL, FALSE);  
		}
	SelectItem (IDC_ELELEV);
	}
m_bInsert = FALSE;	
}

/************************************************************************
 *  ElevDlg.cpp	  				 O n C h a n g e		 				*
 ************************************************************************/
void CElevDlg::OnChange()
{
	// TODO: Add your control notification handler code here
if (this->UpdateData(TRUE))
	{
	this->UpdateData (FALSE);
	}
}
	
/************************************************************************
 *  ElevDlg.cpp	  				 O n D e l e t e						*
 ************************************************************************/
void CElevDlg::OnDelete()
{
	// TODO: Add your control notification handler code here
CListBox* ptList = (CListBox*)GetDlgItem (IDC_ELLIST);    

short nDeleteIndex = ptList->GetCurSel (); 
if (nDeleteIndex > -1)
	{
	LPELEV lpElev = (LPELEV)m_ActList.GetAt(nDeleteIndex); 
	if (lpElev != NULL)
		{
		delete lpElev;
		m_ActList.RemoveAt (nDeleteIndex); 
		m_bChanged = TRUE;           
		}

	ptList->DeleteString (nDeleteIndex);

	if (m_ActList.GetSize() > 0)
		{ 
		m_nListIndex = (nDeleteIndex > 0)? nDeleteIndex - 1 : 0; 
		this->UpdateData(FALSE);
		}
	else{
		this->DisableControl (IDC_ELCHANGE, TRUE);
		this->DisableControl (IDC_ELDEL, TRUE);
		m_nListIndex = -1;  
		}	
	}
}



/************************************************************************
 *  ElevDlg.cpp			C h a n g e E l e v								*
 ************************************************************************/
BOOL CElevDlg::ChangeElev (short nIndex, CElev Elev)   // unused
{
BOOL bChanged = FALSE;

LPELEV lpElev = (LPELEV)m_ActList.GetAt(nIndex);
if (lpElev != NULL)
	{  
	delete lpElev;						// delete old plane ptr
	}

lpElev = Elev.CreatePtr();
if (lpElev != NULL)
	{  
	m_ActList.SetAt (nIndex, lpElev);    // set new plane ptr 
	bChanged = TRUE;      
	}

return bChanged;
}


/************************************************************************
 *  ElevDlg.cpp	  			 O n H e l p I n f o						*
 ************************************************************************/
BOOL CElevDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
