#ifndef __ELEV_DLG__      
#define __ELEV_DLG__

// ElevDlg.h : header file
//
#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// CElevDlg dialog     
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

class CElevDoc;
class CElevDlg : public CDlgTool
{
// Construction
public:   
	
	CElevDlg(CWnd* pParent = NULL, CElevDoc* ptDoc=NULL);	// standard constructor
	~CElevDlg();   
	void ReadDataBaseFromDoc();
	BOOL WriteDataBaseIntoDoc();

// Dialog Data
	//{{AFX_DATA(CElevDlg)
	enum { IDD = IDD_ELEVBOX };
	int		m_nListIndex;
	double	m_dLatTL;
	double	m_dLonTL;
	short	m_nSouth_min;
	short	m_nEast_min;
	long	m_lElevation;
	int		m_nElevDim;
	//}}AFX_DATA

BOOL		m_bInsert;
CElevDoc* 	m_ptDoc;
CPtrArray	m_ActList;		// actual elev array
short		m_nOldIndex;
BOOL		m_bChanged;           
 
// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support  
	void DeleteDataBase();
	void SetData (CElev& Elev);
	BOOL GetData (CElev* ptElev);
	void FillElevList (CPtrArray* ptElevs);   
	short OnNewList (CPtrArray* ptElevs);
	short ElevToIndex (CElev& NewElev);
	BOOL InsertSorted(CElev* ptElev);	
	short GetSortedIndex (CElev* ptElev);
	BOOL ChangeElev (short nIndex, CElev Elev);

	// Generated message map functions
	//{{AFX_MSG(CElevDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeList();
	afx_msg void OnInsert();
	afx_msg void OnDelete();
	afx_msg void OnChange();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
