// ElevDoc.cpp : implementation of the CElevDoc class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "DimDoc.h"

#include "ElevDoc.h"  
#include "ElevDlg.h"				

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 	ptInit;              
extern CDimDoc* 	ptDim;      
extern BOOL			bDemo;

 
/////////////////////////////////////////////////////////////////////////////
// CElevDoc

IMPLEMENT_DYNCREATE(CElevDoc, CDocument)

BEGIN_MESSAGE_MAP(CElevDoc, CDocument)
	//{{AFX_MSG_MAP(CElevDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CElevDoc construction/destruction

CElevDoc::CElevDoc()
{
	// TODO: add one-time construction code here  
this->InitHeader();
m_bConverted = FALSE;
}

CElevDoc::~CElevDoc()
{   
if (this->IsModified())  
	{
	CString szPath = this->GetPathName(); 
	this->OnSaveDocument (szPath);
	}

this->DeleteArrayOf (&m_Elevs);
}
   

/************************************************************************
 *  ElevDoc.cpp				D e l e t e A r r a y O f 					*
 ************************************************************************/
void CElevDoc::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	LPELEV ptEntry;
	if ((ptEntry = (LPELEV)ptArray->GetAt(i)) != NULL)
		{
//		TRACE ("Deleting ElevDoc LPELEV %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}                
 
/************************************************************************
 *  ElevDoc.cpp					C o p y E l e v s						*
 ************************************************************************/
void CElevDoc::CopyElevs (CPtrArray* ptDest, CPtrArray* ptSource)
{
short i;
for (i=0; i<ptSource->GetSize(); i++) 
	{
	LPELEV	lpDocElev = NULL;         

	lpDocElev = (LPELEV)ptSource->GetAt (i);    
	if (lpDocElev != NULL)
		{
		LPELEV lpCpyElev = new ELEVTYPE;	 
		
		TRACE ("CElevDoc::CopyElevs Create LPELEV %d\n", i);

		_fmemcpy (lpCpyElev, lpDocElev, sizeof(ELEVTYPE)); 
		ptDest->Add (lpCpyElev);    
		}
	}
}        

/************************************************************************
 *  ElevDoc.cpp				G e t D a t a B a s e 						*
 ************************************************************************/
void CElevDoc::GetDataBase (CPtrArray* ptElevList)
{    
                              	// copy database from Doc to Dlg
this->DeleteArrayOf (ptElevList);
this->CopyElevs (ptElevList, &m_Elevs);   
}   

/************************************************************************
 *  ElevDoc.cpp				S e t D a t a B a s e 						*
 ************************************************************************/
void CElevDoc::SetDataBase (CPtrArray* ptElevList)
{     
                          		 // copy database from Dlg to Doc
this->DeleteArrayOf (&m_Elevs);
this->CopyElevs (&m_Elevs, ptElevList);   
}


/************************************************************************
 *  ElevDoc.cpp					G e t E l e v P t r						*
 ************************************************************************/
LPELEV CElevDoc::GetElevPtr (short nIndex)
{
LPELEV lpElev = NULL;

if (nIndex>=0 && nIndex<m_Elevs.GetSize())
	{
	lpElev = (LPELEV)m_Elevs.GetAt (nIndex);  
	} 
return lpElev;      
}
 
/************************************************************************
 *  ElevDoc.cpp					G e t E l e v P t r						*
 ************************************************************************/
BOOL CElevDoc::GetElevPtr (short nIndex, CElev* ptElev)
{
BOOL bOK = FALSE;

if (nIndex >= 0 && nIndex < m_Elevs.GetSize())
	{
	LPELEV lpElev = (LPELEV)m_Elevs.GetAt(nIndex);
	ptElev->SetPtr (lpElev);
	bOK = TRUE;
	}

return bOK;
}

/************************************************************************
 *  ElevDoc.cpp	  		 G e t S o r t e d I n d e x 					*
 ************************************************************************/
short CElevDoc::GetSortedIndex (ELEVCHANGE* ptElevChange)
{
BOOL	bInsAfter;  
long	IndMin, IndMax, i, OldTestInd;

IndMin  = 0;
IndMax  = m_ElevChanges.GetSize();		/* legal ind: 0...cnt-1		*/
i = (IndMin + IndMax) / 2;				/* i always < cnt !!	*/

if (m_ElevChanges.GetSize() > 0)
   {
   do	{  
        ELEVCHANGE* lpTest = (ELEVCHANGE*)m_ElevChanges.GetAt((int)i);
        
		bInsAfter = (ptElevChange->From.dDist_NM > lpTest->From.dDist_NM);

		if (bInsAfter)	IndMin = i;
				else	IndMax = i;
				
		OldTestInd = i;
		i = (IndMin + IndMax) / 2;
	
		} while (i != OldTestInd);

   if (bInsAfter) i++;
   }                     
   
return (short)i;
}

/************************************************************************
 *  ElevDoc.cpp				A d d E l e v C h a n g e 					*
 ************************************************************************/
void CElevDoc::AddElevChange (ELEVPOS& From, ELEVPOS& To, long lElev_ft)
{
	ELEVCHANGE* ptEC = new ELEVCHANGE;
	ptEC->From		= From;
	ptEC->To		= To;
	ptEC->lElev_ft	= lElev_ft;

	short nNewIndex = this->GetSortedIndex (ptEC); 
	m_ElevChanges.InsertAt (nNewIndex, ptEC);
}

/************************************************************************
 *  ElevDoc.cpp				G e t E l e v C h a n g e C n t 			*
 ************************************************************************/
short CElevDoc::GetElevChangeCnt()
{
	return m_ElevChanges.GetSize();
}


/************************************************************************
 *  ElevDoc.cpp				G e t E l e v C h a n g e 					*
 ************************************************************************/
BOOL CElevDoc::GetElevChange (short nIndex, ELEVPOS* ptFrom, ELEVPOS* ptTo, long* ptElev_ft)
{
	BOOL bOK=FALSE;

	if (0 <= nIndex && nIndex < m_ElevChanges.GetSize())
	{
		ELEVCHANGE* ptEC = (ELEVCHANGE*)m_ElevChanges.GetAt(nIndex);
		if (ptEC != NULL)
		{
			*ptFrom		= ptEC->From;
			*ptTo		= ptEC->To;
			*ptElev_ft	= ptEC->lElev_ft;
			bOK = TRUE;
		}
	}
	return bOK;
}

/************************************************************************
 *  ElevDoc.cpp				R e m o v e E l e v C h a n g e s 			*
 ************************************************************************/
void CElevDoc::RemoveElevChanges ()
{
int i, nEntryCnt;	
											
nEntryCnt = m_ElevChanges.GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	ELEVCHANGE* ptEntry;
	if ((ptEntry = (ELEVCHANGE*)m_ElevChanges.GetAt(i)) != NULL)
		{
		TRACE ("Deleting ElevChange ELEVCHANGE* %d\n", i);
		delete ptEntry;				// delete original element
		}
	}
m_ElevChanges.RemoveAll();
}    


/************************************************************************
 *  ElevDoc.cpp				G e t S t a r t I n d e x					*
 ************************************************************************/
BOOL CElevDoc::GetStartIndex (CLatLon& LL, short* ptIndex)
{
	BOOL bFound = FALSE;

	for (int i=0; i<m_Elevs.GetSize() && !bFound; i++)
	{
		CElev Elev;
		if (this->GetElevPtr (i, &Elev))
		{
			BOOL bFrameIsInside = TRUE;
			// returns  0, if this area covers position LL							*
			// returns  1, if this area is north or at least east of position LL	*
			// returns -1, if this area is south or at least west of position LL	*
			bFound = (Elev.Compare(LL, bFrameIsInside) >= 0);

			if (bFound) *ptIndex = i;
		}
	}

	return bFound;
}

/************************************************************************
 *  ElevDoc.cpp				G e t E n d I n d e x						*
 ************************************************************************/
BOOL CElevDoc::GetEndIndex (CLatLon& LL, short* ptIndex)
{
	BOOL bFound = FALSE;

	for (int i=m_Elevs.GetSize()-1; i>=0 && !bFound; i--)
	{
		CElev Elev;
		if (this->GetElevPtr (i, &Elev))
		{
			BOOL bFrameIsInside = TRUE;
			// returns  0, if this area covers position LL							*
			// returns  1, if this area is north or at least east of position LL	*
			// returns -1, if this area is south or at least west of position LL	*
			bFound = (Elev.Compare(LL, bFrameIsInside) <= 0);

			if (bFound) *ptIndex = i;
		}
	}

	return bFound;
}

/************************************************************************
 *  ElevDoc.cpp				G e t M i n M a x I n d e x					*
 ************************************************************************/
BOOL CElevDoc::GetMinMaxIndex (CLatLon& LL1, CLatLon& LL2, 
							   short* ptStartInd, short* ptEndInd)
{
	BOOL	bFound = FALSE;

	double dLon2 = LL1.GetLon() + CLatLon::FlightAngle(LL1.GetLon(), LL2.GetLon());

	BOOL bLess = (LL1.GetLat() < LL2.GetLat());
	double dMinLat = (bLess)? LL1.GetLat() : LL2.GetLat();
	double dMaxLat = (bLess)? LL2.GetLat() : LL1.GetLat();

	bLess = (LL1.GetLon() < dLon2);
	double dMinLon = (bLess)? LL1.GetLon() : dLon2;
	double dMaxLon = (bLess)? dLon2 : LL1.GetLon();

	CLatLon LLmin (dMinLat, dMinLon);
	CLatLon LLmax (dMaxLat, dMaxLon);

	if (!LLmin.IsEqual(LLmax))
	{					// LL1 must be different from LL2
		if (this->GetStartIndex (LLmin, ptStartInd) &&
			this->GetEndIndex (LLmax, ptEndInd))
		{
			if (*ptEndInd < *ptStartInd)
			{				// for antipod situation!!
				short nHelpInd = *ptStartInd;
				*ptStartInd = *ptEndInd;
				*ptEndInd = nHelpInd;
			}

			bFound = TRUE;
		}
	}

	return bFound;
}   


/************************************************************************
 *  ElevDoc.cpp				A d d E l e v C h a n g e s 				*
 ************************************************************************/
BOOL CElevDoc::AddElevChanges(CLatLon& LL1, CLatLon& LL2, short nIndex)
{
	short nOldChangeCnt = m_ElevChanges.GetSize();

	CElev Elev;
	if (this->GetElevPtr (nIndex, &Elev))
	{
		ELEVPOS Pos1, Pos2;
		Pos1.dDist_NM = -1;
		Pos2.dDist_NM = -1;

		long	lElev_ft;
		double	dCourse;
		BOOL	bCheckBorder = FALSE;

		BOOL bFrameIsInside = TRUE;
		BOOL bLL1 = (Elev.Compare(LL1, bFrameIsInside) == 0);
		BOOL bLL2 = (Elev.Compare(LL2, bFrameIsInside) == 0);
			
		lElev_ft = (long)ptDim->ConvertDist(Elev.GetMaxElev(), Elev.GetElevDim(), DIM_FEET);

		if(bLL1)
		{			
			if (bLL2)
			{				// LL1 and LL2 are in actual Elev
				Pos1.dDist_NM = 0;
				Pos1.llPos = LL1;

				Pos2.dDist_NM = LL1.LoxoDist(LL2, &dCourse);
				Pos2.llPos = LL2;
				bCheckBorder = FALSE;
			}
			else
			{				// only LL1 is in actual Elev
				Pos1.dDist_NM = 0;
				Pos1.llPos = LL1;
				bCheckBorder = TRUE;
			}
		}
		else
		{	
			if (bLL2)
			{				// only LL2 is in actual Elev
				Pos2.dDist_NM = LL1.LoxoDist(LL2, &dCourse);
				Pos2.llPos = LL2;
				bCheckBorder = TRUE;
			}
			else
			{				// neither LL1 nor LL2 is in actual Elev
				bCheckBorder = TRUE;
			}
		}


		if (bCheckBorder)
		{
			double dLat, dLon;

			if (Elev.CrossNorth(LL1, LL2, &dLon))
			{
				dLat = Elev.GetPosTL().GetLat();			// top border of elev
				if (Pos1.dDist_NM == -1)	
				{
					Pos1.llPos.SetLatLon(dLat, dLon);
					Pos1.dDist_NM = LL1.LoxoDist(Pos1.llPos, &dCourse);
				}
				else
				{
					Pos2.llPos.SetLatLon(dLat, dLon);
					Pos2.dDist_NM = LL1.LoxoDist(Pos2.llPos, &dCourse);
				}
			}

			if (Elev.CrossSouth(LL1, LL2, &dLon))
			{
				dLat = Elev.GetPosBR().GetLat();			// bottom border of elev
				if (Pos1.dDist_NM == -1)	
				{
					Pos1.llPos.SetLatLon(dLat, dLon);
					Pos1.dDist_NM = LL1.LoxoDist(Pos1.llPos, &dCourse);
				}
				else
				{
					Pos2.llPos.SetLatLon(dLat, dLon);
					Pos2.dDist_NM = LL1.LoxoDist(Pos2.llPos, &dCourse);
				}
			}

			if (Elev.CrossWest(LL1, LL2, &dLat))
			{
				dLon = Elev.GetPosTL().GetLon();			// left border of elev
				if (Pos1.dDist_NM == -1)	
				{
					Pos1.llPos.SetLatLon(dLat, dLon);
					Pos1.dDist_NM = LL1.LoxoDist(Pos1.llPos, &dCourse);
				}
				else
				{
					Pos2.llPos.SetLatLon(dLat, dLon);
					Pos2.dDist_NM = LL1.LoxoDist(Pos2.llPos, &dCourse);
				}
			}


			if (Elev.CrossEast(LL1, LL2, &dLat))
			{
				dLon = Elev.GetPosBR().GetLon();			// right border of elev
				if (Pos1.dDist_NM == -1)	
				{
					Pos1.llPos.SetLatLon(dLat, dLon);
					Pos1.dDist_NM = LL1.LoxoDist(Pos1.llPos, &dCourse);
				}
				else
				{
					Pos2.llPos.SetLatLon(dLat, dLon);
					Pos2.dDist_NM = LL1.LoxoDist(Pos2.llPos, &dCourse);
				}
			}
		} // end check border

		if (Pos1.dDist_NM > -1 && Pos2.dDist_NM > -1)
		{	
			if (Pos1.dDist_NM < Pos2.dDist_NM)
				this->AddElevChange(Pos1, Pos2, lElev_ft);	// From, To, Elev
			else
				this->AddElevChange(Pos2, Pos1, lElev_ft);	// From, To, Elev
		}
	}

	return (nOldChangeCnt < m_ElevChanges.GetSize());
}
                        
/****************************************************************************
 *	ElevView.cpp			AltOnLegAtDist								*
 *  Purpose: Calculates altitude on leg LL1-LL2, dDist_NM after LL1			*
 ****************************************************************************/
long CElevDoc::AltOnLegAtDist (double dDist_NM, CLatLon& LL1, long lAlt1, CLatLon& LL2, long lAlt2)
{
	long lAlt=NO_ALT;

	if (lAlt1 == lAlt2)
	{					// constant altitude
		lAlt = lAlt1;
	}
	else
	{
		double dDist12 = LL1.LoxoDist(LL2);
		if (dDist12 > 0)
		{
			lAlt = (long)(dDist_NM * (double)(lAlt2 - lAlt1)/dDist12 + lAlt1);
		}
	}
	return lAlt;
}


/****************************************************************************
 *	ElevView.cpp			DistOnLegAtElev								*
 *  Purpose: Calculates dist after LL1, where planned alt is lElev_ft		*
 ****************************************************************************/
double CElevDoc::DistOnLegAtElev (long lElev_ft, CLatLon& LL1, long lAlt1, CLatLon& LL2, long lAlt2)
{
	double dDist_NM=-1;
	double dDist12 = LL1.LoxoDist(LL2);

	if (lAlt1 != lAlt2)
	{
		dDist_NM = (double)(lElev_ft - lAlt1) * dDist12/((double)(lAlt2 - lAlt1));
	}

	return dDist_NM;		// where planned alt is lElev_ft
}

/****************************************************************************
 *	ElevView.cpp			CriticalLegPoints								*
 *  Purpose:  Look for elev changes below one leg and						*
 *				calculate enter and leave points for each elev area,		*
 *				where elev > planned alt									*
 ****************************************************************************/
void CElevDoc::CriticalLegPoints(CLatLon& LL0, long lAlt0, CLatLon& LL1, long lAlt1,
					CriticalLegProcPtr CriticalLeg, BOOL bOrtho, void* ptData)
{
	short nStartInd, nEndInd;		// Elev Index
	if (this->GetMinMaxIndex (LL0, LL1, &nStartInd, &nEndInd))
	{
		int j;
		BOOL bAdded = FALSE;

		for (j=nStartInd; j<=nEndInd; j++)
		{					// for all Elevs around actual leg
			if (this->AddElevChanges(LL0, LL1, j))
			{
				bAdded = TRUE;
			}
		}


		for (j=0; j<this->GetElevChangeCnt(); j++)
		{		// get all strored elev changes for actual leg in sorted order	
			ELEVPOS From, To;
			long	lElev_ft;

			if (this->GetElevChange(j, &From, &To, &lElev_ft))
			{					// calc planned alt at begin and end of actual elev area

				long PlAlt1 = this->AltOnLegAtDist (From.dDist_NM, LL0, lAlt0, LL1, lAlt1);
				long PlAlt2 = this->AltOnLegAtDist (To.dDist_NM, LL0, lAlt0, LL1, lAlt1);

				if (PlAlt1 != NO_ALT && PlAlt2 != NO_ALT)
				{
					ELEVPOS Warn1, Warn2;
					Warn1.dDist_NM = -1;
					Warn2.dDist_NM = -1;

					if (PlAlt1 > lElev_ft)
					{
						if (PlAlt2 > lElev_ft)
						{
							// Planned Alt1 and 2 above elev area
						}
						else
						{	// only planned alt1 above elev area
							Warn1.dDist_NM = this->DistOnLegAtElev (lElev_ft, LL0, lAlt0, LL1, lAlt1);
							if (bOrtho)
								Warn1.llPos = CLatLon::PointOnOrthoLegAtDist(Warn1.dDist_NM, LL0, LL1);
							else
								Warn1.llPos = CLatLon::PointOnLoxoLegAtDist(Warn1.dDist_NM, LL0, LL1);
							Warn2 = To;
						}
					}
					else
					{
						if (PlAlt2 > lElev_ft)
						{	// only planned alt 2 above elev area
							Warn1 = From;
							Warn2.dDist_NM = this->DistOnLegAtElev (lElev_ft, LL0, lAlt0, LL1, lAlt1);	
							if (bOrtho)
								Warn2.llPos = CLatLon::PointOnOrthoLegAtDist(Warn2.dDist_NM, LL0, LL1);
							else
								Warn2.llPos = CLatLon::PointOnLoxoLegAtDist(Warn2.dDist_NM, LL0, LL1);
						}
						else
						{	// planned alt 1 and 2 below elev area
							Warn1 = From;
							Warn2 = To;
						}
					}

					if (Warn1.dDist_NM > -1 && Warn2.dDist_NM > -1)
					{
						if (bOrtho)
						{
						Warn1.llPos = CLatLon::PointOnOrthoLegAtDist (Warn1.dDist_NM, LL0, LL1);
						Warn2.llPos = CLatLon::PointOnOrthoLegAtDist (Warn2.dDist_NM, LL0, LL1);
						}
						else
						{
							// use positions stored in ELEVPOS
						}

						CriticalLeg (Warn1.llPos, Warn2.llPos, lElev_ft, ptData);	// callback function
					}

				}
	
			}
		}

		this->RemoveElevChanges();
	}
}

/************************************************************************
 *  ElevDoc.cpp			O n N e w D o c u m e n t						*
 ************************************************************************/
BOOL CElevDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)     
	
   
return TRUE;
}   

/************************************************************************
 *  ElevDoc.cpp			D e l e t e C o n t e n t s						*
 *  Called from: OnFileNew and OnFileOpen								*
 ************************************************************************/
void CElevDoc::DeleteContents()
{
this->InitHeader();
this->DeleteArrayOf (&m_Elevs);
}

/************************************************************************
 *  ElevDoc.cpp			O n O p e n D o c u m e n t						*
 ************************************************************************/
BOOL CElevDoc::OnOpenDocument(LPCTSTR pszPathName)
{
BOOL bOpened = FALSE;

bOpened = CDocument::OnOpenDocument(pszPathName); 

if (bOpened)
	{
	if (m_bConverted)
		{
		if (this->OnSaveDocument (pszPathName, FALSE))		// don't confirm
			{
			m_bConverted = FALSE;
			if (ptInit->IsSaveSignal())
				MessageBeep(MB_OK);	
			}
		}
	}

return bOpened;
}


/************************************************************************
 *  ElevDoc.cpp				O n S a v e D o c u m e n t					*
 ************************************************************************/
BOOL CElevDoc::OnSaveDocument(const char* pszPathName, BOOL bConfirm)
{
BOOL bSaved = FALSE;
BOOL bDoSave;

if (bConfirm)
	{
	CString szText;
	CString szFileExt = this->GetTitle();
	szText.Format(IDF_SAVE_FILE, (LPCTSTR)szFileExt);
	bDoSave = (AfxMessageBox ((LPCTSTR)szText, MB_YESNO) == IDYES);
	}
else{
	bDoSave = TRUE;
	}

if (bDoSave)
	{
	if (bDemo)
		{
		AfxMessageBox (IDS_SAVE_DISABLED);
		return bSaved;
		}
	else{
		bSaved = CDocument::OnSaveDocument(pszPathName); 
		}
	}        
else{   
    this->SetModifiedFlag (FALSE);
	}

return bSaved;
}


/************************************************************************
 *  ElevDoc.cpp  		 		 C h a n g e 							*
 ************************************************************************/
BOOL CElevDoc::Change(CWnd* ptWnd)
{  
BOOL 	bChanged = FALSE;
CElevDlg ElevDlg(ptWnd, this);

int RetVal = ElevDlg.DoModal();
switch (RetVal)
	{
	case IDOK:
		{   
		CString szPath = this->GetPathName(); 
		if (ElevDlg.WriteDataBaseIntoDoc()) 
			{             
			this->OnSaveDocument (szPath);
 			bChanged = TRUE;
 			}     
		}
 		break;
	case IDCANCEL: 
       this->SetModifiedFlag(FALSE);
		break;
	}
return bChanged;	
} 


/************************************************************************
 *  ElevDoc.cpp				A v e r a g e A n g l e 					*
 *  Purpose: returns angle between Angle1 and Angle2	[degree]		*
 *	Example: Angle1=330, Angle2=10, AverageAngle = 350					*
 ************************************************************************/
double CElevDoc::AverageAngle (double Angle1, double Angle2)
{
double AngleDiff, AverageAngle;

AngleDiff =  Angle1 - Angle2;
if (AngleDiff < 0) AngleDiff *= -1;

AverageAngle = (Angle1 + Angle2) / 2;
if (AngleDiff > 180) AverageAngle += 180;

if (AverageAngle >= 360)	AverageAngle -= 360;

return AverageAngle;
}

/************************************************************************
 *  ElevDoc.cpp	       		L a b e l D i r e c t i o n 				*
 ************************************************************************/
double CElevDoc::LabelDirection (ELEVPROFIL* ptProfil, short i, short nCnt, BOOL* ptRightAlign)
{
	double	TextAngle;
	double	Average = -1;

	if (i>0 && i < (nCnt - 1))
		{
		double		PrevAngle = (ptProfil + i)->dAngle_deg + 180;
		double		NextAngle = (ptProfil + i+1)->dAngle_deg;

		if (PrevAngle > 360)
			PrevAngle -= 360;

		Average = AverageAngle (PrevAngle, NextAngle);
		}
	else{
		double	dAngle;

		if (i==0)
			{					// first waypoint:
			dAngle = 359;		// force left aligned label below elev line 
			}
			
		if (i == (nCnt - 1))			
			{					// last waypoint:
			dAngle = 1;
			}
		Average = dAngle;		// force right aligned label below elev line
		}
	
	if (Average>=0 && Average<180)
		{
		TextAngle = Average + 180;
		*ptRightAlign = TRUE;
		}
	else{			
		TextAngle = Average - 180;
		*ptRightAlign = FALSE;
		}
		
	return TextAngle;
}



//     IDS_LEV_VERS            "PF LEV 1.00  "

/************************************************************************
 *  ElevDoc.cpp  		 		 H e a d e r T o V e r s 				*
 ************************************************************************/
short CElevDoc::HeaderToVers (char* ptHeader)
{  
short nVersion = 0;
CString szTestVers; 

szTestVers.LoadString (IDS_LEV_VERS);
if (szTestVers.Compare (ptHeader) == 0)
	nVersion = ACT_ELEV_VERS;

return nVersion;
} 
     
/************************************************************************
 *  ElevDoc.cpp  		 		V e r s T o H e a d e r 				*
 ************************************************************************/
void CElevDoc::VersToHeader (LPSTR lpHeader, short nVersion)
{      
CString szVers;
switch (nVersion)
	{
	case ACT_ELEV_VERS:	
			 szVers.LoadString (IDS_LEV_VERS);	break; 
	default: szVers.Empty();	break;
    }

_fstrcpy (lpHeader, (LPCTSTR)szVers);
}      

/************************************************************************
 *  ElevDoc.cpp				I n i t H e a d e r							*
 ************************************************************************/
void CElevDoc::InitHeader ()
{  
CString		szVers;

szVers.LoadString (IDS_LEV_VERS);
_fstrcpy (m_Header.szVersion, (LPCTSTR)szVers);
m_Header.cFlags		= 0;
m_Header.cDummy		= 0;
m_Header.nActIndex	= -1;
m_Header.nElevCnt	= 0;  
}

/************************************************************************
 *  ElevDoc.cpp  		 		S e r i a l i z e 						*
 ************************************************************************/
void CElevDoc::Serialize(CArchive& ar)
{    
short i, nVersion;

if (ar.IsStoring())
	{  
		// TODO: add storing code here     
	nVersion = ACT_ELEV_VERS;  
	VersToHeader ((LPSTR)&m_Header.szVersion, nVersion);	
	this->SetElevCnt (m_Elevs.GetSize());	// put elev cnt into header

	ar.Write (&m_Header, sizeof (ELEVHEADER));    
	
	for (i=0; i<m_Elevs.GetSize(); i++)
		{
		LPELEV lpElev = (LPELEV)m_Elevs.GetAt(i);
		CElev Elev(lpElev);
		Elev.Serialize (ar);  
		}      
	m_bConverted = FALSE;		
	}
else{
		// TODO: add loading code here   
	m_bConverted = FALSE;

	ar.Read (&m_Header, sizeof (ELEVHEADER));
	nVersion = this->HeaderToVers (m_Header.szVersion);  
	short nStoredCnt = this->GetElevCnt ();		// unused
		
	if (nVersion < ACT_ELEV_VERS)
		{	  
	//	char szText[256];
	//	CString szFormat;
	//	szFormat.LoadString (IDS_CONVERT_LEV);
	//    wsprintf ((LPSTR)szText, (LPCTSTR)szFormat, (LPCTSTR)this->GetTitle());
	//	if (AfxMessageBox ((LPCSTR)szText, MB_YESNO) == IDYES) 
	//		{ 
	//		m_bConverted = TRUE; 
    //      }
    //    else{ 
    //    	AfxMessageBox (IDS_BAD_PL_VERS);
    //    	return;
    //    	}
        }
	
	
 
	CFile* ptFile = ar.GetFile();
	DWORD	dwLength = (DWORD)ptFile->GetLength();
	  
	DWORD dwBlockSize;  			// get number of entries:
	switch (nVersion)
		{
	//	case 1:	dwBlockSize = sizeof (ELEVTYPE1);	break;
	//	case 2:	dwBlockSize = sizeof (ELEVTYPE2);	break;
		case ACT_ELEV_VERS:	dwBlockSize = sizeof (ELEVTYPE);	break;
        }
	short nCnt = (short)((dwLength - MAX_HEADER_SIZE) / dwBlockSize);
	
	for (i=0; i<nCnt; i++)
		{
		CElev Elev; 
		Elev.Serialize (ar, nVersion);
		LPELEV lpElev = Elev.CreatePtr();	   	
		if (lpElev != NULL)
			{  
			m_Elevs.Add (lpElev);       	// add new Element        
 			}  
		} 
 	}  
}



/////////////////////////////////////////////////////////////////////////////
// CElevDoc diagnostics

#ifdef _DEBUG
void CElevDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CElevDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CElevDoc commands
