#ifndef __ELEV_DOC__      
#define __ELEV_DOC__

// ElevDoc.h : interface of the CElevDoc class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "Elev.h"

typedef void (*CriticalLegProcPtr)(CLatLon& LLenter, CLatLon& LLleave, long lElev_ft, void* ptData);

typedef struct 
	{
	char szVersion[14];
	unsigned char cFlags;
	unsigned char cDummy;
	short	nActIndex;
	short	nElevCnt;
	} ELEVHEADER; 

typedef struct 
	{
	CLatLon	llPos;
	double	dDist_NM;
	} ELEVPOS; 

typedef struct 
	{
	ELEVPOS From;
	ELEVPOS To;
	long	lElev_ft;
	} ELEVCHANGE; 

typedef struct
{
	long lX;
	long lY;
	double dAngle_deg;
} ELEVPROFIL;

class CElevDoc : public CDocument
{         
private:
	#define MAX_HEADER_SIZE 20
    
    ELEVHEADER		m_Header;     
	CPtrArray		m_Elevs;             
 	BOOL			m_bConverted; 
	CPtrArray		m_ElevChanges;             
    
protected: // create from serialization only
	DECLARE_DYNCREATE(CElevDoc)

// Attributes
public:
// Operations
public:           
 	void DeleteArrayOf (CPtrArray* ptArray);
	void CopyElevs (CPtrArray* ptDest, CPtrArray* ptSource);
	void GetDataBase (CPtrArray* ptElevList);
	void SetDataBase (CPtrArray* ptElevList);
 	LPELEV GetElevPtr (short nIndex);
	BOOL GetElevPtr (short nIndex, CElev* ptElev);

	void AddElevChange (ELEVPOS& From, ELEVPOS& To, long lElev_ft);
	short GetElevChangeCnt();
	BOOL GetElevChange (short nIndex, ELEVPOS* ptFrom, ELEVPOS* ptTo, long* ptElev_ft);
	void RemoveElevChanges ();
	BOOL GetStartIndex (CLatLon& LL, short* ptIndex);
	BOOL GetEndIndex (CLatLon& LL, short* ptIndex);
	BOOL GetMinMaxIndex (CLatLon& LL1, CLatLon& LL2, short* ptStartInd, short* ptEndInd);
	BOOL AddElevChanges(CLatLon& LL1, CLatLon& LL2, short nIndex);


	long AltOnLegAtDist (double dDist_NM, CLatLon& LL1, long lAlt1, CLatLon& LL2, long lAlt2);
	double DistOnLegAtElev (long lElev_ft, CLatLon& LL1, long lAlt1, CLatLon& LL2, long lAlt2);
	void CriticalLegPoints(CLatLon& LL0, long lAlt0, CLatLon& LL1, long lAlt1,
						CriticalLegProcPtr CriticalLeg, BOOL bOrto, void* ptData=NULL);

    BOOL WasConverted(){return m_bConverted;}     

	short GetActIndex() { return m_Header.nActIndex; }
	short GetElevCnt () { return m_Header.nElevCnt; }

	void SetActIndex(short nIndex) { m_Header.nActIndex = nIndex; }
	void SetElevCnt (short nCnt) { m_Header.nElevCnt = nCnt; }
	double AverageAngle (double Angle1, double Angle2);
	double LabelDirection (ELEVPROFIL* ptProfil, short i, short nCnt, BOOL* ptRightAlign);
   						  
// Implementation
public:
	CElevDoc();
	virtual ~CElevDoc();  
	virtual BOOL OnNewDocument();  
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(const char* pszPathName, BOOL bConfirm = TRUE);
    
	BOOL Change(CWnd* ptWnd);
	
	virtual void DeleteContents();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:    
	short HeaderToVers (char* ptHeader);
	void VersToHeader (LPSTR lpHeader, short nVersion);   
	void InitHeader ();
	short GetSortedIndex (ELEVCHANGE* ptElevChange);
	
// Generated message map functions
protected:
	//{{AFX_MSG(CElevDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif