#ifndef __ELEVVIEW__
#define __ELEVVIEW__

// ElevView.h : interface of the CElevView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "..\CPPTOOLS\TxVwTool.h"
#include "Map.h"				// includes CBorder class

class CElevView : public CTextViewTool
{
public:
	CFont	m_PlainFont; 
	CFont	m_BoldFont; 
	int		m_CharX, m_LineY;
	int		m_BCharX, m_BLineY;

	CMap*	m_ptAltGraph;
	DRECT	m_rMapBorder;	// lat lon on rVirtLP
	BOOL	m_bInitialView;

	DRECT	m_rMap;			// lat lon on visible map area


protected: // create from serialization only
	DECLARE_DYNCREATE(CElevView)

	CColorDoc* 	m_ptColor;

// Attributes
public:
	CWayDoc* GetDocument();

// Operations
public:

// Implementation
public:
	CElevView();
	virtual ~CElevView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

private:
	BOOL IsAirspaceToDraw(CAirspace* ptAirspace);


protected:
	void UpdateFonts (CDC* pDC);
	void SetXTabs (CDC* pDC, CWayDoc* ptWayDoc, int CharX);
	void PrepareXTabs (CDC* pDC);

	void GetMaxRectLP (CDC* pDC, CWnd* ptWnd, LPRECT lpRectMax, BOOL bPrinter);
	CRect GetUseableRectLP (CDC* pDC);

	double GetTimeForDist_min(double dDist_NM, double dLeg_NM, double dLeg_min);

	static double LineAngle_deg (long LPx0, long LPy0, long LPx1, long LPy1);
	void DrawLabel (CDC* pDC, long LPx1, long LPy1, double TextAngle, long LineY, 
				BOOL bRightAlign, CString szLoc, short nSizeLP, BOOL bActWpt);

	void DrawElevICAO (CDC* pDC, CCalculate* ptLegs, BOOL bAntipod);
	void DrawElev1km (CDC* pDC, CCalculate* ptLegs, BOOL bAntipod);
	void DrawAirspaces (CDC* pDC, CCalculate* ptLegs, BOOL bAntipod);
	void DrawRoute (CDC* pDC, CCalculate* ptLegs, BOOL bAntipod);

	void DrawSky (CDC* pDC, CRect& rMapLP);
	BOOL DrawRouteElev (CDC* pDC, CWayDoc* ptWayDoc, int* ptY, BOOL bDraw = TRUE);

	void PrintPage (CDC* pDC, int nPageToPrint);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
protected:
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo); 
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL



// Generated message map functions
protected:
	//{{AFX_MSG(CElevView)
	afx_msg void OnEditCopy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in ElevView.cpp
inline CWayDoc* CElevView::GetDocument()
   { return (CWayDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
#endif
