// FlPlDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "WayDoc.h"
#include "FlPlDoc.h"
#include "FlPlPDlg.h"
#include "SuppDlg.h"
#include "FlPlDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFlightPlanDlg dialog


CFlightPlanDlg::CFlightPlanDlg(CWnd* pParent, CFlightPlanDoc* ptDoc, CWayDoc* ptWayDoc)
	: CDialog(CFlightPlanDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFlightPlanDlg)
	m_szIdent = _T("");
	m_nRules = -1;
	m_nFlightType = -1;
	m_nNumber = 0;
	m_szPlaneType = _T("");
	m_nWakeCat = -1;
	m_szEquipment = _T("");
	m_nSSR = -1;
	m_szDeparture = _T("");
	m_nTime = 0;
	m_szSpeed = _T("");
	m_szLevel = _T("");
	m_szRoute = _T("");
	m_szDestination = _T("");
	m_nTotal = 0;
	m_szAlternate1 = _T("");
	m_szAlternate2 = _T("");
	m_szOtherInfo = _T("");
	//}}AFX_DATA_INIT

m_nNumber=1;
m_ptDoc = ptDoc;
m_ptWayDoc = ptWayDoc;
m_bSuppChanged = FALSE;
m_bChangedToAutoMode = FALSE;
}


void CFlightPlanDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFlightPlanDlg)
	DDX_Text(pDX, IDC_FPIDENT, m_szIdent);
	DDV_MaxChars(pDX, m_szIdent, 7);
	DDX_CBIndex(pDX, IDC_FPRULES, m_nRules);
	DDX_CBIndex(pDX, IDC_FPFLIGHTTYPE, m_nFlightType);
	DDX_Text(pDX, IDC_FPNUMBER, m_nNumber);
	DDV_MinMaxInt(pDX, m_nNumber, 1, 99);
	DDX_Text(pDX, IDC_FPPLANETYPE, m_szPlaneType);
	DDV_MaxChars(pDX, m_szPlaneType, 4);
	DDX_CBIndex(pDX, IDC_FPWAKECAT, m_nWakeCat);
	DDX_Text(pDX, IDC_FPEQUIPMENT, m_szEquipment);
	DDV_MaxChars(pDX, m_szEquipment, 6);
	DDX_CBIndex(pDX, IDC_FPSSR, m_nSSR);
	DDX_Text(pDX, IDC_FPDEPARTURE, m_szDeparture);
	DDV_MaxChars(pDX, m_szDeparture, 4);
	DDX_Text(pDX, IDC_FPTIME, m_nTime);
	DDV_MinMaxUInt(pDX, m_nTime, 0, 2359);
	DDX_Text(pDX, IDC_FPSPEED, m_szSpeed);
	DDV_MaxChars(pDX, m_szSpeed, 5);
	DDX_Text(pDX, IDC_FPLEVEL, m_szLevel);
	DDV_MaxChars(pDX, m_szLevel, 5);
	DDX_Text(pDX, IDC_FPROUTE, m_szRoute);
	DDV_MaxChars(pDX, m_szRoute, 256);
	DDX_Text(pDX, IDC_FPDESTINATION, m_szDestination);
	DDV_MaxChars(pDX, m_szDestination, 4);
	DDX_Text(pDX, IDC_FPTOTAL, m_nTotal);
	DDV_MinMaxUInt(pDX, m_nTotal, 0, 9959);
	DDX_Text(pDX, IDC_FPALTERNATE1, m_szAlternate1);
	DDV_MaxChars(pDX, m_szAlternate1, 4);
	DDX_Text(pDX, IDC_FPALTERNATE2, m_szAlternate2);
	DDV_MaxChars(pDX, m_szAlternate2, 4);
	DDX_Text(pDX, IDC_FPOTHERINFO, m_szOtherInfo);
	DDV_MaxChars(pDX, m_szOtherInfo, 256);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFlightPlanDlg, CDialog)
	//{{AFX_MSG_MAP(CFlightPlanDlg)
	ON_BN_CLICKED(IDC_FPSUPPLEMENT, OnSupplement)
	ON_BN_CLICKED(IDC_FPPREF, OnPreferences)
	ON_BN_CLICKED(IDC_FPACTUALIZE, OnActualize)
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFlightPlanDlg message handlers

/************************************************************************
 *  FlPlDlg.cpp				D i s a b l e C o n t r o l					*
 ************************************************************************/
void CFlightPlanDlg::DisableControl (int nID, BOOL bDisable)
{ 
CWnd* ptWnd = this->GetDlgItem (nID);	
ptWnd->EnableWindow (!bDisable);
}

/************************************************************************
 *  FlPlDlg.cpp						S e t D a t a						*
 ************************************************************************/
void CFlightPlanDlg::SetData ()
{
m_szIdent		= m_ptDoc->GetPlaneIdent();
m_nRules		= (short)m_ptDoc->GetFlightRules();
m_nFlightType	= (short)m_ptDoc->GetFlightType();

m_nNumber		= m_ptDoc->GetPlaneCnt ();
m_szPlaneType	= m_ptDoc->GetPlaneType ();
m_nWakeCat		= (short)m_ptDoc->GetWakeCat();
m_szEquipment	= m_ptDoc->GetEquipment();
m_nSSR			= (short)m_ptDoc->GetSSR();

m_szDeparture	= m_ptDoc->GetDeparture ();   
m_nTime			= m_ptDoc->GetTime ();  
      
m_szSpeed		= m_ptDoc->GetSpeed ();       
m_szLevel		= m_ptDoc->GetLevel ();       
m_szRoute		= m_ptDoc->GetRoute (); 
      
m_szDestination= m_ptDoc->GetDestination (); 
m_nTotal		= m_ptDoc->GetTotalEET ();  
m_szAlternate1	= m_ptDoc->GetAlternate1 ();  
m_szAlternate2	= m_ptDoc->GetAlternate2 (); 
 
m_szOtherInfo	= m_ptDoc->GetOtherInfo ();  

BOOL bAuto = (m_ptDoc->GetDataMode()==DATA_AUTOMATIC);
	
	
CString szMode;
szMode.LoadString (bAuto? IDS_AUTOMATIC : IDS_MANUALLY);
CString szText = m_szWndTitle + " - " + szMode;
this->SetWindowText (szText); 

this->DisableControl (IDC_FPACTUALIZE, bAuto);
}

/************************************************************************
 *  FlPlDlg.cpp			    O n I n i t D i a l o g						*
 ************************************************************************/
BOOL CFlightPlanDlg::OnInitDialog() 
{
this->GetWindowText(m_szWndTitle);
this->SetData ();
CDialog::OnInitDialog();
	
// TODO: Add extra initialization here
	
return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  FlPlDlg.cpp			    O n S u p p l e m e n t						*
 ************************************************************************/
void CFlightPlanDlg::OnSupplement() 
{
	// TODO: Add your control notification handler code here
CSupplementDlg SuppInfoDlg(this, m_ptDoc);
   
int RetVal = SuppInfoDlg.DoModal();

switch (RetVal)
	{
	case IDOK:   
		m_bSuppChanged = TRUE;
		break;
	case IDCANCEL:
		break;
	}	
	
}


/************************************************************************
 *  FlPlDlg.cpp					O n P r e f e r e n c e s				*
 ************************************************************************/
void CFlightPlanDlg::OnPreferences() 
{
	// TODO: Add your control notification handler code here
CFlPlPrefDlg PrefDlg(this, m_ptDoc);

DATAMODE OldMode = m_ptDoc->GetDataMode();
   
int RetVal = PrefDlg.DoModal();

switch (RetVal)
	{
	case IDOK:   
		if (m_ptDoc->GetDataMode() != OldMode)
			{
			m_bChangedToAutoMode = (m_ptDoc->GetDataMode()==DATA_AUTOMATIC);
			m_ptWayDoc->SetFlPlManual (m_ptDoc->GetDataMode()==DATA_MANUAL);
			m_ptDoc->Update (m_ptWayDoc);	// actualize FlPlDoc
			this->SetData();		// put data from FlPlDoc into dlg variables	 
			this->UpdateData (FALSE);  // show new dlg variables
			}
		break;					
	case IDCANCEL:
		break;
	}	
}

/************************************************************************
 *  FlPlDlg.cpp					O n A c t u a l i z e					*
 ************************************************************************/
void CFlightPlanDlg::OnActualize() 
{
	// TODO: Add your control notification handler code here
DATAMODE OldMode = m_ptDoc->GetDataMode();

m_ptDoc->SetDataMode(DATA_AUTOMATIC);
m_ptWayDoc->SetFlPlManual (FALSE);
m_ptDoc->Update (m_ptWayDoc);	// actualize FlPlDoc

// reset to old data mode
m_ptDoc->SetDataMode (OldMode);			// OldMode must be DATA_MANUAL
m_ptWayDoc->SetFlPlManual (m_ptDoc->GetDataMode()==DATA_MANUAL);

this->SetData();		// put data from FlPlDoc into dlg variables	 
this->UpdateData (FALSE);  // show new dlg variables
}


/************************************************************************
 *  FlPlDlg.cpp					I s C h a n g e d 						*
 ************************************************************************/
BOOL CFlightPlanDlg::IsChanged() 
{
if (m_bSuppChanged) return TRUE;

if (m_szIdent.Compare (m_ptDoc->GetPlaneIdent()) != 0) return TRUE;
if (m_nRules		!= (short)m_ptDoc->GetFlightRules()) return TRUE;
if (m_nFlightType	!= (short)m_ptDoc->GetFlightType()) return TRUE;

if (m_nNumber		!= m_ptDoc->GetPlaneCnt ()) return TRUE;
if (m_szPlaneType.Compare (m_ptDoc->GetPlaneType ()) != 0) return TRUE;
if (m_nWakeCat		!= (short)m_ptDoc->GetWakeCat()) return TRUE;
if (m_szEquipment.Compare (m_ptDoc->GetEquipment()) != 0) return TRUE;
if (m_nSSR			!= (short)m_ptDoc->GetSSR()) return TRUE;

if (m_szDeparture.Compare (m_ptDoc->GetDeparture ()) != 0) return TRUE;   
//if (m_nTime			!= m_ptDoc->GetTime ()) return TRUE;  
      
if (m_szSpeed.Compare (m_ptDoc->GetSpeed ()) != 0) return TRUE;       
if (m_szLevel.Compare (m_ptDoc->GetLevel ()) != 0) return TRUE;       
if (m_szRoute.Compare (m_ptDoc->GetRoute ()) != 0) return TRUE; 
      
if (m_szDestination.Compare (m_ptDoc->GetDestination ()) != 0) return TRUE; 
if (m_nTotal		!= m_ptDoc->GetTotalEET ()) return TRUE;  
if (m_szAlternate1.Compare (m_ptDoc->GetAlternate1 ()) != 0) return TRUE;  
if (m_szAlternate2.Compare (m_ptDoc->GetAlternate2 ()) != 0) return TRUE; 
 
if (m_szOtherInfo.Compare (m_ptDoc->GetOtherInfo ()) != 0) return TRUE; 

return FALSE;
}

/************************************************************************
 *  FlPlDlg.cpp					O n O K									*
 ************************************************************************/
void CFlightPlanDlg::OnOK() 
{
	// TODO: Add extra validation here

if (this->UpdateData(TRUE))
	{
	if (this->IsChanged() && !m_bChangedToAutoMode)
		{
		if (m_ptDoc->GetDataMode () == DATA_AUTOMATIC)
			{
			AfxMessageBox (IDS_FLIGHTPLAN_MANU);
			m_ptDoc->SetDataMode (DATA_MANUAL);
			}
		}

	m_ptDoc->SetPlaneIdent(m_szIdent);
	m_ptDoc->SetFlightRules((FLIGHTRULES)m_nRules);
	m_ptDoc->SetFlightType ((FLIGHTTYPE)m_nFlightType);

	m_ptDoc->SetPlaneCnt (m_nNumber);
	m_ptDoc->SetPlaneType (m_szPlaneType);
	m_ptDoc->SetWakeCat ((WAKETURBCAT)m_nWakeCat);
	m_ptDoc->SetEquipment (m_szEquipment);
	m_ptDoc->SetSSR ((SSRTYPE)m_nSSR);


	m_ptDoc->SetDeparture (m_szDeparture);
	m_ptDoc->SetTime(m_nTime);			  // not checked in IsChanged!!

	m_ptDoc->SetSpeed (m_szSpeed);
	m_ptDoc->SetLevel (m_szLevel);
	m_ptDoc->SetRoute (m_szRoute);

	m_ptDoc->SetDestination (m_szDestination);
	m_ptDoc->SetTotalEET (m_nTotal);
 	m_ptDoc->SetAlternate1 (m_szAlternate1);
	m_ptDoc->SetAlternate2 (m_szAlternate2);

	m_ptDoc->SetOtherInfo (m_szOtherInfo);

	CDialog::OnOK();
	}
}

/************************************************************************
 *  FlPlDlg.cpp	  				 O n H e l p I n f o					*
 ************************************************************************/
BOOL CFlightPlanDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}
