/************************************************************************
 *  							F l P l D o c . c p p  					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"  
#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"
#include "Calc.h"			// this statement must be after PlaneDoc.h

#include "WayDoc.h"



#include "FlPlDlg.h"				// dialog to set flight plan values
#include "SuppDlg.h"				// dialog to set supplementary information
#include "FlPlDoc.h"  

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


									// for updating flight plan
extern CInitDoc* 		ptInit;
extern CDimDoc* 		ptDim;      
extern CMetDoc*			ptMet;
extern CLoadDoc*		ptLoad; 
extern CCalcDoc*		ptCalc;
extern CPlaneDoc*		ptPlaneDoc;

/////////////////////////////////////////////////////////////////////////////
// CFlightPlanDoc
IMPLEMENT_DYNCREATE(CFlightPlanDoc, CDocument)

BEGIN_MESSAGE_MAP(CFlightPlanDoc, CDocument)
	//{{AFX_MSG_MAP(CFlightPlanDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFlightPlanDoc construction/destruction

/************************************************************************
 *  FlPlDoc.cpp	  		 	C F l i g h t P l a n D o c		Constructor	*
 ************************************************************************/
CFlightPlanDoc::CFlightPlanDoc(CString szFileName)
{      
m_ptDib = NULL;

m_szIdent.Empty();
m_Rules = FR_VFR;
m_FlightType = FT_GENERALAVIATION;

m_nNumber = 1;
m_szPlaneType.Empty();
m_WakeCat = WT_LIGHT;
m_szEquipment = "S";
m_SSR =	SS_MODE_A_C;

m_szDeparture.Empty();
m_nTime = 0;

m_szSpeed = "N 100";
m_szLevel = "VFR";
/*	CString	m_szRoute;
	CString	m_szDestinatiion;  */
m_nTotal = 0;
/* 	CString	m_szAlternate1;
	CString	m_szAlternate2;

	CString	m_szOtherInfo; */

										// Supplementary Information
m_nEndurance		= 0;
m_nPersonCnt		= 1;
m_bEmRadioUHF		= FALSE;
m_bEmRadioVHF		= FALSE;
m_bEmRadioELBA		= FALSE;

m_bEquipPolar		= FALSE;
m_bEquipDesert		= FALSE;
m_bEquipMaritime	= FALSE;
m_bEquipJungle		= FALSE;
m_bJacketsLight		= FALSE;
m_bJacketsFloures	= FALSE;
m_bJacketsUHF		= FALSE;
m_bJacketsVHF		= FALSE;

m_nDinghiesCnt		= 0;
m_nDinghiesCap		= 0;
m_bCover			= FALSE;

/*	CString	m_szDinghiesCol;
	CString	m_szPlaneCol;
	CString	m_szRemarks;
	CString	m_szPilot;
	CString m_szSignature;	  */

m_nSignMode = SIGN_TEXT;
/*	CString	m_szRem1;
	CString m_szRem2
	CString m_szRem3	*/

m_nDataMode = DATA_AUTOMATIC;
m_bUpdateRequired = FALSE;
m_nBackGroundCol = BKCOL_GRAY;


m_szDocFileName = ptInit->GetActualPath() + szFileName;   // C:\PF22\ScMapDoc.ini"

BOOL bAddToMRU = FALSE;
this->SetPathName (m_szDocFileName, bAddToMRU);
}


/************************************************************************
 *  FlPlDoc.cpp	  			~ C F l i g h t P l a n D o c	Destructor	*
 ************************************************************************/
CFlightPlanDoc::~CFlightPlanDoc()
{         
if (m_ptDib != NULL)
	{
	delete m_ptDib;
	m_ptDib = NULL;
	}
}

/************************************************************************
 *  FlPlDoc.cpp					F o r m a t								*
 ************************************************************************/
CString CFlightPlanDoc::Format (short nID, ...)
{
CString szFormat;
char	szBuffer[256];   

szFormat.LoadString (nID);
va_list ptArgs;
va_start(ptArgs, nID);
vsprintf (szBuffer, (LPCTSTR)szFormat, ptArgs);
va_end( ptArgs );

return (CString)szBuffer;
}

/************************************************************************
 *  FlPlDoc.cpp    			G e t F l P l S p e e d 					*
 ************************************************************************/
CString CFlightPlanDoc::GetFlPlSpeed (CPlane& Plane)
{
CString szSpeed;
char	cDim;
float	fConvSpeed;
short nSpeedDim = Plane.GetSpeedDim();
float fSpeed = Plane.GetCruiseSpeed();

if (nSpeedDim == DIM_KMH)
	{
	cDim = 'K';
	fConvSpeed = fSpeed;
	}
else{
	cDim = 'N';
	fConvSpeed = (float)ptDim->ConvertSpeed (fSpeed, nSpeedDim, DIM_KT);
	}

szSpeed = this->Format (IDF_FLPLSPEED, cDim, (int)(fSpeed + 0.5));
return szSpeed;
}

/************************************************************************
 *  FlPlDoc.cpp	  			    SetRouteParams							*
 ************************************************************************/
void CFlightPlanDoc::SetRouteParams (CWayDoc* ptWayDoc)
{
BOOL bManual = ptWayDoc->IsFlPlManual();
this->SetDataMode (bManual? DATA_MANUAL : DATA_AUTOMATIC);

if (bManual)
	{
	this->SetLevel(ptWayDoc->GetLevel());   
	this->SetRoute(ptWayDoc->GetRoute());   
	this->SetAlternate1(ptWayDoc->GetAlternate(1));
	this->SetAlternate2(ptWayDoc->GetAlternate(2));
	this->SetOtherInfo(ptWayDoc->GetOtherInfo());
	}
}

/************************************************************************
 *  FlPlDoc.cpp	  			     U p d a t e							*
 ************************************************************************/
void CFlightPlanDoc::Update (CWayDoc* ptWayDoc)
{
CString szRoute;
CString szOtherInfo;
CString szZZZZ;
szZZZZ.LoadString (IDS_ZZZZ);

if (ptWayDoc != NULL)
	{
	short i;
	CWayPoint WayPt, NextWpt;
	CString	szName, szIndic;

	short nCnt= ptWayDoc->GetWayPointCnt ();

	for (i=0; i<nCnt; i++)
		{
		ptWayDoc->GetWayPointPtr (i, &WayPt);
		if (i <nCnt-1)
			ptWayDoc->GetWayPointPtr (i+1, &NextWpt);

		szName = WayPt.GetName();
		szIndic = WayPt.GetIndicator();
		if (i==0)
			{
			if (szIndic.GetLength() == 0)
				{
				szIndic.LoadString (IDS_ZZZZ);
				szOtherInfo += " DEP/";
				szOtherInfo += szName;
				}
			this->SetDeparture (szIndic);
			}
		else if (i==nCnt-1)
			{
			if (szIndic.GetLength() == 0)
				{
				szIndic.LoadString (IDS_ZZZZ);
				szOtherInfo += " DEST/";
				szOtherInfo += szName;
				}
			this->SetDestination (szIndic);
			}
		else{
			szRoute += " ";

			if (NextWpt.IsUp())
				{
				short nSpeed_kt;
				long lAlt1, lAlt2;
				CString szUpName;

				if (szIndic.GetLength() != 0)
						 szUpName = szIndic;
					else szUpName = szName;

				nSpeed_kt = NextWpt.GetActIAS_kt();
				lAlt1 = WayPt.GetActAlt_ft();
				lAlt2 = NextWpt.GetActAlt_ft();
				szRoute += this->Format (IDF_FLPL_CLIMB, 
								(LPCTSTR)szUpName, nSpeed_kt, lAlt1/100, lAlt2/100);
				}
			else if (WayPt.IsUp())
				{
				CString szUpName;
				WayPt.CreateLatLonStr(&szUpName, LATLON_FLPL);
				szRoute += szUpName;
				}
			else if (WayPt.IsDown())
				{
				short nSpeed_kt;
				long lAlt1, lAlt2;
				CString szDownName;
				WayPt.CreateLatLonStr(&szDownName, LATLON_FLPL);
				nSpeed_kt = WayPt.GetActIAS_kt();
				lAlt1 = WayPt.GetActAlt_ft();
				lAlt2 = NextWpt.GetActAlt_ft();
				szRoute += this->Format (IDF_FLPL_DESC, 
								(LPCTSTR)szDownName, nSpeed_kt, lAlt1/100, lAlt2/100);
				}
			else{
				if (szIndic.GetLength() != 0)
						 szRoute += szIndic;
					else szRoute += szName;
				}
			}
		} // for ...

		// must be called for valid and invalid alternates
	this->SetAlternate1(ptWayDoc->GetAlternate(1));
	this->SetAlternate2(ptWayDoc->GetAlternate(2));

	if (ptPlaneDoc != NULL)
		{					 	// put data from plane into CFlightPlanDoc
		CPlane	ActPlane;
		short nIndex = ptPlaneDoc->GetActIndex();
		if (ptPlaneDoc->GetPlanePtr(nIndex, &ActPlane))
			{
			this->SetWakeCat (ActPlane.GetWakeCategory());
			this->SetSSR (ActPlane.GetSSRType());

			this->SetEmRadioUHF (ActPlane.HasEmRadioUHF()); 
			this->SetEmRadioVHF (ActPlane.HasEmRadioVHF()); 
			this->SetEmRadioELBA (ActPlane.HasEmRadioELBA());

 			this->SetPlaneIdent(ActPlane.GetIdent());

			CString szType = ActPlane.GetType();
			if (szType.GetLength() == 0 ||
				szZZZZ.Compare (szType) == 0)
				{
				szType.LoadString (IDS_ZZZZ);
				szOtherInfo += " TYP/????";
				}
			this->SetPlaneType (szType);

			this->SetEquipment (ActPlane.GetEquipment());
			this->SetPlaneCol (ActPlane.GetColor()); 

			this->SetSpeed (this->GetFlPlSpeed (ActPlane));



	  							/* do prepare calculations		*/
			CCalculate* ptLegs = ptWayDoc->GetCalculationPtr();
			ptLegs->Activate(&ActPlane);
			if (ptLegs->DoConsumCalc (&ActPlane, ptMet, ptLoad))
				{
	 			this->SetTotalEET (ptLegs->GetTotalEET ());
				this->SetEndurance (ptLegs->GetEndurance ());
				}
			else{
				CString szMsg;
				CONSUMTYPE* ptC = ptLegs->GetConsPtr();
				if (ptC->nBadRowLoad > 0)	
					{
					szMsg.Format (IDF_BAD_ROW_LOAD, ptC->nBadRowLoad);
					AfxMessageBox (szMsg);
					}
				if (ptC->nBadLugLoad > 0)	
					{
					szMsg.Format (IDF_BAD_LUG_LOAD, ptC->nBadLugLoad);
					AfxMessageBox (szMsg);
					}
				if (ptC->nBadFuelLoad > 0)	
					{
					szMsg.Format (IDF_BAD_FUEL_LOAD, ptC->nBadFuelLoad);
					AfxMessageBox (szMsg);
					}
				}
			ptLegs->DeActivate();
			}  // ActPlane OK
		}  // ptPlaneDoc != NULL
	} // ptWayDoc...

 		// put data from route into CFlightPlanDoc

if (szZZZZ.Compare (this->GetAlternate1()) == 0)
	szOtherInfo += " ALTN/????";
if (szZZZZ.Compare (this->GetAlternate2()) == 0)
	szOtherInfo += " ALTN/????";
	

/*	
this->SetTime(UINT uTime) { m_nTime = uTime; }	  // unknown take off time

this->SetLevel (CString szLev) { m_szLevel=szLev; }

this->SetAlternate1 (CString	szAlt) { m_szAlternate1=szAlt; }
this->SetAlternate2 (CString	szAlt) { m_szAlternate2=szAlt; }


*/



	



		// put data from weight&balance into CFlightPlanDoc
if (ptLoad != NULL)
	{
	this->SetPersonCnt (ptLoad->GetPersonCnt ());
	} 


/*
this->SetRemarks (CString szTxt);*/

this->SetRoute (szRoute);
this->SetOtherInfo (szOtherInfo);
this->SetPilot (ptInit->GetCustName());

if (ptWayDoc != NULL)		  // overwrite previous set route params
	this->SetRouteParams(ptWayDoc);
}

/************************************************************************
 *  FlPlDoc.cpp	  			S e t S i g n F i l e						*
 ************************************************************************/
void CFlightPlanDoc::SetSignFile (CString szFile) 
{ 
m_szSignFile = szFile;
       
//CString szName = "D:\\Cpp_Win\\PF40\\FlPlgrau.bmp";

CFile file;
if (file.Open((LPCTSTR)m_szSignFile, CFile::modeRead)) 
	{
	if (m_ptDib != NULL)
		{
		delete m_ptDib;
		m_ptDib = NULL;
		}

	m_ptDib = new CImage; 			// replace the view's DIB
	if (m_ptDib->Read(file)) 
		{
		}
	else{
		CString szMsg;
		szMsg.Format(IDF_BAD_BMP, (LPCTSTR)szFile);
		AfxMessageBox((LPCTSTR)szMsg);
		}

	file.Close();
	}
}

/************************************************************************
 *  FlPlDoc.cpp	  		 		 C h a n g e 							*
 ************************************************************************/
BOOL CFlightPlanDoc::Change(CWnd* ptWnd, CWayDoc* ptWayDoc)
{
BOOL bOK = FALSE;

CFlightPlanDlg FlPlDlg(ptWnd, this, ptWayDoc);
int RetVal = FlPlDlg.DoModal();
switch (RetVal)
	{
	case IDOK:   
	//	FlPlDlg.GetGpsSpec (this);    
 		ptWnd->InvalidateRect(NULL);
		bOK = TRUE;
		break;
	case IDCANCEL:
		break;
	}	
return bOK;
} 


/************************************************************************
 *  CalcDoc.cpp	  		 		 S e r i a l i z e 						*
 ************************************************************************/
void CFlightPlanDoc::Serialize(CArchive& ar)
{    
if (ar.IsStoring())
	{
		// TODO: add storing code here   
	ar << (WORD)m_Rules;
	ar << (WORD)m_FlightType;

	ar << m_nNumber;

	ar << (WORD)m_nTime;

	ar << m_szLevel;

 	ar << m_szAlternate1;
	ar << m_szAlternate2;

	ar << m_szOtherInfo;

										// Supplementary Information
	ar << m_bEquipPolar;
	ar << m_bEquipDesert;
	ar << m_bEquipMaritime;
	ar << m_bEquipJungle;

	ar << m_bJacketsLight;
	ar << m_bJacketsFloures;
	ar << m_bJacketsUHF;
	ar << m_bJacketsVHF;

	ar << (WORD)m_nDinghiesCnt;
	ar << (WORD)m_nDinghiesCap;
	ar << m_bCover;
	ar << m_szDinghiesCol;

	ar << m_szRemarks;

	ar << m_szPilot;
	ar << m_szSignature;

	ar << m_szSignFile;

	ar << m_szRem1;
	ar << m_szRem2;
	ar << m_szRem3;

									// preferences
	ar << (WORD)m_nBackGroundCol;
	ar << (WORD)m_nSignMode;
	}
else{
	WORD	Word;

	ar >> Word;		m_Rules = (FLIGHTRULES)Word;
	ar >> Word;		m_FlightType = (FLIGHTTYPE)Word;

	ar >> m_nNumber;

	ar >> Word;		m_nTime = (UINT)Word;

	ar >> m_szLevel;

 	ar >> m_szAlternate1;
	ar >> m_szAlternate2;

	ar >> m_szOtherInfo;

										// Supplementary Information
	ar >> m_bEquipPolar;
	ar >> m_bEquipDesert;
	ar >> m_bEquipMaritime;
	ar >> m_bEquipJungle;

	ar >> m_bJacketsLight;
	ar >> m_bJacketsFloures;
	ar >> m_bJacketsUHF;
	ar >> m_bJacketsVHF;

	ar >> Word;		m_nDinghiesCnt = (UINT)Word;
	ar >> Word;		m_nDinghiesCap = (UINT)Word;

	ar >> m_bCover;
	ar >> m_szDinghiesCol;

	ar >> m_szRemarks;

	ar >> m_szPilot;
	ar >> m_szSignature;

	ar >> m_szSignFile;

	ar >> m_szRem1;
	ar >> m_szRem2;
	ar >> m_szRem3;

									// preferences
	ar >> Word;		m_nBackGroundCol = (BKGNDCOLOR)Word;
	ar >> Word;		m_nSignMode = (SIGNMODE)Word;	 

	if (m_szSignFile.GetLength() > 0)
		{
		this->SetSignFile (m_szSignFile);
//		m_nSignMode = (m_ptDib != NULL)? SIGN_BMP : SIGN_TEXT;
		}

	}
}


 
