#ifndef __FLIGHTPLANDOC__
#define __FLIGHTPLANDOC__

#include "Plane.h"
#include "..\Cpptools\Image.h"

/************************************************************************
 *  							F l P l D o c . h 	 					*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

typedef enum	{
				FR_IFR,
				FR_VFR,
				FR_VFR_NIGHT,
				FR_VFR_FL100,
				FR_CVFR,
				FR_IFR_VFR,
				FR_VFR_IFR
				} FLIGHTRULES;


typedef enum	{
				FT_SHEDULED,
				FT_NONSHEDULED,
				FT_GENERALAVIATION,
				FT_MILITARY,
				FT_OTHER
				} FLIGHTTYPE;

typedef enum	{
				DATA_AUTOMATIC,
				DATA_MANUAL
				} DATAMODE;

typedef enum	{
				BKCOL_GRAY,
				BKCOL_WHITE
				} BKGNDCOLOR;

typedef enum	{
				SIGN_TEXT,
				SIGN_BMP
				} SIGNMODE;

class CWayDoc;
class CFlightPlanDoc : public CDocument
{ 
protected: // create from serialization only
	DECLARE_DYNCREATE(CFlightPlanDoc)

protected:   


// Attributes
public:                      
	CString		m_szDocFileName;               

	CString		m_szIdent;
	FLIGHTRULES	m_Rules;
	FLIGHTTYPE	m_FlightType;

	int		m_nNumber;
	CString	m_szPlaneType;
	WAKETURBCAT	m_WakeCat;
	CString	m_szEquipment;
	SSRTYPE	m_SSR;

	CString	m_szDeparture;
	UINT	m_nTime;

	CString	m_szSpeed;
	CString	m_szLevel;
	CString	m_szRoute;

	CString	m_szDestination;
	UINT	m_nTotal;
 	CString	m_szAlternate1;
	CString	m_szAlternate2;

	CString	m_szOtherInfo;

										// Supplementary Information
	UINT	m_nEndurance;
	UINT	m_nPersonCnt;
	BOOL	m_bEmRadioUHF;
	BOOL	m_bEmRadioVHF;
	BOOL	m_bEmRadioELBA;

	BOOL	m_bEquipPolar;
	BOOL	m_bEquipDesert;
	BOOL	m_bEquipMaritime;
	BOOL	m_bEquipJungle;
	BOOL	m_bJacketsLight;
	BOOL	m_bJacketsFloures;
	BOOL	m_bJacketsUHF;
	BOOL	m_bJacketsVHF;

	UINT	m_nDinghiesCnt;
	UINT	m_nDinghiesCap;
	BOOL	m_bCover;
	CString	m_szDinghiesCol;

	CString	m_szPlaneCol;

	CString	m_szRemarks;

	CString	m_szPilot;
	CString m_szSignature;

	CString m_szSignFile;
	CImage*	m_ptDib;

	CString	m_szRem1;
	CString	m_szRem2;
	CString	m_szRem3;

									// preferences
	DATAMODE    m_nDataMode;
	BOOL		m_bUpdateRequired;
	BKGNDCOLOR  m_nBackGroundCol;
	SIGNMODE	m_nSignMode;

	// Operations
public:
	CFlightPlanDoc(CString szFileName = "");	
	~CFlightPlanDoc();   

	CString	GetFullPath () { return m_szDocFileName; }

	CString GetFlPlSpeed (CPlane& Plane);

	void SetRouteParams (CWayDoc* ptWayDoc);

	void Update (CWayDoc* ptWayDoc);

	CString GetPlaneIdent() { return m_szIdent; }
	FLIGHTRULES GetFlightRules() { return m_Rules; }
	FLIGHTTYPE	GetFlightType() { return m_FlightType; }

	int GetPlaneCnt () { return m_nNumber; }
	CString	GetPlaneType () { return m_szPlaneType;	}
	WAKETURBCAT	GetWakeCat() { return m_WakeCat; }
	CString	GetEquipment() { return m_szEquipment;}
	SSRTYPE	GetSSR() { return m_SSR; }

	CString	GetDeparture () { return m_szDeparture; }
	UINT GetTime () { return m_nTime; }

	CString	GetSpeed () { return m_szSpeed; }
	CString	GetLevel () { return m_szLevel; }
	CString	GetRoute () { return m_szRoute; }

  	CString	GetDestination () { return m_szDestination; }
	UINT	GetTotalEET () { return m_nTotal; }
 	CString	GetAlternate1 () { return m_szAlternate1; }
	CString	GetAlternate2 () { return m_szAlternate2; }

	CString	GetOtherInfo () { return m_szOtherInfo; }


	UINT GetEndurance () { return m_nEndurance; }
	UINT GetPersonCnt () { return m_nPersonCnt; }
	BOOL IsEmRadioUHF () { return m_bEmRadioUHF; }
	BOOL IsEmRadioVHF () { return m_bEmRadioVHF; }
	BOOL IsEmRadioELBA () { return m_bEmRadioELBA; }

	BOOL IsEquipPolar () { return m_bEquipPolar; }
	BOOL IsEquipDesert () { return m_bEquipDesert; }
	BOOL IsEquipMaritime () { return m_bEquipMaritime; }
	BOOL IsEquipJungle () { return m_bEquipJungle; }
	BOOL IsJacketsLight () { return m_bJacketsLight; }
	BOOL IsJacketsFloures () { return m_bJacketsFloures; }
	BOOL IsJacketsUHF () { return m_bJacketsUHF; }
	BOOL IsJacketsVHF () { return m_bJacketsVHF; }

	UINT GetDinghiesCnt () { return m_nDinghiesCnt; }
	UINT GetDinghiesCap () { return m_nDinghiesCap; }
	BOOL IsDinghiesCover () { return m_bCover; }
	CString	GetDinghiesCol () { return m_szDinghiesCol; }

	CString	GetPlaneCol () { return m_szPlaneCol; }

	CString	GetRemarks () { return m_szRemarks; }

	CString	GetPilot () { return m_szPilot; }
	CString GetSignature () { return m_szSignature; }
	CString GetSignFile () { return m_szSignFile; }
	CImage*	GetDibPtr () { return m_ptDib; }

	CString	GetRem1 () { return m_szRem1; }
	CString	GetRem2 () { return m_szRem2; }
	CString	GetRem3 () { return m_szRem3; }

	void SetUpdateRequired (BOOL bReq) { m_bUpdateRequired = bReq; }
	BOOL IsUpdateRequired() { return m_bUpdateRequired; }
	DATAMODE GetDataMode () { return m_nDataMode; }
	BKGNDCOLOR  GetBkColor () { return m_nBackGroundCol; }
	SIGNMODE GetSignMode () { return m_nSignMode; }

	void SetPlaneIdent(CString szIdent) { m_szIdent = szIdent; }
	void SetFlightRules (FLIGHTRULES Rules) { m_Rules = Rules; }
	void SetFlightType (FLIGHTTYPE Type) { m_FlightType = Type;	}

   	void SetPlaneCnt (short nNum) {	m_nNumber = nNum; }
	void SetPlaneType (CString szType) { m_szPlaneType = szType; }
	void SetWakeCat (WAKETURBCAT Cat) {	m_WakeCat = Cat; }
	void SetEquipment (CString szEquip) { m_szEquipment = szEquip; }
	void SetSSR (SSRTYPE SSR) {	m_SSR = SSR; }

	void SetDeparture (CString szDep) { m_szDeparture = szDep; }
	void SetTime(UINT uTime) { m_nTime = uTime; }

	void SetSpeed (CString szSpd) { m_szSpeed=szSpd; }
	void SetLevel (CString szLev) { m_szLevel=szLev; }
	void SetRoute (CString szRte) { m_szRoute=szRte; }

	void SetDestination (CString szDest) { m_szDestination=szDest; }
	void SetTotalEET (UINT uTotal) { m_nTotal=uTotal; }
 	void SetAlternate1 (CString	szAlt) { m_szAlternate1=szAlt; }
	void SetAlternate2 (CString	szAlt) { m_szAlternate2=szAlt; }

	void SetOtherInfo (CString szInfo) { m_szOtherInfo=szInfo; }


   	void SetEndurance (UINT uEnd) { m_nEndurance=uEnd; }
	void SetPersonCnt (UINT	uCnt) { m_nPersonCnt=uCnt; }
	void SetEmRadioUHF (BOOL bSet) { m_bEmRadioUHF=bSet; }
	void SetEmRadioVHF (BOOL bSet) { m_bEmRadioVHF=bSet; }
	void SetEmRadioELBA (BOOL bSet) { m_bEmRadioELBA=bSet; }

	void SetEquipPolar (BOOL bSet) { m_bEquipPolar=bSet; }
	void SetEquipDesert (BOOL bSet) { m_bEquipDesert=bSet; }
	void SetEquipMaritime (BOOL bSet) { m_bEquipMaritime=bSet; }
	void SetEquipJungle (BOOL bSet) { m_bEquipJungle=bSet; }
	void SetJacketsLight (BOOL bSet) { m_bJacketsLight=bSet; }
	void SetJacketsFloures (BOOL bSet) { m_bJacketsFloures=bSet; }
	void SetJacketsUHF (BOOL bSet) { m_bJacketsUHF=bSet; }
	void SetJacketsVHF (BOOL bSet) { m_bJacketsVHF=bSet; }

	void SetDinghiesCnt (UINT uCnt) { m_nDinghiesCnt=uCnt; }
	void SetDinghiesCap (UINT uCap) { m_nDinghiesCap=uCap; }
	void SetDinghiesCover (BOOL bSet) { m_bCover=bSet; }
	void SetDinghiesCol (CString szCol) { m_szDinghiesCol=szCol; }
	
	void SetPlaneCol (CString szCol) { m_szPlaneCol=szCol; }

	void SetRemarks (CString szTxt) { m_szRemarks=szTxt; }

	void SetPilot (CString szName) { m_szPilot=szName; }
	void SetSignature (CString szSig) { m_szSignature = szSig; }
	void SetSignFile (CString szFile);		// see *.cpp 

	void SetRem1 (CString szTxt) { m_szRem1=szTxt; }
	void SetRem2 (CString szTxt) { m_szRem2=szTxt; }
	void SetRem3 (CString szTxt) { m_szRem3=szTxt; }

						 // called in: CWayDoc::DeleteContents
	void SetDataMode (DATAMODE Mode) { m_nDataMode = Mode; }

	void SetBkColor (BKGNDCOLOR Col) { m_nBackGroundCol = Col; }
	void SetSignMode (SIGNMODE Mode) { m_nSignMode = Mode; }

	BOOL Change (CWnd* ptWnd, CWayDoc* ptWayDoc);
	void Serialize(CArchive& ar);

private:
	CString Format (short nID, ...);     
	  
// Implementation
protected:          

	// Generated message map functions
protected:
	//{{AFX_MSG(CFlightPlanDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif 
