// FlPlView.cpp : implementation of the CFlPlView class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"  
#include "WayDoc.h"

#include "FlPlDoc.h"
#include "FlPlView.h"                                           

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;

extern CAppendixDoc*	ptAppend;  

extern CFlightPlanDoc*	ptFlPlDoc;
extern BOOL bMMText;

/////////////////////////////////////////////////////////////////////////////
// CFlPlView

IMPLEMENT_DYNCREATE(CFlPlView, CTextViewTool)

BEGIN_MESSAGE_MAP(CFlPlView, CTextViewTool)
	//{{AFX_MSG_MAP(CFlPlView)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTextViewTool::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTextViewTool::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFlPlView construction/destruction

CFlPlView::CFlPlView()
{
	// TODO: add construction code here

//int nProt = filebuf::openprot;	   // is equivalent to filebuf::sh_compat.
//m_ptLogFile=NULL;
//m_ptLogFile = (ofstream*)new ofstream("FlPlView.log", ios::out || ios::app, nProt);	  // schreibt alles neu
//*m_ptLogFile << "FlPlView Constructor" << "\n";


ptFontTool->GetParams (m_FontName, &m_wPointSize);

m_CharX = m_LineY = 0;
m_BCharX = m_BLineY = 0;
m_B10CharX = m_B10LineY = 0;
m_B14CharX = m_B14LineY = 0;
m_RCharX = m_RLineY = 0;

CreateNewFont(&m_PlainFont);
CreateBoldFont(&m_BoldFont);
CreateBoldFont(&m_BoldFont10Pt);
CreateBoldFont(&m_BoldFont14Pt);
CreateNewFont(&m_RectFont);
}

CFlPlView::~CFlPlView()
{
m_PlainFont.DeleteObject ();
m_BoldFont.DeleteObject ();
m_BoldFont10Pt.DeleteObject ();
m_BoldFont14Pt.DeleteObject ();
m_RectFont.DeleteObject ();
}

/************************************************************************
 *  FlPlView.cpp				U p d a t e F o n t s 					*
 ************************************************************************/
void CFlPlView::UpdateFonts (CDC* pDC)
{
long lHeight;

//ptFontTool->GetParams (m_FontName, &m_wPointSize);  // make font unchangeable
_fstrcpy ((LPSTR)m_FontName, (LPSTR)"Arial");
m_wPointSize = 8;


m_PlainFont.DeleteObject ();
CreateNewFont(&m_PlainFont);
this->GetCharSize (pDC, &m_PlainFont, &m_CharX, &m_LineY); 

		//	used to get fixed left margin and defined "max" char width
GetLeftMarginAndCharX_LP (m_wPointSize, &m_CharX);	// defines m_LeftMargin, m_CharX

m_BoldFont.DeleteObject ();
CreateBoldFont(&m_BoldFont);
this->GetCharSize (pDC, &m_BoldFont, &m_BCharX, &m_BLineY);  
	
						   
lHeight = POINT_SIZE_10;
m_BoldFont10Pt.DeleteObject ();
CreateSpecialFont (&m_BoldFont10Pt, "Arial", lHeight, TRUE); 
this->GetCharSize (pDC, &m_BoldFont10Pt, &m_B10CharX, &m_B10LineY); 

lHeight = POINT_SIZE_14;
m_BoldFont14Pt.DeleteObject ();
CreateSpecialFont (&m_BoldFont14Pt, "Arial", lHeight, TRUE); 
this->GetCharSize (pDC, &m_BoldFont14Pt, &m_B14CharX, &m_B14LineY); 

lHeight = POINT_SIZE_5;
m_RectFont.DeleteObject ();
CreateSpecialFont (&m_RectFont, "Arial", lHeight, FALSE); 
this->GetCharSize (pDC, &m_RectFont, &m_RCharX, &m_RLineY); 
}

/************************************************************************
 *  FlPlView.cpp		O n I n i t i a l U p d a t e					*
 * calls OnUpdate														*
 ************************************************************************/
void CFlPlView::OnInitialUpdate()
{
	CTextViewTool::OnInitialUpdate();
	// TODO: calculate the total size of this view


CDC* pDC = GetDC();    
//pDC->SetMapMode(MM_LOMETRIC);

//this->UpdateFonts (pDC);

ReleaseDC(pDC);     
}


/////////////////////////////////////////////////////////////////////////////
// CFlPlView drawing
/************************************************************************
 *  FlPlView.cpp   				  S e t X T a b s 						*
 ************************************************************************/
void CFlPlView::SetXTabs (CDC* pDC, CWayDoc* ptWayDoc, int CharX)
{
int X_TAB, LogPixXToUse, LogPixYToUse;
GetLogPixToUse(pDC, (int*)&LogPixXToUse, (int*)&LogPixYToUse);   
	
//X_TAB = (m_bForPrinter? 3 : 2)*CharX;
X_TAB = m_LeftMargin;
m_dY = LogPixYToUse;

int nStartY = 2*m_LineY;
int nStartX = X_TAB;
m_rMaxRect.SetRect (nStartX,nStartY, (int)(nStartX+FLPLWIDTH_LP), nStartY+FLPLHEIGHT_LP);

m_Xleft  = m_rMaxRect.left;
m_Xright = m_rMaxRect.right;
m_dX = m_Xright - m_Xleft;
}

/************************************************************************
 *  FlPlView.cpp    	 	     S e t L i n e T e x t					*
 ************************************************************************/
void CFlPlView::SetLineText (CDC* pDC, CString szText, short* ptOffs, 
									double dXleft, double dXright, double dYtop)
{
short i, nLastSpaceOffs, nLastCharOffs, nLastOffs, nLen, nOffs;
BOOL	bFree;
CString	szLineText;

bFree = TRUE;
if (ptOffs != NULL) nOffs = *ptOffs;
		else		nOffs = 0;

nLastSpaceOffs = nOffs;
nLastCharOffs = nOffs;
nLen = szText.GetLength();

if (nOffs < nLen)
	{
	for (i=nOffs; i<nLen && bFree; i++)
		{
		CSize	TextSize;
		short	nLenLP;
								  // get length of actual text
		szLineText = szText.Mid (nOffs, i-nOffs+1);
		TextSize = pDC->GetTextExtent(szLineText);
		nLenLP = (short)TextSize.cx;

		bFree = (nLenLP < (short)(dXright - dXleft));
		if (bFree)
			{
 			char ch = szText.GetAt(i);
			if (ch == ' ')
				{
				nLastSpaceOffs = i;
				}
			else{
				nLastCharOffs = i;
				}
			}
		}  

	if (bFree)
		{
		nLastOffs = nLastCharOffs+1;
		}
	else{
		nLastOffs = (nLastSpaceOffs > 0)? nLastSpaceOffs : nLastCharOffs+1;
		}

	if (nLastOffs > nOffs)
		{
	//	short nXleft= (int)(m_rMaxRect.left + dXleft) + m_B10CharX/3;
		short nXleft= (int)(m_rMaxRect.left + dXleft) + m_CharX/3;
		short nYtop	= (int)(m_rMaxRect.top + dYtop) + m_B10LineY/4;

		szLineText = szText.Mid (nOffs, nLastOffs-nOffs);
		TextAlignLeft (pDC, nXleft, nYtop, szLineText);

		if (ptOffs != NULL) *ptOffs = nLastOffs+1;
		}
	}
}

/************************************************************************
 *  FlPlView.cpp    	 	     S e t T e x t							*
 ************************************************************************/
void CFlPlView::SetText (CDC* pDC, double dXleft, double dYtop, CString szText, int XGrid)
{
	int i, nXleft, nYtop;

	//nXleft	= (int)(m_rMaxRect.left + dXleft) + m_B10CharX/3;
	nXleft	= (int)(m_rMaxRect.left + dXleft) + m_CharX/3;
	nYtop	= (int)(m_rMaxRect.top + dYtop) + m_B10LineY/4;

	if (XGrid > 0)
	{
	for (i=0; i<szText.GetLength(); i++)
		{
		CString szChar = szText.Mid(i, 1);
		TextAlignLeft (pDC, nXleft + (int)(i*XGrid), nYtop, szChar);
		}
	}
	else
	{
		TextAlignLeft (pDC, nXleft, nYtop, szText);
	}
}


/************************************************************************
 *  FlPlView.cpp    	 	 F l P l F o r m T e x t					*
 ************************************************************************/
void CFlPlView::FlPlFormText (CDC* pDC, double dXleft, double dYtop, CString szText)
{
this->SetText (pDC, dXleft, dYtop, szText, (int)X_GRID);
}


/************************************************************************
 *  FlPlView.cpp    	 	F l P l R o u t e T e x t					*
 ************************************************************************/
void CFlPlView::FlPlRouteText (CDC* pDC, CString szText)
{
short nOffs = 0;
short nLine;

for (nLine=0; nLine<=4; nLine++)
	{
	double dYtop = Y_HEADER_OFF+(8+nLine)*Y_GRID;
	SetLineText (pDC, szText, &nOffs, 
				((nLine==0)?14: 0)*X_GRID,
				((nLine==4)?34:38)*X_GRID, dYtop);
	}
}

/************************************************************************
 *  FlPlView.cpp    	 F l P l O t h e r I n f o T e x t				*
 ************************************************************************/
void CFlPlView::FlPlOtherInfoText (CDC* pDC, CString szText)
{
short nOffs = 0;
short nLine;

if (szText.GetLength() == 0)
	szText = "0";

for (nLine=0; nLine<=4; nLine++)
	{
	double dYtop = Y_OTHER+(0+nLine)*Y_GRID;
	SetLineText (pDC, szText, &nOffs, 
				((nLine==0)? 1: 0)*X_GRID,
				((nLine==4)?34:38)*X_GRID, dYtop);
	}
}

/************************************************************************
 *  FlPlView.cpp    	 		 L a r g e T e x t						*
 ************************************************************************/
void CFlPlView::LargeText (CDC* pDC, double dXleft, double dYtop, CString szText)
{
int i, nXleft, nYtop;
double	dX = m_B14CharX; //X_GRID;

nXleft	= (int)(m_rMaxRect.left + dXleft) + m_B14CharX/5;
nYtop	= (int)(m_rMaxRect.top + dYtop) + m_B14LineY/8;

CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont14Pt);

for (i=0; i<szText.GetLength(); i++)
	{
	CString szChar = szText.Mid(i, 1);
	TextAlignLeft (pDC, nXleft + (int)(i*dX), nYtop, szChar);
	}

pDC->SelectObject (ptOldFont);

}

/************************************************************************
 *  FlPlView.cpp    	 		 T r i p l e T e x t					*
 ************************************************************************/
void CFlPlView::TripleText (CDC* pDC, double dXleft, double dYtop, CString szText)
{
int i, nXleft, nYtop;
double	dX = X_GRID/2;
BOOL	bLinesDrawn = FALSE;

//nXleft	= (int)(m_rMaxRect.left + dXleft) + m_B10CharX/3;
nXleft	= (int)(m_rMaxRect.left + dXleft) + m_CharX/3;
nYtop	= (int)(m_rMaxRect.top + dYtop) + m_B10LineY/4;

CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont10Pt);

for (i=0; i<szText.GetLength(); i++)
	{
	CString szChar = szText.Mid(i, 1);

	if (szChar == '=')
		{
		if (!bLinesDrawn)
			{
			int dYmiddle = nYtop + m_B10LineY/2;
			int dYLine = m_B10LineY/4;
			double  dXLine = dX/2;

			pDC->MoveTo (nXleft + (int)(i*dX + dXLine), dYmiddle - dYLine);
			pDC->LineTo (nXleft + (int)((i+2)*dX - dXLine), dYmiddle - dYLine);

			pDC->MoveTo (nXleft + (int)(i*dX + dXLine), dYmiddle);
			pDC->LineTo (nXleft + (int)((i+2)*dX - dXLine), dYmiddle);

			pDC->MoveTo (nXleft + (int)(i*dX + dXLine), dYmiddle + dYLine);
			pDC->LineTo (nXleft + (int)((i+2)*dX - dXLine), dYmiddle + dYLine);

			bLinesDrawn = TRUE;
			}
		}
	else{
		TextAlignLeft (pDC, nXleft + (int)(i*dX), nYtop, szChar);
		}
	}

pDC->SelectObject (ptOldFont);

}

/************************************************************************
 *  FlPlView.cpp    	 		 A r r o w L i n e						*
 ************************************************************************/
void CFlPlView::ArrowLine (CDC* pDC, double dXleft, double dYtop, BOOL bRightArrow, BOOL bLeftArrow)
{
int nXleft, nYtop;
double	dX = X_GRID/2;

nXleft	= (int)(m_rMaxRect.left + dXleft);
nYtop	= (int)(m_rMaxRect.top + dYtop) + m_B10LineY/4;


int dYmiddle	= nYtop + m_B10LineY/2;
int dYLine		= m_B10LineY/4;
int dXStart		= nXleft + (int)(0.2*X_GRID);
int dXEnd		= nXleft + (int)(0.8*X_GRID);
int	dXArrow		= (int)(X_GRID/3);

pDC->MoveTo (dXStart, dYmiddle);
pDC->LineTo (dXEnd  , dYmiddle);

if (bRightArrow)
	{
//	CString szChar('>');
//	TextAlignLeft (pDC, nXleft + (int)(2*dX - dXLine), nYtop, szChar);

	pDC->MoveTo (dXEnd,			dYmiddle);
	pDC->LineTo (dXEnd-dXArrow, dYmiddle - dYLine);
	pDC->MoveTo (dXEnd,			dYmiddle);
	pDC->LineTo (dXEnd-dXArrow, dYmiddle + dYLine);
	}

if (bLeftArrow)
	{
//	CString szChar('<');
//	TextAlignLeft (pDC, nXleft + (int)(dXLine), nYtop, szChar);

	pDC->MoveTo (dXStart,		  dYmiddle);
	pDC->LineTo (dXStart+dXArrow, dYmiddle - dYLine);
	pDC->MoveTo (dXStart,		  dYmiddle);
	pDC->LineTo (dXStart+dXArrow, dYmiddle + dYLine);
	}
}

/************************************************************************
 *  FlPlView.cpp    		 F i e l d N u m b e r						*
 ************************************************************************/
void CFlPlView::FieldNumber (CDC* pDC, double dXleft, double dYtop, short nNumber)
{
int nXleft, nYtop;

nXleft	= (int)(m_rMaxRect.left + dXleft + X_GRID/2);	
nYtop	= (int)(m_rMaxRect.top + dYtop - 1.5*m_RLineY);
												//	m_RCharX, &m_RLineY
CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_RectFont);

CString szNumber;
szNumber = this->Format (IDF_D, nNumber);
TextAlignCenter (pDC, nXleft, nYtop, szNumber); 

pDC->SelectObject (ptOldFont);
}


/************************************************************************
 *  FlPlView.cpp    	  S u p p l e m e n t L a b e l s				*
 ************************************************************************/
void CFlPlView::SupplementLabels (CDC* pDC, double dYendurance)
{
int nXleft, nYtop;

nYtop	= (int)(m_rMaxRect.top + dYendurance);

CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_RectFont);

nXleft	= (int)(m_rMaxRect.left + 13*X_GRID);	// title
RsrcAlignLeft (pDC, (int)(nXleft + 0*X_GRID), nYtop - 4*m_RLineY, IDS_SUPPINFO); 

nXleft	= (int)(m_rMaxRect.left + 3*X_GRID);	// endurance
RsrcAlignCenter (pDC, (int)(nXleft + 1*X_GRID), nYtop - m_RLineY, IDS_HOUR); 
RsrcAlignCenter (pDC, (int)(nXleft + 3*X_GRID), nYtop - m_RLineY, IDS_MIN); 
RsrcAlignLeft (pDC, (int)(nXleft), nYtop - 2*m_RLineY, IDS_ENDURANCE_D); 
RsrcAlignLeft (pDC, (int)(nXleft), nYtop - 3*m_RLineY, IDS_ENDURANCE_E); 

nXleft	= (int)(m_rMaxRect.left + 31.5*X_GRID);	// emergency radio
RsrcAlignCenter (pDC, (int)(nXleft), nYtop - 2*m_RLineY, IDS_EMERGRADIO_D); 
RsrcAlignCenter (pDC, (int)(nXleft), nYtop - 3*m_RLineY, IDS_EMERGRADIO_E); 

nXleft	= (int)(m_rMaxRect.left + 1*X_GRID);	// survival equipment
nYtop	= (int)(m_rMaxRect.top + dYendurance + 2*Y_GRID);
RsrcAlignLeft (pDC, (int)(nXleft), nYtop - 1*m_RLineY, IDS_SURVEQUIP_D); 
RsrcAlignLeft (pDC, (int)(nXleft), nYtop - 2*m_RLineY, IDS_SURVEQUIP_E); 

nYtop	= (int)(m_rMaxRect.top + Y_SURVIVAL + 3*Y_GRID/4);
RsrcAlignLeft (pDC, (int)(nXleft), nYtop - 1*m_RLineY, IDS_DINGHIES); 

nXleft	= (int)(m_rMaxRect.left + 22*X_GRID);	// remarks not for transmission
nYtop	= (int)(m_rMaxRect.top + Y_SIGNATURE);
RsrcAlignLeft (pDC, (int)(nXleft), nYtop - 1*m_RLineY, IDS_REMARKS2_D); 
RsrcAlignLeft (pDC, (int)(nXleft), nYtop - 2*m_RLineY, IDS_REMARKS2_E); 

nXleft	= (int)(m_rMaxRect.left + 6.5*X_GRID);		// Signature of pilot
nYtop	= (int)(m_rMaxRect.top + Y_SIGNATURE + 1*Y_GRID_SIG);
RsrcAlignCenter (pDC, (int)(nXleft), nYtop - 1*m_RLineY, IDS_FILEDBY_D); 
RsrcAlignCenter (pDC, (int)(nXleft), nYtop - 2*m_RLineY, IDS_FILEDBY_E); 

nXleft	= (int)(m_rMaxRect.left + 17.5*X_GRID);		// Signature of pilot
RsrcAlignCenter (pDC, (int)(nXleft), nYtop - 1*m_RLineY, IDS_SIGNAIS_D); 
RsrcAlignCenter (pDC, (int)(nXleft), nYtop - 2*m_RLineY, IDS_SIGNAIS_E); 

pDC->SelectObject (ptOldFont);
}


/************************************************************************
 *  FlPlView.cpp    	 	 T o t a l E E T L a b e l					*
 ************************************************************************/
void CFlPlView::TotalEETLabel (CDC* pDC, double dXleft, double dYtop)
{
int nXleft, nYtop;

nXleft	= (int)(m_rMaxRect.left + dXleft);
nYtop	= (int)(m_rMaxRect.top + dYtop);

CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_RectFont);

RsrcAlignCenter (pDC, (int)(nXleft + 1*X_GRID), nYtop - m_RLineY, IDS_HOUR); 
RsrcAlignCenter (pDC, (int)(nXleft + 3*X_GRID), nYtop - m_RLineY, IDS_MIN); 

RsrcAlignCenter (pDC, (int)(nXleft + 2*X_GRID), nYtop - 2*m_RLineY, IDS_TOTAL_D); 
RsrcAlignCenter (pDC, (int)(nXleft + 2*X_GRID), nYtop - 3*m_RLineY, IDS_TOTAL_E); 

pDC->SelectObject (ptOldFont);
}


/************************************************************************
 *  FlPlView.cpp    	 		 F l P l L a b e l						*
 ************************************************************************/
void CFlPlView::FlPlLabel (CDC* pDC, double dXleft, double dYtop,
						short nRsrcID1, short nRsrcID2, short nRsrcID3)
{
int nXleft, nYtop;

nXleft	= (int)(m_rMaxRect.left + dXleft);
nYtop	= (int)(m_rMaxRect.top + dYtop);
 

if (nRsrcID1 > 0)
	{
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_RectFont);

	RsrcAlignLeft (pDC, nXleft, nYtop - m_RLineY, nRsrcID1);

	if (nRsrcID2 > 0)
		{
  		RsrcAlignLeft (pDC, nXleft, nYtop - 2*m_RLineY, nRsrcID2);
		if (nRsrcID3 > 0)
			{
  			RsrcAlignLeft (pDC, nXleft, nYtop - 3*m_RLineY, nRsrcID3);
			}
		}

	pDC->SelectObject (ptOldFont);
	}
}

/************************************************************************
 *  FlPlView.cpp    	 		 F l P l M a r k						*
 *  Input: bottom left position: dXleft, dYbottom						*
 ************************************************************************/
void CFlPlView::FlPlMark (CDC* pDC, double dXleft, double dYbottom)
{
double	dY;
int nXleft, nYtop, nXright, nYbottom;

dY		= (bMMText)? X_GRID : -X_GRID;			// height of ChkBox is X_GRID !!
nXleft	= (int)(m_rMaxRect.left + dXleft);
nYbottom= (int)(m_rMaxRect.top + dYbottom);
nXright	= (int)(nXleft + X_GRID);
nYtop	= (int)(m_rMaxRect.top + dYbottom - dY);			


short nThickLP = 5;			// 0.5 mm
CPen ThickPen (PS_SOLID, nThickLP, RGB(0,0,0));

CPen* ptOldPen = pDC->SelectObject (&ThickPen);

pDC->MoveTo	(nXleft, nYtop);
pDC->LineTo (nXright, nYbottom);
pDC->MoveTo (nXleft, nYbottom);
pDC->LineTo (nXright, nYtop);

pDC->SelectObject (ptOldPen);
}


/************************************************************************
 *  FlPlView.cpp    	 		 F l P l C h k B o x					*
 *  Input: bottom left position: dXleft, dYbottom						*
 ************************************************************************/
void CFlPlView::FlPlChkBox (CDC* pDC, double dXleft, double dYbottom, char cName,
						short nRsrcID1, short nRsrcID2)
{
double	dY;
int nXleft, nYtop, nXright, nYbottom;
CFont* ptOldFont;

dY		= (bMMText)? X_GRID : -X_GRID;			// height of ChkBox is X_GRID !!
nXleft	= (int)(m_rMaxRect.left + dXleft);
nYbottom= (int)(m_rMaxRect.top + dYbottom);
nXright	= (int)(nXleft + X_GRID);
nYtop	= (int)(m_rMaxRect.top + dYbottom - dY);			
 
CRect rField(nXleft, nYtop, nXright, nYbottom);

this->Rectangle(pDC, rField, RGB(255,255,255));		// frame of chkbox



													// contents of chkbox
CString szName("x");			// x: dummy name
szName.SetAt(0, cName);
if (bMMText)	dY = X_GRID + (Y_GRID - X_GRID) / 2;
	else		dY = -X_GRID + (Y_GRID + X_GRID) / 2;

nXleft	= (int)(m_rMaxRect.left + dXleft + X_GRID/2);

ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont10Pt);
TextAlignCenter (pDC, nXleft, (int)(m_rMaxRect.top + dYbottom-dY + m_B10LineY/4), szName);
pDC->SelectObject (ptOldFont);

													// titles of chkbox
ptOldFont = (CFont*)pDC->SelectObject (&m_RectFont);
if (nRsrcID1 > 0)								// first title of chkbox
	RsrcAlignCenter (pDC, nXleft, nYtop - m_RLineY, nRsrcID1);
if (nRsrcID2 > 0)							// second title of chkbox
  	RsrcAlignCenter (pDC, nXleft, nYtop - 2*m_RLineY, nRsrcID2);
pDC->SelectObject (ptOldFont);
}

/************************************************************************
 *  FlPlView.cpp    	 	F l P l W h i t e R e c t					*
 *  Input: top left position: dXleft, dYtop								*
 ************************************************************************/
void CFlPlView::FlPlWhiteRect (CDC* pDC, double dXleft, double dYtop, 
										double dXright, double dYbottom)
{
int nXleft, nYtop, nXright, nYbottom;

nXleft	= (int)(m_rMaxRect.left + dXleft);
nYtop	= (int)(m_rMaxRect.top + dYtop);
nXright	= (int)(m_rMaxRect.left + dXright);
nYbottom= (int)(m_rMaxRect.top + dYbottom);
 
CRect rField(nXleft, nYtop, nXright, nYbottom);

this->Rectangle(pDC, rField, RGB(255,255,255));
}


/************************************************************************
 *  FlPlView.cpp    	 		 F l P l R e c t						*
 *  Input: top left position: dXleft, dYtop								*
 ************************************************************************/
void CFlPlView::FlPlRect (CDC* pDC, double dXleft, double dYtop, double dXright, 
						BOOL bWhite, BOOL bScale, 
						short nRsrcID1, short nRsrcID2, short nRsrcID3)
{
int nXleft, nYtop, nXright, nYbottom;

nXleft	= (int)(m_rMaxRect.left + dXleft);
nYtop	= (int)(m_rMaxRect.top + dYtop);
nXright	= (int)(m_rMaxRect.left + dXright);
nYbottom= (int)(m_rMaxRect.top + dYtop + Y_GRID);
 
CRect rField(nXleft, nYtop, nXright, nYbottom);

if (bWhite)
	{
	this->Rectangle(pDC, rField, RGB(255,255,255));
	}
else{
	this->Rectangle(pDC, rField);
	}

if (bScale)
	{
	POINT Pt;

   	Pt.x = 1;
   	Pt.y = 1;
	pDC->DPtoLP (&Pt);							// Weil Rect.bottom nicht bis bottom malt:
															// Skalierungsstrich um
	double x;												// 1/2 mm nach oben verschieben!
	int	nBottom = nYbottom + 0;				// screen: 5, printer: 5 
	for (x=nXleft+X_GRID; x < nXright-X_GRID/2; x+=X_GRID)
		{
		pDC->MoveTo ((int)x, nBottom);
		pDC->LineTo ((int)x, nBottom+8);
		}
	}

if (nRsrcID1 > 0)
	{
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_RectFont);

	RsrcAlignLeft (pDC, nXleft, nYtop - m_RLineY, nRsrcID1);

	if (nRsrcID2 > 0)
		{
  		RsrcAlignLeft (pDC, nXleft, nYtop - 2*m_RLineY, nRsrcID2);
		if (nRsrcID3 > 0)
			{
  			RsrcAlignLeft (pDC, nXleft, nYtop - 3*m_RLineY, nRsrcID3);
			}
		}

	pDC->SelectObject (ptOldFont);
	}
}


/************************************************************************
 *  FlPlView.cpp    	 	 D r a w F o r m u l a r					*
 ************************************************************************/
void CFlPlView::DrawFormular (CDC* pDC)
{
int	nY;
CString szText;
CFont* ptOldFont;
COLORREF col;
BOOL bBundesrepublik = FALSE;

CBrush* ptOldBrush = (CBrush*)pDC->SelectStockObject (LTGRAY_BRUSH); 

if (pDC->IsPrinting() && ptFlPlDoc->GetBkColor () == BKCOL_WHITE)
		col = RGB(255,255,255);
else	col = RGB(220,220,220);
this->Rectangle(pDC, m_rMaxRect, col);
pDC->SelectObject (ptOldBrush);

pDC->SetBkMode (TRANSPARENT);

if (bBundesrepublik)									// Bold Text:
	{
	ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);
	nY = (int)(m_rMaxRect.top + m_BLineY/2);
	this->RsrcAlignLeft (pDC, (int)(m_Xleft+X_GRID), nY, IDS_BUNDESREP);
	this->RsrcAlignLeft (pDC, (int)(m_Xleft+X_GRID), nY + m_BLineY, IDS_DEUTSCHLAND);
	pDC->SelectObject (ptOldFont);
	}

ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont14Pt);
nY = (int)(m_rMaxRect.top + 3*m_B14LineY/4);
this->RsrcAlignCenter (pDC, (int)(m_Xleft+19*X_GRID), nY, IDS_FLPLAN_EDF);
pDC->SelectObject (ptOldFont);
							   
this->DrawHorzLine(pDC, m_rMaxRect.top + Y_HEADER_ON);		// header, not to fill from user
this->TripleText (pDC, X_GRID, Y_HEADER_ON, "<<==FF");
this->ArrowLine (pDC, 4.3*X_GRID, Y_HEADER_ON, TRUE, FALSE);		// arrow: right
this->TripleText (pDC, 35*X_GRID, Y_HEADER_ON+2*Y_GRID, "<<==");

															  // white, scale
this->FlPlRect (pDC, 10*X_GRID, Y_HEADER_ON+0*Y_GRID, 38*X_GRID, FALSE, FALSE);
this->FlPlRect (pDC, 6*X_GRID, Y_HEADER_ON+1*Y_GRID, 38*X_GRID, FALSE, FALSE, 
						IDS_ADDRESS_D, IDS_ADDRESS_E);
this->FlPlRect (pDC, 6*X_GRID, Y_HEADER_ON+2*Y_GRID, 34*X_GRID, FALSE, FALSE);

this->FlPlLabel (pDC, 1*X_GRID, Y_FILING_TIME, IDS_FILING_D, IDS_FILING_E);
this->FlPlRect (pDC, 0*X_GRID, Y_FILING_TIME, 2*X_GRID, FALSE, TRUE);
this->FlPlRect (pDC, 2*X_GRID, Y_FILING_TIME, 6*X_GRID, FALSE, TRUE);
this->ArrowLine (pDC, 6*X_GRID, Y_FILING_TIME, TRUE, FALSE);		// arrow: right

this->FlPlRect (pDC, 7*X_GRID, Y_FILING_TIME, 15*X_GRID, FALSE, TRUE, 
								IDS_ORIGINA_D, IDS_ORIGINA_E);
this->TripleText (pDC, 16*X_GRID, Y_FILING_TIME, "<<==");

this->FlPlLabel (pDC, 1*X_GRID, Y_HEADER_OFF, IDS_SPECIFI_D, IDS_SPECIFI_E);

this->DrawHorzLine(pDC, m_rMaxRect.top + Y_HEADER_OFF);

												// aircraft identification ...
this->DrawHorzLine(pDC, (int)(m_rMaxRect.top + Y_HEADER_OFF+Y_GRID));
this->TripleText (pDC, X_GRID, Y_HEADER_OFF+1.7*Y_GRID, "<<==(FPL");
this->ArrowLine (pDC, 10*X_GRID, Y_HEADER_OFF+2*Y_GRID, FALSE, FALSE);	// line only
this->ArrowLine (pDC, 24*X_GRID, Y_HEADER_OFF+2*Y_GRID, FALSE, FALSE);	// line only

																 // white, scale
this->FieldNumber (pDC, 10*X_GRID, Y_HEADER_OFF+2*Y_GRID, 7);
this->FlPlRect (pDC, 11*X_GRID, Y_HEADER_OFF+2*Y_GRID, 18*X_GRID, TRUE, TRUE, 
						IDS_IDENTIF_D, IDS_IDENTIF_E);
this->FieldNumber (pDC, 24*X_GRID, Y_HEADER_OFF+2*Y_GRID, 8);
this->FlPlRect (pDC, 25*X_GRID, Y_HEADER_OFF+2*Y_GRID, 27*X_GRID, TRUE, FALSE, 
						IDS_FLRULES_D, IDS_FLRULES_E);
this->FlPlLabel (pDC,32*X_GRID, Y_HEADER_OFF+2*Y_GRID, IDS_FLTYPE_D, IDS_FLTYPE_E);
this->FlPlRect (pDC, 33*X_GRID, Y_HEADER_OFF+2*Y_GRID, 34*X_GRID, TRUE, FALSE);

this->TripleText (pDC, 35*X_GRID, Y_HEADER_OFF+2*Y_GRID, "<<==");


this->ArrowLine (pDC, 1*X_GRID, Y_HEADER_OFF+4*Y_GRID, FALSE, FALSE);	// line only
this->ArrowLine (pDC,27*X_GRID, Y_HEADER_OFF+4*Y_GRID, FALSE, FALSE);	// line only
this->LargeText (pDC, 21*X_GRID, Y_HEADER_OFF+4*Y_GRID, "/");


this->FieldNumber (pDC, 1*X_GRID, Y_HEADER_OFF+4*Y_GRID, 9);
															 // white, scale
this->FlPlRect (pDC, 2*X_GRID, Y_HEADER_OFF+4*Y_GRID, 4*X_GRID, TRUE, TRUE, 
						IDS_NUMBER_D, IDS_NUMBER_E);
this->FlPlRect (pDC, 9*X_GRID, Y_HEADER_OFF+4*Y_GRID, 13*X_GRID, TRUE, TRUE, 
						IDS_PLANETYPE_D, IDS_PLANETYPE_E);

this->FlPlLabel (pDC,19*X_GRID, Y_HEADER_OFF+4*Y_GRID, IDS_WAKECAT_D, IDS_WAKECAT_E);
this->FlPlRect (pDC, 22*X_GRID, Y_HEADER_OFF+4*Y_GRID, 23*X_GRID, TRUE, FALSE);
this->FieldNumber (pDC, 27*X_GRID, Y_HEADER_OFF+4*Y_GRID, 10);
this->FlPlRect (pDC, 28*X_GRID, Y_HEADER_OFF+4*Y_GRID, 34*X_GRID, TRUE, FALSE, 
						IDS_EQUIPMENT_D, IDS_EQUIPMENT_E);

this->TripleText (pDC, 35*X_GRID, Y_HEADER_OFF+4*Y_GRID, "<<==");
						

this->ArrowLine (pDC, 4*X_GRID, Y_HEADER_OFF+6*Y_GRID, FALSE, FALSE);	// line only
												// departure aerodrome ...
this->FieldNumber (pDC, 4*X_GRID, Y_HEADER_OFF+6*Y_GRID, 13);
															// white, scale
this->FlPlRect (pDC, 5*X_GRID, Y_HEADER_OFF+6*Y_GRID, 9*X_GRID, TRUE, TRUE, 
						IDS_DEPARTURE_D, IDS_DEPARTURE_E);
this->FlPlRect (pDC, 14*X_GRID, Y_HEADER_OFF+6*Y_GRID, 18*X_GRID, TRUE, TRUE, 
						IDS_TIME_D, IDS_TIME_E);

this->TripleText (pDC, 19*X_GRID, Y_HEADER_OFF+6*Y_GRID, "<<==");

this->ArrowLine (pDC, 0*X_GRID, Y_HEADER_OFF+8*Y_GRID, FALSE, FALSE);	// line only
this->ArrowLine (pDC, 12.5*X_GRID, Y_HEADER_OFF+8*Y_GRID, TRUE, FALSE);	// right arrow

this->FieldNumber (pDC, 0*X_GRID, Y_HEADER_OFF+8*Y_GRID, 15);
this->FlPlRect (pDC, 1*X_GRID, Y_HEADER_OFF+8*Y_GRID, 6*X_GRID, TRUE, TRUE, 
						IDS_SPEED_D, IDS_SPEED_E);
this->FlPlRect (pDC, 7*X_GRID, Y_HEADER_OFF+8*Y_GRID, 12*X_GRID, TRUE, TRUE, 
						IDS_LEVEL_D, IDS_LEVEL_E);
this->FlPlRect (pDC, 14*X_GRID, Y_HEADER_OFF+8*Y_GRID, 38*X_GRID, TRUE, FALSE, 
						IDS_ROUTE_D, IDS_ROUTE_E);

this->FlPlRect (pDC, 0*X_GRID, Y_HEADER_OFF+ 9*Y_GRID, 38*X_GRID, TRUE, FALSE);
this->FlPlRect (pDC, 0*X_GRID, Y_HEADER_OFF+10*Y_GRID, 38*X_GRID, TRUE, FALSE);
this->FlPlRect (pDC, 0*X_GRID, Y_HEADER_OFF+11*Y_GRID, 38*X_GRID, TRUE, FALSE);
this->FlPlRect (pDC, 0*X_GRID, Y_HEADER_OFF+12*Y_GRID, 34*X_GRID, TRUE, FALSE);
this->TripleText (pDC, 35*X_GRID, Y_HEADER_OFF+12*Y_GRID, "<<==");


												// destination aerodrome ...
this->ArrowLine (pDC,3*X_GRID, Y_DEST+0*Y_GRID, FALSE, FALSE);	// line only	

this->FieldNumber (pDC, 3*X_GRID, Y_DEST+0*Y_GRID, 16);
														// white, scale
this->FlPlRect (pDC, 4*X_GRID, Y_DEST+0*Y_GRID, 8*X_GRID, TRUE, TRUE, 
						IDS_DESTINATION_D, IDS_DESTINATION_E);

this->TotalEETLabel (pDC, 13*X_GRID, Y_DEST+0*Y_GRID);
this->FlPlRect (pDC, 13*X_GRID, Y_DEST+0*Y_GRID, 15*X_GRID, TRUE, TRUE);
this->FlPlRect (pDC, 15*X_GRID, Y_DEST+0*Y_GRID, 17*X_GRID, TRUE, TRUE);

this->ArrowLine (pDC,21*X_GRID, Y_DEST+0*Y_GRID, TRUE, FALSE);		// arrow: right
this->FlPlRect (pDC, 22*X_GRID, Y_DEST+0*Y_GRID, 26*X_GRID, TRUE, TRUE, 
						IDS_ALTERNATE1_D, IDS_ALTERNATE1_E);

this->ArrowLine (pDC,29*X_GRID, Y_DEST+0*Y_GRID, TRUE, FALSE);		// arrow: right
this->FlPlRect (pDC, 30*X_GRID, Y_DEST+0*Y_GRID, 34*X_GRID, TRUE, TRUE, 
						IDS_ALTERNATE2_D, IDS_ALTERNATE2_E);
this->TripleText (pDC, 35*X_GRID, Y_DEST+0*Y_GRID, "<<==");

												// other information ...
this->FieldNumber (pDC, 0*X_GRID, Y_OTHER+0*Y_GRID, 18);
														// white, scale
this->FlPlRect (pDC, 1*X_GRID, Y_OTHER+0*Y_GRID, 38*X_GRID, TRUE, FALSE, 
						IDS_OTHERINFO_D, IDS_OTHERINFO_E);
this->FlPlRect (pDC, 0*X_GRID, Y_OTHER+1*Y_GRID, 38*X_GRID, TRUE, FALSE); 
this->FlPlRect (pDC, 0*X_GRID, Y_OTHER+2*Y_GRID, 38*X_GRID, TRUE, FALSE); 
this->FlPlRect (pDC, 0*X_GRID, Y_OTHER+3*Y_GRID, 38*X_GRID, TRUE, FALSE); 
this->FlPlRect (pDC, 0*X_GRID, Y_OTHER+4*Y_GRID, 34*X_GRID, TRUE, FALSE); 
this->TripleText (pDC, 35*X_GRID, Y_OTHER+4*Y_GRID, ")<<==");

this->DrawHorzLine(pDC, (int)(m_rMaxRect.top + Y_OTHER+5*Y_GRID));


												// supplementary information ...
this->SupplementLabels (pDC, Y_ENDUR);

this->ArrowLine (pDC,0*X_GRID, Y_ENDUR+0*Y_GRID, FALSE, FALSE);	// line only
this->LargeText (pDC,1*X_GRID, Y_ENDUR+0*Y_GRID, "E/");	

this->FieldNumber (pDC, 0*X_GRID, Y_ENDUR+0*Y_GRID, 19);
														// white, scale
this->FlPlRect (pDC, 3*X_GRID, Y_ENDUR+0*Y_GRID, 5*X_GRID, TRUE, TRUE);
this->FlPlRect (pDC, 5*X_GRID, Y_ENDUR+0*Y_GRID, 7*X_GRID, TRUE, TRUE);
this->ArrowLine (pDC, 9*X_GRID, Y_ENDUR+0*Y_GRID, TRUE, FALSE);	// right arrow
this->LargeText (pDC,10*X_GRID, Y_ENDUR+0*Y_GRID, "P/");	
this->FlPlRect (pDC, 12*X_GRID, Y_ENDUR+0*Y_GRID, 15*X_GRID, TRUE, TRUE, 
						IDS_PERSCNT_D, IDS_PERSCNT_E);

this->ArrowLine (pDC, 25*X_GRID, Y_ENDUR+0*Y_GRID, TRUE, FALSE);	// right arrow
this->LargeText (pDC, 26*X_GRID, Y_ENDUR+0*Y_GRID, "R/");	
												// emergency radio
this->FlPlChkBox (pDC, 28*X_GRID, Y_ENDUR+1*Y_GRID, 'U', IDS_UHF);
this->FlPlChkBox (pDC, 31*X_GRID, Y_ENDUR+1*Y_GRID, 'V', IDS_VHF);
this->FlPlChkBox (pDC, 34*X_GRID, Y_ENDUR+1*Y_GRID, 'E', IDS_ELBA);

												// survival equipment
this->ArrowLine (pDC, 1*X_GRID, Y_SURVIVAL - Y_GRID, TRUE, FALSE);	// right arrow
this->FlPlChkBox (pDC, 3*X_GRID, Y_SURVIVAL, 'S');
this->LargeText (pDC,4.5*X_GRID, Y_SURVIVAL - Y_GRID, "/");	
this->FlPlChkBox (pDC, 6*X_GRID, Y_SURVIVAL, 'P', IDS_POLAR);
this->FlPlChkBox (pDC, 9*X_GRID, Y_SURVIVAL, 'D', IDS_DESERT);
this->FlPlChkBox (pDC,12*X_GRID, Y_SURVIVAL, 'M', IDS_MARITIME);
this->FlPlChkBox (pDC,15*X_GRID, Y_SURVIVAL, 'J', IDS_JUNGLE);

												// jackets
this->ArrowLine (pDC, 21*X_GRID, Y_SURVIVAL - Y_GRID, TRUE, FALSE);	// right arrow
this->FlPlChkBox (pDC,22*X_GRID, Y_SURVIVAL, 'J', IDS_JACKETS_D, IDS_JACKETS_E);
this->LargeText (pDC,23.5*X_GRID, Y_SURVIVAL - Y_GRID, "/");	
this->FlPlChkBox (pDC,25*X_GRID, Y_SURVIVAL, 'L', IDS_LIGHT);
this->FlPlChkBox (pDC,28*X_GRID, Y_SURVIVAL, 'F', IDS_FLOURES);
this->FlPlChkBox (pDC,31*X_GRID, Y_SURVIVAL, 'U', IDS_UHF);
this->FlPlChkBox (pDC,34*X_GRID, Y_SURVIVAL, 'V', IDS_VHF);

												// dinghies
this->ArrowLine (pDC, 0*X_GRID, Y_DINGHIES, TRUE, FALSE);	// right arrow
this->FlPlChkBox (pDC,1*X_GRID, Y_DINGHIES+Y_GRID, 'D');
this->LargeText (pDC,2*X_GRID, Y_DINGHIES, "/");	
															// white, scale
this->FlPlRect (pDC, 3*X_GRID, Y_DINGHIES+0*Y_GRID, 5*X_GRID, TRUE, TRUE, 
						IDS_NUMBER_D, IDS_NUMBER_E);
this->ArrowLine (pDC, 5*X_GRID, Y_DINGHIES, TRUE, FALSE);	// right arrow
this->FlPlRect (pDC, 6*X_GRID, Y_DINGHIES+0*Y_GRID, 9*X_GRID, TRUE, TRUE, 
						IDS_CAPACITY_D, IDS_CAPACITY_E);

this->ArrowLine (pDC, 9*X_GRID, Y_DINGHIES, TRUE, FALSE);	// right arrow
this->FlPlChkBox (pDC,10*X_GRID, Y_DINGHIES+Y_GRID, 'C', 0, IDS_COVER);
this->ArrowLine (pDC, 11*X_GRID, Y_DINGHIES, TRUE, FALSE);	// right arrow
this->FlPlRect (pDC,12*X_GRID, Y_DINGHIES+0*Y_GRID, 21*X_GRID, TRUE, FALSE, 
						IDS_COLOR_D, IDS_COLOR_E);
this->TripleText (pDC, 22*X_GRID, Y_DINGHIES+0*Y_GRID, "<<==");


												// Aircraft color...
this->LargeText (pDC,1*X_GRID, Y_DINGHIES+2*Y_GRID, "A");	
this->LargeText (pDC,2*X_GRID, Y_DINGHIES+2*Y_GRID, "/");	
															// white, scale
this->FlPlRect (pDC, 3*X_GRID, Y_DINGHIES+2*Y_GRID, 38*X_GRID, TRUE, FALSE, 
						IDS_PLANECOL_D, IDS_PLANECOL_E);

this->FlPlChkBox (pDC,1*X_GRID, Y_DINGHIES+5*Y_GRID, 'N');
this->LargeText (pDC,2*X_GRID, Y_DINGHIES+4*Y_GRID, "/");	
this->FlPlRect (pDC, 3*X_GRID, Y_DINGHIES+4*Y_GRID, 34*X_GRID, TRUE, FALSE, 
						IDS_REMARKS_D, IDS_REMARKS_E);
this->TripleText (pDC, 35*X_GRID, Y_DINGHIES+4*Y_GRID, "<<==");


this->LargeText (pDC,1*X_GRID, Y_DINGHIES+6*Y_GRID, "C");	
this->LargeText (pDC,2*X_GRID, Y_DINGHIES+6*Y_GRID, "/");	
this->FlPlRect (pDC, 3*X_GRID, Y_DINGHIES+6*Y_GRID, 21*X_GRID, TRUE, FALSE, 
						IDS_PILOT_D, IDS_PILOT_E);
this->TripleText (pDC, 22*X_GRID, Y_DINGHIES+6*Y_GRID, ")<<==");



this->DrawHorzLine(pDC, (int)(m_rMaxRect.top + Y_SIGNATURE+0*Y_GRID_SIG));
this->FlPlWhiteRect (pDC, 22*X_GRID, Y_SIGNATURE, 38*X_GRID, Y_SIGNATURE+1*Y_GRID_SIG);
this->DrawHorzLine(pDC, (int)(m_rMaxRect.top + Y_SIGNATURE+1*Y_GRID_SIG));
this->FlPlWhiteRect (pDC, 22*X_GRID, Y_SIGNATURE+1*Y_GRID_SIG, 38*X_GRID, Y_SIGNATURE+2*Y_GRID_SIG);
this->FlPlWhiteRect (pDC, 22*X_GRID, Y_SIGNATURE+2*Y_GRID_SIG, 38*X_GRID, Y_SIGNATURE+3*Y_GRID_SIG);

this->FlPlWhiteRect (pDC, 0*X_GRID, Y_SIGNATURE+1*Y_GRID_SIG, 22*X_GRID, Y_SIGNATURE+3*Y_GRID_SIG);
pDC->MoveTo ((int)(m_rMaxRect.left + 13*X_GRID), (int)(m_rMaxRect.top + Y_SIGNATURE));
pDC->LineTo ((int)(m_rMaxRect.left + 13*X_GRID), (int)(m_rMaxRect.top + Y_SIGNATURE+3*Y_GRID_SIG));

pDC->SetBkMode (OPAQUE);
}
										   	

/************************************************************************
 *  FlPlView.cpp    	 	 D r a w F l i g h t P l a n				*
 ************************************************************************/
BOOL CFlPlView::DrawFlightPlan (CDC* pDC, CWayDoc* ptWayDoc, 
						DWORD* ptIndex, BOOL bDraw)
{
BOOL	bEndOfPage = FALSE;
CString szText;

ActivateDrawing (bDraw);

if (bDraw)	
	{
	DrawFormular (pDC);
	}


if (bDraw)	
	{
	if (ptFlPlDoc->GetDataMode () == DATA_AUTOMATIC)
		{					// get actual data for flight plan...
		CWayDoc* ptWayDoc = GetDocument();
		ASSERT_VALID(ptWayDoc);
		ptFlPlDoc->Update (ptWayDoc);
		}		  // DATA_AUTOMATIC



	CFont* ptOldFont;
	ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont10Pt);

															// aircraft identificaton...
	this->FlPlFormText (pDC, 11*X_GRID, Y_HEADER_OFF+2*Y_GRID, ptFlPlDoc->GetPlaneIdent());

	FLIGHTRULES Rules = ptFlPlDoc->GetFlightRules();
	switch (Rules)
		{
		case FR_IFR:		m_szRules = "I";	break;
		case FR_VFR:		m_szRules = "V";	break;
		case FR_VFR_NIGHT:	m_szRules = "VN";	break;
		case FR_VFR_FL100:	m_szRules = "VR";	break;
		case FR_CVFR:		m_szRules = "VC";	break;
		case FR_IFR_VFR:	m_szRules = "Y";	break;
		case FR_VFR_IFR:	m_szRules = "Z";	break;
		}
	this->FlPlFormText (pDC, 25*X_GRID, Y_HEADER_OFF+2*Y_GRID, m_szRules);


	FLIGHTTYPE Type = ptFlPlDoc->GetFlightType();
	switch (Type)
		{
		case FT_SHEDULED:       	m_szFlightType = "S";	break;
		case FT_NONSHEDULED:    	m_szFlightType = "N";	break;
		case FT_GENERALAVIATION:	m_szFlightType = "G";	break;
		case FT_MILITARY:       	m_szFlightType = "M";	break;
		case FT_OTHER:          	m_szFlightType = "O";	break;
		}
	this->FlPlFormText (pDC, 33*X_GRID, Y_HEADER_OFF+2*Y_GRID, m_szFlightType);


															// number of planes
	if (ptFlPlDoc->GetPlaneCnt() > 1)
		{
		szText = this->Format (IDF_02D, ptFlPlDoc->GetPlaneCnt()); 
		this->FlPlFormText (pDC, 2*X_GRID, Y_HEADER_OFF+4*Y_GRID, szText);
		}
	this->FlPlFormText (pDC, 9*X_GRID, Y_HEADER_OFF+4*Y_GRID, ptFlPlDoc->GetPlaneType ());

	WAKETURBCAT	WakeCat = ptFlPlDoc->GetWakeCat();
	switch (WakeCat)
		{
		case WT_HEAVY:	m_szWakeCat = "H";	break;
		case WT_MEDIUM:	m_szWakeCat = "M";	break;
		case WT_LIGHT:	m_szWakeCat = "L";	break;
		}
	this->FlPlFormText (pDC, 22*X_GRID, Y_HEADER_OFF+4*Y_GRID, m_szWakeCat);

														// equipment / transponder
	this->FlPlFormText (pDC, 28*X_GRID, Y_HEADER_OFF+4*Y_GRID, ptFlPlDoc->GetEquipment ());
	SSRTYPE SSR = ptFlPlDoc->GetSSR();
	m_szSSR = "/";
	switch (SSR)
		{
		case SS_NONE:		m_szSSR += "N";	break;
		case SS_NOCODING:	m_szSSR += "0";	break;
		case SS_2DIGITS_A:	m_szSSR += "2";	break;
		case SS_4DIGITS_A:	m_szSSR += "4";	break;
		case SS_MODE_A_C:	m_szSSR += "C";	break;
		}			
	this->FlPlFormText (pDC, 32*X_GRID, Y_HEADER_OFF+4*Y_GRID, m_szSSR);

														// departure aerodrome
	this->FlPlFormText (pDC, 5*X_GRID, Y_HEADER_OFF+6*Y_GRID, ptFlPlDoc->GetDeparture ());
	
	UINT uTime = ptFlPlDoc->GetTime();
	if (uTime > 0)
		{						// show time only if defined!
		szText = this->Format (IDF_04D, uTime); 
		this->FlPlFormText (pDC, 14*X_GRID, Y_HEADER_OFF+6*Y_GRID, szText);
		}
	this->FlPlFormText (pDC, 1*X_GRID, Y_HEADER_OFF+8*Y_GRID, ptFlPlDoc->GetSpeed());
	this->FlPlFormText (pDC, 7*X_GRID, Y_HEADER_OFF+8*Y_GRID, ptFlPlDoc->GetLevel());

	this->FlPlRouteText (pDC, ptFlPlDoc->GetRoute());

														// destination aerodrome
	this->FlPlFormText (pDC, 4*X_GRID, Y_DEST+0*Y_GRID, ptFlPlDoc->GetDestination());
	szText = this->Format (IDF_04D, ptFlPlDoc->GetTotalEET()); 
	this->FlPlFormText (pDC, 13*X_GRID, Y_DEST+0*Y_GRID, szText);
	this->FlPlFormText (pDC, 22*X_GRID, Y_DEST+0*Y_GRID, ptFlPlDoc->GetAlternate1());
	this->FlPlFormText (pDC, 30*X_GRID, Y_DEST+0*Y_GRID, ptFlPlDoc->GetAlternate2());

		  
	this->FlPlOtherInfoText (pDC, ptFlPlDoc->GetOtherInfo());

														// endurance
	szText = this->Format (IDF_04D, ptFlPlDoc->GetEndurance()); 
	this->FlPlFormText (pDC, 3*X_GRID, Y_ENDUR+0*Y_GRID, szText);

	szText = this->Format (IDF_03D, ptFlPlDoc->GetPersonCnt()); 
	this->FlPlFormText (pDC, 12*X_GRID, Y_ENDUR+0*Y_GRID, szText);

	if (!ptFlPlDoc->IsEmRadioUHF())
		this->FlPlMark (pDC, 28*X_GRID, Y_ENDUR+1*Y_GRID);
	if (!ptFlPlDoc->IsEmRadioVHF())
		this->FlPlMark (pDC, 31*X_GRID, Y_ENDUR+1*Y_GRID);
	if (!ptFlPlDoc->IsEmRadioELBA())
		this->FlPlMark (pDC, 34*X_GRID, Y_ENDUR+1*Y_GRID);


	if (!ptFlPlDoc->IsEquipPolar() &&
		!ptFlPlDoc->IsEquipDesert() &&
		!ptFlPlDoc->IsEquipMaritime() &&
		!ptFlPlDoc->IsEquipJungle() )
		{
		this->FlPlMark (pDC, 3*X_GRID, Y_SURVIVAL);
		}
	else{
		if (!ptFlPlDoc->IsEquipPolar())
			this->FlPlMark (pDC, 6*X_GRID, Y_SURVIVAL);
		if (!ptFlPlDoc->IsEquipDesert())
			this->FlPlMark (pDC, 9*X_GRID, Y_SURVIVAL);
		if (!ptFlPlDoc->IsEquipMaritime())
			this->FlPlMark (pDC, 12*X_GRID, Y_SURVIVAL);
		if (!ptFlPlDoc->IsEquipJungle())
			this->FlPlMark (pDC, 15*X_GRID, Y_SURVIVAL);
		}	

	if (!ptFlPlDoc->IsJacketsLight() &&
		!ptFlPlDoc->IsJacketsFloures() &&
		!ptFlPlDoc->IsJacketsUHF() &&
		!ptFlPlDoc->IsJacketsVHF() )
		{
		this->FlPlMark (pDC, 22*X_GRID, Y_SURVIVAL);
		}
	else{
		if (!ptFlPlDoc->IsJacketsLight())
			this->FlPlMark (pDC, 25*X_GRID, Y_SURVIVAL);
		if (!ptFlPlDoc->IsJacketsFloures())
			this->FlPlMark (pDC, 28*X_GRID, Y_SURVIVAL);
		if (!ptFlPlDoc->IsJacketsUHF())
			this->FlPlMark (pDC, 31*X_GRID, Y_SURVIVAL);
		if (!ptFlPlDoc->IsJacketsVHF())
			this->FlPlMark (pDC, 34*X_GRID, Y_SURVIVAL);
		}	


												// Dinghies...
	if (ptFlPlDoc->GetDinghiesCnt() == 0)
		{
		this->FlPlMark (pDC, 1*X_GRID, Y_DINGHIES + Y_GRID);
		}
	else{
		szText = this->Format (IDF_02D, ptFlPlDoc->GetDinghiesCnt()); 
		this->FlPlFormText (pDC, 3*X_GRID, Y_DINGHIES+0*Y_GRID, szText);

		szText = this->Format (IDF_03D, ptFlPlDoc->GetDinghiesCap()); 
		this->FlPlFormText (pDC, 6*X_GRID, Y_DINGHIES+0*Y_GRID, szText);

		if (!ptFlPlDoc->IsDinghiesCover())
			this->FlPlMark (pDC, 10*X_GRID, Y_DINGHIES + Y_GRID);

		this->FlPlFormText (pDC, 12*X_GRID, Y_DINGHIES+0*Y_GRID, ptFlPlDoc->GetDinghiesCol());
		}

												// Plane color
	SetLineText (pDC, ptFlPlDoc->GetPlaneCol(), NULL,3*X_GRID, 38*X_GRID, Y_DINGHIES+2*Y_GRID);
	SetLineText (pDC, ptFlPlDoc->GetRemarks(), NULL, 3*X_GRID, 34*X_GRID, Y_DINGHIES+4*Y_GRID);
	SetLineText (pDC, ptFlPlDoc->GetPilot(), NULL,   3*X_GRID, 21*X_GRID, Y_DINGHIES+6*Y_GRID);

	pDC->SelectObject (ptOldFont);


	ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);


	if (ptFlPlDoc->GetSignMode() == SIGN_TEXT)
		{										// show text signature
		short nGrids = 0;
		CString szSign = ptFlPlDoc->GetSignature();
		short nLen = szSign.GetLength();		// field width: 13*X_GRID
		if (nLen < 13) nGrids = (13 - nLen)/2;	// center in field
		this->FlPlFormText (pDC, nGrids*X_GRID, Y_SIGNATURE+1.5*Y_GRID_SIG, szSign);
		}
	else{										// show BMP of signature
		CImage* m_pDib = ptFlPlDoc->GetDibPtr ();
		if (m_pDib != NULL)
			{
 			long lStartX, lStartY;  
			CSize	bmSize;
			int		nMapMode = MM_LOMETRIC;

			pDC->SetMapMode(nMapMode);
			m_pDib->GetSizeLP(pDC, &bmSize);

			if (nMapMode == MM_LOMETRIC)
				bmSize.cy = -bmSize.cy;

			lStartX = (long)(m_rMaxRect.left);
			lStartY = (long)(m_rMaxRect.top + Y_SIGNATURE+1*Y_GRID_SIG);

			long lFieldHeight = (long)(2*Y_GRID_SIG);
			long lFieldWidth = (long)(13*X_GRID);
			CSize sDraw = GetDrawSize (bmSize, CSize (lFieldWidth, lFieldHeight));
			

			m_pDib->SetROPCode (SRCAND);	 // transparent
			m_pDib->Stretch (pDC, CPoint(lStartX, lStartY), sDraw);  // calls StretchDIBits(...)
			}
		}

	short nGap = 0;
	this->SetText (pDC, 23*X_GRID, Y_SIGNATURE+0*Y_GRID_SIG, ptFlPlDoc->GetRem1(), nGap);
	this->SetText (pDC, 23*X_GRID, Y_SIGNATURE+1*Y_GRID_SIG, ptFlPlDoc->GetRem2(), nGap);
	this->SetText (pDC, 23*X_GRID, Y_SIGNATURE+2*Y_GRID_SIG, ptFlPlDoc->GetRem3(), nGap);

	pDC->SelectObject (ptOldFont);
	} // bDraw

if (!m_bDraw && !m_bForPrinter)
	{
	this->SetTotalHeight (m_rMaxRect.bottom+3*m_LineY);
	this->SetTotalWidth (m_Xright + m_Xleft);
	}

return bEndOfPage;
}


/************************************************************************
 *  FlPlView.cpp   			  P r i n t P a g e							*
 ************************************************************************/
void CFlPlView::PrintPage (CDC* pDC, int nPageToPrint)
{
CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);

int	Y;
int	nPage = 1;

DWORD dwIndex = 0;

if (pDoc != NULL)
	{
	BOOL bDraw;

	do	{
		Y = 3*m_LineY;

		bDraw = (nPage == nPageToPrint);
		m_bMore = DrawFlightPlan (pDC, pDoc, &dwIndex, bDraw);
		nPage++;
		} while (!bDraw);
	}    
}                                  


/************************************************************************
 *  FlPlView.cpp    	 		 O n D r a w							*
 ************************************************************************/
void CFlPlView::OnDraw(CDC* pDC)
{
	CWayDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here            
	int	X_TAB = 4*m_CharX;

	if (pDoc != NULL)
	{
		BOOL	bMore = FALSE;
		DWORD 	dwIndex = 0;

		bMore = DrawFlightPlan (pDC, pDoc, &dwIndex, m_bDraw);
	}	
}

/************************************************************************
 *  FlPlView.cpp			P r e p a r e X T a b s						* 
 ************************************************************************/
void CFlPlView::PrepareXTabs (CDC* pDC)
{
CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	pDC->SetMapMode(MM_LOMETRIC);
	this->UpdateFonts (pDC);					// defines m_CharX
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);		
    this->SetXTabs (pDC, pDoc, m_CharX);
	pDC->SelectObject (ptOldFont);
	}
}

/************************************************************************
 *  FlPlView.cpp				O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews 					*
 ************************************************************************/
void CFlPlView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CWayDoc* pDoc = GetDocument();

if (pDoc != NULL)
	{	        
	CDC* pDC = GetDC();    

	this->PrepareXTabs(pDC);
	m_bDraw = FALSE;
	this->OnDraw(pDC);						// sets m_sizeTotal
	m_bDraw = TRUE;
	this->SetScrollSize (m_sizeTotal);

	ReleaseDC(pDC);     



// In OnUpdate werden die Scrollbars eingestellt.
// In OnPrepareDC darf dies nicht stattfinden, weil sonst ein doppelter
// Bildaufbau erfolgt!!
	
	CTextViewTool::OnUpdate (pSender, lHint, pHint);
	}	 
}

/************************************************************************
 *  FlPlView.cpp   			 O n P r e p a r e D C						*
 ************************************************************************/
void CFlPlView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class

CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	m_bForPrinter = pDC->IsPrinting();	  // important to get correct update after printing 
	this->PrepareXTabs(pDC);
	}
		
if (!m_bForPrinter)
	CTextViewTool::OnPrepareDC(pDC, pInfo);	 // sets bContinuePrinting = TRUE if SetMaxPage is set
}

/////////////////////////////////////////////////////////////////////////////
// CFlPlView printing

/************************************************************************
 *  FlPlView.cpp   		  O n P r e p a r e P r i n t i n g				*
 ************************************************************************/
BOOL CFlPlView::OnPreparePrinting(CPrintInfo* pInfo)
{			 // called before the display of the print dialog
	// default preparation
m_bMore = TRUE;	               

UINT nMinPage = 1;						// Number of the first page of the document
UINT nMaxPage = 1;						// Number of the last page of the document
pInfo->SetMinPage (nMinPage);
pInfo->SetMaxPage (nMaxPage);

return DoPreparePrinting(pInfo);
}

/************************************************************************
 *  FlPlView.cpp   		 	O n B e g i n P r i n t i n g				*
 ************************************************************************/
void CFlPlView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{			   // called after the print dialog exists
	// TODO: add extra initialization before printing
CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
//	pDC->SetMapMode(MM_LOMETRIC);

//	this->UpdateFonts (pDC);					// defines m_CharX

//    this->SetXTabs (pDC, pDoc, m_CharX);
	}
							// 2. possibility to set the document length 
}

/************************************************************************
 *  FlPlView.cpp   		 		 O n P r i n t							*
 ************************************************************************/
void CFlPlView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
this->PrintPage (pDC, pInfo->m_nCurPage);
}

/************************************************************************
 *  FlPlView.cpp   		 		 O n E n d P r i n t i n g				*
 ************************************************************************/
void CFlPlView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
}

/////////////////////////////////////////////////////////////////////////////
// CFlPlView diagnostics

#ifdef _DEBUG
void CFlPlView::AssertValid() const
{
	CTextViewTool::AssertValid();
}

void CFlPlView::Dump(CDumpContext& dc) const
{
	CTextViewTool::Dump(dc);
}

CWayDoc* CFlPlView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWayDoc)));
	return (CWayDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFlPlView message handlers


void CFlPlView::OnEditCopy() 
{
	// TODO: Add your command handler code here
this->CopyToClipboard();		
}
