// FlPlView.h : interface of the CFlPlView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

#include "..\CPPTOOLS\TxVwTool.h"

class CFlPlView : public CTextViewTool
{									 // logical values for LO_METRIC
#define Y_RECT_TO_LINE	5

									// font size in logical coords
#define POINT_SIZE_5	-20
#define POINT_SIZE_8	-26
#define POINT_SIZE_10	-34
#define POINT_SIZE_14	-48

#define X_GRID			47.8947
#define Y_GRID			-57.3846
#define Y_GRID_SIG		-50
#define Y_HEADER_ON		-125
#define Y_FILING_TIME	-363
#define Y_HEADER_OFF	-488	
#define Y_DEST			-1319
#define Y_OTHER			-1450
#define Y_ENDUR			-1853
#define Y_SURVIVAL		-2045
#define Y_DINGHIES		-2150
#define Y_SIGNATURE		-2598

//#define FLPLHEIGHT_LP	-2714
#define FLPLHEIGHT_LP	Y_SIGNATURE+3*Y_GRID_SIG
#define FLPLWIDTH_LP	(38*X_GRID)		//1820



public:
	CFont	m_PlainFont; 
	CFont	m_BoldFont;
	CFont	m_BoldFont10Pt; 
	CFont	m_BoldFont14Pt; 
	CFont	m_RectFont;
	int		m_CharX, m_LineY;
	int		m_BCharX, m_BLineY;
	int		m_B10CharX, m_B10LineY;
	int		m_B14CharX, m_B14LineY;
	int		m_RCharX, m_RLineY;

	CRect	m_rMaxRect;



private:
	CString	m_szRules;
	CString m_szFlightType;
	CString m_szWakeCat;
	CString m_szSSR;

public: // create from serialization only
	CFlPlView();
	DECLARE_DYNCREATE(CFlPlView)

// Attributes
public:
	CWayDoc* GetDocument();

// Operations
public:

// Implementation
public:
	virtual ~CFlPlView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void UpdateFonts (CDC* pDC);
	void SetXTabs (CDC* pDC, CWayDoc* ptWayDoc, int CharX);
	void PrepareXTabs (CDC* pDC);

	void FlPlFormText (CDC* pDC, double dXleft, double dYtop, CString szText);

	void FlPlRouteText (CDC* pDC, CString szText);
	void FlPlOtherInfoText (CDC* pDC, CString szText);
	void LargeText (CDC* pDC, double dXleft, double dYtop, CString szText);
	void TripleText (CDC* pDC, double dXleft, double dYtop, CString szText);
	void ArrowLine (CDC* pDC, double dXleft, double dYtop, BOOL bRightArrow, BOOL bLeftArrow);
	void FieldNumber (CDC* pDC, double dXleft, double dYtop, short nNumber);
	void SupplementLabels (CDC* pDC, double dYendurance);
	void TotalEETLabel (CDC* pDC, double dXleft, double dYtop);
	void FlPlLabel (CDC* pDC, double dXleft, double dYtop,
						short nRsrcID1=0, short nRsrcID2=0, short nRsrcID3=0);
	void FlPlMark (CDC* pDC, double dXleft, double dYbottom);
	void FlPlChkBox (CDC* pDC, double dXleft, double dYbottom, char cName,
						short nRsrcID1=0, short nRsrcID2=0);
	void FlPlWhiteRect (CDC* pDC, double dXleft, double dYtop, 
										double dXright, double dYbottom);
	void FlPlRect (CDC* pDC, double dXleft, double dYtop, double dXright, BOOL bWhite, BOOL bScale, 
						short nRsrcID1=0, short nRsrcID2=0, short nRsrcID3=0);
	void DrawFormular (CDC* pDC);
	BOOL DrawFlightPlan (CDC* pDC, CWayDoc* ptWayDoc, DWORD* ptIndex, BOOL bDraw = TRUE);

 	void PrintPage (CDC* pDC, int nPageToPrint);

private:
	void SetLineText (CDC* pDC, CString szText, short* ptOffs, 
									double dXleft, double dXright, double dYtop);
	void SetText (CDC* pDC, double dXleft, double dYtop, CString szText, int XGrid);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
protected:
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo); 
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL


// Generated message map functions
protected:
	//{{AFX_MSG(CFlPlView)
	afx_msg void OnEditCopy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in wayview.cpp
inline CWayDoc* CFlPlView::GetDocument()
   { return (CWayDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
