// fonttool.cpp : implementation file
//

#include "stdafx.h"
#include "pf.h"
#include "fonttool.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFontTool

IMPLEMENT_SERIAL(CFontTool, CDocument, 0 /* schema number*/ )

CFontTool::CFontTool()
{          
strcpy (m_szName, "Arial");
m_wPointSize = 10;
}

BOOL CFontTool::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CFontTool::~CFontTool()
{
}


BEGIN_MESSAGE_MAP(CFontTool, CDocument)
	//{{AFX_MSG_MAP(CFontTool)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFontTool serialization

void CFontTool::Serialize(CArchive& ar)
{
if (ar.IsStoring())
	{
		// TODO: add storing code here
    ar.Write (m_szName, FONTNAME_SIZE);
    ar << m_wPointSize;	
	}
else{
		// TODO: add loading code here   
	ar.Read (m_szName, FONTNAME_SIZE);   
	ar >> m_wPointSize;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CFontTool commands

/************************************************************************
 *  FontTool.cpp			Y _ P o i n t T o L P						*
 ************************************************************************/
short CFontTool::Y_PointToLP (CDC* pDC, WORD wPointSize)
{
short	yLogPixPerInch;
short	yDevicePixels;
POINT	LP;

//  H [mm] = H [pt] *  25.4/72 [mm/pt]
//  H [mm] = H [IN] * 25.4 [mm/IN]
//  DP = H [IN] * yLogPixPerInch

yLogPixPerInch = pDC->GetDeviceCaps (LOGPIXELSY);
yDevicePixels = (int)((double)wPointSize * yLogPixPerInch / 72);

LP.x = 0;
LP.y = yDevicePixels;
pDC->DPtoLP((LPPOINT) &LP, 1);
return (short)LP.y;
}

/************************************************************************
 *  FontTool.cpp			C h o o s e F o n t 						*
 ************************************************************************/
BOOL CFontTool::ChooseFont(CWnd* ptWnd)
{  
BOOL	bChanged = FALSE;
LOGFONT lfNewFont;
memset (&lfNewFont, 0, sizeof (LOGFONT));  

CDC* pDC = ptWnd->GetDC();
lfNewFont.lfHeight = this->Y_PointToLP (pDC, m_wPointSize);
ptWnd->ReleaseDC(pDC);

lfNewFont.lfCharSet = DEFAULT_CHARSET;
strcpy (lfNewFont.lfFaceName, m_szName);
 
CFontDialog FontDlg(&lfNewFont, CF_BOTH, NULL, ptWnd);  
int RetVal = FontDlg.DoModal();	
switch (RetVal)
	{
	case IDOK:
		m_wPointSize = (WORD)FontDlg.m_cf.iPointSize/10;
		strcpy (m_szName, lfNewFont.lfFaceName); 
		strcpy (m_szName, FontDlg.m_cf.lpLogFont->lfFaceName); 
		bChanged = TRUE;
		break;
	case IDCANCEL:
		DWORD dwError = CommDlgExtendedError();
		break;
	}                           
return bChanged;
}      

/************************************************************************
 *  FontTool.cpp				G e t P a r a m s						*
 ************************************************************************/
void CFontTool::GetParams (char* szName, WORD* ptPointSize)
{                                 
strcpy (szName, m_szName);
*ptPointSize = m_wPointSize;
} 