// FuelView.cpp : implementation of the CFuelView class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"  
#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"
#include "Calc.h"			// this statement must be after PlaneDoc.h
#include "Sun.h"

#include "WayDoc.h"
#include "FuelView.h"                                           

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;
extern CDimDoc* 		ptDim;      

extern CLoadDoc*		ptLoad; 
extern CCalcDoc*		ptCalc;
extern CAppendixDoc*	ptAppend;  
extern CMetDoc*			ptMet;
extern CPlaneDoc*		ptPlaneDoc;
extern BOOL bMMText;

/////////////////////////////////////////////////////////////////////////////
// CFuelView

IMPLEMENT_DYNCREATE(CFuelView, CTextViewTool)

BEGIN_MESSAGE_MAP(CFuelView, CTextViewTool)
	//{{AFX_MSG_MAP(CFuelView)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTextViewTool::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTextViewTool::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFuelView construction/destruction

CFuelView::CFuelView()
{
	// TODO: add construction code here
ptFontTool->GetParams (m_FontName, &m_wPointSize);

m_CharX = m_LineY = 0;
m_BCharX = m_BLineY = 0;

CreateBoldFont(&m_BoldFont);
CreateNewFont(&m_PlainFont);
}

CFuelView::~CFuelView()
{
m_PlainFont.DeleteObject ();
m_BoldFont.DeleteObject ();
}

/************************************************************************
 *  FuelView.cpp			U p d a t e F o n t s 						*
 ************************************************************************/
void CFuelView::UpdateFonts (CDC* pDC)
{
ptFontTool->GetParams (m_FontName, &m_wPointSize);
m_lfHeight = this->Y_PointToLP (pDC, m_wPointSize);  

m_PlainFont.DeleteObject ();
CreateNewFont(&m_PlainFont);
this->GetCharSize (pDC, &m_PlainFont, &m_CharX, &m_LineY); 

m_BoldFont.DeleteObject ();
CreateBoldFont(&m_BoldFont);
this->GetCharSize (pDC, &m_BoldFont, &m_BCharX, &m_BLineY); 

		//	used to get fixed left margin and defined "max" char width
GetLeftMarginAndCharX_LP (m_wPointSize, &m_CharX);	// defines m_LeftMargin, m_CharX
}

/************************************************************************
 *  FuelView.cpp			O n I n i t i a l U p d a t e				*
 *  Calls OnUpdate														*
 ************************************************************************/
void CFuelView::OnInitialUpdate()
{
	CTextViewTool::OnInitialUpdate();
	// TODO: calculate the total size of this view

CDC* pDC = GetDC();    
//pDC->SetMapMode(MM_LOMETRIC);

//this->UpdateFonts (pDC);

ReleaseDC(pDC);     
}


/////////////////////////////////////////////////////////////////////////////
// CFuelView drawing
/************************************************************************
 *  FuelView.cpp   				  S e t X T a b s 						*
 ************************************************************************/
void CFuelView::SetXTabs (CDC* pDC, CWayDoc* ptWayDoc, int CharX)
{
int X_TAB, LogPixXToUse, LogPixYToUse;
GetLogPixToUse(pDC, (int*)&LogPixXToUse, (int*)&LogPixYToUse);   


//X_TAB = (m_bForPrinter? 4 : 2)*CharX;
X_TAB = m_LeftMargin;

m_dY = LogPixYToUse;
m_Xleft  = X_TAB;

							/* length of line: File, Plane, Date		*/ 
CString szFilePlane = this->Format(IDF_FILE_PLANE,
					(LPCTSTR)ptWayDoc->GetTitle(),
					(LPCTSTR)ptPlaneDoc->GetActPlaneName ());
m_Xdate  = m_Xleft + GetRightPos(pDC, 0, szFilePlane) + 2*CharX;

UINT uDay, uMonth, uYear;
ptCalc->GetTime (&uDay, &uMonth, &uYear);
CString szDate = this->Format (IDF_DATE, uDay, uMonth, uYear);
pDC->SetTextAlign (TA_RIGHT | TA_TOP);
m_Xdate  += GetRightPos(pDC, 0, szDate);



									// Zuladung in (%s):
CString szDim;
ptDim->GetDimCstring (&szDim, ptDim->Mass());
CString szLoading = this->Format (IDF_LOADING, (LPCTSTR)szDim);

int X_help = GetRightPos (pDC, m_Xleft, szLoading);

m_Xtext	= m_Xleft + CharX;

m_Xrow1 = GetRightPos (pDC, X_help+5*CharX, IDS_POSITION1);
m_Xrow2 = GetRightPos (pDC, m_Xrow1+CharX, IDS_POSITION2);
m_Xrow3 = GetRightPos (pDC, m_Xrow2+CharX, IDS_POSITION3);
m_Xrow4 = GetRightPos (pDC, m_Xrow3+CharX, IDS_POSITION4);
m_Xrow5 = GetRightPos (pDC, m_Xrow4+CharX, IDS_POSITION5);

m_Xright = m_Xrow5 + CharX;
m_dX = m_Xright - m_Xleft;
}

/************************************************************************
 *  FuelView.cpp    	 	 D r a w L o a d i n g						*
 ************************************************************************/
void CFuelView::DrawLoading(CDC* pDC, int* ptY, int dY)
{
int		i;
double	fConvert;

CString szDim;							// Zuladung in (%s):
ptDim->GetDimCstring (&szDim, ptDim->Mass());
RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_LOADING, (LPCTSTR)szDim);

RsrcAlignRight (pDC, m_Xrow1, *ptY, IDS_POSITION1);
RsrcAlignRight (pDC, m_Xrow2, *ptY, IDS_POSITION2);
RsrcAlignRight (pDC, m_Xrow3, *ptY, IDS_POSITION3);
RsrcAlignRight (pDC, m_Xrow4, *ptY, IDS_POSITION4);
RsrcAlignRight (pDC, m_Xrow5, *ptY, IDS_POSITION5);
(*ptY) += dY;

										// Sitzreihe, Gepckabteil
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_SEATROW);
RsrcAlignLeft (pDC, m_Xtext, *ptY+dY, IDS_LUGGAGE);

for (i=0; i<PL_MAX_ARM; i++)
    {
    int X_Pos;

    if (i==0) X_Pos = m_Xrow1;
    if (i==1) X_Pos = m_Xrow2;
    if (i==2) X_Pos = m_Xrow3;
    if (i==3) X_Pos = m_Xrow4;
    if (i==4) X_Pos = m_Xrow5;

	short nMass = ptLoad->GetRowMass(i);
    if (nMass != NO_MASS)
		{
		fConvert = ptDim->ConvertMass (nMass, ptLoad->GetMassDim(), ptDim->Mass());
		RsrcAlignRightEx (pDC, X_Pos, *ptY, IDF_WEIGHT, fConvert);
		}

	nMass = ptLoad->GetLugMass(i);
    if (nMass != NO_MASS)
		{
		fConvert = ptDim->ConvertMass (nMass, ptLoad->GetMassDim(), ptDim->Mass());
		RsrcAlignRightEx (pDC, X_Pos, *ptY+dY, IDF_WEIGHT, fConvert);
		}
    }

(*ptY) += 2*dY;  
}

/************************************************************************
 *  FuelView.cpp			D r a w F u e l I n f o 					*
 ************************************************************************/
void CFuelView::DrawFuelInfo (CDC* pDC, int* ptY, int dY,
								CONSUMTYPE* ptC, short nTankCnt)
{
int		i;
double	fConvert;

CString szDim;
ptDim->GetDimCstring (&szDim, ptDim->Volume());

for (i=0; i<nTankCnt; i++)
    {						//	"Zulssige Auslastung Tank %d: %3.0f%% oder %5.1f %s"
    fConvert = ptDim->ConvertVolume (ptC->fTotalFuel_l[i], DIM_LITER, ptDim->Volume());
	RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_TOTALFUEL, 
						i+1, ptC->fFillDegr_Pc[i], fConvert, (LPCTSTR)szDim); 
    (*ptY) += dY;
    }

							//	"Ausfliegbare Kraftstoffmenge: %5.1f %s"
fConvert = ptDim->ConvertVolume (ptC->fAvailFuel_l, DIM_LITER, ptDim->Volume());
RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_USEFUEL, fConvert, (LPCTSTR)szDim); 
(*ptY) += dY;
}


/************************************************************************
 *  FuelView.cpp	     O u t p u t B a l a n c e						*
 ************************************************************************/
void CFuelView::OutputBalance (CDC* pDC, int* ptY, int dY, 
								CFont* ptBoldFont, CONSUMTYPE* ptC)
{
	double fMass, fTorq, fCoGrav;
	CString	szDim;
	CString	szArmDim;
	CFont* ptOldFont;

	ptDim->GetDimCstring (&szDim, ptDim->Mass());
	ptDim->GetDimCstring (&szArmDim, ptDim->Arm());

					// "Masse = %4.0f %s  Moment = %4.0f %s%s  Schwerpunkt = %4.2f %s"
	fMass = ptDim->ConvertMass (ptC->fTotal_kg, DIM_KG, ptDim->Mass());
	fTorq = ptDim->ConvertDist (ptC->fTotal_mkg, DIM_METER, ptDim->Arm());
	fTorq = ptDim->ConvertMass (fTorq, DIM_KG, ptDim->Mass());
	fCoGrav = ptDim->ConvertDist (ptC->fCoG_m, DIM_METER, ptDim->Arm());
	RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_TOTALMASS, fMass, (LPCTSTR)szDim,
											   fTorq, (LPCTSTR)szArmDim, (LPCTSTR)szDim,
											   fCoGrav, (LPCTSTR)szArmDim);


	double fArm1, fArm2;	/* W a r n u n g			*/
	(*ptY) += (int)(1.5*dY);				/* write limits into next line		*/

	fArm1 = ptDim->ConvertDist (ptC->fMinCoG_m, DIM_METER, ptDim->Arm());
	fArm2 = ptDim->ConvertDist (ptC->fMaxCoG_m, DIM_METER, ptDim->Arm());


	ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
	
	RsrcAlignCenterEx (pDC, m_Xrow1, *ptY, IDF_CENTER_MIN, fArm1, (LPCTSTR)szArmDim);
	RsrcAlignCenterEx (pDC, m_Xrow3, *ptY, IDF_CENTER_MAX, fArm2, (LPCTSTR)szArmDim);
	short Xcenter = (short)((fCoGrav - fArm1)*(m_Xrow3-m_Xrow1)/(fArm2-fArm1) + m_Xrow1);

	(*ptY) += dY;

	if (m_bDraw)
	{	
		short nXoffs = m_Xrow2-m_Xrow1;		// areas outside good loading
		short nY = (*ptY) + dY/2; 
		CPen RedPen (PS_SOLID, 15, RGB(255,0,0));
		CPen* ptOldPen = pDC->SelectObject (&RedPen);
		pDC->MoveTo (m_Xrow1-nXoffs, nY);
		pDC->LineTo (m_Xrow1, nY);
		pDC->MoveTo (m_Xrow3, nY);
		pDC->LineTo (m_Xrow3+nXoffs, nY);

		CPen GreenPen (PS_SOLID, 15, RGB(0,180,0));
		pDC->SelectObject (&GreenPen);
		pDC->MoveTo (m_Xrow1, nY);
		pDC->LineTo (m_Xrow3, nY);

		pDC->SelectObject (ptOldPen);

		pDC->MoveTo (m_Xrow1, nY-dY/2);		// mark minimum value
		pDC->LineTo (m_Xrow1, nY);

		pDC->MoveTo (m_Xrow3, nY-dY/2);		// mark maximum value
		pDC->LineTo (m_Xrow3, nY);

		pDC->MoveTo (Xcenter, nY);			// mark actual value
		pDC->LineTo (Xcenter, nY+dY/2);

	}

	(*ptY) += (int)(1.0*dY);
	RsrcAlignCenterEx (pDC, Xcenter, *ptY, 
					ptC->bBadBalance? IDF_CENTER_ACT_BAD : IDF_CENTER_ACT, 
					fCoGrav, (LPCTSTR)szArmDim);
	pDC->SelectObject (ptOldFont);
}


/************************************************************************
 *  FuelView.cpp			D r a w F l i g h t T i m e 				*
 ************************************************************************/
void CFuelView::DrawFlightTime (CDC* pDC, int* ptY,
					     short nID, int nMinutes, float fFuel_l)
{     
double	fConvert;

RsrcAlignLeft (pDC, m_Xtext, *ptY, nID);
									// "%4d"
RsrcAlignRightEx (pDC, m_Xrow2, *ptY, IDF_TIME, nMinutes);

if (fFuel_l != NO_FUEL)
	{								// "%5.1f"
	fConvert = ptDim->ConvertVolume (fFuel_l, DIM_LITER, ptDim->Volume());
	RsrcAlignRightEx (pDC, m_Xrow3, *ptY, IDF_FUEL, fConvert);
	}
}

/************************************************************************
 *  FuelView.cpp			D r a w S a f e F l i g h t T i m e 		*
 ************************************************************************/
void CFuelView::DrawSafeFlightTime (CDC* pDC, int* ptY,
					     int nSafeResMin, int nMinutes, float fFuel_l)
{     
double	fConvert;

RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_SAFETIME, nSafeResMin);
									// "%4d"
RsrcAlignRightEx (pDC, m_Xrow2, *ptY, IDF_TIME, nMinutes);

if (fFuel_l != NO_FUEL)
	{								// "%5.1f"
	fConvert = ptDim->ConvertVolume (fFuel_l, DIM_LITER, ptDim->Volume());
	RsrcAlignRightEx (pDC, m_Xrow3, *ptY, IDF_FUEL, fConvert);
	}
}


/************************************************************************
 *  FuelView.cpp			D r a w F u e l S p l i t					*
 ************************************************************************/
void CFuelView::DrawFuelSplit (CDC* pDC, int* ptY, int dY, 
								CFont* ptBoldFont, CONSUMTYPE* ptC)
{
double	fConvert;
CString szDim;

									// "%d %s Flugstrecke:"		
ptDim->GetDimCstring (&szDim, ptDim->Distance());
fConvert = ptDim->ConvertDist (ptC->fEnRoute_NM, DIM_NM, ptDim->Distance());
RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_FORROUTE, (long)(fConvert +.5), (LPCTSTR)szDim);

if (ptDim->Distance() == DIM_METER)
{
	short hour = 0;
	short min=0;
	short sec = 0;
	CDimDoc::MinutesToHMS(ptC->fEnRoute_min, &hour, &min, &sec);
	RsrcAlignRightEx (pDC, m_Xrow2, *ptY, IDF_TIME_MS, (int)(60*hour + min), sec);
}
else
{				// "%4d"
	RsrcAlignRightEx (pDC, m_Xrow2, *ptY, IDF_TIME, (int)ptC->fEnRoute_min);
}
									// "%5.1f"
fConvert = ptDim->ConvertVolume (ptC->fEnRoute_l, DIM_LITER, ptDim->Volume());
RsrcAlignRightEx (pDC, m_Xrow3, *ptY, IDF_FUEL, fConvert);


(*ptY) += dY;			/* Rollen + An-Abflug: je 10min	*/
this->DrawFlightTime (pDC, ptY, 
				IDS_FORTAXI, ptC->nTaxi_min + ptC->nDepArv_min, ptC->fTaxiDepArv_l);


				
for (int i=0; i<2; i++)
{				// for alternates:
	if (ptC->forAlternate[i].fRoute_NM > 0)
	{
		(*ptY) += dY;
		CString szName = ptC->forAlternate[i].LandLoc.GetIndicator();
		if (szName.GetLength() < 4)
			szName = ptC->forAlternate[i].LandLoc.GetName();

		fConvert = ptDim->ConvertDist (ptC->forAlternate[i].fRoute_NM, DIM_NM, ptDim->Distance());
		RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_FORALTERNATE, 
					(long)(fConvert +.5), (LPCTSTR)szDim, (LPCTSTR)szName);

		if (ptDim->Distance() == DIM_METER)
		{
			short hour = 0;
			short min=0;
			short sec = 0;
			CDimDoc::MinutesToHMS(ptC->forAlternate[i].fRoute_min, &hour, &min, &sec);
			RsrcAlignRightEx (pDC, m_Xrow2, *ptY, IDF_TIME_MS, (int)(60*hour + min), sec);
		}
		else
		{				// "%4d"
			RsrcAlignRightEx (pDC, m_Xrow2, *ptY, IDF_TIME, (int)ptC->forAlternate[i].fRoute_min);
		}
											// "%5.1f"
		fConvert = ptDim->ConvertVolume (ptC->forAlternate[i].fRoute_l, DIM_LITER, ptDim->Volume());
		RsrcAlignRightEx (pDC, m_Xrow3, *ptY, IDF_FUEL, fConvert);
	}

} // end for alternates


(*ptY) += dY;			/* Sicherheitsreserve: 30 min	*/
this->DrawFlightTime (pDC, ptY, 
				IDS_FORSAFE, ptC->nSafeRes_min, ptC->fSafeRes_l);

(*ptY) += dY;			/* Extra Kraftstoff		*/
this->DrawFlightTime (pDC, ptY, 
				IDS_EXTRAFUEL, ptC->nExtra_min, ptC->fExtra_l);

}

/************************************************************************
 *  wDraw.c				D r a w F u e l R e q							*
 ************************************************************************/
void CFuelView::DrawFuelReq (CDC* pDC, int* ptY, int dY, CONSUMTYPE* ptC)
{

				/* Gesamte Flugzeit mit Extra-Kraftstoff (Endurance)	*/
this->DrawFlightTime (pDC, ptY,
				IDS_ENDURANCE, (short)ptC->fPowered_min, ptC->fAvailFuel_l);

(*ptY) += dY;		/* Mindest-Kraftstoffbedarf ohne Reserve	*/
this->DrawFlightTime (pDC, ptY, 
				IDS_REQUIRED_MIN, ptC->nReq_min, ptC->fReq_l);

(*ptY) += dY;		/* Mindest-Kraftstoffbedarf mit Reserve	*/
this->DrawFlightTime (pDC, ptY,
				IDS_REQUIRED_SAFE, ptC->nSafe_min, ptC->fSafe_l);

(*ptY) += dY;		/* Mindest-Kraftstoffbedarf mit Reserve	*/
this->DrawSafeFlightTime (pDC, ptY, 
				ptC->nSafeRes_min, ptC->nMaxSafe_min, NO_FUEL);

}

/************************************************************************
 *  FuelView.c				D r a w S u n D a t a						*
 ************************************************************************/
void CFuelView::DrawSunData (CDC* pDC, int* ptY, double Lat, double Lon)
{
SUNSHINETYPE SunShine;
CSun Sun(ptCalc->GetTime());
Sun.GetSunShine (Lat, Lon, &SunShine);

switch (SunShine.nMode)
    {
    case SUN_UPDOWN:
		RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_UPDOWN, 
			 SunShine.Hsr, SunShine.Msr, SunShine.Ssr,
			 SunShine.Hss, SunShine.Mss, SunShine.Sss);
		break;
    case SUN_INVISIBLE:			// "Polarnacht"
		RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_INVISIBLE);
		break;
    case SUN_CIRCUMPOLAR:		 // "Polartag"
		RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_CIRCUMPOLAR);
	break;
    }
}

/************************************************************************
 *  FuelView.cpp			D r a w M e t T e x t						*
 ************************************************************************/
void CFuelView::DrawMetText (CDC* pDC, int* ptY, short nActMass,
				CLocation& Loc,
				short nTemp, short nTempDim, 
				short nQNH, short nPressDim, BOOL bWet)
{
double	fMass, fAlt, fDiff, fTemp;
CString	szMassDim;
CString	szAltDim;
CString	szTempDim;
CString	szPressVal;
CString	szPressDim;
CString	szFeucht;

fMass = ptDim->ConvertMass ((double)nActMass, DIM_KG, ptDim->Mass());
fAlt = ptDim->ConvertDist ((double)Loc.GetAltitude(), Loc.GetElevDim(), ptDim->Altitude());
fDiff = ptDim->ConvertDist ((double)Loc.GetElevDiff(), Loc.GetDiffDim(), ptDim->Altitude());
fTemp = ptDim->ConvertTemp ((double)nTemp, nTempDim, ptDim->Temp());
szPressVal = ptMet->SetQnhText (nQNH, nPressDim, ptDim->Press());

ptDim->GetDimCstring (&szMassDim, ptDim->Mass());
ptDim->GetDimCstring (&szAltDim, ptDim->Altitude());
ptDim->GetDimCstring (&szTempDim, ptDim->Temp());
ptDim->GetDimCstring (&szPressDim, ptDim->Press());

szFeucht.Empty();						
if (bWet)
    {										    /* get C-String from Rsrc	    */
    szFeucht.LoadString (WET_STR);
    }
		
				//  Bedingungen: %4d %s, %5ld %s (%2d %s), %3d Grad %s, %s %s%s"
RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_MET_SETTINGS,
		(short)(fMass + 0.5), (LPCTSTR)szMassDim,
		(long)(fAlt + 0.5), (LPCTSTR)szAltDim,
		(short)fDiff, (LPCTSTR)szAltDim,
		(short)(fTemp + 0.5), (LPCTSTR)szTempDim,
		(LPCTSTR)szPressVal, (LPCTSTR)szPressDim, (LPCTSTR)szFeucht);
}


/****************************************************************************
 *	FuelView.cpp					D r a w R w y T r a c k 				*
 ****************************************************************************/
void CFuelView::DrawRwyTrack(CDC* pDC, BOOL bStart, int* ptY, short LineY, CONSUMTYPE* ptC)
{
	BOOL bGras = FALSE;
	double fRwyLen=0;
	double fRollLen=0;
	double fReqLen=0;

	if (bStart)
	{
		if (ptC->nStartObst_m > 0)
		{										/****** Start - Strecke *********/
			short nRwyLen;
			if (ptC->StartLoc.GetRwyLen(&nRwyLen))
			{
				fRwyLen = ptDim->ConvertDist (nRwyLen, ptC->StartLoc.GetLenDim(), ptDim->RwyLength());
				bGras = ptC->StartLoc.IsGras();
		
				if (ptC->nStartRoll_m > 0)
				{
					fRollLen = ptDim->ConvertDist (ptC->nStartRoll_m, DIM_METER, ptDim->RwyLength());
				}
				fReqLen = ptDim->ConvertDist (ptC->nStartObst_m, DIM_METER, ptDim->RwyLength());
			}
		}
	}
	else
	{
		if (ptC->nLandObst_m > 0)
		{										/******* Lande - Strecke ********/
			short nRwyLen;
			if (ptC->LandLoc.GetRwyLen(&nRwyLen))
			{
				fRwyLen = ptDim->ConvertDist (nRwyLen, ptC->LandLoc.GetLenDim(), ptDim->RwyLength());
				bGras = ptC->LandLoc.IsGras();
				if (ptC->nLandRoll_m > 0)
				{
					fRollLen = ptDim->ConvertDist (ptC->nLandRoll_m, DIM_METER, ptDim->RwyLength());
				}
				fReqLen = ptDim->ConvertDist (ptC->nLandObst_m, DIM_METER, ptDim->RwyLength());
			}
		}
	}


	if (fRwyLen > 0)
	{
		short	X;
		BOOL	bOK = (fReqLen <= fRwyLen);
		double fMax = bOK? fRwyLen : fReqLen;	
		
		short nYobst = (short)(-15 * (m_Xrow3-m_Xrow1)/fMax);
		(*ptY) += LineY;
		(*ptY) += nYobst;

		if (m_bDraw)
		{
			CPen RedPen (PS_SOLID, 5, RGB(255,0,0));			// pen for track

			CPen GreenPen (PS_SOLID, 10, RGB(0,180,0));			// pens for rwy
			CPen BlackPen (PS_SOLID, 10, RGB(0,0,0));

			CPen* ptOldPen = pDC->SelectObject (bGras? &GreenPen : &BlackPen);	// set rwy-Color
			X = (short)(fRwyLen * (m_Xrow3-m_Xrow1)/fMax);	// draw RWY
			pDC->MoveTo (m_Xrow1, *ptY);
			pDC->LineTo (m_Xrow1+X, *ptY);
			pDC->SelectObject (ptOldPen);					// reset pen size	
			
			if (!bOK)
				ptOldPen = pDC->SelectObject (&RedPen);		// set red track-Color

			if (bStart)
			{
				short Y = *ptY - LineY/4;								// rwy level
				pDC->MoveTo (m_Xrow1, Y);
				
				if (fRollLen > 0)
					{
					X = (short)(fRollLen * (m_Xrow3-m_Xrow1)/fMax);		// draw roll track
					pDC->LineTo (m_Xrow1+X, Y);
					}
				
				X = (short)(fReqLen * (m_Xrow3-m_Xrow1)/fMax);			// draw climb track
				pDC->LineTo (m_Xrow1+X, Y - nYobst);
			}
			else
			{
				short Y = *ptY - LineY/4;								// rwy level
				pDC->MoveTo (m_Xrow1, Y - nYobst);
				
				if (fRollLen > 0)
					{
					X = (short)((fReqLen - fRollLen) * (m_Xrow3-m_Xrow1)/fMax);		// draw roll track
					pDC->LineTo (m_Xrow1+X, Y);
					}
				
				X = (short)(fReqLen * (m_Xrow3-m_Xrow1)/fMax);		// draw descend track
				pDC->LineTo (m_Xrow1+X, Y);
			}

			if (!bOK)
				pDC->SelectObject (ptOldPen);				// switch off red track Color

			pDC->MoveTo (m_Xrow1+X,  *ptY);
		}

			(*ptY) += LineY;

		if (m_bDraw)
		{
			pDC->LineTo (m_Xrow1+X,  *ptY);

			CString szDim;
			ptDim->GetDimCstring (&szDim, ptDim->RwyLength());

			CString szReqLen;
			szReqLen.Format ("  %d %s", (short)(fReqLen +.5), (LPCTSTR)szDim);

												// set required length color
			COLORREF oldCol = pDC->SetTextColor(bOK? RGB(0,180,0) : RGB(255,0,0));
			int OldBkMode = pDC->SetBkMode (TRANSPARENT);
			TextAlignLeft (pDC, m_Xrow1+X, *ptY-(short)(0.8*LineY), szReqLen); 
			pDC->SetBkMode (OldBkMode);
			pDC->SetTextColor (oldCol);
		}
	}	
}


/************************************************************************
 *  wDraw.c	     Output Start Land	 LOMETRIC: 0/0 = top left	*
 ************************************************************************/
void CFuelView::OutputStartLand(CDC* pDC, int* ptY, int dY, int dYbold, 
								CFont* ptBoldFont, CONSUMTYPE* ptC)
{
int	Len;
CString szFormat;
char	szBuffer[256];
short	nRwyLen;

CString	szGras;
double	fObstHeight_m, fObstacle, fReqLen, fAvailLen;
CString szDim;

fObstHeight_m = 15.0;
fObstacle = ptDim->ConvertDist (fObstHeight_m, DIM_METER, ptDim->RwyLength());
ptDim->GetDimCstring (&szDim, ptDim->RwyLength());

CFont* ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
pDC->SetBkMode(OPAQUE);
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_STARTLAND);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);

(*ptY) += dYbold;					// "In %s (%s): "
RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_INLOC,	
				(LPCTSTR)ptC->StartLoc.GetName(), 
				(LPCTSTR)ptC->StartLoc.GetIndicator());

if (ptC->nStartObst_m > 0)
    {				    /****** Start - Strecke *********/
    Len = 0;
    (*ptY) += dY;

    if (ptC->nStartRoll_m > 0)
		{							// "Startrollstrecke: %4d %s, "
		fReqLen = ptDim->ConvertDist (ptC->nStartRoll_m, DIM_METER, ptDim->RwyLength());
		szFormat.LoadString(IDS_STARTROLL);
		Len += sprintf (szBuffer+Len, (LPCTSTR)szFormat, (short)(fReqLen+.5), (LPCTSTR)szDim);
		}

    fReqLen = ptDim->ConvertDist (ptC->nStartObst_m, DIM_METER, ptDim->RwyLength());
    szFormat.LoadString (LEN_START);
    Len += sprintf (szBuffer+Len, (LPCTSTR)szFormat,
		(short)(fObstacle + .5), (LPCTSTR)szDim, (short)(fReqLen + .5), (LPCTSTR)szDim);
    if (ptC->StartLoc.GetRwyLen(&nRwyLen))
		{
		fAvailLen = ptDim->ConvertDist (nRwyLen,
					 ptC->StartLoc.GetLenDim(), ptDim->RwyLength());
		szGras.Empty();
		if (ptC->StartLoc.IsGras())
			szGras.LoadString (GRAS_STR);
		szFormat.LoadString (LEN_RWY);
		Len += sprintf (szBuffer+Len, (LPCTSTR)szFormat,
				(short)(fAvailLen + .5), (LPCTSTR)szDim, (LPCTSTR)szGras);
		}

	if (ptC->StartLoc.IsAirport())
		{
		short nRwyDir = ptC->StartLoc.GetRwyDir();
		if (nRwyDir != NO_RWYDIR)
			{
			szFormat.LoadString (IDF_RWYDIR);
			Len += sprintf (szBuffer+Len, (LPCTSTR)szFormat, nRwyDir, nRwyDir + 18);
			}
		}
	TextAlignLeft (pDC, m_Xtext, *ptY, (CString)szBuffer); 


    (*ptY) += dY;			    /* Startbedingungen 	*/
    DrawMetText (pDC, ptY, (short)ptC->fTotal_kg,
	    ptC->StartLoc,
	    ptMet->GetTemp1(), ptMet->GetTempDim1(), ptMet->GetQNH1(), ptMet->GetPressDim1(), ptMet->IsWet1());
    }

(*ptY) += dY;				/* Sunrise and Sunset	*/
DrawSunData (pDC, ptY, ptC->StartLoc.GetLat(), ptC->StartLoc.GetLon());

(*ptY) += dY;
DrawRwyTrack(pDC, TRUE, ptY, dY, ptC);		// bStart = TRUE


    (*ptY) += dY;	    /******* Lande - Strecke ********/
	DrawLandingInformation(pDC, ptY, dY, dYbold, fObstacle,
		ptC->LandLoc, ptC->nLandRoll_m, ptC->nLandObst_m, ptC->fLandMass_kg);

	(*ptY) += dY;				/* Sunrise and Sunset	*/
	DrawSunData (pDC, ptY, ptC->LandLoc.GetLat(), ptC->LandLoc.GetLon());

	(*ptY) += dY;
	DrawRwyTrack(pDC, FALSE, ptY, dY, ptC);		// bStart = FALSE


						   /******* Landing - Distances of alternate ********/
	for (int i=0; i<2; i++)
	{
		if (ptC->forAlternate[i].nLandObst_m > 0)
		{
			(*ptY) += dY;
			DrawLandingInformation(pDC, ptY, dY, dYbold, fObstacle,
				ptC->forAlternate[i].LandLoc, 
				ptC->forAlternate[i].nLandRoll_m, 
				ptC->forAlternate[i].nLandObst_m, 
				ptC->forAlternate[i].fLandMass_kg);
			(*ptY) += dY;
		}
	}
}


/************************************************************************
 *  wDraw.c			D r a w L a n d i n g I n f o r m a t i o n			*
 ************************************************************************/
void CFuelView::DrawLandingInformation(CDC* pDC, int* ptY, int dY, int dYbold, double fObstacle,
		CLocation& Loc, int nLandRoll_m, int nLandObst_m, float fLandMass_kg)
{
							// "In %s (%s): "
	RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_INLOC,	
					(LPCTSTR)Loc.GetName(), 
					(LPCTSTR)Loc.GetIndicator());

	if (nLandObst_m > 0)
	{
		int	Len;
		double fReqLen, fAvailLen;
		CString szFormat;
		char	szBuffer[256];
		short	nRwyLen;
		CString	szGras;
		CString szDim;

		Len = 0;
		(*ptY) += dY;

		ptDim->GetDimCstring (&szDim, ptDim->RwyLength());

		if (nLandRoll_m > 0)
			{
			fReqLen = ptDim->ConvertDist (nLandRoll_m, DIM_METER, ptDim->RwyLength());
			szFormat.LoadString (IDS_LANDROLL);
			Len += sprintf (szBuffer+Len, (LPCTSTR)szFormat, (short)(fReqLen+.5), (LPCTSTR)szDim);
			}

		fReqLen = ptDim->ConvertDist (nLandObst_m, DIM_METER, ptDim->RwyLength());
		szFormat.LoadString (LEN_LAND);
		Len += sprintf (szBuffer+Len, (LPCTSTR)szFormat,
		   (short)(fObstacle + .5), (LPCTSTR)szDim, (short)(fReqLen + .5), (LPCTSTR)szDim);

		if (Loc.GetRwyLen(&nRwyLen))
			{
			fAvailLen = ptDim->ConvertDist (nRwyLen,
						 Loc.GetLenDim(), ptDim->RwyLength());
			szGras.Empty();
			if (Loc.IsGras())
				szGras.LoadString (GRAS_STR);
			szFormat.LoadString (LEN_RWY);
			Len += sprintf (szBuffer+Len, (LPCTSTR)szFormat,
				(short)(fAvailLen + .5), (LPCTSTR)szDim, (LPCTSTR)szGras);
			}

		if (Loc.IsAirport())
			{
			short nRwyDir = Loc.GetRwyDir();
			if (nRwyDir != NO_RWYDIR)
				{
				szFormat.LoadString (IDF_RWYDIR);
				Len += sprintf (szBuffer+Len, (LPCTSTR)szFormat, nRwyDir, nRwyDir + 18);
				}
			}
		TextAlignLeft (pDC, m_Xtext, *ptY, (CString)szBuffer); 

		(*ptY) += dY;		    /* Landebedingungen	    */
		DrawMetText (pDC, ptY, (short)fLandMass_kg,
			Loc,
 			ptMet->GetTemp2(), ptMet->GetTempDim2(), ptMet->GetQNH2(), ptMet->GetPressDim2(), ptMet->IsWet2());
	}
}


/************************************************************************
 *  wDraw.c		  D r a w C o s t s    LOMETRIC: 0/0 = top left			*
 ************************************************************************/
void CFuelView::DrawCosts(CDC* pDC, int* ptY, int dY, int dYbold, 
								CFont* ptBoldFont, CONSUMTYPE* ptC)
{
								// "Flugkosten"
CFont* ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
pDC->SetBkMode(OPAQUE);
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_FLIGHTCOST);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);
(*ptY) += dYbold;
							// "Incl. An- und Abflug:"
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_COST_ARV_DEP);
RsrcAlignRightEx (pDC, m_Xrow3, *ptY, IDF_MINUTES, 
					(int)(ptC->fEnRoute_min + ptC->nDepArv_min));
RsrcAlignRightEx (pDC, m_Xrow5, *ptY, IDF_COST, ptC->fCostDepArv); 

 
(*ptY) += dY;            		// "Incl. Rollen, An- und Abflug:"
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_COST_TAXI);
RsrcAlignRightEx (pDC, m_Xrow3, *ptY, IDF_MINUTES, 
					(int)(ptC->fEnRoute_min + ptC->nDepArv_min + ptC->nTaxi_min));
RsrcAlignRightEx (pDC, m_Xrow5, *ptY, IDF_COST, ptC->fCostTaxi); 

(*ptY) += dY;
}

/************************************************************************
 *  FuelView.cpp	     G e t S t a r t L a n d E r r L i n e s		*
 ************************************************************************/
short CFuelView::GetStartLandErrLines (CONSUMTYPE* ptC)
{
    short nLines = 0;
     
	if (ptC->bBadFuel1)
		nLines++;
		
	if (ptC->bBadFuel2)
		nLines++;
		
	if (ptC->bBadBalance)
		nLines++;
		
	if (ptC->bBadElev1)
		nLines++;
		
	if (ptC->bBadStart && !ptC->bBadElev1)
		nLines++;
		
	if (ptC->bBadElev2)
		nLines++;
		
	if (ptC->bBadLand && !ptC->bBadElev2)
		nLines++;
		
	return nLines;
}

/************************************************************************
 *  FuelView.cpp	     D r a w S t a r t L a n d E r r				*
 ************************************************************************/
void CFuelView::DrawStartLandErr (CDC* pDC, int* ptY, int dY, int dYbold, 
								CFont* ptBoldFont, CONSUMTYPE* ptC)
{
CFont* ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
pDC->SetBkMode(OPAQUE);
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_WARN);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);
(*ptY) += dYbold;

if (ptC->bBadFuel1)
	{	
	RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_BAD_FUEL1);
	(*ptY) += dY;
	}	
if (ptC->bBadFuel2)
	{
	RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_BAD_FUEL2);
	(*ptY) += dY;
	}
if (ptC->bBadBalance)
	{
	RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_BAD_BALANCE);
	(*ptY) += dY;
	}
if (ptC->bBadElev1)
	{
	RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_NO_START_ELEV);
	(*ptY) += dY;
	}
if (ptC->bBadStart && !ptC->bBadElev1)
	{
	RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_BAD_START);
	(*ptY) += dY;
	}
if (ptC->bBadElev2)
	{
	RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_NO_LAND_ELEV);
	(*ptY) += dY;
	}
if (ptC->bBadLand && !ptC->bBadElev2)
	{
	RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_BAD_LAND);
	(*ptY) += dY;
	}
}

/************************************************************************
 *  FuelView.cpp	     D r a w L o a d W a r n						*
 ************************************************************************/
void CFuelView::DrawLoadWarn (CDC* pDC, int* ptY, int dY, int dYbold, 
								CFont* ptBoldFont, CONSUMTYPE* ptC)
{
CFont* ptOldFont = (CFont*)pDC->SelectObject (ptBoldFont);
pDC->SetBkMode(OPAQUE);
RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_WARN);
pDC->SetBkMode(TRANSPARENT);
pDC->SelectObject (ptOldFont);
(*ptY) += dYbold;

if (ptC->nBadRowLoad > 0)
	{	
	RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_BAD_ROW_LOAD, ptC->nBadRowLoad);
	(*ptY) += dY;
	}	
if (ptC->nBadLugLoad > 0)
	{
	RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_BAD_LUG_LOAD, ptC->nBadLugLoad);
	(*ptY) += dY;
	}
if (ptC->nBadFuelLoad > 0)
	{
	RsrcAlignLeftEx (pDC, m_Xtext, *ptY, IDF_BAD_FUEL_LOAD, ptC->nBadFuelLoad);
	(*ptY) += dY;
	}
}


/****************************************************************************
 *	FuelView.cpp				D r a w F u e l T o n n						*
 ****************************************************************************/
void CFuelView::DrawFuelTonn(CDC* pDC, int nYbott, int LineY, CONSUMTYPE* ptC, CPlane& Plane)
{
	if (!ptC->bNoFuel)
	{
		double fTotalFuel=0;
		double fAvailFuel, fReqFuel, fUseable_l, fUnuseable_l;
		
		Plane.GetMaxTankVol (&fUseable_l, &fUnuseable_l);		
		double fMaxTankVol = fUseable_l + fUnuseable_l;		// total max. tank volume

		short nTankCnt = Plane.GetTankCnt ();
		for (int i=0; i<nTankCnt; i++)
		{												// total fuel on board
			fTotalFuel += ptC->fTotalFuel_l[i];				
		}		 		
			
 		fAvailFuel = ptC->fAvailFuel_l;						// available fuel on board	

		fReqFuel = ptC->fSafe_l;							// required fuel incl. unused fuel




		BOOL	bOK = (fReqFuel <= fAvailFuel);
		double fMax = (fMaxTankVol > fReqFuel)? fMaxTankVol : fReqFuel;	
		
		short nXtonn = (m_Xrow4 - m_Xrow3)/2;
		short nYmax = 8*LineY;
		
		short nYtank = (short)(fMaxTankVol * nYmax/fMax);
		short nYunused =  (short)(fUnuseable_l * nYmax/fMax);
		short nYavail = (short)(fAvailFuel * nYmax/fMax);
		short nYreq = (short)(fReqFuel * nYmax/fMax);
		
		CPen RedPen (PS_SOLID, 5, RGB(255,0,0));			// pen for arrow
		CPen GreenPen (PS_SOLID, 5, RGB(0,180,0));			// pen for arrow

		CBrush BlueBrush (RGB(0,255,255));
		CBrush BlackBrush (RGB(0,0,0));
		
		short nXleft  = m_Xrow4 - nXtonn/2;
		short nXright = m_Xrow4 + nXtonn/2;
		CRect rFrame;

		if (m_bDraw)
		{
			CBrush* ptOldBrush = (CBrush*)pDC->SelectObject (&BlueBrush);	// set fuel-Color
			rFrame.SetRect (nXleft, nYbott - nYunused - nYavail, nXright, nYbott - nYunused);	// useable fuel
			pDC->Rectangle(rFrame);
			pDC->SelectObject (ptOldBrush);									// reset Color

			ptOldBrush = (CBrush*)pDC->SelectStockObject (BLACK_BRUSH);
			rFrame.SetRect (nXleft, nYbott - nYunused, nXright, nYbott);	// unuseable fuel
			pDC->Rectangle(rFrame);
			pDC->SelectObject (ptOldBrush);

			ptOldBrush = (CBrush*)pDC->SelectStockObject (NULL_BRUSH);
			rFrame.SetRect (nXleft, nYbott - nYtank, nXright, nYbott);	// whole tank
			pDC->Rectangle(rFrame);
			pDC->SelectObject (ptOldBrush);
			
															// draw arrow for required fuel vol
			CPen* ptOldPen = pDC->SelectObject (bOK? &GreenPen : &RedPen);
			short nArrowX0 = nXright+nXtonn/8;
			short nArrowX1 = nXright+nXtonn/2;
			short nArrowY = nYbott- nYunused - nYreq;
			
			pDC->MoveTo (nArrowX0, nArrowY);
			pDC->LineTo (nArrowX1, nArrowY);							// -----
			
			pDC->MoveTo (nArrowX0, nArrowY);								
			pDC->LineTo (nArrowX0+nXtonn/8, nArrowY - LineY/2);				
			
			pDC->MoveTo (nArrowX0, nArrowY);								
			pDC->LineTo (nArrowX0+nXtonn/8, nArrowY + LineY/2);			// <----			
			
			pDC->SelectObject (ptOldPen);					// reset Color

			COLORREF oldCol = pDC->SetTextColor(bOK? RGB(0,180,0) : RGB(255,0,0));
			double fConvert;
			fConvert = ptDim->ConvertVolume(fReqFuel, DIM_LITER, ptDim->Volume());
			RsrcAlignLeftEx (pDC, nArrowX1, nArrowY-LineY/2, IDF_FUEL, fConvert);
			pDC->SetTextColor (oldCol);

		}
	}	
}


/************************************************************************
 *  FuelView.cpp    		 	 D r a w F u e l 						*
 ************************************************************************/
BOOL CFuelView::DrawFuel (CDC* pDC, CWayDoc* ptWayDoc, DWORD* ptIndex,
					    int* ptY, BOOL bPrinter, BOOL bDraw)
{
	BOOL	bEndOfPage = FALSE;
	short	Y_SEP;
	CString szText;

	ActivateDrawing (bDraw);

	CFont* ptOldFont;
	ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);
	pDC->SetBkMode(TRANSPARENT);

								// "Datei: %s  Flugzeug:%s       Datum:..."
	RsrcAlignLeftEx (pDC, m_Xleft, *ptY, IDF_FILE_PLANE, 
						(LPCTSTR)ptWayDoc->GetTitle(),
						(LPCTSTR)ptPlaneDoc->GetActPlaneName ());


	UINT uDay, uMonth, uYear;
	ptCalc->GetTime (&uDay, &uMonth, &uYear);
	RsrcAlignRightEx (pDC, m_Xright, *ptY, IDF_DATE, uDay, uMonth, uYear);
	(*ptY) += m_LineY;  
	(*ptY) += m_LineY;  

	if ((short)*ptIndex == 0)
	{
		/************** M a s s e  u n d  S c h w e r p u n k t  ****************/
		Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);


		pDC->SetBkMode(OPAQUE);							// Weight and Balance
		ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);
		RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_WEIGHTBAL);
		pDC->SelectObject (ptOldFont);
		pDC->SetBkMode(TRANSPARENT);
	} // *ptIndex=0


	CPlane	ActPlane;
	CCalculate* ptLegs = NULL;
	if (ptPlaneDoc != NULL)
	{
		short nIndex = ptPlaneDoc->GetActIndex();
		if (!ptPlaneDoc->GetPlanePtr(nIndex, &ActPlane))
			return TRUE;		// bEndOfPage = TRUE;
	}

	if ((short)*ptIndex == 0)
	{
		(*ptY) += m_LineY;  
		this->DrawLoading (pDC, ptY, m_LineY);
	} // *ptIndex=0

							/* do prepare calculations		*/
	ptLegs = ptWayDoc->GetCalculationPtr();
	ptLegs->Activate(&ActPlane);

	if (ptLegs->DoConsumCalc (&ActPlane, ptMet, ptLoad))
	{
		if ((short)*ptIndex == 0)
		{
			DrawGrayHorzLine (pDC, *ptY+m_LineY/2);
			if (!ptLegs->NoFuel())
				{
				(*ptY) += m_LineY;	/* Tankfuellgrad [%], zul. Tankvolumen	*/
				this->DrawFuelInfo (pDC, ptY, m_LineY, ptLegs->GetConsPtr(), ActPlane.GetTankCnt ());
				DrawGrayHorzLine (pDC, *ptY+m_LineY/2);
				}

			(*ptY) += m_LineY;  
			this->OutputBalance (pDC, ptY, m_LineY, &m_BoldFont, ptLegs->GetConsPtr());


			(*ptY) += m_LineY;  
			DrawHorzLine (pDC, *ptY+m_LineY/2);
			DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
			(*ptY) += m_LineY;  



			/************** T r e i b s t o f f v e r b r a u c h ****************/
			Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

			if (ptLegs->NoFuel())
				{
			   // Y -= m_LineY;
				ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);
				pDC->SetBkMode(OPAQUE);	
				RsrcAlignLeft (pDC, m_Xtext, *ptY, FUEL_WARN);
				pDC->SetBkMode(TRANSPARENT);
				pDC->SelectObject (ptOldFont);
			   }
			else{
			  //  Y -= m_LineY;				/* Treibstoffverbrauch		*/
				ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);
				pDC->SetBkMode(OPAQUE);
 				RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_FUELTITLE);
				pDC->SetBkMode(TRANSPARENT);
				pDC->SelectObject (ptOldFont);

				(*ptY) += m_LineY;				/* "Vorgesehen fr:"		*/
				RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_PLANEDFOR);

												// "Zeit [min]"
 				RsrcAlignCenter (pDC, m_Xrow2, *ptY, IDS_TIMEMIN);
												
				CString szDim;					//  "Vol. [%s]"
				ptDim->GetDimCstring (&szDim, ptDim->Volume());
   				RsrcAlignCenterEx (pDC, m_Xrow3, *ptY, IDF_CONSVOL, (LPCTSTR)szDim);

				(*ptY) += m_LineY;
				DrawHorzLine (pDC, *ptY+m_LineY/2);

				(*ptY) += m_LineY;
				this->DrawFuelSplit (pDC, ptY, m_LineY, &m_BoldFont, ptLegs->GetConsPtr());

				(*ptY) += m_LineY;			// "Flugzeit"	
			//	DrawGrayHorzLine (pDC, *ptY+m_LineY/2);		// avoid line through FuelTonn
				ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);
 				RsrcAlignLeft (pDC, m_Xtext, *ptY, IDS_FLIGHTTIME);
				pDC->SelectObject (ptOldFont);

				(*ptY) += m_LineY;			/* Available and requested flight time	*/
				this->DrawFuelReq (pDC, ptY, m_LineY, ptLegs->GetConsPtr());
				DrawFuelTonn (pDC, *ptY + m_LineY, m_LineY, ptLegs->GetConsPtr(), ActPlane);
				}

			(*ptY) += m_LineY;  
			DrawHorzLine (pDC, *ptY+m_LineY/2);
			DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
			(*ptY) += m_LineY;  


			if (bPrinter)
			{
				short nNextLines = 15;	// take off and landing without alternates
				CONSUMTYPE* ptC = ptLegs->GetConsPtr();
				for (int i=0; i<2; i++)
					if (ptC->forAlternate[i].nLandObst_m > 0) nNextLines += 5;

				bEndOfPage = ((DWORD)(*ptY + nNextLines*m_LineY) < (m_dwLinesPerPage * m_LineY));
				if (!bEndOfPage) (*ptIndex)++;	// show next part on same page
			}
			else
			{
				(*ptIndex)++;
			}
		} // *ptIndex=0



		if ((short)*ptIndex == 1)
		{
			/************** S t a r t  u n d  L a n d u n g	 ****************/
			Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

			OutputStartLand (pDC, ptY, m_LineY, m_BLineY, &m_BoldFont, ptLegs->GetConsPtr());

			DrawHorzLine (pDC, *ptY+m_LineY/2);
			DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
			(*ptY) += m_LineY;  

		
			if (bPrinter)
			{
				short nNextLines = 2;	// flight costs really needs 4 lines, but to use whole page...
				bEndOfPage = ((DWORD)(*ptY + nNextLines*m_LineY) < (m_dwLinesPerPage * m_LineY));
				if (!bEndOfPage) (*ptIndex)++;	// show next part on same page
			}
			else
			{
				(*ptIndex)++;
			}
		} // *ptIndex=1


		if ((short)*ptIndex == 2)
		{
			/************** F l u g k o s t e n	 ****************/
			Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

			DrawCosts(pDC, ptY, m_LineY, m_BLineY, &m_BoldFont, ptLegs->GetConsPtr());

			DrawHorzLine (pDC, *ptY+m_LineY/2);
			DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
			(*ptY) += m_LineY;

		
			if (bPrinter)
			{
				short nErrLines = GetStartLandErrLines(ptLegs->GetConsPtr());
				if (nErrLines > 0)
				{
					short nNextLines = 2 + nErrLines;	// errors
					bEndOfPage = ((DWORD)(*ptY + nNextLines*m_LineY) < (m_dwLinesPerPage * m_LineY));
					if (!bEndOfPage) (*ptIndex)++;	// show next part on same page
				}
			}
			else
			{
				(*ptIndex)++;
			}
		} // *ptIndex=2


		if ((short)*ptIndex == 3)
		{
			/************** F e h l e r m e l d u n g e n	 ****************/
			CONSUMTYPE* ptC = ptLegs->GetConsPtr();
			if (ptC->bBadFuel1 || ptC->bBadFuel2 || ptC->bBadBalance ||
						ptC->bBadElev1 || ptC->bBadStart ||
						ptC->bBadElev2 || ptC->bBadLand )
			{
			Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);

			DrawStartLandErr(pDC, ptY, m_LineY, m_BLineY, &m_BoldFont, ptC);
			DrawHorzLine (pDC, *ptY+m_LineY/2);
			DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
			(*ptY) += m_LineY;
			}
		} // *ptIndex=3
	} // DoConsumCalc
else{				// fehlerhafte Beladung: Keine Verbrauchsberechnung mglich
	DrawHorzLine (pDC, *ptY+m_LineY/2);
	DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
	(*ptY) += m_LineY;

	Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);
	CONSUMTYPE* ptC = ptLegs->GetConsPtr();
	DrawLoadWarn (pDC, ptY, m_LineY, m_BLineY, &m_BoldFont, ptC);
	DrawHorzLine (pDC, *ptY+m_LineY/2);
	DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
	(*ptY) += m_LineY;
	}

ptLegs->DeActivate();


if (!m_bDraw && !m_bForPrinter)
	{
	this->SetTotalHeight (*ptY);
	this->SetTotalWidth (m_Xright + m_Xleft);
	}

pDC->SelectObject (ptOldFont);
  
if (bPrinter && bEndOfPage)
	(*ptIndex)++;		// show next part on next page

return bEndOfPage;
}

/************************************************************************
 *  FuelView.cpp			D r a w P a g e H e a d e r 				*
 ************************************************************************/
void CFuelView::DrawPageHeader (CDC* pDC, CWayDoc* ptWayDoc, int LineY, 
								int* ptY, int dX, BOOL bDraw)
{
int	Y1, Frame;
CWayPoint FirstWayPt, LastWayPt;
CFont* ptOldFont;

ActivateDrawing (bDraw);

Y1 = *ptY + 3*LineY;			/* Draw double line frame	*/ 
if (bDraw) Rectangle(pDC, m_Xleft, *ptY, m_Xleft + dX, Y1);

Frame = (LineY/4);
if (bDraw)
	{ 
	if (bMMText)Rectangle(pDC, m_Xleft+Frame, *ptY+Frame, m_Xleft + dX-Frame, Y1-Frame);
		else	Rectangle(pDC, m_Xleft-Frame, *ptY+Frame, m_Xleft + dX+Frame, Y1-Frame);
	}

ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);

Y1 = *ptY+LineY/2;
RsrcAlignCenter (pDC, (m_Xleft + dX + m_Xleft)/2, Y1, IDS_TITLE1);

Y1 += LineY;

short nCnt= ptWayDoc->GetWayPointCnt ();
if (ptWayDoc->GetWayPointPtr (0, &FirstWayPt) &&
	ptWayDoc->GetWayPointPtr(nCnt-1, &LastWayPt))
	{
	CString szName1, szName2;
	CLocation Loc;
	FirstWayPt.GetLoc (&Loc);
	szName1 = Loc.GetName();

	LastWayPt.GetLoc (&Loc);
	szName2 = Loc.GetName();

	CString szUserName = ptInit->GetCustName();

	RsrcAlignCenterEx (pDC, (m_Xleft + dX + m_Xleft)/2, Y1, 
		IDF_TITLE2,(LPCTSTR)szName1, (LPCTSTR)szName2, (LPCTSTR)szUserName);

	}

pDC->SelectObject (ptOldFont);

*ptY = Y1 + 3*LineY;
}

/************************************************************************
 *  FuelView.cpp    	 	D r a w P a g e F o o t e r 				*
 ************************************************************************/
void CFuelView::DrawPageFooter (CDC* pDC, int nPage, int LineY, 
								int* ptY, int dX, BOOL bDraw)
{
	CString szText;

	CFont* ptOldFont;
	ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);

	(*ptY) += LineY/2;
	szText = this->Format (IDF_PAGENUM, nPage);
	this->TextAlignCenter (pDC, dX/2, *ptY, szText);

	pDC->SelectObject (ptOldFont);
}       


/************************************************************************
 *  FuelView.cpp   			  P r i n t P a g e							*
 ************************************************************************/
void CFuelView::PrintPage (CDC* pDC, int nPageToPrint)
{
	CWayDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	int	Y;
	int	nPage = 1;

	DWORD dwIndex = 0;

	if (pDoc != NULL)
	{
		BOOL bDraw;
		BOOL bPrinter = TRUE;

		do	
		{
			Y = 3*m_LineY;

			bDraw = (nPage == nPageToPrint);
			this->DrawPageHeader (pDC, pDoc, m_LineY, &Y, m_dX, bDraw); 
			m_bMore = DrawFuel (pDC, pDoc, &dwIndex, &Y, bPrinter, bDraw);

			if (m_nPages > 1)
			{
				Y = (bMMText)? m_dY: -m_dY + m_LineY;
				this->DrawPageFooter (pDC, nPage, m_LineY, &Y, m_dX, bDraw); 
			}

			nPage++;
		} while (!bDraw);
	}    
}                                  



/************************************************************************
 *  FuelView.cpp    	 		 O n D r a w							*
 ************************************************************************/
void CFuelView::OnDraw(CDC* pDC)
{
	CWayDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here            
	int	Y = m_LineY;

	if (pDoc != NULL)
	{
		BOOL	bMore = FALSE;
		BOOL	bPrinter = FALSE;
		DWORD 	dwIndex = 0;

		bMore = DrawFuel (pDC, pDoc, &dwIndex, &Y, bPrinter, m_bDraw);
	}	
}

/************************************************************************
 *  FuelView.cpp			P r e p a r e X T a b s						* 
 ************************************************************************/
void CFuelView::PrepareXTabs (CDC* pDC)
{
CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	pDC->SetMapMode(MM_LOMETRIC);
	this->UpdateFonts (pDC);					// defines m_CharX
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);		
    this->SetXTabs (pDC, pDoc, m_CharX);
	pDC->SelectObject (ptOldFont);
	}
}

/************************************************************************
 *  FuelView.cpp				O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews, after changing font*
 ************************************************************************/
void CFuelView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CWayDoc* pDoc = GetDocument();

if (pDoc != NULL)
	{	        
	CDC* pDC = GetDC();    

	this->PrepareXTabs (pDC);
	m_bDraw = FALSE;
	this->OnDraw(pDC);						// sets m_sizeTotal
	m_bDraw = TRUE;
	this->SetScrollSize (m_sizeTotal);


	ReleaseDC(pDC);     
	
	CTextViewTool::OnUpdate (pSender, lHint, pHint);
	}	 
}


/************************************************************************
 *  FuelView.cpp   			 O n P r e p a r e D C						*
 ************************************************************************/
void CFuelView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
	m_bForPrinter = pDC->IsPrinting();	  // important to get correct update after 
	if (m_bForPrinter)					  // printing dlg disappears!!
		{
		int	X, Y;
		DWORD	dwIndex = 0; 
		BOOL bMore = TRUE;

		m_nPages = 0;
		this->PrepareXTabs (pDC);
   						
		m_dwLinesPerPage = this->GetMaxLines (pDC, m_LineY);   // used in DrawKoord	while m_bForPrinter
		m_bDraw = FALSE;
		do	{    
			X = m_Xleft;
			Y = 3*m_LineY;

 			this->DrawPageHeader (pDC, pDoc, m_LineY, &Y, m_dX, FALSE); 
			bMore = DrawFuel (pDC, pDoc, &dwIndex, &Y, m_bForPrinter, FALSE); // sets m_sizeTotal

 		//	this->DrawPageFooter (pDC, 0, m_LineY, &X, &Y, m_dX, FALSE); 
		//  there is place for footer after last line !! see GetLogPixToUse
 			m_nPages++;
			} while (bMore);
		m_bDraw = TRUE;

		if (pInfo != NULL)
			{
			pInfo->SetMaxPage (m_nPages);			// required for Preview
			pInfo->m_nNumPreviewPages = m_nPages;
			pInfo->m_bContinuePrinting = (m_bMore || pInfo->m_bPreview);
			}    
		}  // if m_bForPrinter
	else{
		this->PrepareXTabs (pDC);
		}
	}
		
if (!m_bForPrinter)
	CTextViewTool::OnPrepareDC(pDC, pInfo);	 // sets bContinuePrinting = TRUE if SetMaxPage is set
}



/////////////////////////////////////////////////////////////////////////////
// CFuelView printing

/************************************************************************
 *  FuelView.cpp   		  O n P r e p a r e P r i n t i n g				*
 ************************************************************************/
BOOL CFuelView::OnPreparePrinting(CPrintInfo* pInfo)
{			 // called before the display of the print dialog
	// default preparation
m_bMore = TRUE;	               

return DoPreparePrinting(pInfo);
}

/************************************************************************
 *  FuelView.cpp   		 	O n B e g i n P r i n t i n g				*
 ************************************************************************/
void CFuelView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{			   // called after the print dialog exists
	// TODO: add extra initialization before printing
CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
//	pDC->SetMapMode(MM_LOMETRIC);

//	this->UpdateFonts (pDC);					// defines m_CharX

//    this->SetXTabs (pDC, pDoc, m_CharX);
	}
							// 2. possibility to set the document length 
}

/************************************************************************
 *  FuelView.cpp   		 		 O n P r i n t							*
 ************************************************************************/
void CFuelView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
this->PrintPage (pDC, pInfo->m_nCurPage);
}

/************************************************************************
 *  FuelView.cpp   		 		 O n E n d P r i n t i n g				*
 ************************************************************************/
void CFuelView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
}

/////////////////////////////////////////////////////////////////////////////
// CFuelView diagnostics

#ifdef _DEBUG
void CFuelView::AssertValid() const
{
	CTextViewTool::AssertValid();
}

void CFuelView::Dump(CDumpContext& dc) const
{
	CTextViewTool::Dump(dc);
}

CWayDoc* CFuelView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWayDoc)));
	return (CWayDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFuelView message handlers




void CFuelView::OnEditCopy() 
{
	// TODO: Add your command handler code here
this->CopyToClipboard();		
}
