// FuelView.h : interface of the CFuelView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////
#include "..\CPPTOOLS\TxVwTool.h"

class CFuelView : public CTextViewTool
{
public:
	CFont	m_PlainFont; 
	CFont	m_BoldFont; 
	int		m_CharX, m_LineY;
	int		m_BCharX, m_BLineY;

	int	m_Xtext, m_Xrow1, m_Xrow2, m_Xrow3, m_Xrow4, m_Xrow5, m_Xdate;

public: // create from serialization only
	CFuelView();
	DECLARE_DYNCREATE(CFuelView)

// Attributes
public:
	CWayDoc* GetDocument();

// Operations
public:

// Implementation
public:
	virtual ~CFuelView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void UpdateFonts (CDC* pDC);
	void SetXTabs (CDC* pDC, CWayDoc* ptWayDoc, int CharX);
	void PrepareXTabs (CDC* pDC);

	void DrawLoading(CDC* pDC, int* ptY, int dY);
	void DrawFuelInfo (CDC* pDC, int* ptY, int dY, CONSUMTYPE* ptC, short nTankCnt);
	void OutputBalance (CDC* pDC, int* ptY, int dY, CFont* ptBoldFont, CONSUMTYPE* ptC);
	void DrawFlightTime (CDC* pDC, int* ptY, short nID, int nMinutes, float fFuel_l);
	void DrawSafeFlightTime (CDC* pDC, int* ptY, int nSafeResMin, int nMinutes, float fFuel_l);
	void DrawFuelSplit (CDC* pDC, int* ptY, int dY, CFont* ptBoldFont, CONSUMTYPE* ptC);
	void DrawFuelReq (CDC* pDC, int* ptY, int dY, CONSUMTYPE* ptC);
	void DrawSunData (CDC* pDC, int* ptY, double Lat, double Lon);
	void DrawMetText (CDC* pDC, int* ptY, short nActMass,
				CLocation& Loc,
				short nTemp, short nTempDim, 
				short nQNH, short nPressDim, BOOL bWet);
	void DrawCosts(CDC* pDC, int* ptY, int dY, int dYbold, 
								CFont* ptBoldFont, CONSUMTYPE* ptC);
	void DrawRwyTrack(CDC* pDC, BOOL bStart, int* ptY, short LineY, CONSUMTYPE* ptC);
	void OutputStartLand(CDC* pDC, int* ptY, int dY, int dYbold, 
								CFont* ptBoldFont, CONSUMTYPE* ptC);
	void DrawLandingInformation(CDC* pDC, int* ptY, int dY, int dYbold, double fObstacle,
			CLocation& Loc, int nLandRoll_m, int nLandObst_m, float fLandMass_kg);

	short GetStartLandErrLines (CONSUMTYPE* ptC);
	void DrawStartLandErr (CDC* pDC, int* ptY, int dY, int dYbold, 
								CFont* ptBoldFont, CONSUMTYPE* ptC);

	void DrawLoadWarn (CDC* pDC, int* ptY, int dY, int dYbold, 
								CFont* ptBoldFont, CONSUMTYPE* ptC);

	void DrawFuelTonn(CDC* pDC, int nYbott, int LineY, CONSUMTYPE* ptC, CPlane& Plane);
	BOOL DrawFuel (CDC* pDC, CWayDoc* ptWayDoc, DWORD* ptIndex,
					int* ptY, BOOL bPrinter, BOOL bDraw = TRUE);
	void DrawPageHeader (CDC* pDC, CWayDoc* ptWayDoc, int LineY, 
								int* ptY, int dX, BOOL bDraw);
	void DrawPageFooter (CDC* pDC, int nPage, int LineY, 
								int* ptY, int dX, BOOL bDraw);
	void PrintPage (CDC* pDC, int nPageToPrint);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
protected:
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo); 
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL





// Generated message map functions
protected:
	//{{AFX_MSG(CFuelView)
	afx_msg void OnEditCopy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in wayview.cpp
inline CWayDoc* CFuelView::GetDocument()
   { return (CWayDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
