/*********************************************************************
 *							G a r m i n . c	p p					     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "Garmin.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "InitDoc.h"  
//#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"		  // defines PF_MAX_TANK...
#include "Calc.h"			// this statement must be after PlaneDoc.h



extern CCalcDoc*		ptCalc;

/************************************************************************
 *  Garmin.cpp				C G a r m i n 					CONSTRUCTOR	*
 ************************************************************************/
CGarmin::CGarmin(long lBaud, short nData, float fStop, short nParity, BOOL bBinary)	:
	CSerCom (lBaud, nData, fStop, nParity, bBinary)
{
	m_ptProtocols = NULL;

	m_ptProtocols = new CGarminProtocols();

	m_ptLogFile = NULL;
	m_bRealCommand = TRUE;
	m_bSimulateProtocolArray = FALSE;
}


/************************************************************************
 *  Garmin.cpp			~ C G a r m i n						DESTRUCTOR	*
 ************************************************************************/
CGarmin::~CGarmin()
{
	if (m_ptProtocols != NULL)
		delete m_ptProtocols;
}

/************************************************************************
 *  ProtGarminLink1.cpp			S a v e D a t a							*
 ************************************************************************/
void CGarmin::SaveData (unsigned char uFunc, unsigned char* ptData, short nLen)
{
	if (m_ptLogFile != NULL)
	{
		char szHexBuff[2048];
		long	lHexLen = 0;
		char	szFunc[32];

		CGarmin::FuncToString (uFunc, szFunc);

		lHexLen = sprintf (szHexBuff, "\r\n\r\nHost sends cmd %s (%d,%02X):\r\n", 
						szFunc, (short)uFunc, (short)uFunc);
		m_ptLogFile->Write ((const void*)szHexBuff, (UINT)lHexLen);

		*szHexBuff = 0;
		CSerCom::ConvertBinToHex (ptData, nLen, szHexBuff, &lHexLen);
		szHexBuff[lHexLen] = 0; 		// make C-String

		m_ptLogFile->Write ((const void*)szHexBuff, (UINT)lHexLen);
	}
}

/************************************************************************
 *  ProtGarminLink1.cpp			S e n d C o m m a n d					*
 ************************************************************************/
BOOL CGarmin::SendCommand (unsigned char uFunc, 
									unsigned char* ptData, short nLen)
{
	short nOffs = 0;

	SaveData(uFunc, ptData, nLen);

	*(this->m_lpOut + nOffs++) = 0x10;
	*(this->m_lpOut + nOffs++) = uFunc;
	*(this->m_lpOut + nOffs++) = (unsigned char)nLen;

	for (short i=0; i<nLen; i++)
		*(this->m_lpOut + nOffs++) = *(ptData + i);

	*(this->m_lpOut + nOffs) = FillByte (this->m_lpOut, 1, nOffs - 1);
	nOffs++;


	int iWriteCnt;									// don't check first 2 header bytes
	iWriteCnt = nOffs - 2;				// try to double 0x10 bytes in data area only
	BOOL bInsert = TRUE;
	BOOL bHandleESC = TRUE;
	this->CheckGarminESC (bInsert, (m_lpOut+2), &iWriteCnt, &bHandleESC);
	nOffs = (short)iWriteCnt + 2;		// 2 bytes for header


	*(this->m_lpOut + nOffs++) = 0x10;
	*(this->m_lpOut + nOffs++) = 0x03;

	return this->Write (m_lpOut, nOffs);
}



/************************************************************************
 *  Garmin.cpp			C a l c R t e T r a n s R e c o r d s			*
 *  Anzahl der Datenstze, ohne Pid_Xfer_Cmplt							*
 ************************************************************************/
short CGarmin::CalcRteTransRecords(short nWptCnt)
{
	short nRecords;
	short nTrans, nHdr, nWpt, nLink;
	m_ptProtocols->GetProtocolRte(&nTrans, &nHdr, &nWpt, &nLink);

	if (nTrans == A200_RteTrans)
	{		// Anz Routen * (Pid_Rte_Hdr + Wpt1, Wpt2, Wpt3, ..., WptN)
		nRecords = 1 * (1 + nWptCnt);
	}

	if (nTrans == A201_RteTrans)
	{		// Anz Routen * (Pid_Rte_Hdr + 2 * (Wpt1, Wpt2, Wpt3, ..., WptN)-1)
		nRecords = 1 * (1 + 2*nWptCnt - 1);
	}

	return nRecords;
}



/************************************************************************
 *  Garmin.cpp				 F i l l B y t e							*
 ************************************************************************/
unsigned char CGarmin::FillByte (unsigned char* lpOut, short nFirstByte, short nLastByte)
{
short	nFillByte;
short	N=1;
short	nSum = 0;
short	i;

for (i=nFirstByte; i<=nLastByte; i++)	// build check sum
	nSum += *(lpOut + i);
while (nSum > 256) nSum -= 256;	


do  {					// get fillbyte
    short nTotalSum = (short)(N++) * (short)256;
    nFillByte = nTotalSum - nSum;
    } while (nFillByte<0);

return (unsigned char)nFillByte;
}



/************************************************************************
 *  Garmin.cpp				C o p y W p t N a m e						*
 *  copies nBytes bytes into lpOut, starting at nOffs.					*
 *  source is szName with nMaxWptChars chars.							*
 *  if nMaxWptChars < nBytes, lpOut will get space chars				*
 ************************************************************************/
void CGarmin::CopyWptName (unsigned char* lpOut, short nOffs, short nBytes,
				char* szName, short nMaxWptChars)
{
short i;
BOOL	bEnd = FALSE;
int	ch = 0;
				    // use upper case letters only
for (i=0; i<nBytes; i++)	    // fill "nBytes" bytes of lpOut
    {
    if (!bEnd)
		{
		ch = *(szName+i);
		if (ch == '') ch = 'S';    // check: 
		if (ch == '+') ch = 0x20;   // convert "+" to space char
					    // stop copy on first space char
		bEnd = (ch == 0) || (ch == 0x20) || (i>=nMaxWptChars);
		}

    if (bEnd)
		{
		ch = 0x20;
		}
    else{
		if (!isupper (ch))
		    ch = toupper (ch);

		if (ch == '') ch = 'A';      // 
		if (ch == '') ch = 'O';      // 
		if (ch == '') ch = 'U';      // 
	
		}
    *(lpOut + nOffs + i) = ch;
    }
}


/************************************************************************
 *  Garmin.cpp			S e t Z e r o T e r m S t r i n g				*
 ************************************************************************/
void CGarmin::SetZeroTermString(unsigned char* lpOut, short* ptOffs, char* szText, short nMaxLen)
{
	unsigned char ch;
	short i=0;

	do	{
		ch = *(szText + i++);
		*(lpOut + (*ptOffs)++) = ch;
		} while (ch > 0 && i < nMaxLen);

	if (i== nMaxLen)
		*(lpOut + nMaxLen-1) = 0;
}


/*********************************************************************
 *  Garmin.cpp				S e t S u b C l a s s				     *
 *********************************************************************/
void CGarmin::SetSubClass (SubClassType* ptSubClass)
{
ptSubClass->nDummy = 0;
ptSubClass->lDummy = 0;
ptSubClass->ulDummy1 = 0xFFFFFFFF;
ptSubClass->ulDummy2 = 0xFFFFFFFF;
ptSubClass->ulDummy3 = 0xFFFFFFFF;
}



/*********************************************************************
 *  Garmin.cpp			 S e n d G 1 0 0 R e a d R t e			     *
 *********************************************************************/
void CGarmin::SendG100ReadRte ()
{
*(m_lpOut + 0) = 0x01;
*(m_lpOut + 1) = 0x0A;
*(m_lpOut + 2) = 0x00;
*(m_lpOut + 3) = 0x00;

this->Write (m_lpOut, 4);

WaitTenthSec (2);
}



/************************************************************************
 *  Garmin.cpp				S h i f t A r r a y U p						*
 *  Input: lpData: First byte to shift up (byte whith smallest index)	*
 *			lCnt: Bytes to shift										*
 ************************************************************************/
void CGarmin::ShiftArrayUp (unsigned char* lpData, long lCnt)
{
long i;
for (i=lCnt-1; i>=0; i--)
	*(lpData + i+1) = *(lpData + i);
}

/************************************************************************
 *  Garmin.cpp			 S h i f t A r r a y D o w n					*
 *  Input: lpData: First byte to shift down	(byte whith smallest index)	*
 *			lCnt: Bytes to shift										*
 ************************************************************************/
void CGarmin::ShiftArrayDown (unsigned char* lpData, long lCnt)
{
short i;
for (i=0; i<lCnt; i++)
	*(lpData + i-1) = *(lpData + i);
}


/************************************************************************
 *  Garmin.cpp				C h e c k G a r m i n E S C 				*
 ************************************************************************/
void CGarmin::CheckGarminESC (BOOL bInsert, unsigned char* lpData, int* ptCnt, BOOL* ptHandleESC)
{					
long	i = 0;
long	lCnt = (long)*ptCnt;
long	lRest = lCnt;

while (i<lCnt)
	{
	if (*(lpData+i) == 0x10 && *ptHandleESC)
		{
		*ptHandleESC = TRUE;
		if (bInsert)
			{								// 0x10 will be uchanged
			this->ShiftArrayUp ((lpData+i), lRest);	// and copied here
			//*(lpData+i) = 0x10;			// already there
			lCnt++;
			*ptHandleESC = FALSE;			// accept next byte
			}
		else{
			lRest--;
			if (lRest > 0)					// 0x10 will be overwritten
					this->ShiftArrayDown ((lpData+i+1), lRest);
			else	*ptHandleESC = FALSE;	// accept next byte
			
			lRest--;
			lCnt--;
			}
		}
	else{					// nothing to change
		*ptHandleESC = TRUE;
		lRest--;
		}
		
	i++;
	}

(*ptCnt) = (int)lCnt;
}

/************************************************************************
 *  Garmin.cpp			S i m u l a t e P r o t o c o l A r r a y 		*
 ************************************************************************/
void CGarmin::SimulateProtocolArray()
{
	m_bSimulateProtocolArray = TRUE;
}

/************************************************************************
 *  Garmin.cpp				I s R e a l C o m m a n d 					*
 ************************************************************************/
BOOL CGarmin::IsRealCommand()
{
	m_bSimulateProtocolArray = FALSE;
	return m_bRealCommand;
}




/************************************************************************
 *  Garmin.cpp	     G e t N e x t G 1 0 0 D l E v e n t    DOWNLOAD	*
 ************************************************************************/
BOOL CGarmin::GetNextG100DlEvent (CGarminEvent* ptGE)
{
int	iRead = 0;
long	lOffset = 0;
BOOL	bMemOK = FALSE;
BOOL	bEnd = FALSE;
BOOL	bShifted = FALSE;
unsigned char	uMsgLen = 0;
short	nSum;
unsigned char uFillByte;

//ptGE = (CGarminEvent*)new CGarminEvent ();

iRead = this->BytesInQueue (3);
if (iRead < 3)
    {
    return TRUE;
    }

iRead = 3;
iRead = this->ReadComm(m_lpInp, (int)iRead);

if (iRead >= 3)
    {
    if (*(m_lpInp) == (unsigned char)0xAA)
		{
		UINT uDataLen;

		ptGE->SetFunction (*(m_lpInp + 1));
		uDataLen	= *(m_lpInp + 2);
		if (ptGE->GetFunction() == GE100_ACKN)
			uDataLen = 2;

		if (ptGE->SetDataLen (uDataLen))
			{
			bMemOK = TRUE;
			uMsgLen = (unsigned char)(3 + ptGE->GetDataLen() + 3);
			}
		}
    }

if (iRead < (int)uMsgLen)
    {				// last part of message
    long    lOffset;
    long    lRest;

    lOffset = iRead;
    lRest = (int)uMsgLen - iRead;

    iRead = this->BytesInQueue ((short)lRest);
    if (iRead < lRest)
		{
		return TRUE;
		}

    iRead = (int)lRest;
    iRead = this->ReadComm((m_lpInp + lOffset), (int)iRead);
    iRead = uMsgLen;
    }

do  {
    unsigned char uLast, uNew;

    uLast = *(m_lpInp + 3 + ptGE->GetDataLen() + 1);
    uNew  = *(m_lpInp + 3 + ptGE->GetDataLen() + 2);

    bEnd = (uLast == 0xAA && uNew == 0xAC);

    if (!bEnd)
		{
		*(m_lpInp + 3 + ptGE->GetDataLen() + 1) = uNew;
		iRead = this->BytesInQueue (1);
		if (iRead < 1)
			return TRUE;

		iRead = 1;
		iRead = this->ReadComm(&uNew, (int)iRead);
		if (iRead >= 1) *(m_lpInp + 3 + ptGE->GetDataLen() + 2) = uNew;
			else	return TRUE;
		}
    } while (!bEnd);


if (bMemOK)
    {
	ptGE->SetData (m_lpInp + 3);
    }

nSum = ptGE->GetCheckSum   (m_lpInp, 1, (short)(3+ptGE->GetDataLen() - 1));
uFillByte = this->FillByte (m_lpInp, 1, (short)(3+ptGE->GetDataLen() - 1));
ptGE->SetFillByte (uFillByte);

ptGE->SetCheckSum (*(m_lpInp + 3 + ptGE->GetDataLen()));
if (ptGE->GetFunction() == GE100_ACKN)
    ptGE->SetCheckSum (uFillByte);

return (!bMemOK || (iRead <= 0));
}


/************************************************************************
 *  Garmin.cpp				F u n c T o S t r i n g						*
 ************************************************************************/
void CGarmin::FuncToString (unsigned char uFunc, char* szFunc)
{
    switch (uFunc)
	{
	case GE100_ACKN:				// GPS 100 AVD, Download mode
		strcpy (szFunc, "GE100_ACKN");
		break;
	case GE100_NUMBCMDS:
		strcpy (szFunc, "GE100_NUMBCMDS");
		break;
	case GE100_NUMBRTE:
		strcpy (szFunc, "GE100_NUMBRTE");
		break;
	case GE100_WRITERTE:
		strcpy (szFunc, "GE100_WRITERTE");
		break;
	case GE100_LASTCMD:
		strcpy (szFunc, "GE100_LASTCMD");
		break;

	default:
		strcpy (szFunc, "GE_UNKNOWN");
		break;
	}
}

/************************************************************************
 *  Garmin.cpp				W r i t e T o F i l e						*
 ************************************************************************/
void CGarmin::WriteToFile (CFile* ptFile, CGarminEvent* ptEvt)
{
	long	lLen;
	char	szFunc[32];
	char	szBuffer[256];

	unsigned char uFunc = ptEvt->GetFunction();
	CGarmin::FuncToString(uFunc, szFunc);

	long lDataLen = ptEvt->GetDataLen();
	unsigned char* ptData = ptEvt->GetDataPtr();

	if (ptData != NULL)
    {


    lLen = sprintf (szBuffer, "\r\nGPS sends %s (%d) with %ld bytes:\r\n", 
				szFunc, (short)uFunc, lDataLen);
    if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);

    if (ptData != NULL)
		{
		char szHexBuff[1024];
		long	lHexLen = 0;
		*szHexBuff = 0;
		CSerCom::ConvertBinToHex (ptData, lDataLen, szHexBuff, &lHexLen);
		szHexBuff[lHexLen] = 0; 		// make C-String

		if (ptFile != NULL)
			ptFile->Write ((const void*)szHexBuff, (UINT)lHexLen);
		}
    }
}



/************************************************************************
 *  Garmin.cpp	     G e t G a r m i n 1 0 0 S t a t e					*
 ************************************************************************/
BOOL CGarmin::GetGarmin100State (short* ptState)
{
int	iRead = 0;
BOOL	bState = FALSE;
unsigned char	cState;
short	nPos;
short	nTryCnt = 0;

for (nTryCnt=0; nTryCnt<3 && !bState; nTryCnt++)
    {
    cState = 0;
    iRead = this->BytesInQueue (4);
    if (iRead == 4)
		{
		short i;

		iRead = this->ReadComm(m_lpInp, (int)iRead);

		for (i=0; i<4; i++)
			{			/* get position of state byte		*/
			if (*(m_lpInp + i) != 0)
				{
				cState = *(m_lpInp + i);
				nPos = i;
				}
			}

		if (cState != 0)
			{			/* state byte found !!			*/
			short nZeroByteCnt; /*  => nPos defined (0...3)		*/

			if (nPos > 0)	/* but not on first position		*/
				{
				iRead = this->BytesInQueue (nPos);
				if (iRead == nPos)
					iRead = this->ReadComm((m_lpInp + nPos+1), (int)iRead);
				}

			nZeroByteCnt = 0;
			for (i=1; i<4; i++)
				{	    // check the 3 bytes following the state byte
				if (*(m_lpInp + nPos + i) == 0x00)
					nZeroByteCnt++;
				}

			bState = (nZeroByteCnt == 3);
			}
		}   // iRead == 4
    }	// for nTryCnt...

if (bState)
    {
    switch (cState)
		{
		case GE100_WAITS:
			*ptState = GE100_WAITS;
			break;

		case GE100_REPLY:
			*ptState = GE100_REPLY;
			break;
		default:
			bState = FALSE;
			break;
		}
    }

return (!bState || (iRead <= 0));
}

/************************************************************************
 *  Garmin.cpp				 A d d C h e c k B y t e s					*
 ************************************************************************/
short CGarmin::AddCheckBytes (unsigned char* szOut, short nLen,
		     unsigned char uStartByte)
{
short	i, j, nBytesToInsert;

nBytesToInsert = nLen /3;

for (i=nBytesToInsert-1; i>=0; i--)
    {
    for (j=2; j>=0; j--)
		{
		*(szOut + i*3 + j + i + 1) = *(szOut + i*3 + j);
		}
    *(szOut + i*3 + j + i + 1) = uStartByte + (unsigned)i;
    }
return nBytesToInsert;
}

/************************************************************************
 *  Garmin.cpp				C o p y B i t R a n g e						*
 *  Purpose: Copies "nCnt" bits from "Src" to "ptDest"					*
 ************************************************************************/
void CGarmin::CopyBitRange (short nCnt, unsigned char* ptDest, short nLowDestBit,
							unsigned char Src, short nLowSrcBit)
{
unsigned char SrcCpy = 0;
unsigned char SrcBitMask = 0;
unsigned char DestBitMask = 0;
						// nLowSrcBit:	3
						// bits to copy: 00101
						// Src:		10010110
SrcCpy = Src >> (nLowSrcBit - 1);		// SrcCpy:	00100101
SrcBitMask = (unsigned char)0xFF >> (8 - nCnt);	// SrcBitMask:	00011111
SrcCpy = SrcCpy & SrcBitMask;			// SrcCpy:	00000101

						// nLowDestBit:	3
DestBitMask = SrcCpy << (nLowDestBit - 1);	// DestBitMask:	00010100

*ptDest = *ptDest | DestBitMask;
}

/************************************************************************
 *  Garmin.cpp			 S e t G 1 0 0 R t e H e a d e r				*
 ************************************************************************/
short CGarmin::SetG100RteHeader (short nRteID, short nWptCnt)
{
short	nOffs = 0;
//*(m_lpOut + 0) =				// Fillbyte
*(m_lpOut + 1) = (unsigned char)nRteID + 0x30;
*(m_lpOut + 2) = (unsigned char)nWptCnt;
nOffs = 3;

return nOffs;
}

/************************************************************************
 *  Garmin.cpp				    I s C h a r A _ Z						*
 ************************************************************************/
BOOL CGarmin::IsCharA_Z (char ch)
{
BOOL	bIsChar = FALSE;

if (ch >= 'A' && ch <= 'Z')
    bIsChar = TRUE;

return bIsChar;
}


/************************************************************************
 *  Garmin.cpp				S e t G 1 0 0 R t e W p t					*
 ************************************************************************/
short CGarmin::SetG100RteWpt (short nOffs,
							char* szWptName, short nLen,
							short nCC, unsigned char uType)
{
char	szName[20];
short	nCountryCode, i;
char	szCC[3];
BOOL	bLetter[8];
unsigned char* szOut;

this->CopyWptName ((unsigned char*)szName, 0, 5, szWptName, nLen);
szName[5] = 0;

nCountryCode = nCC;
szCC[0] = *((unsigned char*)&nCountryCode+0);
szCC[1] = *((unsigned char*)&nCountryCode+1);
szCC[2]	= 0;

for (i=0; i<5; i++)
	bLetter[i] = this->IsCharA_Z (*(szName + i));

for (i=0; i<2; i++)
	bLetter[i+5] = this->IsCharA_Z (*(szCC + i));

bLetter[7] = this->IsCharA_Z (uType);


szOut = m_lpOut + nOffs;
for (i=0; i<6; i++)			// reset szOut - Bytes
	*(szOut+i) = 0;

this->CopyBitRange (1, szOut+5, 8,	(unsigned char)(bLetter[0]? 1:0), 1);
this->CopyBitRange (5, szOut+5, 3,	*(szName+0), 	1);
this->CopyBitRange (1, szOut+5, 2,	(unsigned char)(bLetter[1]? 1:0), 1);
this->CopyBitRange (1, szOut+5, 1,	*(szName+1),	5);

this->CopyBitRange (4, szOut+4, 5,	*(szName+1), 	1);
this->CopyBitRange (1, szOut+4, 4,	(unsigned char)(bLetter[2]? 1:0), 1);
this->CopyBitRange (3, szOut+4, 1,	*(szName+2),	3);

this->CopyBitRange (2, szOut+3, 7,	*(szName+2), 	1);
this->CopyBitRange (1, szOut+3, 6,	(unsigned char)(bLetter[3]? 1:0), 1);
this->CopyBitRange (5, szOut+3, 1,	*(szName+3), 	1);

this->CopyBitRange (1, szOut+2, 8,	(unsigned char)(bLetter[4]? 1:0), 1);
this->CopyBitRange (5, szOut+2, 3,	*(szName+4),	1);
this->CopyBitRange (1, szOut+2, 2,	(unsigned char)(bLetter[5]? 1:0), 1);
this->CopyBitRange (1, szOut+2, 1,	*(szCC+0),		5);

this->CopyBitRange (4, szOut+1, 5,	*(szCC+0),		1);
this->CopyBitRange (1, szOut+1, 4,	(unsigned char)(bLetter[6]? 1:0), 1);
this->CopyBitRange (3, szOut+1, 1, 	*(szCC+1),		3);

this->CopyBitRange (2, szOut+0, 7, 	*(szCC+1),		1);
this->CopyBitRange (1, szOut+0, 6,	(unsigned char)(bLetter[7]? 1:0), 1);
this->CopyBitRange (5, szOut+0, 1,	uType,			1);

nOffs = 6;
return nOffs;
}

/************************************************************************
 *  Garmin.cpp			S e n d G 1 0 0 R t e W p t s					*
 ************************************************************************/
void CGarmin::SendG100RteWpts (short nOffs)
{
*(m_lpOut + 0) = this->FillByte (m_lpOut, 1, nOffs-1);
nOffs += this->AddCheckBytes (m_lpOut, nOffs, 0x0B);
this->Write (m_lpOut, nOffs);
}


/************************************************************************
 *  Garmin.cpp			S e n d G 1 0 0 U s e r W p t					*
 ************************************************************************/
void CGarmin::SendG100UserWpt (char* szName, short nMaxWptChars,
							double Lat, double Lon, long lAlt)
{
long	lKoord;
short	nOffs = 0;

this->CopyWptName (m_lpOut, 0, 6, szName, nMaxWptChars);
nOffs = 6;
*(m_lpOut + nOffs) = 0x20;
nOffs+=1;

*(m_lpOut + nOffs) = 0x55;
nOffs+=1;

lKoord = (long)(Lat * KOORD_FAKT);
*(m_lpOut + nOffs) = *((unsigned char*)&lKoord+0);
*(m_lpOut + nOffs+1) = *((unsigned char*)&lKoord+1);
*(m_lpOut + nOffs+2) = *((unsigned char*)&lKoord+2);
*(m_lpOut + nOffs+3) = *((unsigned char*)&lKoord+3);
nOffs+=4;

lKoord = (long)(Lon * KOORD_FAKT);
*(m_lpOut + nOffs) = *((unsigned char*)&lKoord+0);
*(m_lpOut + nOffs+1) = *((unsigned char*)&lKoord+1);
*(m_lpOut + nOffs+2) = *((unsigned char*)&lKoord+2);
*(m_lpOut + nOffs+3) = *((unsigned char*)&lKoord+3);
nOffs+=4;

*(m_lpOut + nOffs) = *((unsigned char*)&lAlt+0);
*(m_lpOut + nOffs+1) = *((unsigned char*)&lAlt+1);
*(m_lpOut + nOffs+2) = *((unsigned char*)&lAlt+2);
*(m_lpOut + nOffs+3) = *((unsigned char*)&lAlt+3);
nOffs+=4;


*(m_lpOut + nOffs) = this->FillByte (m_lpOut, 0, nOffs-1);
nOffs+=1;

nOffs += this->AddCheckBytes (m_lpOut, nOffs, 0x1E);

this->Write (m_lpOut, nOffs);
}




/////////////////////////////////////////////////////////////////////////////
// CGarmin diagnostics

#ifdef _DEBUG
void CGarmin::AssertValid() const
{
	CSerCom::AssertValid();
}

void CGarmin::Dump(CDumpContext& dc) const
{
	CSerCom::Dump(dc);
}

#endif //_DEBUG

IMPLEMENT_DYNAMIC(CGarmin, CSerCom)
