#ifndef __GARMIN__
#define __GARMIN__
/*********************************************************************
 *							G a r m i n . h						     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "..\Cpptools\SerCom.h"
#include "GarminEv.h"
#include "GarminProtocols.h"

class CFile;
class CGarmin : public CSerCom
{    
DECLARE_DYNAMIC(CGarmin)
     
private:
	CGarminProtocols* m_ptProtocols;
	CFile*				m_ptLogFile;
	BOOL	m_bRealCommand;
	BOOL	m_bSimulateProtocolArray;

protected: // create from serialization only

// Attributes
// Operations
public:
	BOOL SendCommand (unsigned char uFunc, unsigned char* ptData, short nLen);
	short CalcRteTransRecords(short nWptCnt);

	void SimulateProtocolArray();
	BOOL IsRealCommand();

// Implementation
private:
	void ShiftArrayUp (unsigned char* lpData, long lCnt);
	void ShiftArrayDown (unsigned char* lpData, long lCnt);
	short AddCheckBytes (unsigned char* szOut, short nLen, unsigned char uStartByte);
	void CopyBitRange (short nCnt, unsigned char* ptDest, short nLowDestBit,
							unsigned char Src, short nLowSrcBit);
	BOOL IsCharA_Z (char ch);
	void SaveData (unsigned char uFunc, unsigned char* ptData, short nLen);

public:
	CGarmin(long lBaud, short nData, float fStop, short nParity, BOOL bBinary = FALSE);
	virtual ~CGarmin();

	void SetLogFilePtr(CFile* ptFile) { m_ptLogFile = ptFile; }

	unsigned char FillByte (unsigned char* lpOut, short nFirstByte, short nLastByte);


	void CopyWptName (unsigned char* lpOut, short nOffs, short nBytes, 
						char* szName, short nLen);

	void SetZeroTermString(unsigned char* lpOut, short* ptOffs, char* szText, short nMaxLen);

	void SetSubClass (SubClassType* ptSubClass);
	void SendG100ReadRte ();
	void CheckGarminESC (BOOL bInsert, unsigned char* lpData, int* ptCnt, BOOL* ptHandleESC);

	BOOL GetNextG100DlEvent (CGarminEvent* ptGE);
	static void FuncToString (unsigned char uFunc, char* szFunc);
	void WriteToFile (CFile* ptFile, CGarminEvent* ptEvt);

	BOOL GetGarmin100State (short* ptState);
	short SetG100RteHeader (short nRteID, short nWptCnt);
	short SetG100RteWpt (short nOffs,
							char* szWptName, short nLen,
							short nCC, unsigned char uType);
	void SendG100RteWpts (short nOffs);
	void SendG100UserWpt (char* szName, short nLen, double Lat, double Lon, long lAlt);



#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};




#endif
