#ifndef __GARMINEVENT__
#define __GARMINEVENT__
/*********************************************************************
 *							G a r m i n E v . h					     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "..\Cpptools\SerCom.h"
#include "GarminWpt.h"
#include "GarminHeaderTypes.h"

#define WAIT_TIME 10

#define GE100_WAITS	((unsigned char)0x0A)
#define GE100_REPLY	((unsigned char)0x09)
#define GE100_ACKN	((unsigned char)0x08)
#define GE100_NUMBCMDS	((unsigned char)0x43)
#define GE100_NUMBRTE	((unsigned char)0x45)
#define GE100_WRITERTE	((unsigned char)0x46)
#define GE100_LASTCMD	((unsigned char)0x42)

					    // TRANSMIT mode
#define GE100_USERWPT	((unsigned char)0x1E)
#define GE100_RTE		((unsigned char)0x0B)

#define ALT_KORR    47




class CGarminEvent : public CObject
{    
DECLARE_DYNAMIC(CGarminEvent)
     
private:
    unsigned char   m_uFunc;
    unsigned char   m_uDataLen;
    unsigned char*	m_ptData;
    unsigned char   m_uCheckSum;
    unsigned char   m_uFill;


protected: // create from serialization only

// Attributes
// Operations
public:


// Implementation
private:
	void SpaceTerminatedText (char* szText, short nBuffLen, 
							unsigned char* lpData, short nMaxData);
	void TextToLower (char* szText);

public:
	CGarminEvent();
	virtual ~CGarminEvent();

	void SetFunction (unsigned char uFunc) { m_uFunc = uFunc; }
	BOOL SetDataLen (unsigned char uLen);
	void SetData (unsigned char* ptData);
	void SetCheckSum (unsigned char uSum) { m_uCheckSum = uSum; }
	void SetFillByte (unsigned char uFill) { m_uFill = uFill; }

	unsigned char* GetDataPtr() { return m_ptData; }
	long GetDataLen () { return (long)m_uDataLen; }
	unsigned char GetFunction () { return m_uFunc; }

	short GetCheckSum (unsigned char* lpOut, short nFirstByte, short nLastByte);
	BOOL CheckSumOK();
	short SplitAcknowledge ();
	short SplitNumbOfCmds();
	short SplitLimZeroTermString(long* ptOffset, char* ptText, short nMaxLen);
	short SplitD200RouteHeader();
	short SplitD201RouteHeader(char* szName);
	short SplitD202RouteHeader(char* szName);

	BOOL SplitWriteWpt (CFile* ptFile,
		    char* szIndic, char* szName, double* ptLat, double* ptLon,
		    short* ptCC, unsigned char* ptCategory);

	BOOL SplitG100Wpt (CFile* ptFile,
		    char* szIndic, double* ptLat, double* ptLon,
		    short* ptCC, unsigned char* ptCategory, float* ptElev_m);



	unsigned long GarminToSystemTime (unsigned long lGarminTime);
	BOOL SplitD300TrackPoint (CFile* ptFile, double* ptLat, double* ptLon, 
			unsigned long* ptTime, BOOL* ptStart);
	BOOL SplitD301TrackPoint (CFile* ptFile, double* ptLat, double* ptLon, 
			unsigned long* ptTime, double* ptAlt_ft, BOOL* ptAltOK, BOOL* ptStart);
	BOOL SplitD310TrackHeader(CFile* ptFile, BOOL* ptDisplay, char* ptColor, CString* ptHeader);


#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};




#endif
