#ifndef __GARMIN_HEADER_TYPES__
#define __GARMIN_HEADER_TYPES__

// GarminHeaderTypes.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de


typedef struct
{
	short product_ID;
	short software_version;
	CString product_description;
	// char* product_description[];  // null-terminated string
	// zero or more additional null-terminated strings
} Product_Data_Type;		// see page 14


/******************************** D200_Rte_Hdr_Type	****************************/
//Example products: GPS 55 and GPS 55 AVD.
typedef byte D200_Rte_Hdr_Type; /* route number */

/******************************** D201_Rte_Hdr_Type	****************************/
//Example products: all products unless otherwise noted.
	typedef struct
	{
	byte nmbr; /* route number */
	char cmnt[20]; /* comment */
	} D201_Rte_Hdr_Type;

/******************************** D202_Rte_Hdr_Type	****************************/
// Example products: StreetPilot.
typedef struct
{
	CString rte_ident; /* null-terminated string */
} D202_Rte_Hdr_Type;

/******************************** D310_Trk_Hdr_Type	****************************/

typedef struct
{
boolean				dspl;				/* display on the map?		*/
byte				color;				/* color (same as D108)		*/
char				trk_ident[52];		/* null-terminated string	*/
} D310_Trk_Hdr_Type;


typedef struct
{
	unsigned short index;	/* unique among all tracks received from device	*/
} D311_Trk_Hdr_Type;


typedef struct
{
	boolean dspl;		/* display on the map? */
	byte	color;		/* color (see below) */
	char	trk_ident[52];		/* null-terminated string	*/
} D312_Trk_Hdr_Type;


#endif