#ifndef __GARMIN_LINK1_EVENT__
#define __GARMIN_LINK1_EVENT__

/*********************************************************************
 *							G a r m i n E v . h					     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "..\Cpptools\SerCom.h"
#include "GarminWpt.h"
#include "GarminHeaderTypes.h"

#define WAIT_TIME 10

#define ALT_KORR    47






class CGpsDevice;
class CGarminLink1Event : public CObject
{    
DECLARE_DYNAMIC(CGarminLink1Event)
     
private:
    short		    m_nFunc;
    DWORD			m_dwDataLen;
    unsigned char*	m_ptData;
    unsigned char   m_uCheckSum;
    unsigned char   m_uFill;

protected: // create from serialization only

// Attributes
// Operations
public:
	enum							// A010 Device Command Protocol, see pg. 17
	{
	Cmnd_Abort_Transfer = 0,		/* abort current transfer */
	Cmnd_Transfer_Alm = 1,			/* transfer almanac */
	Cmnd_Transfer_Posn = 2,			/* transfer position */
	Cmnd_Transfer_Prx = 3,			/* transfer proximity waypoints */
	Cmnd_Transfer_Rte = 4,			/* transfer routes */
	Cmnd_Transfer_Time = 5,			/* transfer time */
	Cmnd_Transfer_Trk = 6,			/* transfer track log */
	Cmnd_Transfer_Wpt = 7,			/* transfer waypoints */
	Cmnd_Turn_Off_Pwr = 8,			/* turn off power */
	Cmnd_Start_Pvt_Data = 49,		/* start transmitting PVT data */
	Cmnd_Stop_Pvt_Data = 50			/* stop transmitting PVT data */
	};

	enum
	{								// Basic packet IDs, see pg. 9
	Pid_Ack_Byte = 6,
	Pid_Nak_Byte = 21,
	Pid_Version_Terrain_DB = 248,	/* may not be implemented in all products */
	Pid_Protocol_Array = 253,		/* may not be implemented in all products */
	Pid_Product_Rqst = 254,
	Pid_Product_Data = 255
	};

	enum							// L001 Link Protocol, see pg. 10
	{
	Pid_Command_Data = 10,
	Pid_Xfer_Cmplt = 12,
	Pid_Date_Time_Data = 14,
	Pid_Position_Data = 17,
	Pid_Prx_Wpt_Data = 19,
	Pid_Records = 27,
	Pid_Rte_Hdr = 29,
	Pid_Rte_Wpt_Data = 30,
	Pid_Almanac_Data = 31,
	Pid_Trk_Data = 34,
	Pid_Wpt_Data = 35,
	Pid_Pvt_Data = 51,
	Pid_Rte_Link_Data = 98,
	Pid_Trk_Hdr = 99
	};

// Implementation
private:
	void SpaceTerminatedText (char* szText, short nBuffLen, 
							unsigned char* lpData, short nMaxData);
	void TextToLower (char* szText);

public:
	CGarminLink1Event();
	CGarminLink1Event(CGarminLink1Event& SourceEvt);
	virtual ~CGarminLink1Event();

	CGarminLink1Event& operator =(const CGarminLink1Event& evt);

	void SetFunction (short nFunc) { m_nFunc = nFunc; }
	BOOL SetDataLen (DWORD dwDataSize);
	void SetData (unsigned char* ptData);
	void SetCheckSum (unsigned char uSum) { m_uCheckSum = uSum; }
	void SetFillByte (unsigned char uFill) { m_uFill = uFill; }

	unsigned char* GetDataPtr() { return m_ptData; }
	long GetDataLen () { return (long)m_dwDataLen; }
	short GetFunction () { return m_nFunc; }

	short GetCheckSum (unsigned char* lpOut, short nFirstByte, short nLastByte);
	BOOL CheckSumOK();
	short SplitAcknowledge ();
	BOOL OnReadProduct (Product_Data_Type* ptProd, CFile* ptFile);
	short SplitNumbOfCmds(CFile* ptFile=NULL);
	short SplitLimZeroTermString(long* ptOffset, char* ptText, short nMaxLen);
	short SplitD200RouteHeader();
	short SplitD201RouteHeader(char* szName);
	short SplitD202RouteHeader(char* szName);

	BOOL SplitWriteWpt (CFile* ptFile,
		    char* szIndic, char* szName, double* ptLat, double* ptLon,
		    short* ptCC, unsigned char* ptCategory);

	BOOL IsValueNot1E25(float fValue);


	unsigned long GarminToSystemTime (unsigned long lGarminTime);

	BOOL SplitD300TrackPoint (CFile* ptFile, double* ptLat, double* ptLon, 
			unsigned long* ptTime, BOOL* ptStart);
	BOOL SplitD301TrackPoint (CFile* ptFile, double* ptLat, double* ptLon, 
			unsigned long* ptTime, double* ptAlt_ft, BOOL* ptAltOK, BOOL* ptStart);
	BOOL SplitD302TrackPoint (CFile* ptFile, double* ptLat, double* ptLon, 
			unsigned long* ptTime, double* ptAlt_ft, BOOL* ptAltOK,
			double* ptTemp_C, BOOL* ptTempOK, BOOL* ptStart);
	BOOL SplitD303TrackPoint (CFile* ptFile, double* ptLat, double* ptLon, 
			unsigned long* ptTime, double* ptAlt_ft, BOOL* ptAltOK, 
			BYTE* ptHeartRate, BOOL* ptFirstStopTrk, BOOL* ptStartLap);
	BOOL SplitD304TrackPoint (CFile* ptFile, double* ptLat, double* ptLon, 
			unsigned long* ptTime, 
			double* ptAlt_ft, BOOL* ptAltOK, 
			double* ptDist_m, BOOL* ptDistOK, 
			BYTE* ptHeartRate, BYTE* ptCadence, BOOL* ptFirstStopTrk, BOOL* ptStartLap);


	BOOL SplitD310TrackHeader(CFile* ptFile, BOOL* ptDisplay, char* ptColor, CString* ptHeader);
	BOOL SplitD311TrackHeader(CFile* ptFile, short* ptIndex);
	BOOL SplitD312TrackHeader(CFile* ptFile, BOOL* ptDisplay, char* ptColor, CString* ptHeader);


#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};




#endif
