/*********************************************************************
 *					G a r m i n L i n k 2 E v . c p p			     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "DimDoc.h"  
#include "Location.h"			// defines INDICATOR_SIZE, WP_USER
#include "GpsDevice.h"
#include "GarminLink2Ev.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*			ptDim;

/************************************************************************
 *  GarminEv.cpp				C G a r m i n E v e n t		CONSTRUCTOR	*
 ************************************************************************/
CGarminLink2Event::CGarminLink2Event()
{
m_uFunc = 0;
m_uDataLen = 0;
m_ptData = NULL;
m_uCheckSum = 0;
m_uFill = 0;
}

/************************************************************************
 *  GarminEv.cpp				C G a r m i n E v e n t		CONSTRUCTOR	*
 ************************************************************************/
CGarminLink2Event::CGarminLink2Event(CGarminLink2Event& SourceEvt)
{ 
	*this = SourceEvt;
}


/************************************************************************
 *  GarminEv.cpp			~ C G a r m i n	E v e n t		DESTRUCTOR	*
 ************************************************************************/
CGarminLink2Event::~CGarminLink2Event()
{
if (m_ptData != NULL)
	{
	delete [] m_ptData;
	m_ptData = NULL;
	}
}

/************************************************************************
 *  GarminEv.cpp				o p e r a t o r  = 						*
 ************************************************************************/
CGarminLink2Event& CGarminLink2Event::operator =(const CGarminLink2Event& evt)
{
	if (m_ptData != NULL)
	{
		delete [] m_ptData;
		m_ptData = NULL;
		m_uDataLen = NULL;
	}

    m_uFunc	= evt.m_uFunc;
    m_uDataLen	= evt.m_uDataLen;
	
	m_ptData = (unsigned char*)new unsigned char[m_uDataLen];
	memcpy(m_ptData, evt.m_ptData, m_uDataLen);
   
    m_uCheckSum = evt.m_uCheckSum;
    m_uFill		= evt.m_uFill;

	return *this;
}

/************************************************************************
 *  GarminEv.cpp				S e t D a t a L e n						*
 ************************************************************************/
BOOL CGarminLink2Event::SetDataLen (unsigned char uLen)
{
m_uDataLen	= uLen;
m_ptData = (unsigned char*)new unsigned char[m_uDataLen];
return (m_ptData != NULL);
}

/************************************************************************
 *  GarminEv.cpp				S e t D a t a							*
 ************************************************************************/
void CGarminLink2Event::SetData (unsigned char* ptData)
{
_fmemcpy (m_ptData, ptData, m_uDataLen);
}

/************************************************************************
 *  GarminEv.cpp			    G e t C h e c k S u m					*
 ************************************************************************/
short CGarminLink2Event::GetCheckSum (unsigned char* lpOut, short nFirstByte, short nLastByte)
{
short	nSum = 0;
short	i;

for (i=nFirstByte; i<=nLastByte; i++)	// build check sum
	nSum += *(lpOut + i);
return nSum;
}

/************************************************************************
 *  GarminEv.cpp				C h e c k S u m O K						*
 ************************************************************************/
BOOL CGarminLink2Event::CheckSumOK()
{
return (m_uCheckSum == m_uFill);
}



/************************************************************************
 *  GarminEv.cpp			S p l i t A c k n o w l e d g e				*
 ************************************************************************/
short CGarminLink2Event::SplitAcknowledge ()
{
short nFunc = 0;

if (m_ptData != NULL)
    {
    nFunc = (short)*(m_ptData);
    }

return nFunc;
}


/************************************************************************
 *  GarminEv.cpp			O n R e a d P r o d u c t					*
 ************************************************************************/
BOOL CGarminLink2Event::OnReadProduct (Product_Data_Type* ptProd, CFile* ptFile)
{
	BOOL bRead = FALSE;
	long lOffset = 0;

	if (m_uDataLen > 0)
	{		
		char	szBuffer[256];
		short	nBuffLen;
		

		ptProd->product_ID = *((short*)(m_ptData + lOffset));
		lOffset += 2;

		ptProd->software_version = *((short*)(m_ptData + lOffset));
		lOffset += 2;


		nBuffLen = sprintf (szBuffer, "\r\nProdID: %d Software: %d\r\nProdukt-Info:\r\n",
			ptProd->product_ID, ptProd->software_version);
		if (ptFile != NULL)
			ptFile->Write ((const void*)szBuffer, (UINT)nBuffLen);

	
		CStringArray prodInfos;

		do
		{
			char szText[256];
			SplitLimZeroTermString (&lOffset, szText, 256);
			CString prodInfo(szText);
			prodInfos.Add(prodInfo);

			if (ptProd->product_description.GetLength() == 0)
				ptProd->product_description = prodInfo;

			nBuffLen = sprintf (szBuffer, "%s\r\n", szText);
			if (ptFile != NULL)
				ptFile->Write ((const void*)szBuffer, (UINT)nBuffLen);

		} while (lOffset < m_uDataLen);

		bRead = TRUE;
	}
	

	return bRead;
}


/************************************************************************
 *  GarminEv.cpp			S p l i t N u m b O f C m d s				*
 ************************************************************************/
short CGarminLink2Event::SplitNumbOfCmds()
{
short nNumbOfCmds = 0;

if (m_ptData != NULL)
    {
    nNumbOfCmds = (short)*((unsigned char*)m_ptData);
    }

return nNumbOfCmds;
}


/************************************************************************
 *  GarminEv.cpp		S p l i t L i m Z e r o T e r m S t r i n g		*
 ************************************************************************/
short CGarminLink2Event::SplitLimZeroTermString(long* ptOffset, char* ptText, short nMaxLen)
{
	short j=0;
	unsigned char ch;
    do	{
    	ch = (unsigned char)*((unsigned char*)m_ptData + (*ptOffset)++); 
   		*(ptText + j++) = (char)ch;  
    	} while (ch > 0 && j < nMaxLen);

	if (j==nMaxLen)
		*(ptText + nMaxLen-1) = 0;

	return j;
}

/************************************************************************
 *  GarminEv.cpp		S p l i t D 2 0 0 R o u t e H e a d e r			*
 ************************************************************************/
short CGarminLink2Event::SplitD200RouteHeader()
{
short nNumbOfRte = 0;

if (m_ptData != NULL)
    {
    nNumbOfRte = (short)*((unsigned char*)m_ptData);
    }

return nNumbOfRte;
}

/************************************************************************
 *  GarminEv.cpp		S p l i t D 2 0 1 R o u t e H e a d e r			*
 ************************************************************************/
short CGarminLink2Event::SplitD201RouteHeader(char* szName)
{
short nNumbOfRte = 0;

if (m_ptData != NULL)
    {
    short	i, j;
    BOOL	bStop = FALSE;
    
    i=0;                  
    j=0;
    nNumbOfRte = (short)*((unsigned char*)m_ptData + i++);               
    do	{
    	unsigned char ch = (unsigned char)*((unsigned char*)m_ptData + i++); 
    	if (ch==0x5F)
    		{
    		*szName = 0;
    		bStop=TRUE;
    		}       
    	else{
    		*(szName + j++) = (char)ch;  
    		}
    	if (ch == 0)
    		bStop = TRUE;
    	} while (!bStop);
    }

return nNumbOfRte;
}

/************************************************************************
 *  GarminEv.cpp		S p l i t D 2 0 2 R o u t e H e a d e r			*
 ************************************************************************/
short CGarminLink2Event::SplitD202RouteHeader(char* szName)
{
	short nStrLen=0;

	if (m_ptData != NULL)
    {
    short	i;
    BOOL	bStop = FALSE;
    
    i=0;                  
    nStrLen=0;
    do	{
    	unsigned char ch = (unsigned char)*((unsigned char*)m_ptData + i++); 
    	if (ch==0x5F)
    		{
    		*szName = 0;
    		bStop=TRUE;
    		}       
    	else{
    		*(szName + nStrLen++) = (char)ch;  
    		}
    	if (ch == 0)
    		bStop = TRUE;
    	} while (!bStop);
    }

return nStrLen;
}

/************************************************************************
 *  GarminEv.cpp		S p a c e T e r m i n a t e d T e x t			*
 ************************************************************************/
void CGarminLink2Event::SpaceTerminatedText (char* szText, short nBuffLen, 
							unsigned char* lpData, short nMaxData)
{       
short	i, nDataLen, nCopy;
BOOL	bEnd = FALSE;
  
memset (szText, 0, nBuffLen); 			// initialize text buffer

nDataLen = nMaxData;      				// get data length
for (i=nMaxData-1; i>=0 && !bEnd; i--)
	if (*(lpData+i) == ' ')	nDataLen--;
			else			bEnd = TRUE;
			
nCopy = (nDataLen > nBuffLen-1)? nBuffLen-1 : nDataLen;

for (i=0; i<nCopy; i++)
	*(szText+i) = *(lpData+i);
}

/************************************************************************
 *  GarminEv.cpp			T e x t T o L o w e r						* 
 *  Purpose: Convert string ABCD EFG to Abcd Efg						*
 ************************************************************************/
void CGarminLink2Event::TextToLower (char* szText)
{
short 	i, nLen;     
char	ch;
BOOL	bUpper = TRUE;

nLen = strlen (szText);

for (i=0; i<nLen; i++)
	{
	ch = *(szText + i);
	if (!bUpper)
		*(szText + i) = tolower(ch); 
	bUpper = (ch == ' ');
	}
}   

/************************************************************************
 *  GarminEv.cpp			S p l i t W r i t e W p t					*
 ************************************************************************/
BOOL CGarminLink2Event::SplitWriteWpt (CFile* ptFile,
		    char* szIndic, char* szName, double* ptLat, double* ptLon,
		    short* ptCC, unsigned char* ptCategory)
{
BOOL	bOK = FALSE;
long	lLat, lLon, lTime;
char	szFacility[31];

if (m_ptData != NULL)
    {
	char	szBuffer[256];
    short   nSumLat, nSumLon;
    long    lOffs = 0;
    long    lLen;

 
    this->SpaceTerminatedText (szIndic, INDICATOR_SIZE, m_ptData+lOffs, 6);
    lOffs += 6;

    *(m_ptData + lOffs) = 0;		// ignore first byte of long
    lLat = *((long*)(m_ptData + lOffs));
    nSumLat = this->GetCheckSum (m_ptData + lOffs, 0, 3);
    *ptLat = (double)lLat/KOORD_FAKT;
    lOffs += 4;

    *(m_ptData + lOffs) = 0;		// ignore first byte of long
    lLon = *((long*)(m_ptData + lOffs));
    nSumLon = this->GetCheckSum (m_ptData + lOffs, 0, 3);
    *ptLon = (double)lLon/KOORD_FAKT;
    lOffs += 4;

    lTime = *((unsigned long*)(m_ptData + lOffs));
    lOffs += 4;
         
	if (m_uDataLen >= 124)
		{              
		lOffs = 62;
		this->SpaceTerminatedText (szFacility, 31, m_ptData+lOffs, 30);

		lOffs = 92;
		this->SpaceTerminatedText (szName, SIZEOF_ORT, m_ptData+lOffs, 24);
        this->TextToLower (szName);
        
		lOffs = 120;
		*ptCC = *((short*)(m_ptData+lOffs));
	
		lOffs = 123;
		*ptCategory = *((unsigned char*)(m_ptData+lOffs));
		}
         
    lLen = sprintf (szBuffer, "\r\nCity=%s Facility=%s Indic=%s, Lat=%f, Lon=%f\r\nCC=%d, Cat=%d, Time=%ld CheckSum=%d Fill=%d\r\n",
	       		szName, szFacility, szIndic, *ptLat, *ptLon, *ptCC, (short)(*ptCategory),
				lTime, (int)m_uCheckSum, (int)m_uFill);
    if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);
    bOK = TRUE;
    }

return bOK;
}





/************************************************************************
 *  GarminEv.cpp		G a r m i n T o S y s t e m T i m e 			*
 ************************************************************************/
unsigned long CGarminLink2Event::GarminToSystemTime (unsigned long lGarminTime)
{
	unsigned long lTimeDiff = 7304 * (24*3600);
	unsigned long lSystemTime = lGarminTime + lTimeDiff;
	return lSystemTime;
}

/************************************************************************
 *  GarminEv.cpp		S p l i t D 3 0 0 T r a c k P o i n t			*
 ************************************************************************/
BOOL CGarminLink2Event::SplitD300TrackPoint (CFile* ptFile,
		    double* ptLat, double* ptLon, unsigned long* ptTime, BOOL* ptStart)
{
BOOL	bOK = FALSE;
D300_Trk_Point_Type	GarminWpt;

if (m_ptData != NULL)
    {
	char	szBuffer[256];
    long    lLen;

	short nBlkSize = sizeof (D300_Trk_Point_Type);

												// read garmin data struct
	memcpy (&GarminWpt, m_ptData, nBlkSize);
												// convert data to preflight format
	*ptLat = (double)GarminWpt.posn.lat/KOORD_FAKT;
	*ptLon = (double)GarminWpt.posn.lon/KOORD_FAKT;
 
	*ptTime = this->GarminToSystemTime (GarminWpt.time);
	*ptStart = GarminWpt.new_trk;

         
    lLen = sprintf (szBuffer, "\r\nLat=%f, Lon=%f Time=%ld, bStart=%d, CheckSum=%d Fill=%d\r\n",
	       		*ptLat, *ptLon, *ptTime, *ptStart,
				(int)m_uCheckSum, (int)m_uFill);
    if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);
    bOK = TRUE;
    }

return bOK;
}

/************************************************************************
 *  GarminEv.cpp		S p l i t D 3 0 1 T r a c k P o i n t			*
 ************************************************************************/
BOOL CGarminLink2Event::SplitD301TrackPoint (CFile* ptFile,
		    double* ptLat, double* ptLon, unsigned long* ptTime, 
			double* ptAlt_ft, BOOL* ptAltOK, BOOL* ptStart)
{
BOOL	bOK = FALSE;
D301_Trk_Point_Type	GarminWpt;

if (m_ptData != NULL)
    {
	char	szBuffer[256];
    long    lLen;

	short nBlkSize = sizeof (D301_Trk_Point_Type);

												// read garmin data struct
	memcpy (&GarminWpt, m_ptData, nBlkSize);
												// convert data to preflight format
	*ptLat = (double)GarminWpt.posn.lat/KOORD_FAKT;
	*ptLon = (double)GarminWpt.posn.lon/KOORD_FAKT;
 
	*ptTime = this->GarminToSystemTime (GarminWpt.time);

	*ptAltOK = (GarminWpt.alt != 0x4A000000);	// 1 EXP 25
	if (*ptAltOK)
	{							// gps sends altitude in meters					
		*ptAlt_ft = ptDim->ConvertDist (GarminWpt.alt, DIM_METER, DIM_FEET);
	}

	double dDepth;				// unused!!
	BOOL	bDepthOK = (GarminWpt.dpth != 0x4A000000);	// 1 EXP 25
	if (bDepthOK)
	{							// gps sends depth in meters					
		dDepth = ptDim->ConvertDist (GarminWpt.dpth, DIM_METER, DIM_FEET);
	}

	*ptStart = GarminWpt.new_trk;

         
    lLen = sprintf (szBuffer, "\r\nLat=%f, Lon=%f Time=%ld, Alt_ft=%f\r\nDepth_ft=%f, bStart=%d, CheckSum=%d Fill=%d\r\n",
	       		*ptLat, *ptLon, *ptTime, *ptAlt_ft, dDepth, *ptStart,
				(int)m_uCheckSum, (int)m_uFill);
    if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);
    bOK = TRUE;
    }

return bOK;
}

/************************************************************************
 *  GarminEv.cpp		S p l i t D 3 1 0 T r a c k H e a d e r			*
 ************************************************************************/
BOOL CGarminLink2Event::SplitD310TrackHeader(CFile* ptFile, BOOL* ptDisplay, char* ptColor, CString* ptHeader)
{
	BOOL	bOK = FALSE;
	D310_Trk_Hdr_Type header;

	if (m_ptData != NULL)
    {
		char	szBuffer[256];
		long    lOffs = 0;
		long    lLen;

		header.dspl = m_ptData[lOffs++];
		header.color = m_ptData[lOffs++];
		lLen = this->SplitLimZeroTermString(&lOffs, header.trk_ident, 52);
		bOK = (lLen > 0);

		*ptDisplay = (header.dspl == 1);
		*ptColor = (char)header.color;
		*ptHeader = header.trk_ident;

		lLen = sprintf (szBuffer, "\r\nbDisplay=%d Color=%d, TrkIdent=%s, CheckSum=%d Fill=%d\r\n",
	       		header.dspl, (int)header.color, header.trk_ident,
				(int)m_uCheckSum, (int)m_uFill);

		if (ptFile != NULL)
			ptFile->Write ((const void*)szBuffer, (UINT)lLen);
	}

	return bOK;
}


/////////////////////////////////////////////////////////////////////////////
// CGarminLink2Event diagnostics

#ifdef _DEBUG
void CGarminLink2Event::AssertValid() const
{
	CObject::AssertValid();
}

void CGarminLink2Event::Dump(CDumpContext& dc) const
{
	CObject::Dump(dc);
}

#endif //_DEBUG

IMPLEMENT_DYNAMIC(CGarminLink2Event, CObject)
