#ifndef __GARMIN_LINK2_EVENT__
#define __GARMIN_LINK2_EVENT__

/*********************************************************************
 *							G a r m i n E v . h					     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "..\Cpptools\SerCom.h"
#include "GarminWpt.h"
#include "GarminHeaderTypes.h"

#define WAIT_TIME 10

#define ALT_KORR    47


class CGpsDevice;
class CGarminLink2Event : public CObject
{    
DECLARE_DYNAMIC(CGarminLink2Event)
     
private:
    unsigned char   m_uFunc;
    unsigned char   m_uDataLen;
    unsigned char*	m_ptData;
    unsigned char   m_uCheckSum;
    unsigned char   m_uFill;

protected: // create from serialization only

// Attributes
// Operations
public:
	enum							// A011 Device Command Protocol, see pg. 18
	{
	Cmnd_Abort_Transfer = 0,		/* abort current transfer	*/
	Cmnd_Transfer_Alm = 4,			/* transfer almanac			*/
	Cmnd_Transfer_Rte = 8,			/* transfer routes			*/
	Cmnd_Transfer_Time = 20,		/* transfer time			*/
	Cmnd_Transfer_Wpt = 21,			/* transfer waypoints		*/
	Cmnd_Turn_Off_Pwr = 26			/* turn off power			*/
	};

	enum
	{								// Basic packet IDs, see pg. 9
	Pid_Ack_Byte = 6,
	Pid_Nak_Byte = 21,
	Pid_Protocol_Array = 253, /* may not be implemented in all products */
	Pid_Product_Rqst = 254,
	Pid_Product_Data = 255
	};


	enum
	{
	Pid_Almanac_Data = 4,
	Pid_Command_Data = 11,
	Pid_Xfer_Cmplt = 12,
	Pid_Date_Time_Data = 20,
	Pid_Position_Data = 24,
	Pid_Records = 35,
	Pid_Rte_Hdr = 37,
	Pid_Rte_Wpt_Data = 39,
	Pid_Wpt_Data = 43
	};

// Implementation
private:
	void SpaceTerminatedText (char* szText, short nBuffLen, 
							unsigned char* lpData, short nMaxData);
	void TextToLower (char* szText);

public:
	CGarminLink2Event();
	CGarminLink2Event(CGarminLink2Event& SourceEvt);
	virtual ~CGarminLink2Event();

	CGarminLink2Event& operator =(const CGarminLink2Event& evt);

	void SetFunction (unsigned char uFunc) { m_uFunc = uFunc; }
	BOOL SetDataLen (unsigned char uLen);
	void SetData (unsigned char* ptData);
	void SetCheckSum (unsigned char uSum) { m_uCheckSum = uSum; }
	void SetFillByte (unsigned char uFill) { m_uFill = uFill; }

	unsigned char* GetDataPtr() { return m_ptData; }
	long GetDataLen () { return (long)m_uDataLen; }
	unsigned char GetFunction () { return m_uFunc; }

	short GetCheckSum (unsigned char* lpOut, short nFirstByte, short nLastByte);
	BOOL CheckSumOK();
	static void FuncToString (unsigned char uFunc, char* szFunc);
	void WriteToFile (CFile* ptFile, CGarminLink2Event* ptEvt);
	short SplitAcknowledge ();
	BOOL OnReadProduct (Product_Data_Type* ptProd, CFile* ptFile);
	short SplitNumbOfCmds();
	short SplitLimZeroTermString(long* ptOffset, char* ptText, short nMaxLen);
	short SplitD200RouteHeader();
	short SplitD201RouteHeader(char* szName);
	short SplitD202RouteHeader(char* szName);

	BOOL SplitWriteWpt (CFile* ptFile,
		    char* szIndic, char* szName, double* ptLat, double* ptLon,
		    short* ptCC, unsigned char* ptCategory);


	unsigned long GarminToSystemTime (unsigned long lGarminTime);
	BOOL SplitD300TrackPoint (CFile* ptFile, double* ptLat, double* ptLon, 
			unsigned long* ptTime, BOOL* ptStart);
	BOOL SplitD301TrackPoint (CFile* ptFile, double* ptLat, double* ptLon, 
			unsigned long* ptTime, double* ptAlt_ft, BOOL* ptAltOK, BOOL* ptStart);
	BOOL SplitD310TrackHeader(CFile* ptFile, BOOL* ptDisplay, char* ptColor, CString* ptHeader);


#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
};




#endif
