/*********************************************************************
 *					G a r m i n P r o t o c o l s . c p p 		     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "GarminProtocols.h"


/************************************************************************
 *  GarminProtocols.cpp	  C G a r m i n P r o t o c o l s	CONSTRUCTOR	*
 ************************************************************************/
CGarminProtocols::CGarminProtocols()
{
	ResetProtocols();
}


/************************************************************************
 *  GarminProtocols.cpp	 ~ C G a r m i n P r o t o c o l s 	DESTRUCTOR	*
 ************************************************************************/
CGarminProtocols::~CGarminProtocols()
{
}


/********************************************************************************
 *  GarminProtocols.cpp			R e s e t P r o t o c o l s						*
 ********************************************************************************/
void CGarminProtocols::ResetProtocols()
{
    memset (&m_Protocols, 0, sizeof(GarminProtocols));
}

/************************************************************************
 *  GarminProtocols.cpp			S e t P r o t o c o l s					*
 ************************************************************************/
void CGarminProtocols::SetProtocols(short nProductID, double fSoftwareVersion)
{
	ResetProtocols();

	m_nProduct_ID = nProductID;
	m_fSoftware_Version = fSoftwareVersion;

	switch(m_nProduct_ID)
	{
		case 7:		SetProduct007Protocols();	break;
		case 25:	SetProduct025Protocols();	break;
		case 13:	SetProduct013Protocols();	break;
		case 14:	SetProduct014Protocols();	break;
		case 15:	SetProduct015Protocols();	break;
		case 18:	SetProduct018Protocols();	break;
		case 20:	SetProduct020Protocols();	break;
		case 22:	SetProduct022Protocols();	break;
		case 23:	SetProduct023Protocols();	break;
		case 24:	SetProduct024Protocols();	break;
		case 29:	SetProduct029Protocols();	break;
		case 31:	SetProduct031Protocols();	break;
		case 33:	SetProduct033Protocols();	break;
		case 34:	SetProduct034Protocols();	break;
		case 35:	SetProduct035Protocols();	break;
		case 36:	SetProduct036Protocols();	break;
		case 39:	SetProduct039Protocols();	break;

		case 41:	SetProduct041Protocols();	break;
		case 42:	SetProduct042Protocols();	break;
		case 44:	SetProduct044Protocols();	break;
		case 45:	SetProduct045Protocols();	break;
		case 47:	SetProduct047Protocols();	break;
		case 48:	SetProduct048Protocols();	break;
		case 49:	SetProduct049Protocols();	break;
		case 50:	SetProduct050Protocols();	break;
		case 52:	SetProduct052Protocols();	break;
		case 53:	SetProduct053Protocols();	break;
		case 55:	SetProduct055Protocols();	break;
		case 56:	SetProduct056Protocols();	break;
		case 59:	SetProduct059Protocols();	break;
		case 61:	SetProduct061Protocols();	break;
		case 62:	SetProduct062Protocols();	break;
		case 64:	SetProduct064Protocols();	break;
		case 71:	SetProduct071Protocols();	break;
		case 72:	SetProduct072Protocols();	break;
		case 73:	SetProduct073Protocols();	break;
		case 74:	SetProduct074Protocols();	break;
		case 76:	SetProduct076Protocols();	break;
		case 77:	SetProduct077Protocols();	break;
		case 87:	SetProduct087Protocols();	break;
		case 88:	SetProduct088Protocols();	break;
		case 95:	SetProduct095Protocols();	break;
		case 96:	SetProduct096Protocols();	break;
		case 97:	SetProduct097Protocols();	break;
		case 98:	SetProduct098Protocols();	break;
		case 100:	SetProduct100Protocols();	break;
		case 105:	SetProduct105Protocols();	break;
		case 106:	SetProduct106Protocols();	break;
		case 112:	SetProduct112Protocols();	break;
		case 145:	SetProduct145Protocols();	break;
	}	
}

/************************************************************************
 *  GarminProtocols.cpp			S p l i t P r o t o c o l s				*
 ************************************************************************/
void CGarminProtocols::SplitProtocols(unsigned char* ptData,
								  long lDataLen,
								  CFile* ptFile)
{
	short nOffset=0;
	CString szMode;

	ResetProtocols();

	char	szBuffer[256];
	long lLen = sprintf (szBuffer, "\r\n");
    if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);

	GarminProtocolMode protMode, oldProtMode;

	Protocol_Data_Type ProtocolType;
	short nBlkSize =  sizeof (Protocol_Data_Type);

	while (nOffset < lDataLen)
	{
		memcpy (&ProtocolType, (ptData + nOffset), nBlkSize);

		if (ProtocolType.cTag == Tag_Phys_Prot_Id)
		{
			protMode = PHYS;
			oldProtMode = protMode;

			switch (ProtocolType.wData)
			{
			case 000: m_Protocols.nPhys = P000_Dflt;		break;
			default:
				m_Protocols.nPhys = P000_Dflt;
				break;
			}
		}

		if (ProtocolType.cTag == Tag_Link_Prot_Id)
		{
			protMode = LINK;
			switch (ProtocolType.wData)
			{
			case 000:	m_Protocols.nLink = L000_Basic;		break;
			case 001:	m_Protocols.nLink = L001_Link;		break;
			case 002:	m_Protocols.nLink = L002_Link;		break;
			default:
				break;
			}
		}

		if (ProtocolType.cTag == Tag_Appl_Prot_Id)
		{
			switch (ProtocolType.wData)
			{
			case 000:	protMode = PROD;
						m_Protocols.nProd = A000_ProdData;		break;
			case 001:	protMode = PROT;
						m_Protocols.nProt = A001_ProtCapa;		break;
			case 010:	protMode = CMND;
						m_Protocols.nCmnd = A010_DeviceCmd;		break;
			case 011:	protMode = CMND;
						m_Protocols.nCmnd = A011_DeviceCmd;		break;
			case 100:	protMode = WPT;
						m_Protocols.Wpt.nTrans = A100_WptTrans;		break;
			case 101:	protMode = WPT;
						m_Protocols.Wpt.nTrans = A101_WptCategory;		break;
			case 200:	protMode = RTE;
						m_Protocols.Rte.nTrans = A200_RteTrans;		break;
			case 201:	protMode = RTE;
						m_Protocols.Rte.nTrans = A201_RteTrans;		break;
			case 300:	protMode = TRK;
						m_Protocols.Trk.nTrans = A300_TrkTrans;		break;
			case 301:	protMode = TRK;
						m_Protocols.Trk.nTrans = A301_TrkTrans;		break;
			case 302:	protMode = TRK;
						m_Protocols.Trk.nTrans = A302_TrkTrans;		break;
			case 400:	protMode = PRX;
						m_Protocols.Prx.nTrans = A400_PrxTrans;		break;
			case 500:	protMode = ALM;
						m_Protocols.Alm.nTrans = A500_AlmTrans;		break;
			case 600:	protMode = DATETIME;
						m_Protocols.Dat.nTrans = A600_DateTime;		break;
			case 650:	protMode = FLB;
						m_Protocols.Flb.nTrans = A650_FlightBook;	break;
			case 700:	protMode = INIT;
						m_Protocols.Ini.nTrans = A700_PosInit;		break;
			case 800:	protMode = PVT;
						m_Protocols.Pvt.nTrans = A800_PVTdata;		break;
			case 900:	protMode = UNKN;
						m_Protocols.Xxx.nTrans = A900_Xxx;		break;
			case 901:	protMode = UNKN;
						m_Protocols.Xxx.nTrans = A901_Xxx;		break;
			case 902:	protMode = UNKN;
						m_Protocols.Xxx.nTrans = A902_Xxx;		break;
			case 903:	protMode = UNKN;
						m_Protocols.Xxx.nTrans = A903_Xxx;		break;
			case 904:	protMode = UNKN;
						m_Protocols.Xxx.nTrans = A904_Xxx;		break;
			case 905:	protMode = UNKN;
						m_Protocols.Xxx.nTrans = A905_Xxx;		break;
			case 906:	protMode = LAP;
						m_Protocols.Lap.nTrans = A906_LapTrans;		break;
			case 1000:	protMode = RUN;
						m_Protocols.Run.nTrans = A1000_RunTrans;	break;
			case 1002:	protMode = WKO;
						m_Protocols.Wko.nTrans = A1002_Workout;		break;
			case 1004:	protMode = FITUSER;
						m_Protocols.Usr.nTrans = A1004_FitnessUser;		break;
			case 1005:	protMode = WKL;
						m_Protocols.Wkl.nTrans = A1005_WorkoutLimits;	break;
			case 1006:	protMode = CRS;
						m_Protocols.Crs.nTrans = A1006_Course;			break;
			case 1009:	protMode = CRL;
						m_Protocols.Crl.nTrans = A1009_CourseLimits;	break;

			default:
				break;
			}

			// for debugging only:

			switch (protMode)
			{
				case WPT:		szMode = "WPT";		break;
				case RTE:		szMode = "RTE";		break;
				case TRK:		szMode = "TRK";		break;
				case PRX:		szMode = "PRX";		break;
				case ALM:		szMode = "ALM";		break;
				case DATETIME:	szMode = "DATETIME";break;
				case FLB:		szMode = "FLB";		break;			
				case INIT:		szMode = "INIT";	break;
				case PVT:		szMode = "PVT";		break;
				case UNKN:		szMode = "UNKN";	break;
				case LAP:		szMode = "LAP";			break;
				case RUN:		szMode = "RUN";			break;
				case WKO:		szMode = "WORKOUT";		break;
				case FITUSER:	szMode = "FITUSER";		break;
				case WKL:		szMode = "WORKOUTLIM";	break;
				case CRS:		szMode = "COURSE";		break;
				case CRL:		szMode = "COURSELIM";	break;
			}

			if (protMode != oldProtMode)
			{
				lLen = sprintf (szBuffer, "\r\nMode:=%s", (LPCTSTR)szMode);
				if (ptFile != NULL)
					ptFile->Write ((const void*)szBuffer, (UINT)lLen);

				oldProtMode=protMode;
			}
		}

		if (ProtocolType.cTag == Tag_Data_Type_Id)
		{
			switch (protMode)
			{
			case WPT:
					// D100_Wpt, ..., D155_Wpt
				if (ProtocolType.wData >=100 && ProtocolType.wData <=199)
				{		// for G296: replace D120_WptCat with alternate D101_Wpt
					if (ProtocolType.wData != D120_WptCat)
						m_Protocols.Wpt.nWpt = ProtocolType.wData;
				}
				break;
			case RTE:
					// D100_Wpt, ..., D155_Wpt
				if (ProtocolType.wData >=100 && ProtocolType.wData <=199)
					m_Protocols.Rte.nWpt = ProtocolType.wData;

					// D200_Rte_Hdr, D201_Rte_Hdr, D202_Rte_Hdr
				if (ProtocolType.wData >=200 && ProtocolType.wData <=209)
					m_Protocols.Rte.nHdr = ProtocolType.wData;

					// D210_Rte_Link
				if (ProtocolType.wData >=210 && ProtocolType.wData <=219)
					m_Protocols.Rte.nLink = ProtocolType.wData;
				break;
			case TRK:
					// D300_Trk_Point, D301_Trk_Point
				if (ProtocolType.wData >=300 && ProtocolType.wData <=309)
					m_Protocols.Trk.nPoint = ProtocolType.wData;

					// D310_Trk_Hdr
				if (ProtocolType.wData >=310 && ProtocolType.wData <=319)
					m_Protocols.Trk.nHdr = ProtocolType.wData;
				break;
			case PRX:
					// D100_Wpt, ..., D155_Wpt

			//	if (ProtocolType.wData >=100 && ProtocolType.wData <=199)
			//		m_Protocols.Prx.nWpt = ProtocolType.wData;

					// D400_Prx_Wpt, D403_Prx_Wpt, D450_Prx_Wpt
			//	if (ProtocolType.wData >=400 && ProtocolType.wData <=499)
					m_Protocols.Prx.nWpt = ProtocolType.wData;

				break;
			case ALM:	// D500_Almanac, D501_Almanac, D550_Almanac, D551_Almanac
				m_Protocols.Alm.nAlm = ProtocolType.wData;
				break;

			case DATETIME:	// D600_Date_Time
				m_Protocols.Dat.nDateTime = ProtocolType.wData;
				break;

			case FLB:	//	D650_FlightBook
				m_Protocols.Flb.nFlightBook = ProtocolType.wData;
				break;

			case INIT:	// D700_Position
				m_Protocols.Ini.nPosInit = ProtocolType.wData;
				break;
			case PVT:	// D800_Pvt_Data
				m_Protocols.Pvt.nPvt = ProtocolType.wData; 
				break;
			case UNKN:	// D900_Xxx
				m_Protocols.Xxx.nXxx = ProtocolType.wData;
				break;

			case LAP:
				m_Protocols.Lap.nLap = ProtocolType.wData;
				break;

			case RUN:
				m_Protocols.Run.nRun = ProtocolType.wData;
				break;

			case WKO:
				m_Protocols.Wko.nWorkout = ProtocolType.wData;
				break;

			case FITUSER:
				m_Protocols.Usr.nFltUser = ProtocolType.wData;
				break;

			case WKL:
				m_Protocols.Wkl.nWorkoutLimit = ProtocolType.wData;
				break;

			case CRS:
				m_Protocols.Crs.nCourse = ProtocolType.wData;
				break;

			case CRL:
				m_Protocols.Crl.nCourseLimit = ProtocolType.wData;
				break;
			}
		}

		nOffset += nBlkSize;

		long lLen = sprintf (szBuffer, "%c%d ",ProtocolType.cTag, ProtocolType.wData);
		if (ptFile != NULL)
			ptFile->Write ((const void*)szBuffer, (UINT)lLen);

	} // end while

	lLen = sprintf (szBuffer, "nBlkSize=%d nOffset=%d\r\n", nBlkSize, nOffset);
    if (ptFile != NULL)
		ptFile->Write ((const void*)szBuffer, (UINT)lLen);

}


/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l B a s e						*
 ********************************************************************************/
void CGarminProtocols::SetProtocolBase(short nPhys, short nLink, short nCmd)
{
    m_Protocols.nPhys = nPhys;
	m_Protocols.nLink = nLink;
	m_Protocols.nCmnd = nCmd;
}		
	

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l W p t							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolWpt(short nTrans, short nWpt)
{
	m_Protocols.Wpt.nTrans = nTrans;
	m_Protocols.Wpt.nWpt = nWpt;
}

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l R t e							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolRte(short nTrans, short nHdr, short nWpt, short nLink)
{
	m_Protocols.Rte.nTrans = nTrans;
	m_Protocols.Rte.nHdr = nHdr;
	m_Protocols.Rte.nWpt = nWpt;
	m_Protocols.Rte.nLink = nLink;
}
		
/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l T r k							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolTrk(short nTrans, short nHdr, short nPoint)
{
	m_Protocols.Trk.nTrans = nTrans;
	m_Protocols.Trk.nHdr = nHdr;
	m_Protocols.Trk.nPoint = nPoint;
}

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l P r x							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolPrx(short nTrans, short nWpt)
{
	m_Protocols.Prx.nTrans = nTrans;
	m_Protocols.Prx.nWpt = nWpt;
}

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l A l m							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolAlm(short nTrans, short nAlm)
{
	m_Protocols.Alm.nTrans = nTrans;
	m_Protocols.Alm.nAlm = nAlm;
}

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l D a t							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolDat(short nTrans, short nDateTime)
{
	m_Protocols.Dat.nTrans = nTrans;
	m_Protocols.Dat.nDateTime = nDateTime;
}

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l F l b							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolFlb(short nTrans, short nFlightBook)
{
	m_Protocols.Flb.nTrans = nTrans;
	m_Protocols.Flb.nFlightBook = nFlightBook;
}

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l I n i							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolIni(short nTrans, short nPosInit)
{
	m_Protocols.Ini.nTrans = nTrans;
	m_Protocols.Ini.nPosInit = nPosInit;
}

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l P v t							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolPvt(short nTrans, short nPvt)
{
	m_Protocols.Pvt.nTrans = nTrans;
	m_Protocols.Pvt.nPvt = nPvt;
}

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l X x x							*
 ********************************************************************************/
void CGarminProtocols::SetProtocolXxx(short nTrans, short nXxx)
{
	m_Protocols.Xxx.nTrans = nTrans;
	m_Protocols.Xxx.nXxx = nXxx;
}





/********************************************************************************
 *  GarminProtocols.cpp		G e t P r o t o c o l B a s e						*
 ********************************************************************************/
void CGarminProtocols::GetProtocolBase(short* ptPhys, short* ptLink, short* ptCmd)
{
    *ptPhys = m_Protocols.nPhys;
	*ptLink = m_Protocols.nLink;
	*ptCmd  = m_Protocols.nCmnd;
}		
	
/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l W p t							*
 ********************************************************************************/
void CGarminProtocols::GetProtocolWpt(short* ptTrans, short* ptWpt)
{
	*ptTrans = m_Protocols.Wpt.nTrans;
	*ptWpt   = m_Protocols.Wpt.nWpt;
}

/********************************************************************************
 *  GarminProtocols.cpp		S e t P r o t o c o l R t e							*
 ********************************************************************************/
void CGarminProtocols::GetProtocolRte(short* ptTrans, short* ptHdr, short* ptWpt, short* ptLink)
{
	*ptTrans = m_Protocols.Rte.nTrans;
	*ptHdr   = m_Protocols.Rte.nHdr;
	*ptWpt   = m_Protocols.Rte.nWpt;
	*ptLink  = m_Protocols.Rte.nLink; 
}
		
/********************************************************************************
 *  GarminProtocols.cpp		G e t P r o t o c o l T r k							*
 ********************************************************************************/
void CGarminProtocols::GetProtocolTrk(short* ptTrans, short* ptHdr, short* ptPoint)
{
	*ptTrans = m_Protocols.Trk.nTrans;
	*ptHdr	 = m_Protocols.Trk.nHdr;
	*ptPoint = m_Protocols.Trk.nPoint;
}

/********************************************************************************
 *  GarminProtocols.cpp		G e t P r o t o c o l P r x							*
 ********************************************************************************/
void CGarminProtocols::GetProtocolPrx(short* ptTrans, short* ptWpt)
{
	*ptTrans = m_Protocols.Prx.nTrans;
	*ptWpt = m_Protocols.Prx.nWpt;
}

/********************************************************************************
 *  GarminProtocols.cpp		G e t P r o t o c o l A l m							*
 ********************************************************************************/
void CGarminProtocols::GetProtocolAlm(short* ptTrans, short* ptAlm)
{
	*ptTrans = m_Protocols.Alm.nTrans;
	*ptAlm = m_Protocols.Alm.nAlm;
}

/********************************************************************************
 *  GarminProtocols.cpp		G e t P r o t o c o l D a t							*
 ********************************************************************************/
void CGarminProtocols::GetProtocolDat(short* ptTrans, short* ptDateTime)
{
	*ptTrans = m_Protocols.Dat.nTrans;
	*ptDateTime = m_Protocols.Dat.nDateTime;
}

/********************************************************************************
 *  GarminProtocols.cpp		G e t P r o t o c o l I n i							*
 ********************************************************************************/
void CGarminProtocols::GetProtocolIni(short* ptTrans, short* ptPosInit)
{
	*ptTrans = m_Protocols.Ini.nTrans;
	*ptPosInit = m_Protocols.Ini.nPosInit;
}

/********************************************************************************
 *  GarminProtocols.cpp		G e t P r o t o c o l P v t							*
 ********************************************************************************/
void CGarminProtocols::GetProtocolPvt(short* ptTrans, short* ptPvt)
{
	*ptTrans = m_Protocols.Pvt.nTrans;
	*ptPvt = m_Protocols.Pvt.nPvt;
}

/********************************************************************************
 *  GarminProtocols.cpp		G e t P r o t o c o l X x x							*
 ********************************************************************************/
void CGarminProtocols::GetProtocolXxx(short* ptTrans, short* ptXxx)
{
	*ptTrans = m_Protocols.Xxx.nTrans;
	*ptXxx = m_Protocols.Xxx.nXxx;
}





/************************************************************************
 *  GarminProtocols.cpp		SetProduct007Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct007Protocols()
{		// 7 All L001 A010 A100, D100 A200, D200, D100 A500, D500
				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D100_Wpt);
							// Trk
							// Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}


/************************************************************************
 *  GarminProtocols.cpp		SetProduct025Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct025Protocols()
{		// 25 All L001 A010 A100, D100 A200, D200, D100 A300, D300 A400, D400 A500, D500
				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D400_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}


/************************************************************************
 *  GarminProtocols.cpp		SetProduct013Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct013Protocols()
{		// 13 All L001 A010 A100, D100 A200, D200, D100 A300, D300 A400, D400 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D400_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct014Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct014Protocols()
{	//14 All L001 A010 A100, D100 A200, D200, D100 A400, D400 A500, D500


				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D100_Wpt);
							// Trk
	SetProtocolPrx(A400_PrxTrans, D400_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct015Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct015Protocols()
{	//15 All L001 A010 A100, D151 A200, D200, D151 A400, D151 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D151_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D151_Wpt);
							// Trk
	SetProtocolPrx(A400_PrxTrans, D151_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct018Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct018Protocols()
{	//18 All L001 A010 A100, D100 A200, D200, D100 A300, D300 A400, D400 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D400_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct020Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct020Protocols()
{	//20 All L002 A011 A100, D150 A200, D201, D150 A400, D450 A500, D550

				// All versions:
	SetProtocolBase(P000_Dflt, L002_Link, A011_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D150_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D150_Wpt);
	//Trk
	SetProtocolPrx(A400_PrxTrans, D450_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D550_Almanac);
}


/************************************************************************
 *  GarminProtocols.cpp		SetProduct022Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct022Protocols()
{	//22 All L001 A010 A100, D152 A200, D200, D152 A300, D300 A400, D152 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D152_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D152_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D151_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct023Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct023Protocols()
{	//23 All L001 A010 A100, D100 A200, D200, D100 A300, D300 A400, D400 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D400_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct024Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct024Protocols()
{	//24 All L001 A010 A100, D100 A200, D200, D100 A300, D300 A400, D400 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D400_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct029Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct029Protocols()
{	//29 < 4.00 L001 A010 A100, D101 A200, D201, D101 A300, D300 A400, D101 A500, D500
	//29 >= 4.00 L001 A010 A100, D102 A200, D201, D102 A300, D300 A400, D102 A500, D500

	if (m_fSoftware_Version < 4)
	{
		SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
		SetProtocolWpt(A100_WptTrans, D101_Wpt);
		SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D101_Wpt);
		SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
		SetProtocolPrx(A400_PrxTrans, D101_Wpt);
		SetProtocolAlm(A500_AlmTrans, D500_Almanac);
	}
	else
	{
		SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
		SetProtocolWpt(A100_WptTrans, D102_Wpt);
		SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D102_Wpt);
		SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
		SetProtocolPrx(A400_PrxTrans, D102_Wpt);
		SetProtocolAlm(A500_AlmTrans, D500_Almanac);
	}
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct031Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct031Protocols()
{	//31 All L001 A010 A100, D100 A200, D201, D100 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct033Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct033Protocols()
{	//33 All L002 A011 A100, D150 A200, D201, D150 A400, D450 A500, D550

				// All versions:
	SetProtocolBase(P000_Dflt, L002_Link, A011_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D150_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D150_Wpt);
	//Trk
	SetProtocolPrx(A400_PrxTrans, D450_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D550_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct034Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct034Protocols()
{	//34 All L002 A011 A100, D150 A200, D201, D150 A400, D450 A500, D550

				// All versions:
	SetProtocolBase(P000_Dflt, L002_Link, A011_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D150_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D150_Wpt);
	//Trk
	SetProtocolPrx(A400_PrxTrans, D450_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D550_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct035Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct035Protocols()
{	//35 All L001 A010 A100, D100 A200, D200, D100 A300, D300 A400, D400 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D400_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct036Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct036Protocols()
{	//36 < 3.00 L001 A010 A100, D152 A200, D200, D152 A300, D300 A400, D152 A500, D500
	//36 >= 3.00 L001 A010 A100, D152 A200, D200, D152 A300, D300 A500, D500

	if (m_fSoftware_Version < 3)
	{
		SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
		SetProtocolWpt(A100_WptTrans, D152_Wpt);
		SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D152_Wpt);
		SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
		SetProtocolPrx(A400_PrxTrans, D152_Wpt);
		SetProtocolAlm(A500_AlmTrans, D500_Almanac);
	}
	else
	{
		SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
		SetProtocolWpt(A100_WptTrans, D152_Wpt);
		SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D152_Wpt);
		SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
		//Prx
		SetProtocolAlm(A500_AlmTrans, D500_Almanac);
	}
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct039Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct039Protocols()
{	//39 All L001 A010 A100, D151 A200, D201, D151 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D151_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D151_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct041Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct041Protocols()
{	//41 All L001 A010 A100, D100 A200, D201, D100 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct042Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct042Protocols()
{	//42 All L001 A010 A100, D100 A200, D200, D100 A300, D300 A400, D400 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D200_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D400_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct044Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct044Protocols()
{	//44 All L001 A010 A100, D101 A200, D201, D101 A300, D300 A400, D101 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D101_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D101_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D101_Wpt);
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct045Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct045Protocols()
{	//45 All L001 A010 A100, D152 A200, D201, D152 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D152_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D152_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct047Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct047Protocols()
{	//47 All L001 A010 A100, D100 A200, D201, D100 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct048Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct048Protocols()
{	//48 All L001 A010 A100, D154 A200, D201, D154 A300, D300 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D154_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D154_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct049Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct049Protocols()
{	//49 All L001 A010 A100, D102 A200, D201, D102 A300, D300 A400, D102 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D102_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D102_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D102_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct050Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct050Protocols()
{	//50 All L001 A010 A100, D152 A200, D201, D152 A300, D300 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D152_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D152_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct052Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct052Protocols()
{	//52 All L002 A011 A100, D150 A200, D201, D150 A400, D450 A500, D550

				// All versions:
	SetProtocolBase(P000_Dflt, L002_Link, A011_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D150_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D150_Wpt);
	//Trk
	SetProtocolPrx(A400_PrxTrans, D450_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D550_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct053Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct053Protocols()
{	//53 All L001 A010 A100, D152 A200, D201, D152 A300, D300 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D152_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D152_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct055Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct055Protocols()
{	//55 All L001 A010 A100, D100 A200, D201, D100 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct056Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct056Protocols()
{	//56 All L001 A010 A100, D100 A200, D201, D100 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct059Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct059Protocols()
{	//59 All L001 A010 A100, D100 A200, D201, D100 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct061Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct061Protocols()
{	//61 All L001 A010 A100, D100 A200, D201, D100 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct062Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct062Protocols()
{	//62 All L001 A010 A100, D100 A200, D201, D100 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct064Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct064Protocols()
{	//64 All L002 A011 A100, D150 A200, D201, D150 A400, D450 A500, D551

				// All versions:
	SetProtocolBase(P000_Dflt, L002_Link, A011_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D150_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D150_Wpt);
	//Trk
	SetProtocolPrx(A400_PrxTrans, D450_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D551_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct071Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct071Protocols()
{	//71 All L001 A010 A100, D155 A200, D201, D155 A300, D300 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D155_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D155_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct072Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct072Protocols()
{	//72 All L001 A010 A100, D104 A200, D201, D104 A300, D300 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D104_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D104_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct073Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct073Protocols()
{	//73 All L001 A010 A100, D103 A200, D201, D103 A300, D300 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D103_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct074Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct074Protocols()
{	//74 All L001 A010 A100, D100 A200, D201, D100 A300, D300 A500, D500

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D100_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D500_Almanac);
}


/************************************************************************
 *  GarminProtocols.cpp		SetProduct076Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct076Protocols()
{	//76 All L001 A010 A100, D102 A200, D201, D102 A300, D300 A400, D102 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D102_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D102_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D102_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct077Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct077Protocols()
{	//77 < 3.01 L001 A010 A100, D100 A200, D201, D100 A300, D300 A400, D400 A500, D501
	//77 >= 3.01, < 3.50 L001 A010 A100, D103 A200, D201, D103 A300, D300 A400, D403 A500, D501
	//77 >= 3.50, < 3.61 L001 A010 A100, D103 A200, D201, D103 A300, D300 A500, D501
	//77 >= 3.61 L001 A010 A100, D103 A200, D201, D103 A300, D300 A400, D403 A500, D501

	if (m_fSoftware_Version < 3.01)
	{
		SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
		SetProtocolWpt(A100_WptTrans, D100_Wpt);
		SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D100_Wpt);
		SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
		SetProtocolPrx(A400_PrxTrans, D400_Prx_Wpt);
		SetProtocolAlm(A500_AlmTrans, D501_Almanac);
	}

	if (m_fSoftware_Version >= 3.01 && m_fSoftware_Version < 3.5)
	{
		SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
		SetProtocolWpt(A100_WptTrans, D103_Wpt);
		SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
		SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
		SetProtocolPrx(A400_PrxTrans, D403_Prx_Wpt);
		SetProtocolAlm(A500_AlmTrans, D501_Almanac);
	}

	if (m_fSoftware_Version >= 3.5 && m_fSoftware_Version < 3.61)
	{
		SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
		SetProtocolWpt(A100_WptTrans, D103_Wpt);
		SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
		SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
		//Prx
		SetProtocolAlm(A500_AlmTrans, D501_Almanac);
	}

	if (m_fSoftware_Version >= 3.61)
	{
		SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
		SetProtocolWpt(A100_WptTrans, D103_Wpt);
		SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
		SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
		SetProtocolPrx(A400_PrxTrans, D403_Prx_Wpt);
		SetProtocolAlm(A500_AlmTrans, D501_Almanac);
	}
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct087Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct087Protocols()
{	//87 All L001 A010 A100, D103 A200, D201, D103 A300, D300 A400, D403 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D103_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D403_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct088Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct088Protocols()
{	//87 All L001 A010 A100, D103 A200, D201, D103 A300, D300 A400, D403 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D102_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D102_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D102_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct095Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct095Protocols()
{	//95 All L001 A010 A100, D103 A200, D201, D103 A300, D300 A400, D403 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D103_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D403_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct096Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct096Protocols()
{	//96 All L001 A010 A100, D103 A200, D201, D103 A300, D300 A400, D403 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D103_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D403_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct097Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct097Protocols()
{	//97 All L001 A010 A100, D103 A200, D201, D103 A300, D300 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D103_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct098Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct098Protocols()
{	//98 All L002 A011 A100, D150 A200, D201, D150 A400, D450 A500, D551

				// All versions:
	SetProtocolBase(P000_Dflt, L002_Link, A011_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D150_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D150_Wpt);
	//Trk
	SetProtocolPrx(A400_PrxTrans, D450_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D551_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct100Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct100Protocols()
{	//100 All L001 A010 A100, D103 A200, D201, D103 A300, D300 A400, D403 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D103_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D403_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct105Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct105Protocols()
{	//105 All L001 A010 A100, D103 A200, D201, D103 A300, D300 A400, D403 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D103_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D403_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct106Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct106Protocols()
{	//106 All L001 A010 A100, D103 A200, D201, D103 A300, D300 A400, D403 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D103_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D103_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D403_Prx_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct112Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct112Protocols()
{	//112 All L001 A010 A100, D152 A200, D201, D152 A300, D300 A500, D501

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D152_Wpt);
	SetProtocolRte(A200_RteTrans, D201_Rte_Hdr, D152_Wpt);
	SetProtocolTrk(A300_TrkTrans, 0, D300_Trk_Point);
	//Prx
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
}

/************************************************************************
 *  GarminProtocols.cpp		SetProduct145Protocols						*
 ************************************************************************/
void CGarminProtocols::SetProduct145Protocols()
{	//GPSMAP196: ID=145 Vers: 0xCE00 (2.06) Vers: 0x3601

				// All versions:
	SetProtocolBase(P000_Dflt, L001_Link, A010_DeviceCmd);
	SetProtocolWpt(A100_WptTrans, D109_Wpt);
	SetProtocolRte(A201_RteTrans, D202_Rte_Hdr, D109_Wpt, D210_Rte_Link);
	SetProtocolTrk(A301_TrkTrans, D310_Trk_Hdr, D301_Trk_Point);
	SetProtocolPrx(A400_PrxTrans, D109_Wpt);
	SetProtocolAlm(A500_AlmTrans, D501_Almanac);
			
//	SetProtocolDat(A600_DateTime, D600_Date_Time);
	SetProtocolFlb(A650_FlightBook, D650_FlightBook);
	
	SetProtocolIni(A700_PosInit, D700_Position);		// see: 6.10
    SetProtocolPvt(A800_PVTdata, D800_Pvt_Data);		// see: 6.11
 
//	A900_Xxx, A901_Xxx, A902_Xxx, A903_Xxx, A904_Xxx
	SetProtocolXxx(A901_Xxx, D901_Xxx);
}
