#ifndef __GARMIN_PROTOCOLS__
#define __GARMIN_PROTOCOLS__

/*********************************************************************
 *					G a r m i n P r o t o c o l s . h			     *
 *********************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de


/******************* Pid_Protocol_Array ***************************/

typedef enum
{
	Tag_Phys_Prot_Id ='P',
	Tag_Link_Prot_Id ='L',
	Tag_Appl_Prot_Id ='A',
	Tag_Data_Type_Id ='D'
} PROTOCOL_TAG;				// see 6.2.3

typedef enum
{
P000_Dflt			// see: 3.1
} PhysProt;


typedef enum
{
L000_Basic,			// see: 4.1
L001_Link,			// see: 4.2
L002_Link			// see: 4.3
} LinkProt;


typedef enum
{						// see: page 11:
A000_ProdData=0,		// see: 6.2.4
A001_ProtCapa=1,
A010_DeviceCmd=10,		// see: 6.3.1
A011_DeviceCmd=11,		// see: 6.3.2
A100_WptTrans=100,		// see: 6.4
A101_WptCategory=101,	// see: 6.5
A200_RteTrans=200,		// see: 6.6.2
A201_RteTrans=201,		// see: 6.6.3
A300_TrkTrans=300,		// see: 6.7.2
A301_TrkTrans=301,		// see: 6.7.3
A302_TrkTrans=302,		// see: 6.7.4
A400_PrxTrans=400,		// see: 6.8
A500_AlmTrans=500,		// see: 6.9
A600_DateTime=600,		// see: 6.10
A650_FlightBook=650,	// see: 6.11
A700_PosInit=700,		// see: 6.12
A800_PVTdata=800,		// see: 6.13
A900_Xxx=900,			// ??
A901_Xxx,				// ??
A902_Xxx,				// ??
A903_Xxx,				// ??
A904_Xxx,				// ??
A905_Xxx,				// ??
A906_LapTrans,			// see: 6.14
A1000_RunTrans,			// see: 6.15
A1002_Workout,			// see: 6.16
A1004_FitnessUser,		// see: 6.17
A1005_WorkoutLimits,	// see: 6.18
A1006_Course,			// see: 6.19
A1009_CourseLimits		// see: 6.20
} ApplProt;


typedef enum
{
D100_Wpt = 100,			// see: 7.4.1
D101_Wpt,
D102_Wpt,
D103_Wpt,
D104_Wpt,
D105_Wpt,
D106_Wpt,
D107_Wpt,
D108_Wpt,
D109_Wpt,
D110_Wpt,				// see: 7.4.11
D120_WptCat=120,		// see: 7.4.12
D150_Wpt=150,
D151_Wpt,
D152_Wpt,
D154_Wpt=154,
D155_Wpt,
D200_Rte_Hdr=200,
D201_Rte_Hdr,
D202_Rte_Hdr,
D210_Rte_Link=210,
D300_Trk_Point=300,
D301_Trk_Point,
D302_Trk_Point,			// see: 7.4.24
D303_Trk_Point,			// see: 7.4.25
D304_Trk_Point,			// see: 7.4.26
D310_Trk_Hdr=310,
D311_Trk_Hdr,			// see: 7.4.28
D312_Trk_Hdr,			// see: 7.4.29
D400_Prx_Wpt=400,
D403_Prx_Wpt=403,
D450_Prx_Wpt=450,
D500_Almanac=500,
D501_Almanac,
D550_Almanac=550,
D551_Almanac,
D600_Date_Time=600,
D650_FlightBook=650,
D700_Position=700,
D800_Pvt_Data=800,
D901_Xxx=901,
D906_Lap=906,				// see: 7.4.41
D1000_Run=1000,				// see: 7.4.42
D1001_Run,					// see: 7.4.43
D1002_Workout,				// see: 7.4.44
D1003_WorkoutOccurence,		// see: 7.4.45
D1004_FitnesUser,			// see: 7.4.46
D1005_WorkoutLimits,		// see: 7.4.47
D1006_Course,				// see: 7.4.48
D1007_CourseLap,			// see: 7.4.49
D1008_Workout,				// see: 7.4.50
D1009_Run,					// see: 7.4.51
D1010_Run,					// see: 7.4.52
D1011_Lap,					// see: 7.4.53
D1012_Course_Pt,			// see: 7.4.54
D1013_Course_Limits			// see: 7.4.55
} ProdSpecData;


typedef struct
{
	short nTrans;
	short nWpt;
} GarminWptTrans;

typedef struct
{
	short nTrans;
	short nHdr;
	short nWpt;
	short nLink;
} GarminRteTrans;

typedef struct
{
	short nTrans;
	short nHdr;
	short nPoint;
} GarminTrkTrans;

typedef struct
{
	short nTrans;
	short nWpt;
} GarminPrxTrans;

typedef struct
{
	short nTrans;
	short nAlm;
} GarminAlmTrans;


typedef struct
{
	short nTrans;
	short nFlightBook;
} GarminFlbTrans;

typedef struct
{
	short nTrans;
	short nDateTime;
} GarminDatTrans;

typedef struct
{
	short nTrans;
	short nPosInit;
} GarminIniTrans;

typedef struct
{
	short nTrans;
	short nPvt;
} GarminPvtTrans;

typedef struct
{
	short nTrans;
	short nXxx;
} GarminXxxTrans;

typedef struct
{
	short nTrans;
	short nLap;
} GarminLapTrans;

typedef struct
{
	short nTrans;
	short nRun;
} GarminRunTrans;

typedef struct
{
	short nTrans;
	short nWorkout;
} GarminWkoTrans;

typedef struct
{
	short nTrans;
	short nFltUser;
} GarminUsrTrans;

typedef struct
{
	short nTrans;
	short nWorkoutLimit;
} GarminWklTrans;

typedef struct
{
	short nTrans;
	short nCourse;
} GarminCrsTrans;

typedef struct
{
	short nTrans;
	short nCourseLimit;
} GarminCrlTrans;


typedef enum
{
	PHYS,
	PROD,
	PROT,
	LINK,
	CMND,
	WPT,
	RTE,
	TRK,
	PRX,
	ALM,
	DATETIME,
	FLB,
	INIT,
	PVT,
	UNKN,
	LAP,
	RUN,
	WKO,
	FITUSER,
	WKL,
	CRS,
	CRL
} GarminProtocolMode;

typedef struct
{
	short nPhys;		// P000_Dflt			// see: 3.1
	short nProd;		// A000_ProdData
	short nProt;		// A001_ProtCapa
	short nLink;		// L000_Basic,			// see: 4.1
						// L001_Link,			// see: 4.2
						// L002_Link			// see: 4.3
	short nCmnd;		// A010_DeviceCmd,		// see: 6.3
						// A011_DeviceCmd,
	GarminWptTrans Wpt;	// A100...	
	GarminRteTrans Rte;	// A200...
	GarminTrkTrans Trk;	// A300...	
	GarminPrxTrans Prx;	// A400...	
	GarminAlmTrans Alm;	// A500...	
	GarminDatTrans Dat;	// A600...
	GarminFlbTrans Flb;	// A650...
	GarminIniTrans Ini;	// A700...
	GarminPvtTrans Pvt;	// A800...
	GarminXxxTrans Xxx;	// A900...
	GarminLapTrans Lap;	// A906...
	GarminRunTrans Run;	// A1000...
	GarminWkoTrans Wko;	// A1002...
	GarminUsrTrans Usr;	// A1004...
	GarminWklTrans Wkl;	// A1005...
	GarminCrsTrans Crs;	// A1006...
	GarminCrlTrans Crl;	// A1009...
} GarminProtocols;


#pragma pack(1)

typedef struct
{
	unsigned char	cTag;
	WORD			wData;
} Protocol_Data_Type;

#pragma pack()

class CGarminProtocols
{    
     
private:
	GarminProtocols m_Protocols;
	short	m_nProduct_ID;
	double	m_fSoftware_Version;


protected: // create from serialization only

// Attributes
// Operations
public:


// Implementation

public:
	CGarminProtocols();
	virtual ~CGarminProtocols();

	void ResetProtocols();
	void SetProtocols(short nProductID, double fSoftwareVersion);
	void SplitProtocols(unsigned char* ptData,
								  long lDataLen,
								  CFile* ptFile);

	void SetProtocolBase(short nPhys, short nLink, short nCmd);
	void SetProtocolWpt(short nTrans, short nWpt);
	void SetProtocolRte(short nTrans, short nHdr, short nWpt, short nLink=0);
	void SetProtocolTrk(short nTrans, short nHdr, short nPoint);
	void SetProtocolPrx(short nTrans, short nWpt);
	void SetProtocolAlm(short nTrans, short nAlm);
	void SetProtocolDat(short nTrans, short nDateTime);
	void SetProtocolFlb(short nTrans, short nFlightBook);
	void SetProtocolIni(short nTrans, short nPosInit);
	void SetProtocolPvt(short nTrans, short nPvt);
	void SetProtocolXxx(short nTrans, short nXxx);
	
	void GetProtocolBase(short* ptPhys, short* ptLink, short* ptCmd);
	void GetProtocolWpt(short* ptTrans, short* ptWpt);
	void GetProtocolRte(short* ptTrans, short* ptHdr, short* ptWpt, short* ptLink);
	void GetProtocolTrk(short* ptTrans, short* ptHdr, short* ptPoint);
	void GetProtocolPrx(short* ptTrans, short* ptWpt);
	void GetProtocolAlm(short* ptTrans, short* ptAlm);
	void GetProtocolDat(short* ptTrans, short* ptDateTime);
	void GetProtocolIni(short* ptTrans, short* ptPosInit);
	void GetProtocolPvt(short* ptTrans, short* ptPvt);
	void GetProtocolXxx(short* ptTrans, short* ptXxx);


private:
	void SetProduct007Protocols();
	void SetProduct025Protocols();
	void SetProduct013Protocols();
	void SetProduct014Protocols();
	void SetProduct015Protocols();
	void SetProduct018Protocols();
	void SetProduct020Protocols();
	void SetProduct022Protocols();
	void SetProduct023Protocols();
	void SetProduct024Protocols();
	void SetProduct029Protocols();
	void SetProduct031Protocols();
	void SetProduct033Protocols();
	void SetProduct034Protocols();
	void SetProduct035Protocols();
	void SetProduct036Protocols();
	void SetProduct039Protocols();
	void SetProduct041Protocols();
	void SetProduct042Protocols();
	void SetProduct044Protocols();
	void SetProduct045Protocols();
	void SetProduct047Protocols();
	void SetProduct048Protocols();
	void SetProduct049Protocols();
	void SetProduct050Protocols();
	void SetProduct052Protocols();
	void SetProduct053Protocols();
	void SetProduct055Protocols();
	void SetProduct056Protocols();
	void SetProduct059Protocols();
	void SetProduct061Protocols();
	void SetProduct062Protocols();
	void SetProduct064Protocols();
	void SetProduct071Protocols();
	void SetProduct072Protocols();
	void SetProduct073Protocols();
	void SetProduct074Protocols();
	void SetProduct076Protocols();
	void SetProduct077Protocols();
	void SetProduct087Protocols();
	void SetProduct088Protocols();
	void SetProduct095Protocols();
	void SetProduct096Protocols();
	void SetProduct097Protocols();
	void SetProduct098Protocols();
	void SetProduct100Protocols();
	void SetProduct105Protocols();
	void SetProduct106Protocols();
	void SetProduct112Protocols();
	void SetProduct145Protocols();
};

#endif
