// GetElev.cpp : Definiert den Einsprungpunkt fr die Konsolenanwendung.
//

#include "stdafx.h"
#include "GetElev.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Das einzige Anwendungsobjekt

CWinApp theApp;

using namespace std;

short LatLonToElev_m (double fLat, double fLon)
{
	double left_map_x			= 0.00000000000;
	double right_map_x			= 20.00000000000;
	double upper_map_y			= 60.00000000000;
	double lower_map_y			= 40.00000000000;
	short number_of_rows		= 2400;
	short number_of_columns		= 2400;
	double grid_size			= 0.00833333333;
	short elev_m_missing_flag	= -500;

	
	
	short nElev_m = elev_m_missing_flag;

	short nRow=-1;
	short nColumn=-1;
	long  lOffs = -1;

	if ((upper_map_y >= fLat && fLat >= lower_map_y+grid_size) &&
		 (left_map_x <= fLon && fLon <= right_map_x-grid_size) )
	{
		nRow	= number_of_rows   /(lower_map_y - upper_map_y) * (fLat - upper_map_y);
		nColumn = number_of_columns/(right_map_x - left_map_x ) * (fLon - left_map_x);

		lOffs = (nRow * number_of_columns + nColumn) * sizeof (short);
	}


	if (lOffs >= 0)
	{					// try to read counter from file
		CFile f;
		CFileException e;
		char* pFileName = "f:\\ELEVATION60_0_20_40\\mydata.bin";
		if(f.Open( pFileName, CFile::modeRead, &e ) )
		{
			f.Seek(lOffs, CFile::begin);
			f.Read ((void*)&nElev_m, sizeof (short));
			f.Close();
		}
		else
		{
		#ifdef _DEBUG
		   afxDump << "File could not be opened " << e.m_cause << "\n";
		#endif
		}
	}

	return nElev_m;
}


int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// MFC initialisieren, Ausgabe und Fehlermeldung bei Fehlern
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// ZU ERLEDIGEN: Fehlercode gem Ihren Anforderungen ndern
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{
		// ZU ERLEDIGEN: Anwendungsverhalten hier festlegen.
		double fLat, fLon;
		CString szTitle;
		szTitle.LoadString(IDS_TITLE);
		cout << (const TCHAR*)szTitle << endl;

		cout << "Breitengrad: ";
		cin >> fLat;
		cout << endl << "Laengengrad: ";
		cin >> fLon;
		cout << endl;

		short nElev = LatLonToElev_m (fLat, fLon);
		cout << "Hoehe = " << nElev << " m" << endl;

		nElev = LatLonToElev_m (60, 0);				// -500 (undefined)

		nElev = LatLonToElev_m (49.938,  9.0633);	// Aschaffenburg: 125 m  -> 125
		nElev = LatLonToElev_m (47.97333,8.52166);	// Donaueschingen: 679 m ->680
		nElev = LatLonToElev_m (42.5433, 2.12);		// Mont-Louis: 1709 m -> 1783
		nElev = LatLonToElev_m (47.4333,10.98333);	// Zugspitze: 3101 m -> 1557
		nElev = LatLonToElev_m (47.4166,10.98333);	// Zugspitze: 3101 m -> 2665


		double dLastLat = (double)40 + (double)20/2400;
		double dLastLon = (double)20 - (double)20/2400;
		nElev = LatLonToElev_m (dLastLat, dLastLon);	// -> 189 m

	}

	return nRetCode;
}


