/************************************************************************
 *  							G p s . c p p	  						*
 ************************************************************************/
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"

#include "pf.h"

#include "Location.h"				// defines WP_USER
#include "Gps.h"
#include "GarminEv.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CGps

IMPLEMENT_SERIAL(CGps, CObject, 0 /* schema number*/ )

/************************************************************************
 *  Gps.cpp			 	 C G p s						Constructor		*
 ************************************************************************/
CGps::CGps(LPGPS lpGps)
{ 
if (lpGps == NULL)
	{       
	this->FirstInit();
	} 
else{
    this->ReadFromPtr (lpGps);
    }
}

CGps::CGps(CGps& SourceGps)
{ 
*this = SourceGps;
}



/************************************************************************
 *  Gps.cpp			 ~ C G p s						Destructor		*
 ************************************************************************/
CGps::~CGps()
{
} 


/************************************************************************
 *  Gps.cpp						G e t P t r								*
 ************************************************************************/
void CGps::GetPtr(LPGPS lpGps)
{
this->WriteToPtr (lpGps);
}  

/************************************************************************
 *  Gps.cpp						S e t P t r								*
 ************************************************************************/
void CGps::SetPtr (LPGPS lpGps)
{
this->ReadFromPtr(lpGps);
}  

/************************************************************************
 *  Gps.cpp				operator=									*
 ************************************************************************/
const CGps& CGps::operator=(const CGps& Gps)
{
_fmemcpy (m_GPS.szName, Gps.m_GPS.szName, SIZEOF_GPS); 

return *this;
}

/************************************************************************
 *  Gps.cpp					F i r s t I n i t							*
 ************************************************************************/
void CGps::FirstInit()
{
	_fmemset (m_GPS.szName, 0, SIZEOF_GPS);
}


/************************************************************************
 *  Gps.cpp					R e a d F r o m P t r						*
 ************************************************************************/
void CGps::ReadFromPtr(LPGPS lpGps)
{
_fmemcpy ((LPGPS)&m_GPS, lpGps, sizeof (GPSTYPE)); 
}

/************************************************************************
 *  Gps.cpp					W r i t e T o P t r							*
 ************************************************************************/
void CGps::WriteToPtr(LPGPS lpGps) const
{
_fmemcpy (lpGps, (LPGPS)&m_GPS, sizeof (GPSTYPE)); 
}



/************************************************************************
 *  Gps.cpp			 	     G e t G 1 0 0 L o c T y p e 				*
 *  Input: cCategory: 48, 49 50, ...
 ************************************************************************/
unsigned char CGps::GetG100LocType (unsigned char cCategory)
{
short	i;

for (i=WP_USER; i>0; i--)
	{
	if (cCategory == m_GPS.cWptType[i])
		return (unsigned char)i;
	}
return WP_USER;
}

/************************************************************************
 *  Gps.cpp    		 		 S e r i a l i z e						*
 ************************************************************************/
void CGps::Serialize(CArchive& ar)
{ 
if (ar.IsStoring())
	{
		// TODO: add storing code here 
	AnsiToOem(m_GPS.szName, m_GPS.szName);
	ar.Write (m_GPS.szName, SIZEOF_GPS);
	}
else{ 					// TODO: add loading code here    
	ar.Read (m_GPS.szName, SIZEOF_GPS);   	
	OemToAnsi(m_GPS.szName, m_GPS.szName);
	}
} 


/************************************************************************
 *  Location.cpp    		 	C r e a t e P t r 						*
 ************************************************************************/
LPGPS CGps::CreatePtr ()
{
LPGPS lpGps = new GPSTYPE;

_fmemset (lpGps, 0, sizeof (GPSTYPE));

WriteToPtr(lpGps);
return lpGps;
}

   
/************************************************************************
 *  Gps.cpp    		 		 S e t N a m e								*
 ************************************************************************/
void CGps::SetName(CString szName)
{    
_fstrcpy (m_GPS.szName, (LPCTSTR)szName); 
}

/************************************************************************
 *  Gps.cpp    		 		 G e t N a m e								*
 ************************************************************************/
CString CGps::GetName()
{         
CString szName = (CString)m_GPS.szName;
return szName;
}


/////////////////////////////////////////////////////////////////////////////
// CGps commands


