#ifndef __GPS__      
#define __GPS__

// Gps.h
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#define GPSG100STD	0
#define GPSG100AVD	1
#define GPSLINK1	2
#define GPSLINK2	3
#define GPSMAGELLAN	4
#define GPSOTHER 	5
      
   
#define GPS_LIST_NONE	0 			// choose list index
#define GPS_LIST_OTHER	(GPSOTHER+1)	


#define PR_GARMIN1	1				// GPSG100STD, GPSG100AVD
#define PR_GARMIN2	2				// GPSLINK1, GPSOTHER
#define PR_GARMIN3	3				// GPSLINK2
#define PR_MAGELLAN	4				// GPSMAGELLAN


#define SIZEOF_GPS     128

typedef struct
	{
	char	szName[SIZEOF_GPS];  // name of GPS
	short	nGpsID; 	    // GPS_...
	short	nMaxRouteCnt;	    // max. number of GPS routes
	short	nMaxRteWpts;	    // max. waypoints per route
	short	nMaxWptChars;	    // max. waypoint name length
	short	nMaxTrackCnt;	    // max. number of GPS tracks
	short	nProtocol;			// PR_GARMIN1, PR_GARMIN2, PR_MAGELLAN
	short	nBaudRate;
	short	nDataBits;
	short	nStopBits;	    // 10 * stop bits (15 => 1.5)
	unsigned char	cWptType[10];
	} GPSTYPE;


typedef GPSTYPE FAR* LPGPS;
	
class CGps : public CObject
{
	DECLARE_SERIAL(CGps)

// Attributes
public:    

// Operations
private:
	GPSTYPE	m_GPS;

protected:
	void ReadFromPtr(LPGPS lpGps);
	void WriteToPtr(LPGPS lpGps) const;

// Implementation
public:
	CGps(LPGPS lpGps = NULL);		
	CGps(CGps& SourceGps);
	~CGps();                                                

	void GetPtr(LPGPS lpGps);
	void SetPtr (LPGPS lpGps);
	const CGps& operator=(const CGps& Gps);
	void FirstInit();

 	void Serialize(CArchive& ar);
	LPGPS CreatePtr ();

 	void SetName(CString szName);
 	CString GetName(); 

	short GetID() { return m_GPS.nGpsID; }
	short GetMaxRouteCnt () { return m_GPS.nMaxRouteCnt; }
	short GetMaxTrackCnt () { return m_GPS.nMaxTrackCnt; }

	unsigned char GetWptType (short nWptType) { return m_GPS.cWptType[nWptType]; }
	unsigned char GetG100LocType (unsigned char cCategory);
	
	short GetProtocol () { return m_GPS.nProtocol; }
	short GetBaudRate () { return m_GPS.nBaudRate; }
	short GetDataBits () { return m_GPS.nDataBits; }
	float GetStopBits () { return (float)m_GPS.nStopBits/10; }
	short GetMaxRteWpts () { return m_GPS.nMaxRteWpts; }
	short GetMaxWptChars () { return m_GPS.nMaxWptChars; }

};
#endif 

