// GpsDevice.cpp: Implementierungsdatei
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"
#include "DimDoc.h"
#include "WayDoc.h"				// verwaltet Routen
#include "GpsDevice.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CDimDoc*	ptDim;

/////////////////////////////////////////////////////////////////////////////
// CGpsDevice
BOOL bDebug = TRUE;

CGpsDevice::CGpsDevice(long lBaud, short nData, float fStop, short nParity) :
	CSerCom (lBaud, nData, fStop, nParity)
{
	m_ptLogFile = NULL;
}

CGpsDevice::~CGpsDevice()
{
}


/************************************************************************
 *  GpsDevice.cpp					 O n O p e n						*
 ************************************************************************/
void CGpsDevice::OnOpen(short nPortID)
{
	if (bDebug)
		{
		CString szFileTitle;
		szFileTitle = SaveAsTextBox (NULL, "Simulating GPS", "gps.log");

		if (szFileTitle.GetLength() > 0)
			{
			m_ptLogFile = new CFile ();
			m_ptLogFile->Open(szFileTitle, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL); 
			}
		}	

	this->BinMode();
	this->Open(nPortID, 2560, 2560);		// open serial port
}

/************************************************************************
 *  GpsDevice.cpp					 r u n								*
 ************************************************************************/
BOOL CGpsDevice::run()
{
	BOOL bStop = false;
	// to be overloaded by derived classes
	return bStop;
}



/************************************************************************
 *  GpsDevice.cpp					O n C l o s e						*
 ************************************************************************/
void CGpsDevice::OnClose()
{

	this->Close();


	if (m_ptLogFile != NULL)
	{
		m_ptLogFile->Close();
		delete m_ptLogFile;
		m_ptLogFile = NULL;
	}

}


/************************************************************************
 *  GpsDevice.cpp			G e t R t e W p t C n t						*
 ************************************************************************/
short CGpsDevice::GetRteWptCnt()
{
	return m_ptWayDoc->GetWayPointCnt();
}

/************************************************************************
 *  GpsDevice.cpp			G e t R t e H d r							*
 ************************************************************************/
void CGpsDevice::GetRteHdr(short* ptID)
{
	*ptID = 0;
}

/************************************************************************
 *  GpsDevice.cpp			G e t R t e H d r							*
 ************************************************************************/
void CGpsDevice::GetRteHdr(CString* ptHeader)
{
	short nFirstID, nLastID;
	
	nFirstID = 0;
	nLastID = m_ptWayDoc->GetWayPointCnt() - 1;

	if (nLastID > nFirstID)
	{
		CWayPoint wpt;
		if (m_ptWayDoc->GetWayPointPtr(nFirstID, &wpt))
			*ptHeader = wpt.GetIndicator();
		*ptHeader += "-";
		if (m_ptWayDoc->GetWayPointPtr(nLastID, &wpt))
			*ptHeader += wpt.GetIndicator();
	}
}

/************************************************************************
 *  GpsDevice.cpp			G e t R t e W p t							*
 ************************************************************************/
BOOL CGpsDevice::GetRteWpt(short i, double* ptLat, double* ptLon,
			 CString* ptName, CString* ptIdent, short* ptCategory, 
			 double* ptAlt_m, short* ptCC)
{
	BOOL bDone = FALSE;

	if (m_ptWayDoc != NULL)
	{
		CWayPoint wpt;
		if (m_ptWayDoc->GetWayPointPtr(i, &wpt))
		{
			*ptLat = wpt.GetLat();
			*ptLon = wpt.GetLon();
			*ptName = wpt.GetName();
			*ptIdent = wpt.GetIndicator();
			*ptCategory = wpt.GetCategory();
			*ptAlt_m = ptDim->ConvertDist(wpt.GetAltitude(), 
									wpt.GetAltDim(), DIM_METER);
			*ptCC = wpt.GetCC();
			bDone = TRUE;
		}
	}

	return bDone;
}

/************************************************************************
 *  GpsDevice.cpp			G e t T r k W p t C n t						*
 ************************************************************************/
short CGpsDevice::GetTrkWptCnt(short nTrackID)
{
	return (nTrackID==0)? 5 : 5;
}



/************************************************************************
 *  GpsDevice.cpp			G e t T r k H d r							*
 ************************************************************************/
void CGpsDevice::GetTrkHdr(short* ptID)
{
	*ptID = m_nActTrkID;
}

/************************************************************************
 *  GpsDevice.cpp			G e t T r k H d r							*
 ************************************************************************/
void CGpsDevice::GetTrkHdr(CString* ptHeader)
{
	if (m_nActTrkID == 0)
		*ptHeader = "06-APR-04";
	if (m_nActTrkID == 1)
		*ptHeader = "02-MAR-04";
}


/************************************************************************
 *  GpsDevice.cpp			G e t T r k P t			 					*
 ************************************************************************/
BOOL CGpsDevice::GetTrkPt(short nTrkID, short nWptID,
			  double* ptLat, double* ptLon, unsigned long* ptTime, float* ptAlt_m)
{
	BOOL bDone = FALSE;

	if (nTrkID >=0 && nTrkID < m_nTrkCnt)
	{
		if (nWptID >=0 && nWptID < GetTrkWptCnt(nTrkID))
		{
	//		*ptLat		= m_Track[nTrkID][nWptID].dLat;
	//		*ptLon		= m_Track[nTrkID][nWptID].dLon;

	//		*ptTime		= m_Track[nTrkID][nWptID].lTime;
	//		*ptAlt_m	= m_Track[nTrkID][nWptID].fAlt_m;

			bDone = TRUE;
		}
	}
	return bDone;
}



/************************************************************************
 *  GpsDevice.cpp			H e x T o B i n								*
 *  uBinData: Array to receive binary data								*
 *  szHexBytes: String, contining hex values, separated by space		*
 *  like: "20 20 31 2E 31 32 20 00"										*
 ************************************************************************/
short CGpsDevice::HexToBin(unsigned char* uBinData, char* szHexBytes)
{
	short	nOffs = 0;
	char*	ptToken = NULL;
	char	szBuffer[1024];
	BOOL	bFirst = TRUE;

	strcpy (szBuffer, szHexBytes);

	do
	{
		if (bFirst)		ptToken = strtok(szBuffer, " ");
			else		ptToken = strtok(NULL, " ");

		bFirst = FALSE;

		if (ptToken != NULL)
		{
			short nData;
			int nLen = 0;
			nLen = sscanf(ptToken, "%X", &nData);
			if (nLen == 1) 
			{
				uBinData[nOffs] = (unsigned char)nData;
				nOffs++;
			}
		}
	} while (ptToken != NULL);

	return nOffs;
}


/************************************************************************
 *  GpsDevice.cpp	  		 	 G e t D a t e							*
 ************************************************************************/
void CGpsDevice::GetDate (short* ptDay, short* ptMonth, short* ptYear)
{
	time_t	ltime;
	struct	tm LogTime, *ptLogTime;

	ltime = m_Time;
	ptLogTime = &LogTime;
	ptLogTime = localtime (&ltime);		/* get actual date		*/

	*ptDay		= (short)ptLogTime->tm_mday;
	*ptMonth	= (short)ptLogTime->tm_mon + 1;
	*ptYear		= (short)ptLogTime->tm_year + 1900;
}

/************************************************************************
 *  GpsDevice.cpp	  		 	 G e t T i m e							*
 ************************************************************************/
void CGpsDevice::GetTime (short* ptHour, short* ptMin, short* ptSec)
{
	time_t	ltime;
	struct	tm LogTime, *ptLogTime;

	ltime = m_Time;
	ptLogTime = &LogTime;
	ptLogTime = localtime (&ltime);		/* get actual date		*/

	*ptHour	= (short)ptLogTime->tm_hour;
	*ptMin	= (short)ptLogTime->tm_min;
	*ptSec	= (short)ptLogTime->tm_sec;
}



/************************************************************************
 *  GpsDevice.cpp	  		G e t A c t u a l D a t e					*
 ************************************************************************/
void CGpsDevice::GetActualDate (short* ptDay, short* ptMonth, short* ptYear)
{
	time (&m_Time);
	this->GetDate (ptDay, ptMonth, ptYear);
}

/************************************************************************
 *  GpsDevice.cpp	  		G e t A c t u a l T i m e					*
 ************************************************************************/
void CGpsDevice::GetActualTime (short* ptHour, short* ptMin, short* ptSec)
{
	time (&m_Time);
	this->GetTime (ptHour, ptMin, ptSec);
}



/************************************************************************
 *  GpsDevice.cpp	  		 		 G e t T i m e						*
 ************************************************************************/
time_t CGpsDevice::GetTime ()
{
	time (&m_Time);
	return m_Time;
}

/********************************************************************************
 *  GpsDevice.cpp					S p l i t F l o a t							*
 ********************************************************************************/
float CGpsDevice::SplitFloat (unsigned char* ptData, long* ptOffs)
{
	float	fValue;

	short nLen = 4;
	memcpy (&fValue, ptData + *ptOffs, nLen);
	*ptOffs += nLen;

	return fValue;
}

/********************************************************************************
 *  GpsDevice.cpp					S p l i t L o n g 							*
 ********************************************************************************/
long CGpsDevice::SplitLong (unsigned char* ptData, long* ptOffs)
{
	long	lValue;

	short nLen = 4;
	memcpy (&lValue, ptData + *ptOffs, nLen);
	*ptOffs += nLen;

	return lValue;
}

/********************************************************************************
 *  GpsDevice.cpp					S p l i t U L o n g 						*
 ********************************************************************************/
unsigned long CGpsDevice::SplitULong (unsigned char* ptData, long* ptOffs)
{
	unsigned long	lValue;
	short nLen = 4;
	memcpy (&lValue, ptData + *ptOffs, nLen);
	*ptOffs += nLen;

	return lValue;
}

/********************************************************************************
 *  GpsDevice.cpp					S p l i t S h o r t							*
 ********************************************************************************/
short CGpsDevice::SplitShort (unsigned char* ptData, long* ptOffs)
{
	short	nValue;
	short nLen = 2;
	memcpy (&nValue, ptData + *ptOffs, nLen);
	*ptOffs += nLen;

	return nValue;
}

/********************************************************************************
 *  GpsDevice.cpp					S p l i t U S h o r t						*
 ********************************************************************************/
unsigned short CGpsDevice::SplitUShort (unsigned char* ptData, long* ptOffs)
{
	unsigned short	nValue;
	short nLen = 2;
	memcpy (&nValue, ptData + *ptOffs, nLen);
	*ptOffs += nLen;

	return nValue;
}

/********************************************************************************
 *  GpsDevice.cpp				S p l i t C S t r i n g							*
 ********************************************************************************/
CString CGpsDevice::SplitCString(unsigned char* ptData, long* ptOffs)
{
    CString szText;
    szText = (char*)(ptData + *ptOffs);
    *ptOffs += strlen((char*)(ptData + *ptOffs)) + 1;
    
    return szText;
}


/********************************************************************************
 *  GpsDevice.cpp					P r e p a r e F l o a t						*
 ********************************************************************************/
void CGpsDevice::PrepareFloat (unsigned char* ptData, long* ptOffs, float fValue)
{
	short nLen = 4;
	memcpy (ptData + *ptOffs, &fValue, nLen);
	*ptOffs += nLen;
}

/********************************************************************************
 *  GpsDevice.cpp					P r e p a r e L o n g 						*
 ********************************************************************************/
void CGpsDevice::PrepareLong (unsigned char* ptData, long* ptOffs, long lValue)
{
	short nLen = 4;
	memcpy (ptData + *ptOffs, &lValue, nLen);
	*ptOffs += nLen;
}

/********************************************************************************
 *  GpsDevice.cpp					P r e p a r e U L o n g 					*
 ********************************************************************************/
void CGpsDevice::PrepareULong (unsigned char* ptData, long* ptOffs, unsigned long lValue)
{
	short nLen = 4;
	memcpy (ptData + *ptOffs, &lValue, nLen);
	*ptOffs += nLen;
}

/********************************************************************************
 *  GpsDevice.cpp					P r e p a r e S h o r t						*
 ********************************************************************************/
void CGpsDevice::PrepareShort (unsigned char* ptData, long* ptOffs, short nValue)
{
	short nLen = 2;
	memcpy (ptData + *ptOffs, &nValue, nLen);
	*ptOffs += nLen;
}

/********************************************************************************
 *  GpsDevice.cpp					P r e p a r e U S h o r t					*
 ********************************************************************************/
void CGpsDevice::PrepareUShort (unsigned char* ptData, long* ptOffs, unsigned short nValue)
{
	short nLen = 2;
	memcpy (ptData + *ptOffs, &nValue, nLen);
	*ptOffs += nLen;
}

/********************************************************************************
 *  GpsDevice.cpp					P r e p a r e C S t r i n g					*
 ********************************************************************************/
void CGpsDevice::PrepareCString(unsigned char* ptData, long* ptOffs, CString szText)
{
    strcpy((char*)(ptData + *ptOffs), (LPCTSTR)szText);
    *ptOffs += szText.GetLength();
    
    *(ptData + *ptOffs) = 0;
    *ptOffs += 1;
}

signed int CGpsDevice::le_read16(const void *addr)
{
	const unsigned char *p = (const unsigned char *)addr;
	return p[0] | (p[1] << 8);
}

signed int CGpsDevice::le_read32(const void *addr)
{
	const unsigned char *p = (const unsigned char *)addr;
	return p[0] | (p[1] << 8) | (p[2] << 16) | (p[3] << 24);
}


void CGpsDevice::le_write16(void *addr, const unsigned value)
{
	unsigned char *p = (unsigned char*)addr;
	p[0] = value;
	p[1] = value >> 8;
	
}

void CGpsDevice::le_write32(void *addr, const unsigned value)
{
	unsigned char *p = (unsigned char*)addr;
	p[0] = value;
	p[1] = value >> 8;
	p[2] = value >> 16;
	p[3] = value >> 24;
}

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CGpsDevice 
