#if !defined(__GPS_DEVICE__)
#define __GPS_DEVICE__

#include "..\Cpptools\SerCom.h"

/////////////////////////////////////////////////////////////////////////////
// CGpsDevice 
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

typedef enum
{
	GPS50,
	GPSIII,
	GPS55AVD,
	GPS90,
	GPS100,
	GPS150,
	GPS195,
	GPS196,
	GPS295,
	Magellan315
} GPSModell;


class CWayDoc;
class CGpsDevice : public CSerCom
{
public:
	CGpsDevice(long lBaud, short nData, float fStop, short nParity); 
	virtual ~CGpsDevice();

protected:
	short m_nActRteID;		// ID of route to transfer
	CString m_szActRteID;	// name of route to transfer
	short m_nActWptID;		// actual waypoint ID to transfer
	short m_nWptCnt;		// number of waypoints in actual route

	CWayDoc* m_ptWayDoc;	// way document pointer


	short m_nActTrkID;		// ID of track to transfer
	CString m_szActTrkID;	// name of track to transfer
	short m_nTrkCnt;		// 2

	

// Attribute
private:
	time_t		m_Time;
protected:
	CFile*		m_ptLogFile;

public:

// Operationen
public:
	virtual void OnOpen(short nPortID);
	virtual BOOL run();
	virtual void OnClose();

	void SetWayDoc(CWayDoc* ptDoc) { m_ptWayDoc = ptDoc; }

	short GetRteWptCnt();
	void GetRteHdr(short* ptID);
	void GetRteHdr(CString* ptHeader);
	BOOL GetRteWpt(short i, double* ptLat, double* ptLon, CString* ptName, 
		CString* ptIdent, short* ptCategory, double* ptAlt_m, short* ptCC);


	short GetTrkWptCnt(short nTrackID);
	void GetTrkHdr(short* ptID);
	void GetTrkHdr(CString* ptHeader);
	BOOL GetTrkPt(short nTrkID, short nWptID,
			  double* ptLat, double* ptLon, unsigned long* ptTime, float* ptAlt_m);



	short HexToBin(unsigned char* uBinData, char* szHexBytes);

	void GetDate (short* ptDay, short* ptMonth, short* ptYear);
	void GetTime (short* ptHour, short* ptMin, short* ptSec);
	void GetActualDate (short* ptDay, short* ptMonth, short* ptYear);
	void GetActualTime (short* ptHour, short* ptMin, short* ptSec);
	time_t GetTime ();

	static float SplitFloat (unsigned char* ptData, long* ptOffs);
	static long SplitLong (unsigned char* ptData, long* ptOffs);
	static unsigned long SplitULong (unsigned char* ptData, long* ptOffs);
	static short SplitShort (unsigned char* ptData, long* ptOffs);
	static unsigned short SplitUShort (unsigned char* ptData, long* ptOffs);
    static CString SplitCString(unsigned char* ptData, long* ptOffs);

    static void PrepareFloat (unsigned char* ptData, long* ptOffs, float fValue);
    static void PrepareLong (unsigned char* ptData, long* ptOffs, long lValue);
    static void PrepareULong (unsigned char* ptData, long* ptOffs, unsigned long lValue);
    static void PrepareShort (unsigned char* ptData, long* ptOffs, short nValue);
	static void PrepareUShort (unsigned char* ptData, long* ptOffs, unsigned short nValue);
    static void PrepareCString(unsigned char* ptData, long* ptOffs, CString szText);

	signed int le_read16(const void *addr);
	signed int le_read32(const void *addr);
	void le_write16(void *addr, const unsigned value);
	void le_write32(void *addr, const unsigned value);

};

#endif // __GPS_DEVICE__
