// GpsRdDlg.cpp : implementation file
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"
#include "WayDoc.h"
#include "GpsDoc.h"
#include "GpsRdDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CReadFromGpsDlg dialog

extern CDimDoc* 	ptDim;      
extern CInitDoc* 	ptInit;  


/************************************************************************
 *  GpsRdDlg.cpp			C R e a d F r o m G p s D l g  Constructor	*
 ************************************************************************/
CReadFromGpsDlg::CReadFromGpsDlg(CWnd* pParent, CWayDoc* ptDoc, CGpsDoc* ptGpsDoc)
	: CDlgTool(CReadFromGpsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CReadFromGpsDlg)
	m_nReadMode = -1;
	m_szGPS = _T("");
	m_szState = _T("");
	m_szRequest = _T("");
	m_szRteID = _T("");
	m_nRteID = 0;
	//}}AFX_DATA_INIT

m_ptDoc		= ptDoc;
m_ptGpsDoc	= ptGpsDoc;	
m_bTimeOut	= FALSE;
m_bStop		= FALSE;
m_bOK		= FALSE;
m_bConnected= FALSE;

m_ptGrmn		= NULL;
m_ptGrmnLink1	= NULL;
m_ptGrmnLink2	= NULL;
m_ptGrmnLink1Usb	= NULL;
m_ptNmea		= NULL;

m_uTimer	= 0;
m_ptLogFile	= NULL;
m_nReadMode = READMODE_ALL;	

m_nRecords			= 0;
m_lRecordsReceived	= 0;
m_ptCachedWayDoc	= NULL;
}

/************************************************************************
 *  GpsRdDlg.cpp		~ C R e a d F r o m G p s D l g		DESTRUCTOR	*
 ************************************************************************/
CReadFromGpsDlg::~CReadFromGpsDlg()
{
	if (m_ptGrmn != NULL)
	{
		m_ptGrmn->Close();
		delete m_ptGrmn;
		m_ptGrmn = NULL;
	}

	if (m_ptGrmnLink1 != NULL)
	{
		m_ptGrmnLink1->Close();
		delete m_ptGrmnLink1;
		m_ptGrmnLink1 = NULL;
	}

	if (m_ptGrmnLink2 != NULL)
	{
		m_ptGrmnLink2->Close();
		delete m_ptGrmnLink2;
		m_ptGrmnLink2 = NULL;
	}

	if (m_ptGrmnLink1Usb != NULL)
	{
		m_ptGrmnLink1Usb->Close();
		delete m_ptGrmnLink1Usb;
		m_ptGrmnLink1Usb = NULL;
	}

	if (m_ptNmea != NULL)
	{
		m_ptNmea->Close();
		delete m_ptNmea;
		m_ptNmea = NULL;
	}

	if (m_nReadMode == READMODE_ALL)
	{
		DeleteArrayOf(&m_CachedWayDocs);
	}
	else
	{
		if (m_ptCachedWayDoc != NULL)
		{
			delete m_ptCachedWayDoc;
			m_ptCachedWayDoc = NULL;
		}
	}

	if (m_ptLogFile != NULL)
	{
		m_ptLogFile->Close();
		delete m_ptLogFile;
		m_ptLogFile = NULL;
	}
}

/************************************************************************
 *  GpsRdDlg.cpp			D e l e t e A r r a y O f 					*
 ************************************************************************/
void CReadFromGpsDlg::DeleteArrayOf (CPtrArray* ptArray)
{
int i, nEntryCnt;	
											
nEntryCnt = ptArray->GetSize();
for (i=0; i<nEntryCnt; i++)
	{
	CWayDoc* ptEntry;
	if ((ptEntry = (CWayDoc*)ptArray->GetAt(i)) != NULL)
		{
		delete ptEntry;				// delete original element
		}
	}
ptArray->RemoveAll();
}              


void CReadFromGpsDlg::DoDataExchange(CDataExchange* pDX)
{
	CDlgTool::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CReadFromGpsDlg)
	DDX_Radio(pDX, ID_GRREADALL, m_nReadMode);
	DDX_Text(pDX, ID_GRGPS, m_szGPS);
	DDX_Text(pDX, ID_GRSTATE, m_szState);
	DDX_Text(pDX, ID_GRREQUEST, m_szRequest);
	DDX_Text(pDX, ID_GRNUM, m_szRteID);
	//}}AFX_DATA_MAP

if (pDX->m_bSaveAndValidate)
	{        
		if (m_szRteID.GetLength() == 0)
			pDX->Fail();	// 	DDX_Text(pDX, ID_GRNUM, m_szRteID); must be last DDX_...
		else
			m_nRteID = this->ConvertToRteNum(m_szRteID);
	}
}


BEGIN_MESSAGE_MAP(CReadFromGpsDlg, CDlgTool)
	//{{AFX_MSG_MAP(CReadFromGpsDlg)
	ON_BN_CLICKED(ID_GRREAD, OnReadRte)
	ON_WM_TIMER()
	ON_WM_HELPINFO()
	ON_MESSAGE (WM_GPSEVENT, OnGpsEvent)
	ON_BN_CLICKED(ID_GRREADALL, OnReadModeAll)
	ON_BN_CLICKED(ID_GRREADLAST, OnReadModeLast)
	ON_BN_CLICKED(ID_GRREADSPEC, OnReadModeSpec)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/************************************************************************
 *  GpsRdDlg.cpp			S a v e L a s t R t e						*
 ************************************************************************/
BOOL CReadFromGpsDlg::SaveLastRte(CWayDoc* ptWayDoc, short nRteID)
{
	BOOL bSaved = FALSE;
	if (ptWayDoc->GetWayPointCnt() > 0)
	{
		CString szFullPath  = ptWayDoc->GetPathName();
		if (CInitDoc::FileExists(szFullPath))	// if this file is already present,
		{									// use name: RouteXX.way
			CString szPath = ptInit->GetActualPath();	// without NameExt
			szFullPath.Format ("%sRoute%02d.way", (LPCTSTR)szPath, nRteID);
			ptWayDoc->SetPathName (szFullPath);
		}

		bSaved = ptWayDoc->OnSaveDocument(szFullPath);
		WaitTenthSec (WAIT_TIME);
	}

	return bSaved;
}


/************************************************************************
 *  GpsRdDlg.cpp			I n i t R t e R e a d						*
 ************************************************************************/
BOOL CReadFromGpsDlg::InitRteRead(short nInpLen, short nOutLen) 
{
	BOOL bInit = FALSE;

	if (m_ptGrmn != NULL)
	{
		m_ptGrmn->BinMode();
		bInit = m_ptGrmn->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink1 != NULL)
	{
		m_ptGrmnLink1->BinMode();
		bInit = m_ptGrmnLink1->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink2 != NULL)
	{
		m_ptGrmnLink2->BinMode();
		bInit = m_ptGrmnLink2->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	if (m_ptGrmnLink1Usb != NULL)
	{		// USB: m_ptGpsDoc->GetPortID() = 8, else 1-7
		bInit = m_ptGrmnLink1Usb->OpenUSB(m_ptGpsDoc->GetUsbListIndex(), nInpLen, nOutLen);

		short nLastEventFromGPS = CGarminLink1UsbEvent::Pid_Xfer_Cmplt;
		m_ptGrmnLink1Usb->SetStopThreadEvent(nLastEventFromGPS);
	}

	if (m_ptNmea != NULL)
	{
		m_ptNmea->BinMode();
		bInit = m_ptNmea->Open(m_ptGpsDoc->GetPortID(), nInpLen, nOutLen);
	}

	return bInit;
}


/************************************************************************
 *  GpsRdDlg.cpp	     R t e I d T o S t r i n g						*
 ************************************************************************/
void CReadFromGpsDlg::RteIdToString(char* szActRteName, short nRteID)
{
	CString szFormat;
	szFormat.LoadString(IDF_D);
	sprintf(szActRteName, (LPCTSTR)szFormat, nRteID);
}

/************************************************************************
 *  GpsRdDlg.cpp	    O n T r a n s f e r C o m p l e t e d			*
 *  save all cached routes, copy last route to m_ptDoc					*
 ************************************************************************/
BOOL CReadFromGpsDlg::OnTransferCompleted()
{
	BOOL bOK = FALSE;

	if (m_nRecords>0)
	{
		CString szMsg;
		szMsg.Format (IDF_GPSRESULT, m_lRecordsReceived, m_nRecords);
		AfxMessageBox (szMsg);
	}
	
	if (m_nReadMode == READMODE_ALL)
	{			// if m_nReadMode == READMODE_ALL, there are only cached docs !!
		for (int i=0; i<m_CachedWayDocs.GetSize(); i++)
		{		// store cached tracks and free temp events
			CWayDoc* ptCachedWayDoc = (CWayDoc*)m_CachedWayDocs.GetAt(i);
			if (ptCachedWayDoc != NULL)
			{
				CString szTitle = ptCachedWayDoc->GetTitle();
				m_szState = this->Format (IDF_RDRTESAVE, (LPCTSTR)szTitle);  
				this->SetText (ID_GRSTATE, m_szState);
				SaveLastRte(ptCachedWayDoc, i);
			}
		}

		m_ptCachedWayDoc->SetWayName ();	// first try to use name like EDFEEDFC.way
		*m_ptDoc = *m_ptCachedWayDoc;

		DeleteArrayOf(&m_CachedWayDocs);	// this will also delete m_ptCachedTrackDoc!
	}
	else
	{
		if (m_ptCachedWayDoc != NULL)	// use operator = to copy last track wpts to current doc
		{
			m_ptCachedWayDoc->SetWayName ();	// first try to use name like EDFEEDFC.way
			*m_ptDoc = *m_ptCachedWayDoc;
		}
	}

	if (m_ptDoc->GetWayPointCnt() > 0)
	{
		m_ptDoc->SetModifiedFlag (TRUE);	// to enable save as in WayDlg
		m_szState = this->Format (IDS_RDRTECLOSE, m_nActRteID);  
		this->SetText (ID_GRSTATE, m_szState);
		bOK = TRUE;
	}
	return bOK;
}



/************************************************************************
 *  GpsRdDlg.cpp			D o C a c h e R o u t e						*
 ************************************************************************/
void CReadFromGpsDlg::DoCacheRoute(CFile* ptFile)
{
	m_ptCachedWayDoc->SetWayName ();	// first try to use name like EDFEEDFC.way
	m_CachedWayDocs.Add(m_ptCachedWayDoc);

	if (ptFile != NULL)
	{
		long    lLen;
		char	szBuffer[256];
		lLen = sprintf (szBuffer, "\r\nTotal: %ld, Route=%d mit %d Punkten gelesen.\r\n\r\n", m_lRecordsReceived, m_nActRteID, m_nWptCnt);
		if (ptFile != NULL)
			ptFile->Write ((const void*)szBuffer, (UINT)lLen);

	}
	m_szState = this->Format (IDF_RDRTEFOUND, m_nActRteID);  
	this->SetText (ID_GRSTATE, m_szState);
}


/************************************************************************
 *  GpsRdDlg.cpp	     R e a d G a r m i n L i n k 1					*
 ************************************************************************/
BOOL CReadFromGpsDlg::ReadGarminLink1 (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
	BOOL bTimeOut, bRead;
    char	szBuffer[256];
	CGarminLink1Event GarminEvent;

	short	nFunc;                               
	Product_Data_Type	productData;
		
	bTimeOut = m_ptGrmnLink1->GetNextGarminEvent(&GarminEvent);
	switch (GarminEvent.GetFunction())
    {
    case CGarminLink1Event::Pid_Product_Data:
		m_nActRteID		= -1;
		*m_szActLocName = 0;
		*ptRequestIDCnt = 0;

		GarminEvent.OnReadProduct (&productData, ptFile);		
		m_szGPS = productData.product_description;
		this->SetText(ID_GRGPS, m_szGPS);

		m_ptGrmnLink1->SetProtocols(productData.product_ID, 100.*productData.software_version);

		*ptConnected = TRUE;
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink1->SimulateProtocolArray();	// try to read protocol array or simulate event
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		break;

	case CGarminLink1Event::Pid_Protocol_Array:
		if (m_ptGrmnLink1->IsRealCommand())
		{
			m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
			m_ptGrmnLink1->SplitProtocols (GarminEvent.GetDataPtr(), 
										GarminEvent.GetDataLen(), ptFile);

			m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		}
											// send main command
		m_ptGrmnLink1->SendCommand (CGarminLink1Event::Cmnd_Transfer_Rte);
		break;

	case CGarminLink1Event::Pid_Version_Terrain_DB:
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		break;

    case CGarminLink1Event::Pid_Records:
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		m_nRecords = GarminEvent.SplitNumbOfCmds ();
		m_lRecordsReceived = 0;
		m_nWptCnt = 0;
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		break;

    case CGarminLink1Event::Pid_Rte_Hdr:
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);

		m_lRecordsReceived++;

		if (m_nActRteID >= 0 && m_nWptCnt > 1)
		{					// already one route received:
			if (m_nReadMode == READMODE_ALL)
			{
				DoCacheRoute(ptFile);
			}
		}

		switch (m_ptGrmnLink1->GetRteHdrProt())
		{
			case D200_Rte_Hdr:
				m_nActRteID = GarminEvent.SplitD200RouteHeader ();
				this->RteIdToString(m_szActNameOfRte, m_nActRteID);
				break;
			case D201_Rte_Hdr:
				m_nActRteID = GarminEvent.SplitD201RouteHeader(m_szActNameOfRte);
				this->RteIdToString(m_szActNameOfRte, m_nActRteID);
				break;
			case D202_Rte_Hdr:
				m_nActRteID++;
				GarminEvent.SplitD202RouteHeader(m_szActNameOfRte);
				break;
		}

		if (m_nReadMode == READMODE_SPEC)
			{
			if (m_szRteID.CompareNoCase (m_szActNameOfRte) != 0)
				{       
				m_szState = this->Format (IDF_RDRTEFOUND, m_nActRteID);
				this->SetText (ID_GRSTATE, m_szState);
				}      			
			}

		m_nWptCnt = 0;
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		break;

    case CGarminLink1Event::Pid_Rte_Wpt_Data:
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);

		m_lRecordsReceived++;

		if (m_nReadMode == READMODE_SPEC)
		{
			bRead = (m_szRteID.CompareNoCase (m_szActNameOfRte) == 0);
		}
		else
		{				// m_nReadMode == READMODE_ALL
			bRead = TRUE;
		}

		if (bRead)
		    {
		    CWayPoint Wpt;
			char	szName[SIZEOF_ORT];
			char	szIndic[INDICATOR_SIZE];
			double	dLat, dLon;
			short	nCC;
		    unsigned char cCategory;
	
			if (ptInit->IsSaveSignal())
				MessageBeep (MB_OK);
	
			BOOL bSplit = FALSE;


			CGarminWpt wpt(m_ptGrmnLink1);
			bSplit = wpt.SplitRteWpt(GarminEvent.GetDataPtr(), GarminEvent.GetDataLen(),
								m_ptGrmnLink1->GetRteWptProt());
			CString Name, Ident;
			short nCategory;
			double dAlt_m;
			wpt.GetRteWpt(&dLat, &dLon, &Name, &Ident, &nCategory, &dAlt_m, &nCC);
			CLocation::SetName((LPSTR)szName, Name);
			CLocation::SetIndicator((LPSTR)szIndic, Ident);
			cCategory = (unsigned char)nCategory;

		
            if (ptFile != NULL)
            {
                long lLen;
                lLen = sprintf ((char*)szBuffer, 
                    "\r\nFacility=%s Indic=%s, Lat=%f, Lon=%f CC=%d, Cat=%d\r\n",
                    szName, szIndic, dLat, dLon, nCC, nCategory);
                ptFile->Write ((const void*)szBuffer, lLen);
            }


		    if (bSplit)
				{
				Wpt.SetLat(dLat);
				Wpt.SetLon(dLon);
				Wpt.SetCC (nCC);
				Wpt.SetCategory (cCategory);	
				Wpt.SetName ((*szName > 0)? szName : szIndic);
				if (Wpt.GetCategory() != WP_USER)
					Wpt.SetIndicator (szIndic);
 
 				Wpt.MarkNameForRte (szIndic);


				if (m_nWptCnt == 0)
				{
					if (m_nReadMode == READMODE_LAST)
					{		// we only need the last track
						if (m_ptCachedWayDoc != NULL)
						{	// delete the previously stored one
							delete m_ptCachedWayDoc;
							m_ptCachedWayDoc = NULL;
						}
					}

					m_ptCachedWayDoc = new CWayDoc();
				}
				strcpy (m_szActLocName, szIndic);
		
				m_szState = this->Format (IDS_RDRTEWPT, m_szActLocName);
				this->SetText (ID_GRSTATE, m_szState);
		
				Wpt.SetAltDim(ptDim->Altitude());
				Wpt.SetPlannedAlt ((long)ptDim->ConvertDist (5000.,
											DIM_FEET, ptDim->Altitude()));
				m_ptCachedWayDoc->AppendWpt (Wpt);
				m_nWptCnt++;
				}
		    }
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		break;

	case CGarminLink1Event::Pid_Rte_Link_Data:
		m_lRecordsReceived++;
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		break;

    case CGarminLink1Event::Pid_Xfer_Cmplt:
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);

		m_ptGrmnLink1->SendG55Reply (&GarminEvent);

		*ptOK = OnTransferCompleted();
		*ptStop = TRUE;
		break;

    case CGarminLink1Event::Pid_Nak_Byte:
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		*ptStop = TRUE;
		break;


    case CGarminLink1Event::Pid_Ack_Byte:
		nFunc = GarminEvent.SplitAcknowledge ();
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		break;

    default:
		m_ptGrmnLink1->WriteToFile (ptFile, &GarminEvent);
		m_ptGrmnLink1->SendG55Reply (&GarminEvent);
		break;
    }

if (bTimeOut && (*ptRequestIDCnt)>0 && (*ptRequestIDCnt)<3)
    {
    bTimeOut = FALSE;
	m_ptGrmnLink1->SendProductRqst ();
    (*ptRequestIDCnt)++;
    }

return bTimeOut;
}

/************************************************************************
 *  GpsRdDlg.cpp	     R e a d G a r m i n L i n k 2					*
 ************************************************************************/
BOOL CReadFromGpsDlg::ReadGarminLink2 (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
	BOOL bTimeOut, bRead;
    char	szBuffer[256];
	CGarminLink2Event GarminEvent;

	short	nFunc;                               
	Product_Data_Type	productData;
		
	bTimeOut = m_ptGrmnLink2->GetNextGarminEvent (&GarminEvent);
	switch (GarminEvent.GetFunction())
    {
    case CGarminLink2Event::Pid_Product_Data:
		m_nActRteID		= -1;
		*m_szActLocName = 0;
		*ptRequestIDCnt = 0;

		GarminEvent.OnReadProduct (&productData, ptFile);		
		m_szGPS = productData.product_description;
		this->SetText(ID_GRGPS, m_szGPS);

		m_ptGrmnLink2->SetProtocols(productData.product_ID, 100.*productData.software_version);

		*ptConnected = TRUE;

		m_ptGrmnLink2->SendG55Reply (&GarminEvent);
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink2->SimulateProtocolArray();	// try to read protocol array or simulate event
		break;

	case CGarminLink2Event::Pid_Protocol_Array:
		if (m_ptGrmnLink2->IsRealCommand())
		{
			m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
			m_ptGrmnLink2->SplitProtocols (GarminEvent.GetDataPtr(), 
										GarminEvent.GetDataLen(), ptFile);

			m_ptGrmnLink2->SendG55Reply (&GarminEvent);
		}
											// send main command
		m_ptGrmnLink2->SendCommand (CGarminLink2Event::Cmnd_Transfer_Rte);
		break;

    case CGarminLink2Event::Pid_Records:
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
		m_nRecords = GarminEvent.SplitNumbOfCmds ();
		m_lRecordsReceived = 0;
		m_nWptCnt = 0;
		m_ptGrmnLink2->SendG55Reply (&GarminEvent);
		break;

    case CGarminLink2Event::Pid_Rte_Hdr:
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);

		m_lRecordsReceived++;

		if (m_nActRteID >= 0 && m_nWptCnt > 1)
		{					// already one route received:
			if (m_nReadMode == READMODE_ALL)
			{
				DoCacheRoute(ptFile);
			}
		}

		switch (m_ptGrmnLink2->GetRteHdrProt())
		{
			case D200_Rte_Hdr:
				m_nActRteID = GarminEvent.SplitD200RouteHeader ();
				this->RteIdToString(m_szActNameOfRte, m_nActRteID);
				break;
			case D201_Rte_Hdr:
				m_nActRteID = GarminEvent.SplitD201RouteHeader(m_szActNameOfRte);
				this->RteIdToString(m_szActNameOfRte, m_nActRteID);
				break;
			case D202_Rte_Hdr:
				m_nActRteID++;
				GarminEvent.SplitD202RouteHeader(m_szActNameOfRte);
				break;
		}

		if (m_nReadMode == READMODE_SPEC)
			{
			if (m_szRteID.CompareNoCase (m_szActNameOfRte) != 0)
				{       
				m_szState = this->Format (IDF_RDRTEFOUND, m_nActRteID);
				this->SetText (ID_GRSTATE, m_szState);
				}      			
			}

		m_nWptCnt = 0;
		m_ptGrmnLink2->SendG55Reply (&GarminEvent);
		break;

    case CGarminLink2Event::Pid_Rte_Wpt_Data:
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);

		m_lRecordsReceived++;

		if (m_nReadMode == READMODE_SPEC)
		{
			bRead = (m_szRteID.CompareNoCase (m_szActNameOfRte) == 0);
		}
		else
		{				// m_nReadMode == READMODE_ALL
			bRead = TRUE;
		}

		if (bRead)
		    {
		    CWayPoint Wpt;
			char	szName[SIZEOF_ORT];
			char	szIndic[INDICATOR_SIZE];
			double	dLat, dLon;
			short	nCC;
		    unsigned char cCategory;
	
			if (ptInit->IsSaveSignal())
				MessageBeep (MB_OK);
	
			BOOL bSplit = FALSE;


			CGarminWpt wpt(m_ptGrmnLink2);
			bSplit = wpt.SplitRteWpt(GarminEvent.GetDataPtr(), GarminEvent.GetDataLen(),
								m_ptGrmnLink2->GetRteWptProt());
			CString Name, Ident;
			short nCategory;
			double dAlt_m;
			wpt.GetRteWpt(&dLat, &dLon, &Name, &Ident, &nCategory, &dAlt_m, &nCC);
			CLocation::SetName((LPSTR)szName, Name);
			CLocation::SetIndicator((LPSTR)szIndic, Ident);
			cCategory = (unsigned char)nCategory;

		
            if (ptFile != NULL)
            {
                long lLen;
                lLen = sprintf ((char*)szBuffer, 
                    "\r\nFacility=%s Indic=%s, Lat=%f, Lon=%f CC=%d, Cat=%d\r\n",
                    szName, szIndic, dLat, dLon, nCC, nCategory);
                ptFile->Write ((const void*)szBuffer, lLen);
            }


		    if (bSplit)
				{
				Wpt.SetLat(dLat);
				Wpt.SetLon(dLon);
				Wpt.SetCC (nCC);
				Wpt.SetCategory (cCategory);	
				Wpt.SetName ((*szName > 0)? szName : szIndic);
				if (Wpt.GetCategory() != WP_USER)
					Wpt.SetIndicator (szIndic);
 
 				Wpt.MarkNameForRte (szIndic);

				if (m_nWptCnt == 0)
				{
					if (m_nReadMode == READMODE_LAST)
					{		// we only need the last track
						if (m_ptCachedWayDoc != NULL)
						{	// delete the previously stored one
							delete m_ptCachedWayDoc;
							m_ptCachedWayDoc = NULL;
						}
					}	

					m_ptCachedWayDoc = new CWayDoc();
				}

				strcpy (m_szActLocName, szIndic);
		
				m_szState = this->Format (IDS_RDRTEWPT, m_szActLocName);
				this->SetText (ID_GRSTATE, m_szState);
		
				Wpt.SetAltDim(ptDim->Altitude());
				Wpt.SetPlannedAlt ((long)ptDim->ConvertDist (5000.,
											DIM_FEET, ptDim->Altitude()));
				m_ptCachedWayDoc->AppendWpt (Wpt);
				m_nWptCnt++;
				}
		    }
		m_ptGrmnLink2->SendG55Reply (&GarminEvent);
		break;

    case CGarminLink2Event::Pid_Xfer_Cmplt:
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
		m_ptGrmnLink2->SendG55Reply (&GarminEvent);

		*ptOK = OnTransferCompleted();
		*ptStop = TRUE;
		break;

    case CGarminLink2Event::Pid_Nak_Byte:
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
		m_ptGrmnLink2->SendG55Reply (&GarminEvent);
		*ptStop = TRUE;
		break;


    case CGarminLink2Event::Pid_Ack_Byte:
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
		nFunc = GarminEvent.SplitAcknowledge ();
		break;

    default:
		m_ptGrmnLink2->WriteToFile (ptFile, &GarminEvent);
		break;
    }

if (bTimeOut && (*ptRequestIDCnt)>0 && (*ptRequestIDCnt)<3)
    {
    bTimeOut = FALSE;
	m_ptGrmnLink2->SendProductRqst ();
    (*ptRequestIDCnt)++;
    }

return bTimeOut;
}

/************************************************************************
 *  GpsRdDlg.cpp	     R e c e i v e G a r m i n 1 0 0				*
 ************************************************************************/
BOOL CReadFromGpsDlg::ReceiveGarmin100 (short* ptRequestIDCnt, BOOL* ptOK, 
					BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
BOOL bTimeOut, bRead;
CGarminEvent GarminEvent;
BOOL	bOut	= FALSE;
BOOL	bInp	= FALSE;


if (!(*ptConnected))
    {
	m_ptGrmn->Close();

    if (this->InitRteRead (2048, 256))
		{			    // output opened for 110 baud
		bOut = TRUE;
		(*ptRequestIDCnt)++;
		m_ptGrmn->SendG100ReadRte ();    // call GPS and wait 0.2 sec...
	
		if (m_ptGrmn->SetBaudRate (9600))
		    {				// input opened for 9600 baud
		    bInp = TRUE;
		    }
		}

    if (!bOut && !bInp)
		return TRUE;

    m_nWptCnt = 0;
    *m_szActLocName = 0;
    }

bTimeOut = m_ptGrmn->GetNextG100DlEvent (&GarminEvent);

switch (GarminEvent.GetFunction())
    {
    case GE100_ACKN:
		m_ptGrmn->WriteToFile (ptFile, &GarminEvent);
		*ptRequestIDCnt = 0;
		*ptConnected = TRUE;
		break;

    case GE100_NUMBCMDS:
		m_ptGrmn->WriteToFile (ptFile, &GarminEvent);
		*ptConnected = TRUE;
		m_nRecords = GarminEvent.SplitNumbOfCmds ();
		break;

    case GE100_NUMBRTE:
		*ptRequestIDCnt = 0;
		*ptConnected = TRUE;

		if (m_nReadMode == READMODE_ALL && m_nActRteID > -1)
			DoCacheRoute(ptFile);

		m_nWptCnt=0;

		m_nActRteID = GarminEvent.SplitD200RouteHeader () - 0x30;
		m_ptGrmn->WriteToFile (ptFile, &GarminEvent);
		if (m_nReadMode == READMODE_SPEC)
		{
			if (m_nRteID != m_nActRteID)
				{       
				m_szState = this->Format (IDF_RDRTEFOUND, m_nActRteID);
				this->SetText (ID_GRSTATE, m_szState);
				}
		}
		break;
	
    case GE100_WRITERTE:
		m_ptGrmn->WriteToFile (ptFile, &GarminEvent);

		if (m_nReadMode == READMODE_SPEC)
		{
			bRead = (m_nRteID == m_nActRteID);
		}
		else
		{				// m_nReadMode == READMODE_ALL
			bRead = TRUE;
		}

		if (bRead)
		    {
		    CWayPoint Wpt;
			char	szIndic[INDICATOR_SIZE];
			double	dLat, dLon;
			short	nCC;
		    unsigned char cCategory;
		    float    fElev_m;

		    if (ptInit->IsSaveSignal())
				MessageBeep (MB_OK);
	
		    if (GarminEvent.SplitG100Wpt (ptFile,
										szIndic, &dLat, &dLon,
										&nCC, &cCategory, &fElev_m))
				{
 				Wpt.SetLat(dLat);
				Wpt.SetLon(dLon);
				Wpt.SetCC (nCC);
				Wpt.SetCategory (m_Gps.GetG100LocType (cCategory));	
				Wpt.SetName (szIndic);

				if (Wpt.GetCategory() != WP_USER)
					Wpt.SetIndicator (szIndic);
				
 				Wpt.MarkNameForRte (szIndic);
		
				if (fElev_m < (float)9999)
				    {
					Wpt.SetAltitude ((long)ptDim->ConvertDist ((double)fElev_m,
											DIM_METER, ptDim->Altitude()));
					Wpt.SetElevDim (ptDim->Altitude());
				    }
		
				if (m_nWptCnt == 0)
				{
					if (m_nReadMode == READMODE_LAST)
					{		// we only need the last track
						if (m_ptCachedWayDoc != NULL)
						{	// delete the previously stored one
							delete m_ptCachedWayDoc;
							m_ptCachedWayDoc = NULL;
						}
					}

					m_ptCachedWayDoc = new CWayDoc();
				}

				strcpy (m_szActLocName, szIndic);
		
				m_szState = this->Format (IDS_RDRTEWPT, m_szActLocName);
				this->SetText (ID_GRSTATE, m_szState);
		
				Wpt.SetAltDim(ptDim->Altitude());
				Wpt.SetPlannedAlt ((long)ptDim->ConvertDist (5000.,
									DIM_FEET, ptDim->Altitude()));
				m_ptCachedWayDoc->AppendWpt (Wpt);
				m_nWptCnt++;
				}
		    }
		break;

    case GE100_LASTCMD:
		m_ptGrmn->WriteToFile (ptFile, &GarminEvent);

		*ptOK = OnTransferCompleted();
		*ptStop = TRUE;
		break;

    default:
		m_ptGrmn->WriteToFile (ptFile, &GarminEvent);
		break;
    } // switch (GarminEvent...


if (bTimeOut && (*ptRequestIDCnt)>0 && (*ptRequestIDCnt)<3)
    {
    bTimeOut = FALSE;
    }

return bTimeOut;
}


/************************************************************************
 *  GpsRdDlg.cpp	H a n d l e G a r m i n L i n k 1 U s b E v e n t	*
 ************************************************************************/
BOOL CReadFromGpsDlg::HandleGarminLink1UsbEvent(CGarminLink1UsbEvent* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
	BOOL  bRead;
    char	szBuffer[256];
	Product_Data_Type	productData;

	switch (ptGarminEvent->GetFunction())
    {
	case CGarminLink1UsbEvent::Pid_Data_Available:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		break;

    case CGarminLink1UsbEvent::Pid_Session_Started:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1Usb->SplitStartSession (ptGarminEvent->GetDataPtr(), 
										ptGarminEvent->GetDataLen(), ptFile);

		m_ptGrmnLink1Usb->SendProductRqst ();
		m_nWptCnt=0;
		break;

    case CGarminLink1UsbEvent::Pid_Product_Data:
		m_nActRteID		= -1;
		*m_szActLocName = 0;
		*ptRequestIDCnt = 0;

		ptGarminEvent->OnReadProduct (&productData, ptFile);
		m_szGPS = productData.product_description;
		this->SetText(ID_GRGPS, m_szGPS);

		m_ptGrmnLink1Usb->SetProtocols(productData.product_ID, 100.*productData.software_version);

		*ptConnected = TRUE;

		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
	
		WaitTenthSec (WAIT_TIME);
		m_ptGrmnLink1Usb->SimulateProtocolArray();	// try to read protocol array or simulate event
		break;

	case CGarminLink1UsbEvent::Pid_Version_Terrain_DB:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		break;

	case CGarminLink1UsbEvent::Pid_Protocol_Array:
		if (m_ptGrmnLink1Usb->IsRealCommand())
		{
			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
			m_ptGrmnLink1Usb->SplitProtocols (ptGarminEvent->GetDataPtr(), 
										ptGarminEvent->GetDataLen(), ptFile);
		}
											// send main command
		m_ptGrmnLink1Usb->SendCommand (CGarminLink1UsbEvent::Cmnd_Transfer_Rte);
		break;


    case CGarminLink1UsbEvent::Pid_Records:
		m_nRecords = ptGarminEvent->SplitNumbOfCmds (ptFile);
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		m_lRecordsReceived = 0;
		m_nWptCnt = 0;
		break;

    case CGarminLink1UsbEvent::Pid_Rte_Hdr:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);

		m_lRecordsReceived++;

		if (m_nActRteID >= 0 && m_nWptCnt > 1)
		{					// already one route received:
			if (m_nReadMode == READMODE_ALL)
			{
				DoCacheRoute(ptFile);
			}
		}

		switch (m_ptGrmnLink1Usb->GetRteHdrProt())
		{
			case D200_Rte_Hdr:
				m_nActRteID = ptGarminEvent->SplitD200RouteHeader ();
				this->RteIdToString(m_szActNameOfRte, m_nActRteID);
				break;
			case D201_Rte_Hdr:
				m_nActRteID = ptGarminEvent->SplitD201RouteHeader(m_szActNameOfRte);
				this->RteIdToString(m_szActNameOfRte, m_nActRteID);
				break;
			case D202_Rte_Hdr:
				m_nActRteID++;
				ptGarminEvent->SplitD202RouteHeader(m_szActNameOfRte);
				break;
		}

		if (m_nReadMode == READMODE_SPEC)
			{
			if (m_szRteID.CompareNoCase (m_szActNameOfRte) != 0)
				{       
				m_szState = this->Format (IDF_RDRTEFOUND, m_nActRteID);
				this->SetText (ID_GRSTATE, m_szState);
				}      			
			}

		m_nWptCnt = 0;
		break;

    case CGarminLink1UsbEvent::Pid_Rte_Wpt_Data:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);

		m_lRecordsReceived++;

		if (m_nReadMode == READMODE_SPEC)
		{
			bRead = (m_szRteID.CompareNoCase (m_szActNameOfRte) == 0);
		}
		else
		{				// m_nReadMode == READMODE_ALL
			bRead = TRUE;
		}

		if (bRead)
		    {
		    CWayPoint Wpt;
			char	szName[SIZEOF_ORT];
			char	szIndic[INDICATOR_SIZE];
			double	dLat, dLon;
			short	nCC;
		    unsigned char cCategory;
	
			if (ptInit->IsSaveSignal())
				MessageBeep (MB_OK);
	
			BOOL bSplit = FALSE;


			CGarminWpt wpt(m_ptGrmnLink1Usb);
			bSplit = wpt.SplitRteWpt(ptGarminEvent->GetDataPtr(), ptGarminEvent->GetDataLen(),
								m_ptGrmnLink1Usb->GetRteWptProt());
			CString Name, Ident;
			short nCategory;
			double dAlt_m;
			wpt.GetRteWpt(&dLat, &dLon, &Name, &Ident, &nCategory, &dAlt_m, &nCC);
			CLocation::SetName((LPSTR)szName, Name);
			CLocation::SetIndicator((LPSTR)szIndic, Ident);
			cCategory = (unsigned char)nCategory;

		
            if (ptFile != NULL)
            {
                long lLen;
                lLen = sprintf ((char*)szBuffer, 
                    "\r\nFacility=%s Indic=%s, Lat=%f, Lon=%f CC=%d, Cat=%d\r\n",
                    szName, szIndic, dLat, dLon, nCC, nCategory);
                ptFile->Write ((const void*)szBuffer, lLen);
            }


		    if (bSplit)
				{
				Wpt.SetLat(dLat);
				Wpt.SetLon(dLon);
				Wpt.SetCC (nCC);
				Wpt.SetCategory (cCategory);	
				Wpt.SetName ((*szName > 0)? szName : szIndic);
				if (Wpt.GetCategory() != WP_USER)
					Wpt.SetIndicator (szIndic);
 
 				Wpt.MarkNameForRte (szIndic);





				if (m_nWptCnt == 0)
				{
					if (m_nReadMode == READMODE_LAST)
					{		// we only need the last track
						if (m_ptCachedWayDoc != NULL)
						{	// delete the previously stored one
							delete m_ptCachedWayDoc;
							m_ptCachedWayDoc = NULL;
						}
					}

					m_ptCachedWayDoc = new CWayDoc();
				}
				strcpy (m_szActLocName, szIndic);
		
				m_szState = this->Format (IDS_RDRTEWPT, m_szActLocName);
				this->SetText (ID_GRSTATE, m_szState);
		
				Wpt.SetAltDim(ptDim->Altitude());
				Wpt.SetPlannedAlt ((long)ptDim->ConvertDist (5000.,
											DIM_FEET, ptDim->Altitude()));
				m_ptCachedWayDoc->AppendWpt (Wpt);
				m_nWptCnt++;
				}
		    }
		break;

	case CGarminLink1UsbEvent::Pid_Rte_Link_Data:
		m_lRecordsReceived++;
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		m_ptGrmnLink1Usb->SendG55Reply (ptGarminEvent);
		break;

    case CGarminLink1UsbEvent::Pid_Xfer_Cmplt:					// Cmnd_Transfer_Rte
		{
			m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);

			*ptOK = OnTransferCompleted();
			*ptStop = TRUE;
		}
		break;


    default:
		m_ptGrmnLink1Usb->WriteToFile (ptFile, ptGarminEvent);
		return FALSE;
		break;
    }

return TRUE;
}

/************************************************************************
 *  GpsRdDlg.cpp	     R e c e i v e M a g e l l a n R t e			*
 ************************************************************************/
BOOL CReadFromGpsDlg::ReceiveMagellanRte (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile)
{
char		szBuffer[256];
BOOL 		bTimeOut = FALSE;
BOOL		bInvalid = FALSE;
CNmeaEvent 	NMEAData;	
BOOL		bStored = FALSE;  
BOOL		bStart;
BOOL		bWpl=FALSE;

do	{
	bTimeOut = m_ptNmea->GetNextNMEAEvent (&NMEAData, ptFile);
	*ptStop = bTimeOut;	   // evtl. test mouse down button here

	switch (NMEAData.GetFunction())
		{			
		case FM_MGN:
			{
			long	lLen;
			switch (NMEAData.GetMGNFunc ())
				{
				case MGN_CSM:
					{
					short nChkSum;
					NMEAData.SplitMGNCSM (&nChkSum);
					lLen = sprintf (szBuffer, "\nReceivedChk=%d", nChkSum);
					if (ptFile != NULL)
						ptFile->Write ((const void*)szBuffer, (UINT)lLen);
					}
					break;

				case MGN_CMD:
					{
						CString szCmd;
						NMEAData.SplitMGNCMD (&szCmd);

						if (szCmd.Compare ("END") == 0)			// end of wpl transfer ?
						{
							m_ptNmea->SendMGNCSM (&NMEAData);

							if (!bWpl)
							{
								m_nWptCnt = 0;

								CNmeaEvent GetRte(SN_PROP, FM_MGN, MGN_CMD, "WAYPOINT");
								m_ptNmea->SendNMEAEvent (&GetRte, ptFile);

								lLen = sprintf (szBuffer, "\nMGN WAYPOINT command sent");
								if (ptFile != NULL)
									ptFile->Write ((const void*)szBuffer, (UINT)lLen);

								bWpl=TRUE;
							}
							else
							{			// stop reading data
								CNmeaEvent HandEvt(SN_PROP, FM_MGN, MGN_CMD, "HANDOFF");
								m_ptNmea->SendNMEAEvent (&HandEvt, ptFile);
											
								*ptOK = OnTransferCompleted();
								*ptStop = TRUE;
							}
						}
					}
					break;

				case MGN_VER:
					{
						NMEA_MGNVER Vers;
						NMEAData.SplitMGNVER (&Vers);

						m_ptNmea->SendMGNCSM (&NMEAData);


						lLen = sprintf (szBuffer, "\nID=%d, Vers=%s, Model=%s", 
							Vers.nProdID, Vers.szRev, Vers.szModel);
						if (ptFile != NULL)
							ptFile->Write ((const void*)szBuffer, (UINT)lLen);

												// request Rte
						CNmeaEvent GetRte(SN_PROP, FM_MGN, MGN_CMD, "ROUTE");
						m_ptNmea->SendNMEAEvent (&GetRte, ptFile);

						m_nActRteID		= -1;
						*m_szActLocName = 0;
						*ptRequestIDCnt = 0;
						m_nRecords		= 0;
						m_lRecordsReceived = 0;
						*ptConnected = TRUE;
						bStart = TRUE;
					}
					break;

				case MGN_RTE:
					{
						NMEA_MGNRTE Route;
						BOOL		bRead;

						NMEAData.SplitMGNRTE(&Route);

						m_ptNmea->SendMGNCSM (&NMEAData);

						if (Route.nID == 1)
						{					// new route found
							if (m_nReadMode == READMODE_ALL && m_nActRteID > -1)
								DoCacheRoute(ptFile);

							m_nWptCnt=0;
							m_nActRteID++;
						}

						strcpy(m_szActNameOfRte, Route.szName);

						lLen = sprintf (szBuffer, "\nMGN_RTE: Found: ID=%d, Cnt=%d, Name=%s, Need:%s", 
							Route.nID, Route.nNumbOfMsgs, Route.szName, (LPCTSTR)m_szRteID);
						if (ptFile != NULL)
							ptFile->Write ((const void*)szBuffer, (UINT)lLen);


						if (m_nReadMode == READMODE_SPEC)
						{
							CString szReqRteID;
							if (m_szRteID.GetLength() == 1)
							{				// convert "2" to "02"
								szReqRteID = "0";
								szReqRteID += m_szRteID;
							}
							else
							{
								szReqRteID = m_szRteID;
							}


							bRead = (szReqRteID.CompareNoCase (m_szActNameOfRte) == 0);		
						}
						else
						{			// m_nReadMode == READMODE_ALL
							bRead = TRUE;
						}

						if (bRead)
						{
							if (Route.nID == 1)
							{
								if (m_nReadMode == READMODE_LAST)
								{		// we only need the last track
									if (m_ptCachedWayDoc != NULL)
									{	// delete the previously stored one
										delete m_ptCachedWayDoc;
										m_ptCachedWayDoc = NULL;
									}
								}

								m_ptCachedWayDoc = new CWayDoc();
							}

							lLen = sprintf (szBuffer, "\nID=%d, Cnt=%d, Name=%s", 
								Route.nID, Route.nNumbOfMsgs, Route.szName);
							if (ptFile != NULL)
								ptFile->Write ((const void*)szBuffer, (UINT)lLen);

							if (Route.cIndic == 'c')
							{							// get new waypoint names
								for (int i=0; i<Route.ptWptNames->GetSize(); i++)
								{
									MGN_WPT_INFO* ptInfo;
									ptInfo = (MGN_WPT_INFO*)Route.ptWptNames->GetAt(i);
									if (ptInfo != NULL)
									{// copy new waypoint names 

										CWayPoint WayPt;
										WayPt.SetName ((CString)ptInfo->szName);
											// ptInfo->cIcon
										m_ptCachedWayDoc->AppendWpt (WayPt);		// only name defined!!!!
										m_nWptCnt++;
										lLen = sprintf (szBuffer, "\nWptName=%s, Icon=%c", 
											ptInfo->szName, ptInfo->cIcon);
										if (ptFile != NULL)
											ptFile->Write ((const void*)szBuffer, (UINT)lLen);
									}
								}
							}

							if (Route.cIndic == 'm')
							{				// get route message
								lLen = sprintf (szBuffer, "\nMessage=%s", Route.szMessage);
								if (ptFile != NULL)
									ptFile->Write ((const void*)szBuffer, (UINT)lLen);
							}
						} // bRead
						else
						{
							m_szState = this->Format (IDF_RDRTEFOUND, m_nActRteID);
							this->SetText (ID_GRSTATE, m_szState);
						}

						NMEAData.DeleteArrayOf(Route.ptWptNames);
					}
					break;

				case MGN_WPL:
					{
						NMEA_MGNWPL Wpl;
						NMEAData.SplitMGNWPL (&Wpl);

						m_ptNmea->SendMGNCSM (&NMEAData);

												// get next required waypoint name
						
						short nIndex;						
						for (nIndex=0; nIndex < m_ptCachedWayDoc->GetWayPointCnt(); nIndex++)
						{					// for all waypoints of route:

							CWayPoint WayPt;
							if (m_ptCachedWayDoc->GetWayPointPtr (nIndex, &WayPt))
							{
								CString szWptName = WayPt.GetName(); 
								if (szWptName.CompareNoCase((LPCTSTR)Wpl.szName) == 0)
								{					// add this waypoint into WayDoc

									m_lRecordsReceived++;

									if (Wpl.bName && Wpl.bLatLon)
									{
										WayPt.SetLat(Wpl.fLat);
										WayPt.SetLon(Wpl.fLon);

										lLen = sprintf (szBuffer, "\nName=%s, Lat=%f, Lon=%f",
											Wpl.szName, Wpl.fLat, Wpl.fLon);
										if (ptFile != NULL)
											ptFile->Write ((const void*)szBuffer, (UINT)lLen);
									}

									if (Wpl.bAlt)
									{
										WayPt.SetAltitude ((long)ptDim->ConvertDist (Wpl.nAlt,
																(Wpl.cDim == 'F')? DIM_FEET : DIM_METER, 
																ptDim->Altitude()));
										WayPt.SetElevDim (ptDim->Altitude());

										lLen = sprintf (szBuffer, " Alt=%d, Dim=%c",Wpl.nAlt, Wpl.cDim);
										if (ptFile != NULL)
											ptFile->Write ((const void*)szBuffer, (UINT)lLen);
									}

									WayPt.SetCategory (WP_USER);	 

									WayPt.SetAltDim(ptDim->Altitude());
									WayPt.SetPlannedAlt ((long)ptDim->ConvertDist (5000.,
																DIM_FEET, ptDim->Altitude()));

									strcpy (m_szActLocName, Wpl.szName);
							
									m_szState = this->Format (IDS_RDRTEWPT, m_szActLocName);
									this->SetText (ID_GRSTATE, m_szState);

									m_ptCachedWayDoc->ChangeWpt (nIndex, WayPt);
									m_nWptCnt++;
								}
							}
						}						
					}
					break;
					
				default:
					break;
				}
			}
			break;

		case FN_WPL:
			{
			long lLen = sprintf (szBuffer, "\nNMEA WPL message received!");
			if (ptFile != NULL)
				ptFile->Write ((const void*)szBuffer, (UINT)lLen);
			}
			break;

		default:
			break;
		}
	} while (!*ptStop && !bStored && !bInvalid);

return bTimeOut;		
}


/////////////////////////////////////////////////////////////////////////////
// CReadFromGpsDlg message handlers


/************************************************************************
 *  GpsRdDlg.cpp			O n I n i t D i a l o g						*
 ************************************************************************/
BOOL CReadFromGpsDlg::OnInitDialog() 
{
	// TODO: Add extra initialization here
short nIndex;
if (m_ptGpsDoc->GetActGpsInd (&nIndex))
	{
	if (m_ptGpsDoc->GetGpsPtr (nIndex, &m_Gps))
		{
		m_nRequestIDCnt = 0;

		switch (m_Gps.GetProtocol())
		{
		case PR_GARMIN1:
			m_ptGrmn = (CGarmin*)new CGarmin (m_Gps.GetBaudRate(), 
								  m_Gps.GetDataBits(), 
								  m_Gps.GetStopBits(), 
								  NO);
			break;

		case PR_GARMIN2:
			if(m_ptGpsDoc->IsUsbProtocol())
					m_ptGrmnLink1Usb = (CProtGarminLink1Usb*)new CProtGarminLink1Usb ();
			else	m_ptGrmnLink1 = (CProtGarminLink1*)new CProtGarminLink1 ();
			break;

		case PR_GARMIN3:
			m_ptGrmnLink2 = (CProtGarminLink2*)new CProtGarminLink2 ();
			break;

		case PR_MAGELLAN:
			m_ptNmea = (CNmea*)new CNmea (m_Gps.GetBaudRate(), 
								  m_Gps.GetDataBits(), 
								  m_Gps.GetStopBits(), 
								  NO);
			break;
		default:
			break;
		}

		m_szRequest.LoadString (IDS_RDREQUESTNAM);  
	    
		m_szGPS = m_Gps.GetName ();
		m_szState.LoadString (IDS_IDLE);

		m_szRteID = m_ptGpsDoc->GetReadRte (); 
		m_nRteID = ConvertToRteNum(m_szRteID);

		if (m_nReadMode == READMODE_SPEC)
			this->SelectItem (ID_GRNUM);

		if (m_nReadMode == READMODE_ALL || m_nReadMode == READMODE_LAST)
			this->DisableControl(ID_GRNUM, TRUE);
		}
	}

CDlgTool::OnInitDialog();
	
return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/************************************************************************
 *  GpsRdDlg.cpp			C o n v e r t T o R t e N u m				*
 ************************************************************************/
short CReadFromGpsDlg::ConvertToRteNum(CString szRteName)
{
	short nNum=0;
	if (szRteName.GetLength() > 0)
		nNum = (short)atoi((LPCTSTR)szRteName);
	return nNum;
}


/************************************************************************
 *  GpsRdDlg.cpp				M g n R e q u e s t I D					*
 ************************************************************************/
void CReadFromGpsDlg::MgnRequestID(CFile* ptFile)
{
						// aktivate hand shake
	CNmeaEvent HandEvt(SN_PROP, FM_MGN, MGN_CMD, "HANDON");
	m_ptNmea->SendNMEAEvent (&HandEvt, ptFile);

						// request gps ID and version
	CNmeaEvent VersEvt(SN_PROP, FM_MGN, MGN_CMD, "VERSION");
	m_ptNmea->SendNMEAEvent (&VersEvt, ptFile);
}

/************************************************************************
 *  GpsRdDlg.cpp	  		O n R e a d M o d e A l l					*
 ************************************************************************/
void CReadFromGpsDlg::OnReadModeAll() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->DisableControl(ID_GRNUM, TRUE);
}

/************************************************************************
 *  GpsRdDlg.cpp	  		O n R e a d M o d e L a s t					*
 ************************************************************************/
void CReadFromGpsDlg::OnReadModeLast() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->DisableControl(ID_GRNUM, TRUE);
}


/************************************************************************
 *  GpsRdDlg.cpp	  		O n R e a d M o d e S p e c					*
 ************************************************************************/
void CReadFromGpsDlg::OnReadModeSpec() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	this->DisableControl(ID_GRNUM, FALSE);
	this->SelectItem (ID_GRNUM);
}

/************************************************************************
 *  GpsTrDlg.cpp					O n G p s E v e n t					*
 ************************************************************************/
LONG CReadFromGpsDlg::OnGpsEvent(UINT wParam, LONG lParam)
{
	CString szBuffer;
	BOOL bError = (wParam == 1);
	if (bError)
	{
		if (m_ptLogFile != NULL)
		{
			m_ptLogFile->Close();
			delete m_ptLogFile;
			m_ptLogFile = NULL;
		}

		if (!m_ptGrmnLink1Usb->CloseReadThread(&szBuffer))
			AfxMessageBox ("Bad CloseReadThread: " + szBuffer);

		AfxMessageBox("Error received in OnGpsEvent");
		CDlgTool::OnCancel();
		return 0L;
	}


	CGarminLink1UsbEvent GarminEvent;

	long lIndex = 0;		// always read first queue entry
	while (m_ptGrmnLink1Usb->GetQueueEvent (lIndex, &GarminEvent))
	{		
		HandleGarminLink1UsbEvent (&GarminEvent, &m_nRequestIDCnt,
							&m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);

		if (m_bStop || m_bTimeOut)
		{
			if (m_ptGrmnLink1Usb != NULL)
			{
				if (m_ptGrmnLink1Usb->Close())
					this->DisableControl (ID_GRREAD, FALSE);
				if (m_ptGrmnLink1Usb->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

			if (m_bTimeOut)
			{
				short nStrID = (m_bOK)? IDS_GPSOK : IDS_GPSTIMEOUT;
				szBuffer.LoadString (nStrID);
				AfxMessageBox (szBuffer);
			}
			else
			{	// m_bStop, !m_bTimeOut
				if (m_bConnected && !m_bOK)
				{                               
					szBuffer = this->Format (IDF_RDRTEUNDEFNAME, m_szRteID);
					AfxMessageBox (szBuffer);
				}
			}

			m_ptGpsDoc->SetReadRte(m_szRteID);
			if (m_ptLogFile != NULL)
			{
				m_ptLogFile->Close();
				delete m_ptLogFile;
				m_ptLogFile = NULL;
			}

			if (!m_ptGrmnLink1Usb->CloseReadThread(&szBuffer))
				AfxMessageBox ("Bad CloseReadThread: " + szBuffer);

			if (m_bOK)	CDlgTool::OnOK();		
				else	CDlgTool::OnCancel();
		}
	} // while Garmin Events in queue...

	return 0L;
}

/************************************************************************
 *  GpsRdDlg.cpp				O n R e a d R t e						*
 ************************************************************************/
void CReadFromGpsDlg::OnReadRte() 
{
	// TODO: Add your control notification handler code here
if (this->UpdateData (TRUE))
	{
	BOOL bDebug = FALSE;

	CString szTestGPS;	// debug gps data transfer if route title starts with TestGPS
	szTestGPS.LoadString(IDS_TESTGPS);
	bDebug = (m_ptDoc->GetTitle().Find((LPCTSTR)szTestGPS) == 0);
	if (bDebug)
		{
		CString szFileTitle;
		szFileTitle = SaveAsTextBox (this, "Reading Route", "ReadRte");

		if (szFileTitle.GetLength() > 0)
			{
			m_ptLogFile = new CFile ();
			m_ptLogFile->Open(szFileTitle, CFile::modeCreate | CFile::modeNoInherit | CFile::modeWrite, NULL); 
			}
		}

	if (this->InitRteRead(256, 256))
		{
		this->DisableControl (ID_GRREAD, TRUE);

		if (m_nReadMode == READMODE_ALL)
			m_szState.LoadString (IDS_RDRTEALL);
		if (m_nReadMode == READMODE_LAST)
			m_szState.LoadString (IDS_RDRTELAST);
		if (m_nReadMode == READMODE_SPEC)
			m_szState = this->Format (IDF_RDSEARCHNAME, m_szRteID);  

		this->SetText (ID_GRSTATE, m_szState);

		BOOL bUsbProtocol = m_ptGpsDoc->IsUsbProtocol();

		switch (m_Gps.GetProtocol())
		{
		case PR_GARMIN1:	// GPS100 ... GPS 100 AVD
			m_ptGrmn->SetLogFilePtr(m_ptLogFile);
			// directly start timer
			break;
		case PR_GARMIN2:
			if (bUsbProtocol)
			{
				m_ptGrmnLink1Usb->SetLogFilePtr(m_ptLogFile);
				m_ptGrmnLink1Usb->SendStartSession ();
				m_ptGrmnLink1Usb->StartReadThread(this);
				m_nRequestIDCnt++;
			}
			else
			{
				m_ptGrmnLink1->SetLogFilePtr(m_ptLogFile);
				m_ptGrmnLink1->SendProductRqst ();
				m_nRequestIDCnt++;
			}

			if (m_Gps.GetID() == GPSOTHER)
				m_bTimeOut = TRUE;    
			break;

		case PR_GARMIN3:
			m_ptGrmnLink2->SetLogFilePtr(m_ptLogFile);
  			if (m_Gps.GetID() == GPSLINK2)
				{	
				m_ptGrmnLink2->SendProductRqst ();
				m_nRequestIDCnt++;
				}
			break;

		case PR_MAGELLAN:
			MgnRequestID(m_ptLogFile);
			break;

		default:
			m_bTimeOut = TRUE;
			break;
		}
		
		if (!bUsbProtocol)	
		{				// no timer for USB GPS, instead use thread event!!
			m_uTimer = SetTimer (GPS_TIMER, 500, NULL);
			if (m_uTimer == 0)
				{									/* 1/2 sec Timer	*/
				AfxMessageBox ("Bad Timer");
				CDlgTool::OnCancel();
				}
			}
		}
	}	
}

/************************************************************************
 *  GpsRdDlg.cpp				O n T i m e r							*
 ************************************************************************/
void CReadFromGpsDlg::OnTimer(UINT nIDEvent) 
{
CString szBuffer;
BOOL	bFastMode = FALSE;
	// TODO: Add your message handler code here and/or call default
switch (nIDEvent)
	{
	case GPS_TIMER:
		this->KillTimer (m_uTimer);

		switch (m_Gps.GetProtocol())
		{
		case PR_GARMIN1:		// GPSG100STD || GPSG100AVD
			m_bTimeOut = ReceiveGarmin100 (&m_nRequestIDCnt,
					   &m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);   
			break;

		case PR_GARMIN2:
	 		if (m_Gps.GetID() == GPSLINK1)
				{	
					bFastMode = TRUE;
					m_bTimeOut = ReadGarminLink1 (&m_nRequestIDCnt,
					   &m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
				}
	 		if (m_Gps.GetID() == GPSOTHER)
	 			m_bTimeOut = TRUE;
			break;

		case PR_GARMIN3:
	 		if (m_Gps.GetID() == GPSLINK2)
				{	
				m_bTimeOut = ReadGarminLink2 (&m_nRequestIDCnt,
					   &m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
				}
			break;


		case PR_MAGELLAN:
			m_bTimeOut = ReceiveMagellanRte (&m_nRequestIDCnt,
						&m_bOK, &m_bStop, &m_bConnected, m_ptLogFile);
			break;

		default:
			m_bTimeOut = TRUE;
			break;
		}
		

		if (m_bStop || m_bTimeOut)
		    {
			if (m_ptGrmn != NULL)
			{
				if (m_ptGrmn->Close())
					this->DisableControl (ID_GRREAD, FALSE);
				if (m_ptGrmn->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}


			if (m_ptGrmnLink1 != NULL)
			{
				if (m_ptGrmnLink1->Close())
					this->DisableControl (ID_GRREAD, FALSE);
				if (m_ptGrmnLink1->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

			if (m_ptGrmnLink2 != NULL)
			{
				if (m_ptGrmnLink2->Close())
					this->DisableControl (ID_GRREAD, FALSE);
				if (m_ptGrmnLink2->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}

			if (m_ptNmea != NULL)
			{
				if (m_ptNmea->Close())
					this->DisableControl (ID_GRREAD, FALSE);
				if (m_ptNmea->GetError() == SER_BADCLOSE)
					AfxMessageBox("bad Close Comm");
			}
	
		    if (m_bTimeOut)
				{
				short nStrID = (m_bOK)? IDS_GPSOK : IDS_GPSTIMEOUT;
				szBuffer.LoadString (nStrID);
				AfxMessageBox (szBuffer);
				}
		    else{	// m_bStop, !m_bTimeOut
				if (m_bConnected && !m_bOK)
				    {                               
					szBuffer = this->Format (IDF_RDRTEUNDEFNAME, m_szRteID);
				    AfxMessageBox (szBuffer);
				    }
				}
	
			m_ptGpsDoc->SetReadRte(m_szRteID);
			if (m_ptLogFile != NULL)
				{
				m_ptLogFile->Close();
				delete m_ptLogFile;
				m_ptLogFile = NULL;
				}
	
			if (m_bOK)	CDlgTool::OnOK();		
				else	CDlgTool::OnCancel();
		    }
		else{
			if (bFastMode)	m_uTimer = SetTimer (GPS_TIMER, 100, NULL);
				else		m_uTimer = SetTimer (GPS_TIMER, 500, NULL);

		    if (m_uTimer == 0)
				{   // 0.5 sec Timer  
				AfxMessageBox ("Bad Timer");
				CDlgTool::OnCancel();
				}
		    }

		break;
	default:
		AfxMessageBox ("Unknown Timer in OnTimer");
		break;
	}
	
CDlgTool::OnTimer(nIDEvent);
}


/************************************************************************
 *  GpsRdDlg.cpp	  			 O n H e l p I n f o					*
 ************************************************************************/
BOOL CReadFromGpsDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	// TODO: Add your message handler code here and/or call default
	
if (pHelpInfo->iContextType == HELPINFO_WINDOW)
	{
	AfxGetApp()->WinHelp (pHelpInfo->dwContextId, HELP_CONTEXTPOPUP);
	}

return TRUE;
}


