#if !defined(AFX_RDGPSRT_H__4BA2B5C1_35AB_11D2_BFB4_DD4FD09F7F7F__INCLUDED_)
#define AFX_RDGPSRT_H__4BA2B5C1_35AB_11D2_BFB4_DD4FD09F7F7F__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
// GpsRdDlg.h : header file
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

// CReadFromGpsDlg dialog
#include "DlgTool.h"
#include "Garmin.h"						// includes GarminEv.h
#include "ProtGarminLink1.h"			// includes GarminLink1Ev.h
#include "ProtGarminLink2.h"			// includes GarminLink2Ev.h
#include "ProtGarminLink1Usb.h"			// includes GarminLink1UsbEv.h


class CWayDoc;
//class CGpsDoc;
class CReadFromGpsDlg : public CDlgTool
{
#define READMODE_ALL	0
#define READMODE_LAST	1
#define READMODE_SPEC	2

// Construction
public:
	#define GPS_TIMER	2

	CReadFromGpsDlg(CWnd* pParent=NULL, CWayDoc* ptDoc=NULL, CGpsDoc* ptGpsDoc=NULL);   // standard constructor
	virtual ~CReadFromGpsDlg();

// Dialog Data
	//{{AFX_DATA(CReadFromGpsDlg)
	enum { IDD = IDD_GPSRTEREADBOX };
	int		m_nReadMode;
	CString	m_szGPS;
	CString	m_szState;
	CString	m_szRequest;
	CString	m_szRteID;
	//}}AFX_DATA

private:
	CWayDoc*	m_ptDoc;
	CGpsDoc*	m_ptGpsDoc; 
	CGps		m_Gps;
	CGarmin*				m_ptGrmn;
	CProtGarminLink1*		m_ptGrmnLink1;
	CProtGarminLink2*		m_ptGrmnLink2;
	CProtGarminLink1Usb*	m_ptGrmnLink1Usb;
	CNmea*					m_ptNmea;
	short		m_nRteID;

	short		m_nRequestIDCnt;
	BOOL		m_bTimeOut;
	BOOL		m_bStop;
	BOOL		m_bOK;
	BOOL		m_bConnected;
	UINT		m_uTimer;
	CFile*		m_ptLogFile;
	short		m_nWptCnt;
	char		m_szActLocName[SIZEOF_ORT];
	short  		m_nActRteID;
	char		m_szActNameOfRte[32];
	short		m_nRecords;
	long		m_lRecordsReceived;

	CPtrArray	m_CachedWayDocs;		// array of CWayDoc*, used to cache routes while downloading
	CWayDoc*	m_ptCachedWayDoc;

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CReadFromGpsDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual LONG OnGpsEvent(UINT wParam, LONG lParam);
	//}}AFX_VIRTUAL

// Implementation
private:
	short ConvertToRteNum(CString szRteName);
	BOOL InitRteRead(short nInpLen, short nOutLen);

	void RteIdToString(char* szActRteName, short nRteID);
	BOOL OnTransferCompleted();
	void DoCacheRoute(CFile* ptFile);

	void DeleteArrayOf (CPtrArray* ptArray);
	BOOL SaveLastRte(CWayDoc* ptWayDoc, short nRteID);


	BOOL ReadGarminLink1 (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* FileSpec);
	BOOL ReadGarminLink2 (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* FileSpec);
	BOOL ReceiveGarmin100 (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* FileSpec);

	void MgnRequestID(CFile* ptFile);
	BOOL HandleGarminLink1UsbEvent(CGarminLink1UsbEvent* ptGarminEvent, short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* ptFile);
	BOOL ReceiveMagellanRte (short* ptRequestIDCnt, BOOL* ptOK, 
						BOOL* ptStop, BOOL* ptConnected, CFile* FileSpec);

protected:

	// Generated message map functions
	//{{AFX_MSG(CReadFromGpsDlg)
	afx_msg void OnReadRte();
	afx_msg void OnTimer(UINT nIDEvent);
	virtual BOOL OnInitDialog();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnReadModeAll();
	afx_msg void OnReadModeLast();
	afx_msg void OnReadModeSpec();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_RDGPSRT_H__4BA2B5C1_35AB_11D2_BFB4_DD4FD09F7F7F__INCLUDED_)
